/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.text.TabExpander;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaUI;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenPainter;

public class DefaultTokenPainter
implements TokenPainter {
    private Rectangle2D.Float bgRect = new Rectangle2D.Float();
    private static char[] tabBuf;

    DefaultTokenPainter() {
    }

    @Override
    public float nextX(Token token, int charCount, float x15, RSyntaxTextArea host, TabExpander e15) {
        int textOffs = token.getTextOffset();
        char[] text = token.getTextArray();
        int end = textOffs + charCount;
        int flushLen = 0;
        int flushIndex = textOffs;
        FontMetrics fm4 = host.getFontMetricsForTokenType(token.getType());
        for (int i15 = textOffs; i15 < end; ++i15) {
            if (text[i15] == '\t') {
                x15 = e15.nextTabStop(x15 + (float)fm4.charsWidth(text, flushIndex, flushLen), 0);
                flushLen = 0;
                flushIndex = i15 + 1;
                continue;
            }
            ++flushLen;
        }
        return x15 + (float)fm4.charsWidth(text, flushIndex, flushLen);
    }

    @Override
    public final float paint(Token token, Graphics2D g15, float x15, float y15, RSyntaxTextArea host, TabExpander e15) {
        return this.paint(token, g15, x15, y15, host, e15, 0.0f);
    }

    @Override
    public float paint(Token token, Graphics2D g15, float x15, float y15, RSyntaxTextArea host, TabExpander e15, float clipStart) {
        return this.paintImpl(token, g15, x15, y15, host, e15, clipStart, false, false);
    }

    @Override
    public float paint(Token token, Graphics2D g15, float x15, float y15, RSyntaxTextArea host, TabExpander e15, float clipStart, boolean paintBG) {
        return this.paintImpl(token, g15, x15, y15, host, e15, clipStart, !paintBG, false);
    }

    protected void paintBackground(float x15, float y15, float width, float height, Graphics2D g15, int fontAscent, RSyntaxTextArea host, Color color) {
        g15.setColor(color);
        this.bgRect.setRect(x15, y15 - (float)fontAscent, width, height);
        g15.fillRect((int)x15, (int)(y15 - (float)fontAscent), (int)width, (int)height);
    }

    protected float paintImpl(Token token, Graphics2D g15, float x15, float y15, RSyntaxTextArea host, TabExpander e15, float clipStart, boolean selected, boolean useSTC) {
        int origX = (int)x15;
        int textOffs = token.getTextOffset();
        char[] text = token.getTextArray();
        int end = textOffs + token.length();
        float nextX = x15;
        int flushLen = 0;
        int flushIndex = textOffs;
        Color fg5 = useSTC ? host.getSelectedTextColor() : host.getForegroundForToken(token);
        Color bg5 = selected ? null : host.getBackgroundForToken(token);
        g15.setFont(host.getFontForToken(token));
        FontMetrics fm4 = host.getFontMetricsForToken(token);
        block3: for (int i15 = textOffs; i15 < end; ++i15) {
            switch (text[i15]) {
                case '\t': {
                    nextX = e15.nextTabStop(x15 + (float)fm4.charsWidth(text, flushIndex, flushLen), 0);
                    if (bg5 != null) {
                        this.paintBackground(x15, y15, nextX - x15, fm4.getHeight(), g15, fm4.getAscent(), host, bg5);
                    }
                    if (flushLen > 0) {
                        g15.setColor(fg5);
                        g15.drawChars(text, flushIndex, flushLen, (int)x15, (int)y15);
                        flushLen = 0;
                    }
                    flushIndex = i15 + 1;
                    x15 = nextX;
                    continue block3;
                }
                default: {
                    ++flushLen;
                }
            }
        }
        nextX = x15 + (float)fm4.charsWidth(text, flushIndex, flushLen);
        Rectangle r15 = host.getMatchRectangle();
        if (flushLen > 0 && nextX >= clipStart) {
            if (bg5 != null) {
                this.paintBackground(x15, y15, nextX - x15, fm4.getHeight(), g15, fm4.getAscent(), host, bg5);
                if (token.length() == 1 && r15 != null && (float)r15.x == x15) {
                    ((RSyntaxTextAreaUI)host.getUI()).paintMatchedBracketImpl(g15, host, r15);
                }
            }
            g15.setColor(fg5);
            g15.drawChars(text, flushIndex, flushLen, (int)x15, (int)y15);
        }
        if (host.getUnderlineForToken(token)) {
            g15.setColor(fg5);
            int y25 = (int)(y15 + 1.0f);
            g15.drawLine(origX, y25, (int)nextX, y25);
        }
        if (host.getPaintTabLines() && origX == host.getMargin().left) {
            this.paintTabLines(token, origX, (int)y15, (int)nextX, g15, e15, host);
        }
        return nextX;
    }

    @Override
    public float paintSelected(Token token, Graphics2D g15, float x15, float y15, RSyntaxTextArea host, TabExpander e15, boolean useSTC) {
        return this.paintSelected(token, g15, x15, y15, host, e15, 0.0f, useSTC);
    }

    @Override
    public float paintSelected(Token token, Graphics2D g15, float x15, float y15, RSyntaxTextArea host, TabExpander e15, float clipStart, boolean useSTC) {
        return this.paintImpl(token, g15, x15, y15, host, e15, clipStart, true, useSTC);
    }

    protected void paintTabLines(Token token, int x15, int y15, int endX, Graphics2D g15, TabExpander e15, RSyntaxTextArea host) {
        Token next;
        if (token.getType() != 21) {
            int offs;
            for (offs = 0; offs < token.length() && RSyntaxUtilities.isWhitespace(token.charAt(offs)); ++offs) {
            }
            if (offs < 2) {
                return;
            }
            endX = (int)token.getWidthUpTo(offs, host, e15, 0.0f);
        }
        FontMetrics fm4 = host.getFontMetricsForToken(token);
        int tabSize = host.getTabSize();
        if (tabBuf == null || tabBuf.length < tabSize) {
            tabBuf = new char[tabSize];
            for (int i15 = 0; i15 < tabSize; ++i15) {
                DefaultTokenPainter.tabBuf[i15] = 32;
            }
        }
        int tabW = fm4.charsWidth(tabBuf, 0, tabSize);
        g15.setColor(host.getTabLineColor());
        int x05 = x15 + tabW;
        int y05 = y15 - fm4.getAscent();
        if ((y05 & 1) > 0) {
            ++y05;
        }
        if ((next = token.getNextToken()) == null || !next.isPaintable()) {
            ++endX;
        }
        while (x05 < endX) {
            int y25 = y05 + host.getLineHeight();
            for (int y16 = y05; y16 < y25; y16 += 2) {
                g15.drawLine(x05, y16, x05, y16);
            }
            x05 += tabW;
        }
    }
}

