/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.math.BigInteger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.Debugger;
import sun.jvm.hotspot.debugger.UnmappedAddressException;
import sun.jvm.hotspot.ui.GraphicsUtilities;
import sun.jvm.hotspot.ui.HighPrecisionJScrollBar;
import sun.jvm.hotspot.ui.StringTransferable;

public class MemoryPanel
extends JPanel {
    private boolean is64Bit;
    private Debugger debugger;
    private int addressSize;
    private String unmappedAddrString;
    private HighPrecisionJScrollBar scrollBar;
    private AbstractTableModel model;
    private JTable table;
    private BigInteger startVal;
    private int numVisibleRows;
    private int numUsableRows;
    private boolean haveAnchor;
    private int rowAnchorIndex;
    private int colAnchorIndex;
    private boolean haveLead;
    private int rowLeadIndex;
    private int colLeadIndex;
    private int updateLevel;

    public MemoryPanel(final Debugger debugger, boolean is64Bit) {
        this.debugger = debugger;
        this.is64Bit = is64Bit;
        if (is64Bit) {
            this.addressSize = 8;
            this.unmappedAddrString = "??????????????????";
        } else {
            this.addressSize = 4;
            this.unmappedAddrString = "??????????";
        }
        this.setLayout(new BorderLayout());
        this.setupScrollBar();
        this.add((Component)this.scrollBar, "East");
        this.model = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return MemoryPanel.this.numVisibleRows;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int row, int column) {
                switch (column) {
                    case 0: {
                        return MemoryPanel.this.bigIntToHexString(MemoryPanel.this.startVal.add(new BigInteger(Integer.toString(row * MemoryPanel.this.addressSize))));
                    }
                    case 1: {
                        try {
                            Address addr = MemoryPanel.this.bigIntToAddress(MemoryPanel.this.startVal.add(new BigInteger(Integer.toString(row * MemoryPanel.this.addressSize))));
                            if (addr != null) {
                                return MemoryPanel.this.addressToString(addr.getAddressAt(0L));
                            }
                            return MemoryPanel.this.unmappedAddrString;
                        }
                        catch (UnmappedAddressException e) {
                            return MemoryPanel.this.unmappedAddrString;
                        }
                    }
                }
                throw new RuntimeException("Column " + column + " out of bounds");
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.table = new JTable(this.model);
        this.table.setTableHeader(null);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setCellSelectionEnabled(true);
        this.table.setSelectionMode(1);
        this.table.setDragEnabled(true);
        Font font = GraphicsUtilities.lookupFont("Courier");
        if (font == null) {
            throw new RuntimeException("Error looking up monospace font Courier");
        }
        this.table.setFont(font);
        this.table.setTransferHandler(new TransferHandler(){

            @Override
            protected Transferable createTransferable(JComponent c) {
                JTable table = (JTable)c;
                if (MemoryPanel.this.haveSelection()) {
                    StringBuffer buf = new StringBuffer();
                    int iDir = MemoryPanel.this.getRowAnchor() < MemoryPanel.this.getRowLead() ? 1 : -1;
                    int jDir = MemoryPanel.this.getColAnchor() < MemoryPanel.this.getColLead() ? 1 : -1;
                    for (int i = MemoryPanel.this.getRowAnchor(); i != MemoryPanel.this.getRowLead() + iDir; i += iDir) {
                        for (int j = MemoryPanel.this.getColAnchor(); j != MemoryPanel.this.getColLead() + jDir; j += jDir) {
                            Object val = MemoryPanel.this.model.getValueAt(i, j);
                            buf.append(val == null ? "" : val.toString());
                            if (j == MemoryPanel.this.getColLead()) continue;
                            buf.append("\t");
                        }
                        if (i == MemoryPanel.this.getRowLead()) continue;
                        buf.append("\n");
                    }
                    return new StringTransferable(buf.toString());
                }
                return null;
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }

            @Override
            public boolean importData(JComponent c, Transferable t) {
                if (this.canImport(c, t.getTransferDataFlavors())) {
                    try {
                        String str = (String)t.getTransferData(DataFlavor.stringFlavor);
                        this.handleImport(c, str);
                        return true;
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return false;
            }

            @Override
            public boolean canImport(JComponent c, DataFlavor[] flavors) {
                for (int i = 0; i < flavors.length; ++i) {
                    if (!DataFlavor.stringFlavor.equals(flavors[i])) continue;
                    return true;
                }
                return false;
            }

            private void handleImport(JComponent c, String str) {
                try {
                    MemoryPanel.this.makeVisible(debugger.parseAddress(str));
                    MemoryPanel.this.clearSelection();
                    MemoryPanel.this.table.clearSelection();
                }
                catch (NumberFormatException e) {
                    System.err.println("Unable to parse address \"" + str + "\"");
                }
            }
        });
        ActionMap map = this.table.getActionMap();
        MemoryPanel.installActionWrapper(map, "selectPreviousRow", new ActionWrapper(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryPanel.this.beginUpdate();
                MemoryPanel.this.clearSelection();
                if (MemoryPanel.this.table.getSelectedRow() == 0) {
                    MemoryPanel.this.scrollBar.scrollUpOrLeft();
                    MemoryPanel.this.table.setRowSelectionInterval(0, 0);
                } else {
                    super.actionPerformed(e);
                }
                MemoryPanel.this.maybeGrabSelection();
                MemoryPanel.this.endUpdate();
            }
        });
        MemoryPanel.installActionWrapper(map, "selectNextRow", new ActionWrapper(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryPanel.this.beginUpdate();
                MemoryPanel.this.clearSelection();
                int row = MemoryPanel.this.table.getSelectedRow();
                if (row >= MemoryPanel.this.numUsableRows) {
                    MemoryPanel.this.scrollBar.scrollDownOrRight();
                    MemoryPanel.this.table.setRowSelectionInterval(row, row);
                } else {
                    super.actionPerformed(e);
                }
                MemoryPanel.this.maybeGrabSelection();
                MemoryPanel.this.endUpdate();
            }
        });
        MemoryPanel.installActionWrapper(map, "scrollUpChangeSelection", new ActionWrapper(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryPanel.this.beginUpdate();
                MemoryPanel.this.clearSelection();
                int row = MemoryPanel.this.table.getSelectedRow();
                MemoryPanel.this.scrollBar.pageUpOrLeft();
                if (row >= 0) {
                    MemoryPanel.this.table.setRowSelectionInterval(row, row);
                }
                MemoryPanel.this.maybeGrabSelection();
                MemoryPanel.this.endUpdate();
            }
        });
        MemoryPanel.installActionWrapper(map, "scrollDownChangeSelection", new ActionWrapper(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryPanel.this.beginUpdate();
                MemoryPanel.this.clearSelection();
                int row = MemoryPanel.this.table.getSelectedRow();
                MemoryPanel.this.scrollBar.pageDownOrRight();
                if (row >= 0) {
                    MemoryPanel.this.table.setRowSelectionInterval(row, row);
                }
                MemoryPanel.this.maybeGrabSelection();
                MemoryPanel.this.endUpdate();
            }
        });
        MemoryPanel.installActionWrapper(map, "selectPreviousRowExtendSelection", new ActionWrapper(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryPanel.this.beginUpdate();
                if (!MemoryPanel.this.haveAnchor()) {
                    MemoryPanel.this.setAnchorFromTable();
                    MemoryPanel.this.setLeadFromTable();
                }
                int newLead = MemoryPanel.this.getRowLead() - 1;
                int newAnchor = MemoryPanel.this.getRowAnchor();
                if (newLead < 0) {
                    MemoryPanel.this.scrollBar.scrollUpOrLeft();
                    ++newLead;
                    ++newAnchor;
                }
                MemoryPanel.this.setSelection(newAnchor, newLead, MemoryPanel.this.getColAnchor(), MemoryPanel.this.getColLead());
                MemoryPanel.this.endUpdate();
            }
        });
        MemoryPanel.installActionWrapper(map, "selectPreviousColumnExtendSelection", new ActionWrapper(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryPanel.this.beginUpdate();
                if (!MemoryPanel.this.haveAnchor()) {
                    MemoryPanel.this.setAnchorFromTable();
                    MemoryPanel.this.setLeadFromTable();
                }
                int newLead = Math.max(0, MemoryPanel.this.getColLead() - 1);
                MemoryPanel.this.setSelection(MemoryPanel.this.getRowAnchor(), MemoryPanel.this.getRowLead(), MemoryPanel.this.getColAnchor(), newLead);
                MemoryPanel.this.endUpdate();
            }
        });
        MemoryPanel.installActionWrapper(map, "selectNextRowExtendSelection", new ActionWrapper(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryPanel.this.beginUpdate();
                if (!MemoryPanel.this.haveAnchor()) {
                    MemoryPanel.this.setAnchorFromTable();
                    MemoryPanel.this.setLeadFromTable();
                }
                int newLead = MemoryPanel.this.getRowLead() + 1;
                int newAnchor = MemoryPanel.this.getRowAnchor();
                if (newLead > MemoryPanel.this.numUsableRows) {
                    MemoryPanel.this.scrollBar.scrollDownOrRight();
                    --newLead;
                    --newAnchor;
                }
                MemoryPanel.this.setSelection(newAnchor, newLead, MemoryPanel.this.getColAnchor(), MemoryPanel.this.getColLead());
                MemoryPanel.this.endUpdate();
            }
        });
        MemoryPanel.installActionWrapper(map, "selectNextColumnExtendSelection", new ActionWrapper(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryPanel.this.beginUpdate();
                if (!MemoryPanel.this.haveAnchor()) {
                    MemoryPanel.this.setAnchorFromTable();
                    MemoryPanel.this.setLeadFromTable();
                }
                int newLead = Math.min(MemoryPanel.this.model.getColumnCount() - 1, MemoryPanel.this.getColLead() + 1);
                MemoryPanel.this.setSelection(MemoryPanel.this.getRowAnchor(), MemoryPanel.this.getRowLead(), MemoryPanel.this.getColAnchor(), newLead);
                MemoryPanel.this.endUpdate();
            }
        });
        MemoryPanel.installActionWrapper(map, "scrollUpExtendSelection", new ActionWrapper(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryPanel.this.beginUpdate();
                if (!MemoryPanel.this.haveAnchor()) {
                    MemoryPanel.this.setAnchorFromTable();
                    MemoryPanel.this.setLeadFromTable();
                }
                int newLead = MemoryPanel.this.getRowLead() - MemoryPanel.this.numUsableRows;
                int newAnchor = MemoryPanel.this.getRowAnchor();
                if (newLead < 0) {
                    MemoryPanel.this.scrollBar.pageUpOrLeft();
                    newLead += MemoryPanel.this.numUsableRows;
                    newAnchor += MemoryPanel.this.numUsableRows;
                }
                MemoryPanel.this.setSelection(newAnchor, newLead, MemoryPanel.this.getColAnchor(), MemoryPanel.this.getColLead());
                MemoryPanel.this.endUpdate();
            }
        });
        MemoryPanel.installActionWrapper(map, "scrollDownExtendSelection", new ActionWrapper(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryPanel.this.beginUpdate();
                if (!MemoryPanel.this.haveAnchor()) {
                    MemoryPanel.this.setAnchorFromTable();
                    MemoryPanel.this.setLeadFromTable();
                }
                int newLead = MemoryPanel.this.getRowLead() + MemoryPanel.this.numUsableRows;
                int newAnchor = MemoryPanel.this.getRowAnchor();
                if (newLead > MemoryPanel.this.numUsableRows) {
                    MemoryPanel.this.scrollBar.pageDownOrRight();
                    newLead -= MemoryPanel.this.numUsableRows;
                    newAnchor -= MemoryPanel.this.numUsableRows;
                }
                MemoryPanel.this.setSelection(newAnchor, newLead, MemoryPanel.this.getColAnchor(), MemoryPanel.this.getColLead());
                MemoryPanel.this.endUpdate();
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (MemoryPanel.this.shouldIgnore(e)) {
                    return;
                }
                if (e.isShiftDown()) {
                    MemoryPanel.this.maybeGrabSelection();
                    return;
                }
                MemoryPanel.this.clearSelection();
            }
        });
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (MemoryPanel.this.shouldIgnore(e)) {
                    return;
                }
                Point p = e.getPoint();
                if (MemoryPanel.this.table.rowAtPoint(p) == -1) {
                    Rectangle rect = new Rectangle();
                    MemoryPanel.this.getBounds(rect);
                    MemoryPanel.this.beginUpdate();
                    if (p.y < rect.y) {
                        MemoryPanel.this.scrollBar.scrollUpOrLeft();
                        MemoryPanel.this.setSelection(MemoryPanel.this.getRowAnchor(), 0, MemoryPanel.this.getColAnchor(), MemoryPanel.this.getColLead());
                    } else {
                        MemoryPanel.this.scrollBar.scrollDownOrRight();
                        MemoryPanel.this.setSelection(MemoryPanel.this.getRowAnchor(), MemoryPanel.this.numUsableRows, MemoryPanel.this.getColAnchor(), MemoryPanel.this.getColLead());
                    }
                    MemoryPanel.this.endUpdate();
                } else {
                    MemoryPanel.this.maybeGrabSelection();
                }
            }
        });
        this.add((Component)this.table, "Center");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MemoryPanel.this.recomputeNumVisibleRows();
                MemoryPanel.this.constrain();
            }
        });
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                MemoryPanel.this.recomputeNumVisibleRows();
                MemoryPanel.this.constrain();
            }
        });
        this.updateFromScrollBar();
    }

    public void makeVisible(Address addr) {
        BigInteger bi = this.addressToBigInt(addr);
        this.scrollBar.setValueHP(bi);
    }

    private void setupScrollBar() {
        if (this.is64Bit) {
            this.scrollBar = new HighPrecisionJScrollBar(1, new BigInteger(1, new byte[]{-128, 0, 0, 0, 0, 0, 0, 0}), new BigInteger(1, new byte[]{0, 0, 0, 0, 0, 0, 0, 0}), new BigInteger(1, new byte[]{-1, -1, -1, -1, -1, -1, -1, -4}));
            this.scrollBar.setUnitIncrementHP(new BigInteger(1, new byte[]{0, 0, 0, 0, 0, 0, 0, 8}));
            this.scrollBar.setBlockIncrementHP(new BigInteger(1, new byte[]{0, 0, 0, 0, 0, 0, 0, 64}));
        } else {
            this.scrollBar = new HighPrecisionJScrollBar(1, new BigInteger(1, new byte[]{-128, 0, 0, 0}), new BigInteger(1, new byte[]{0, 0, 0, 0}), new BigInteger(1, new byte[]{-1, -1, -1, -4}));
            this.scrollBar.setUnitIncrementHP(new BigInteger(1, new byte[]{0, 0, 0, 4}));
            this.scrollBar.setBlockIncrementHP(new BigInteger(1, new byte[]{0, 0, 0, 32}));
        }
        this.scrollBar.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MemoryPanel.this.updateFromScrollBar();
            }
        });
    }

    private void updateFromScrollBar() {
        this.beginUpdate();
        BigInteger oldStartVal = this.startVal;
        this.startVal = this.scrollBar.getValueHP();
        this.constrain();
        this.model.fireTableDataChanged();
        if (oldStartVal != null) {
            this.modifySelection(oldStartVal.subtract(this.startVal).intValue() / this.addressSize);
        }
        this.endUpdate();
    }

    private void constrain() {
        BigInteger offset = new BigInteger(Integer.toString(this.addressSize * this.numUsableRows));
        BigInteger endVal = this.startVal.add(offset);
        if (endVal.compareTo(this.scrollBar.getMaximumHP()) > 0) {
            this.startVal = this.scrollBar.getMaximumHP().subtract(offset);
            endVal = this.scrollBar.getMaximumHP();
            this.scrollBar.setValueHP(this.startVal);
            this.model.fireTableDataChanged();
        }
    }

    private void recomputeNumVisibleRows() {
        Rectangle rect = new Rectangle();
        this.getBounds(rect);
        int h = this.table.getRowHeight();
        this.numVisibleRows = (rect.height + (h - 1)) / h;
        this.numUsableRows = this.numVisibleRows - 2;
        this.scrollBar.setBlockIncrementHP(new BigInteger(Integer.toString(this.addressSize * this.numUsableRows)));
        this.model.fireTableDataChanged();
    }

    private String bigIntToHexString(BigInteger bi) {
        StringBuffer buf = new StringBuffer();
        buf.append("0x");
        String val = bi.toString(16);
        for (int i = 0; i < 2 * this.addressSize - val.length(); ++i) {
            buf.append('0');
        }
        buf.append(val);
        return buf.toString();
    }

    private Address bigIntToAddress(BigInteger i) {
        String s = this.bigIntToHexString(i);
        return this.debugger.parseAddress(s);
    }

    private BigInteger addressToBigInt(Address a) {
        String s = this.addressToString(a);
        if (!s.startsWith("0x")) {
            throw new NumberFormatException(s);
        }
        return new BigInteger(s.substring(2), 16);
    }

    private String addressToString(Address a) {
        if (a == null) {
            if (this.is64Bit) {
                return "0x0000000000000000";
            }
            return "0x00000000";
        }
        return a.toString();
    }

    private static void installActionWrapper(ActionMap map, String actionName, ActionWrapper wrapper) {
        wrapper.setParent(map.get(actionName));
        map.put(actionName, wrapper);
    }

    private boolean shouldIgnore(MouseEvent e) {
        return e.isConsumed() || !SwingUtilities.isLeftMouseButton(e) || !this.table.isEnabled();
    }

    private void clearSelection() {
        this.haveAnchor = false;
        this.haveLead = false;
    }

    private boolean updating() {
        return this.updateLevel > 0;
    }

    private void beginUpdate() {
        ++this.updateLevel;
    }

    private void endUpdate() {
        --this.updateLevel;
    }

    private boolean haveAnchor() {
        return this.haveAnchor;
    }

    private boolean haveLead() {
        return this.haveLead;
    }

    private boolean haveSelection() {
        return this.haveAnchor() && this.haveLead();
    }

    private int getRowAnchor() {
        return this.rowAnchorIndex;
    }

    private int getColAnchor() {
        return this.colAnchorIndex;
    }

    private int getRowLead() {
        return this.rowLeadIndex;
    }

    private int getColLead() {
        return this.colLeadIndex;
    }

    private void setAnchorFromTable() {
        this.setAnchor(this.table.getSelectionModel().getAnchorSelectionIndex(), this.table.getColumnModel().getSelectionModel().getAnchorSelectionIndex());
    }

    private void setLeadFromTable() {
        this.setLead(this.table.getSelectionModel().getAnchorSelectionIndex(), this.table.getColumnModel().getSelectionModel().getAnchorSelectionIndex());
    }

    private void setAnchor(int row, int col) {
        this.rowAnchorIndex = row;
        this.colAnchorIndex = col;
        this.haveAnchor = true;
    }

    private void setLead(int row, int col) {
        this.rowLeadIndex = row;
        this.colLeadIndex = col;
        this.haveLead = true;
    }

    private int clamp(int val, int min, int max) {
        return Math.max(Math.min(val, max), min);
    }

    private void maybeGrabSelection() {
        if (this.table.getSelectedRow() != -1) {
            ListSelectionModel rowSel = this.table.getSelectionModel();
            ListSelectionModel colSel = this.table.getColumnModel().getSelectionModel();
            if (!this.haveAnchor()) {
                this.setSelection(rowSel.getAnchorSelectionIndex(), rowSel.getLeadSelectionIndex(), colSel.getAnchorSelectionIndex(), colSel.getLeadSelectionIndex());
            } else {
                this.setSelection(this.getRowAnchor(), rowSel.getLeadSelectionIndex(), this.getColAnchor(), colSel.getLeadSelectionIndex());
            }
        }
    }

    private void setSelection(int rowAnchor, int rowLead, int colAnchor, int colLead) {
        this.setAnchor(rowAnchor, colAnchor);
        this.setLead(rowLead, colLead);
        this.table.setRowSelectionInterval(this.clamp(rowAnchor, 0, this.numUsableRows), this.clamp(rowLead, 0, this.numUsableRows));
        this.table.setColumnSelectionInterval(colAnchor, colLead);
    }

    private void modifySelection(int amount) {
        if (this.haveSelection()) {
            this.setSelection(this.getRowAnchor() + amount, this.getRowLead() + amount, this.getColAnchor(), this.getColLead());
        }
    }

    private void printSelection() {
        System.err.println("Selection updated to (" + this.model.getValueAt(this.getRowAnchor(), this.getColAnchor()) + ", " + this.model.getValueAt(this.getRowLead(), this.getColLead()) + ") [(" + this.getRowAnchor() + ", " + this.getColAnchor() + "), (" + this.getRowLead() + ", " + this.getColLead() + ")]");
    }

    abstract class ActionWrapper
    extends AbstractAction {
        private Action parent;

        ActionWrapper() {
        }

        void setParent(Action parent) {
            this.parent = parent;
        }

        Action getParent() {
            return this.parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.getParent() != null) {
                this.getParent().actionPerformed(e);
            }
        }
    }
}

