/*
 * Decompiled with CFR 0.152.
 */
package jspecview.app;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import jspecview.api.JSVPanel;
import org.jmol.api.EventManager;
import org.jmol.api.GenericMouseInterface;
import org.jmol.util.Logger;

public class GenericMouse
implements GenericMouseInterface {
    protected EventManager pd;
    protected JSVPanel jsvp;
    protected int xWhenPressed;
    protected int yWhenPressed;
    protected int modifiersWhenPressed10;
    protected boolean isMouseDown;
    private boolean disposed;

    public GenericMouse(JSVPanel jSVPanel) {
        this.jsvp = jSVPanel;
        this.pd = jSVPanel.getPanelData();
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean processEvent(int n, int n2, int n3, int n4, long l) {
        if (this.pd == null) {
            if (!this.disposed && n == 501 && (n4 & 4) != 0) {
                this.jsvp.showMenu(n2, n3);
            }
            return true;
        }
        if (n != 507) {
            n4 = GenericMouse.applyLeftMouse(n4);
        }
        switch (n) {
            case 507: {
                this.wheeled(l, n2, n4 | 0x20);
                break;
            }
            case 501: {
                this.xWhenPressed = n2;
                this.yWhenPressed = n3;
                this.modifiersWhenPressed10 = n4;
                this.pressed(l, n2, n3, n4, false);
                break;
            }
            case 506: {
                this.dragged(l, n2, n3, n4);
                break;
            }
            case 504: {
                this.entered(l, n2, n3);
                break;
            }
            case 505: {
                this.exited(l, n2, n3);
                break;
            }
            case 503: {
                this.moved(l, n2, n3, n4);
                break;
            }
            case 502: {
                this.released(l, n2, n3, n4);
                if (n2 != this.xWhenPressed || n3 != this.yWhenPressed || n4 != this.modifiersWhenPressed10) break;
                this.clicked(l, n2, n3, n4, 1);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.entered(mouseEvent.getWhen(), mouseEvent.getX(), mouseEvent.getY());
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.exited(mouseEvent.getWhen(), mouseEvent.getX(), mouseEvent.getY());
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.moved(mouseEvent.getWhen(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.pressed(mouseEvent.getWhen(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers(), mouseEvent.isPopupTrigger());
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if ((n & 0x1C) == 0) {
            n |= 0x10;
        }
        this.dragged(mouseEvent.getWhen(), mouseEvent.getX(), mouseEvent.getY(), n);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.released(mouseEvent.getWhen(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.clicked(mouseEvent.getWhen(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers(), mouseEvent.getClickCount());
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        mouseWheelEvent.consume();
        this.wheeled(mouseWheelEvent.getWhen(), mouseWheelEvent.getWheelRotation(), mouseWheelEvent.getModifiers() | 0x20);
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (this.pd == null) {
            return;
        }
        char c = keyEvent.getKeyChar();
        int n = keyEvent.getModifiers();
        Logger.info("MouseManager keyTyped: " + c + " " + ('\u0000' + c) + " " + n);
        if (this.pd.keyTyped(c, n)) {
            keyEvent.consume();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.pd != null && this.pd.keyPressed(keyEvent.getKeyCode(), keyEvent.getModifiers())) {
            keyEvent.consume();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.pd != null) {
            this.pd.keyReleased(keyEvent.getKeyCode());
        }
    }

    @Override
    public void processKeyEvent(Object object) {
        KeyEvent keyEvent = (KeyEvent)object;
        switch (keyEvent.getID()) {
            case 401: {
                this.keyPressed(keyEvent);
                break;
            }
            case 402: {
                this.keyReleased(keyEvent);
                break;
            }
            case 400: {
                this.keyTyped(keyEvent);
            }
        }
    }

    protected void entered(long l, int n, int n2) {
        if (this.pd != null) {
            this.pd.mouseEnterExit(l, n, n2, false);
        }
    }

    protected void exited(long l, int n, int n2) {
        if (this.pd != null) {
            this.pd.mouseEnterExit(l, n, n2, true);
        }
    }

    protected void clicked(long l, int n, int n2, int n3, int n4) {
        if (this.pd != null) {
            this.pd.mouseAction(2, l, n, n2, 1, n3);
        }
    }

    protected void moved(long l, int n, int n2, int n3) {
        if (this.pd == null) {
            return;
        }
        if (this.isMouseDown) {
            this.pd.mouseAction(1, l, n, n2, 0, GenericMouse.applyLeftMouse(n3));
        } else {
            this.pd.mouseAction(0, l, n, n2, 0, n3 & 0xFFFFFFE3);
        }
    }

    protected void wheeled(long l, int n, int n2) {
        if (this.pd != null) {
            this.pd.mouseAction(3, l, 0, n, 0, n2);
        }
    }

    protected void pressed(long l, int n, int n2, int n3, boolean bl) {
        if (this.pd == null) {
            if (!this.disposed) {
                this.jsvp.showMenu(n, n2);
            }
            return;
        }
        this.isMouseDown = true;
        this.pd.mouseAction(4, l, n, n2, 0, n3);
    }

    protected void released(long l, int n, int n2, int n3) {
        if (this.pd == null) {
            return;
        }
        this.isMouseDown = false;
        this.pd.mouseAction(5, l, n, n2, 0, n3);
    }

    protected void dragged(long l, int n, int n2, int n3) {
        if (this.pd == null) {
            return;
        }
        if ((n3 & 0x14) == 20) {
            n3 = n3 & 0xFFFFFFFB | 2;
        }
        this.pd.mouseAction(1, l, n, n2, 0, n3);
    }

    protected static int applyLeftMouse(int n) {
        return (n & 0x1C) == 0 ? n | 0x10 : n;
    }

    @Override
    public void processTwoPointGesture(float[][][] fArray) {
    }

    @Override
    public void dispose() {
        this.pd = null;
        this.jsvp = null;
        this.disposed = true;
    }
}

