/*
 * Decompiled with CFR 0.152.
 */
package org.qcschema;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.jmol.viewer.Viewer;

public class QCSchemaUnits {
    public static final String version = "QCJSON 0-0-0.Jmol_" + Viewer.getJmolVersion().replace(' ', '_');
    public static final String UNITS_FRACTIONAL = "fractional";
    public static final String UNITS_AU = "au";
    public static final double TOAU_AU = 1.0;
    public static final String UNITS_CM = "cm";
    public static final double TOAU_CM = 1.8897261254578283E8;
    public static final String UNITS_M = "m";
    public static final double TOAU_M = 1.889726125457828E10;
    public static final String UNITS_ANGSTROMS = "angstroms";
    public static final double TOAU_ANGSTROMS = 1.8897261254578281;
    public static final String UNITS_BOHR = "bohr";
    public static final double TOAU_BOHR = 1.0;
    public static final String UNITS_HARTREE = "hartree";
    public static final double TOAU_HARTREE = 1.0;
    public static final String UNITS_EV = "ev";
    public static final double TOAU_EV = 0.0367498438131638;
    public static final String UNITS_CM_1 = "cm-1";
    public static final double TOAU_CM_1 = 4.55633590401805E-6;
    public static final String UNITS_KJ_MOL = "kj/mol";
    public static final double TOAU_KJ_MOL = 3.7943464238284955E-4;
    public static final String UNITS_KCAL_MOL = "kcal/mol";
    public static final double TOAU_KCAL_MOL = 0.0015936254980079682;
    private static final String knownUnits = "cm cm^-1 cm-1 angstroms au atomic units fractional bohrs hartrees ev kj_mol kcal_mol";
    private static Hashtable<String, Double> htConvert = new Hashtable();

    public static double getFactorToAU(String units) {
        switch (knownUnits.indexOf(units.toLowerCase())) {
            case 0: {
                return 1.8897261254578283E8;
            }
            case 1: {
                return 1.889726125457828E10;
            }
            case 3: 
            case 9: {
                return 4.55633590401805E-6;
            }
            case 14: {
                return 1.8897261254578281;
            }
            case 24: 
            case 27: {
                return 1.0;
            }
            case 40: {
                return 0.0;
            }
            case 51: {
                return 1.0;
            }
            case 57: {
                return 1.0;
            }
            case 66: {
                return 0.0367498438131638;
            }
            case 69: {
                return 0.0015936254980079682;
            }
            case 76: {
                return 3.7943464238284955E-4;
            }
        }
        return Double.NaN;
    }

    public static double getUnitConversion(String fromUnits, String toUnits) {
        if (fromUnits.equalsIgnoreCase(toUnits)) {
            return 1.0;
        }
        String key = "" + fromUnits + toUnits;
        Double d = htConvert.get(key);
        if (d != null) {
            return d;
        }
        double val = Double.NaN;
        try {
            double toAUDesired = QCSchemaUnits.getFactorToAU(toUnits);
            double toAUActual = QCSchemaUnits.getFactorToAU(fromUnits);
            val = toAUActual / toAUDesired;
        }
        catch (Exception exception) {
            // empty catch block
        }
        htConvert.put(key, val);
        return val;
    }

    public static double getConversionFactorTo(ArrayList<Object> unitsFactor, String unitsDesired) {
        try {
            double toAUDesired = QCSchemaUnits.getFactorToAU(unitsDesired);
            double toAUActual = QCSchemaUnits.getFactorToAU(unitsFactor == null ? UNITS_AU : unitsFactor.get(0).toString());
            if (Double.isNaN(toAUActual)) {
                toAUActual = Double.parseDouble(unitsFactor.get(1).toString());
            }
            return toAUActual / toAUDesired;
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public static double convertValue(Map<String, Object> valueUnits, String toUnits) {
        return QCSchemaUnits.getDouble(valueUnits, "value", null) * QCSchemaUnits.getConversionFactor(valueUnits, "units", toUnits);
    }

    public static Object getUnitsJSON(String name, boolean asArray) {
        Object object;
        String toAU;
        double d = QCSchemaUnits.getFactorToAU(name);
        String string = !Double.isNaN(d) ? "" + d : (toAU = asArray ? "?" : "\"?\"");
        if (asArray) {
            String[] stringArray = new String[2];
            stringArray[0] = name;
            object = stringArray;
            stringArray[1] = toAU;
        } else {
            object = "[\"" + name + "\"," + toAU + "]";
        }
        return object;
    }

    public static double getConversionFactor(Map<String, Object> map, String key, String toUnits) {
        ArrayList<Object> list = QCSchemaUnits.getList(map, key + "_units");
        String units = list == null ? null : list.get(0).toString();
        double f = QCSchemaUnits.getConversionFactorTo(list, toUnits);
        if (Double.isNaN(f)) {
            System.out.println("units for " + units + "? " + units);
            f = 1.0;
        }
        return f;
    }

    public static double getDouble(Map<String, Object> map, String key, String toUnits) {
        Object o = map.get(key);
        double conv = 1.0;
        if (toUnits != null) {
            if (o instanceof Map) {
                return QCSchemaUnits.convertValue((Map)o, toUnits);
            }
            if (map.containsKey(key + "_units")) {
                conv = QCSchemaUnits.getConversionFactor(map, key, toUnits);
            }
        }
        return o == null ? Double.NaN : ((Number)o).doubleValue() * conv;
    }

    public static ArrayList<Object> getList(Object mapOrList, String key) {
        ArrayList list = (ArrayList)(key == null ? mapOrList : ((Map)mapOrList).get(key));
        if (list == null) {
            return null;
        }
        int n = list.size();
        if (n == 0 || !"_RLE_".equals(list.get(0))) {
            return list;
        }
        ArrayList<Object> list1 = QCSchemaUnits.newList();
        for (int i = 1; i < n; ++i) {
            int count = ((Number)list.get(i)).intValue();
            Object value = list.get(++i);
            for (int j = 0; j < count; ++j) {
                list1.add(value);
            }
        }
        return list1;
    }

    protected static ArrayList<Object> newList() {
        return new ArrayList<Object>();
    }

    public static double[] getDoubleArray(Object mapOrList, String key) {
        ArrayList<Object> list = QCSchemaUnits.getList(mapOrList, key);
        if (list == null) {
            return null;
        }
        double[] a = new double[list.size()];
        int i = a.length;
        while (--i >= 0) {
            try {
                a[i] = ((Number)list.get(i)).doubleValue();
            }
            catch (Exception e) {
                a[i] = Double.NaN;
            }
        }
        return a;
    }

    public static int[] getIntArray(Object mapOrList, String key) {
        ArrayList<Object> list = QCSchemaUnits.getList(mapOrList, key);
        if (list != null) {
            try {
                int[] a = new int[list.size()];
                int i = a.length;
                while (--i >= 0) {
                    a[i] = ((Number)list.get(i)).intValue();
                }
                return a;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String[] getStringArray(Object mapOrList, String key) {
        ArrayList<Object> list = QCSchemaUnits.getList(mapOrList, key);
        if (list == null) {
            return null;
        }
        String[] a = new String[list.size()];
        int i = a.length;
        while (--i >= 0) {
            Object o = list.get(i);
            a[i] = o == null ? null : list.get(i).toString();
        }
        return a;
    }
}

