/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import org.jboss.logging.Logger;
import org.keycloak.common.util.DurationConverter;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.workflow.DefaultWorkflowExecutionContext;
import org.keycloak.models.workflow.Workflow;
import org.keycloak.models.workflow.WorkflowExecutionContext;
import org.keycloak.models.workflow.WorkflowExecutionException;
import org.keycloak.models.workflow.WorkflowStateProvider;
import org.keycloak.models.workflow.WorkflowStep;
import org.keycloak.models.workflow.WorkflowTransactionalTask;
import org.keycloak.models.workflow.Workflows;

class RunWorkflowTask
extends WorkflowTransactionalTask {
    private static final Logger log = Logger.getLogger(RunWorkflowTask.class);
    protected final DefaultWorkflowExecutionContext context;

    RunWorkflowTask(DefaultWorkflowExecutionContext context) {
        super(context.getSession());
        this.context = context;
    }

    public void run(KeycloakSession session) {
        DefaultWorkflowExecutionContext context = new DefaultWorkflowExecutionContext(session, this.context);
        WorkflowStateProvider stateProvider = (WorkflowStateProvider)session.getProvider(WorkflowStateProvider.class);
        Workflow workflow = context.getWorkflow();
        String resourceId = context.getResourceId();
        String executionId = context.getExecutionId();
        WorkflowStep nextStep = this.runCurrentStep(context);
        while (nextStep != null) {
            if (DurationConverter.isPositiveDuration((String)nextStep.getAfter())) {
                log.debugf("Scheduling step %s to run in %s for resource %s (execution id: %s)", new Object[]{nextStep.getProviderId(), nextStep.getAfter(), resourceId, executionId});
                stateProvider.scheduleStep(workflow, nextStep, resourceId, executionId);
                return;
            }
            DefaultWorkflowExecutionContext stepContext = new DefaultWorkflowExecutionContext(session, this.context, nextStep);
            nextStep = this.runWorkflowStep(stepContext);
            if (!stepContext.isCompleted()) continue;
            return;
        }
        log.debugf("Workflow '%s' completed for resource %s (execution id: %s)", (Object)workflow.getName(), (Object)resourceId, (Object)executionId);
        stateProvider.remove(executionId);
    }

    protected WorkflowStep runCurrentStep(DefaultWorkflowExecutionContext context) {
        if (context.getStep() != null) {
            return this.runWorkflowStep(context);
        }
        return context.getWorkflow().getSteps().findFirst().orElse(null);
    }

    private WorkflowStep runWorkflowStep(DefaultWorkflowExecutionContext context) {
        WorkflowStep step = context.getStep();
        String executionId = context.getExecutionId();
        String resourceId = context.getResourceId();
        log.debugf("Running step %s on resource %s (execution id: %s)", (Object)step.getProviderId(), (Object)resourceId, (Object)executionId);
        try {
            Workflows.getStepProvider((KeycloakSession)context.getSession(), (WorkflowStep)step).run((WorkflowExecutionContext)context);
            log.debugf("Step %s completed successfully (execution id: %s)", (Object)step.getProviderId(), (Object)executionId);
        }
        catch (WorkflowExecutionException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Step %s failed (execution id: %s)");
            String errorMessage = e.getMessage();
            if (errorMessage != null) {
                sb.append(" - error message: %s");
                log.debugf(sb.toString(), (Object)step.getProviderId(), (Object)executionId, (Object)errorMessage);
            } else {
                log.debugf(sb.toString(), (Object)step.getProviderId(), (Object)executionId);
            }
            throw e;
        }
        return context.getNextStep();
    }
}

