/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import java.util.List;
import java.util.Optional;
import org.keycloak.config.ImportOptions;
import org.keycloak.config.Option;
import org.keycloak.config.OptionBuilder;
import org.keycloak.config.OptionCategory;
import org.keycloak.exportimport.Strategy;
import org.keycloak.quarkus.runtime.cli.Picocli;
import org.keycloak.quarkus.runtime.cli.PropertyException;
import org.keycloak.quarkus.runtime.cli.command.Import;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapperGrouping;

public final class ImportPropertyMappers
implements PropertyMapperGrouping {
    private static final String IMPORTER_PROPERTY = "kc.spi-import--importer";
    private static final String SINGLE_FILE = "singleFile";
    private static final String DIR = "dir";
    private static final Option<String> IMPORTER_PLACEHOLDER = new OptionBuilder("importer", String.class).category(OptionCategory.IMPORT).description("Placeholder for determining import mode").buildTime(false).hidden().build();

    public List<PropertyMapper<?>> getPropertyMappers() {
        return List.of(PropertyMapper.fromOption(IMPORTER_PLACEHOLDER).to(IMPORTER_PROPERTY).transformer(ImportPropertyMappers::transformImporter).paramLabel("file").build(), PropertyMapper.fromOption(ImportOptions.FILE).to("kc.spi-import--single-file--file").paramLabel("file").isEnabled(c -> c instanceof Import).build(), PropertyMapper.fromOption(ImportOptions.DIR).to("kc.spi-import--dir--dir").paramLabel(DIR).isEnabled(c -> c instanceof Import).build(), PropertyMapper.fromOption(ImportOptions.OVERRIDE).to("kc.spi-import--single-file--strategy").transformer(ImportPropertyMappers::transformOverride).isEnabled(ImportPropertyMappers::isSingleFileProvider).build(), PropertyMapper.fromOption(ImportOptions.OVERRIDE).to("kc.spi-import--dir--strategy").transformer(ImportPropertyMappers::transformOverride).isEnabled(ImportPropertyMappers::isDirProvider).build());
    }

    @Override
    public void validateConfig(Picocli picocli) {
        if (picocli.getParsedCommand().orElse(null) instanceof Import && Configuration.getOptionalValue(IMPORTER_PROPERTY).isEmpty() && System.getProperty("keycloak.migration.provider") == null) {
            throw new PropertyException("Must specify either --dir or --file options.");
        }
    }

    private static boolean isSingleFileProvider() {
        return ImportPropertyMappers.isProvider(SINGLE_FILE);
    }

    private static boolean isDirProvider() {
        return !ImportPropertyMappers.isSingleFileProvider();
    }

    private static boolean isProvider(String provider) {
        return Configuration.getOptionalValue(IMPORTER_PROPERTY).filter(provider::equals).isPresent();
    }

    private static String transformOverride(String option, ConfigSourceInterceptorContext context) {
        if (Boolean.parseBoolean(option)) {
            return Strategy.OVERWRITE_EXISTING.name();
        }
        return Strategy.IGNORE_EXISTING.name();
    }

    private static String transformImporter(String option, ConfigSourceInterceptorContext context) {
        ConfigValue importer = context.proceed(IMPORTER_PROPERTY);
        if (importer != null) {
            return importer.getValue();
        }
        Optional<String> file = Configuration.getOptionalValue("kc.spi-import--single-file--file").map(f -> SINGLE_FILE);
        Optional<String> dir = Configuration.getOptionalValue("kc.spi-import--dir--dir").or(() -> Configuration.getOptionalValue("kc.dir")).map(f -> DIR);
        boolean xor = file.isPresent() ^ dir.isPresent();
        return xor ? file.or(() -> dir).get() : null;
    }
}

