/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.vertx.http.runtime.security.ImmutablePathMatcher;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ImmutableSubstringMap<V> {
    private static final int ALL_BUT_LAST_BIT = -2;
    private final Object[] table;

    ImmutableSubstringMap(Object[] table) {
        this.table = Arrays.copyOf(table, table.length);
    }

    public SubstringMatch<V> get(String key, int length) {
        int pos;
        if (key.length() < length) {
            throw new IllegalArgumentException();
        }
        int hash = ImmutableSubstringMap.hash(key, length);
        int start = pos = ImmutableSubstringMap.tablePos(this.table, hash);
        while (this.table[pos] != null) {
            if (ImmutableSubstringMap.doEquals((String)this.table[pos], key, length)) {
                SubstringMatch match = (SubstringMatch)this.table[pos + 1];
                if (match == null) {
                    return null;
                }
                if (match.hasSubPathMatcher) {
                    String nextPath;
                    ImmutablePathMatcher.PathMatch subMatch;
                    int nextPathSegmentIdx;
                    if (key.length() > match.key.length() + 1 && (nextPathSegmentIdx = key.indexOf(47, match.key.length() + 1)) != -1 && (subMatch = match.subPathMatcher.match(nextPath = key.substring(nextPathSegmentIdx))).getValue() != null) {
                        return subMatch.getValue();
                    }
                    if (match.value == null) {
                        return null;
                    }
                }
                return match;
            }
            if ((pos += 2) >= this.table.length) {
                pos = 0;
            }
            if (pos != start) continue;
            return null;
        }
        return null;
    }

    static int tablePos(Object[] table, int hash) {
        return hash & table.length - 1 & 0xFFFFFFFE;
    }

    static boolean doEquals(String s1, String s2, int length) {
        if (s1.length() != length || s2.length() < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    static int hash(String value, int length) {
        if (length == 0) {
            return 0;
        }
        int h = 0;
        for (int i = 0; i < length; ++i) {
            h = 31 * h + value.charAt(i);
        }
        return h;
    }

    static <V> SubstringMapBuilder<V> builder() {
        return new SubstringMapBuilder();
    }

    public static final class SubstringMatch<V> {
        private final String key;
        private final V value;
        private final boolean hasSubPathMatcher;
        private final ImmutablePathMatcher<SubstringMatch<V>> subPathMatcher;

        SubstringMatch(String key, V value) {
            this.key = key;
            this.value = value;
            this.subPathMatcher = null;
            this.hasSubPathMatcher = false;
        }

        SubstringMatch(String key, V value, ImmutablePathMatcher<SubstringMatch<V>> subPathMatcher) {
            this.key = key;
            this.value = value;
            this.subPathMatcher = subPathMatcher;
            this.hasSubPathMatcher = subPathMatcher != null;
        }

        public String getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        boolean hasSubPathMatcher() {
            return this.hasSubPathMatcher;
        }
    }

    static final class SubstringMapBuilder<V> {
        private Object[] table = new Object[16];
        private int size;

        private SubstringMapBuilder() {
        }

        void put(String key, V value, ImmutablePathMatcher<SubstringMatch<V>> subPathMatcher) {
            Object[] newTable;
            if (key == null) {
                throw new NullPointerException();
            }
            if ((double)this.table.length / (double)this.size < 4.0 && this.table.length != Integer.MAX_VALUE) {
                newTable = new Object[this.table.length << 1];
                for (int i = 0; i < this.table.length; i += 2) {
                    if (this.table[i] == null) continue;
                    this.doPut(newTable, (String)this.table[i], this.table[i + 1]);
                }
            } else {
                newTable = new Object[this.table.length];
                System.arraycopy(this.table, 0, newTable, 0, this.table.length);
            }
            this.doPut(newTable, key, new SubstringMatch<V>(key, value, subPathMatcher));
            this.table = newTable;
            ++this.size;
        }

        private void doPut(Object[] newTable, String key, Object value) {
            int hash = ImmutableSubstringMap.hash(key, key.length());
            int pos = ImmutableSubstringMap.tablePos(newTable, hash);
            while (newTable[pos] != null && !newTable[pos].equals(key)) {
                if ((pos += 2) < newTable.length) continue;
                pos = 0;
            }
            newTable[pos] = key;
            newTable[pos + 1] = value;
        }

        public Iterable<String> keys() {
            return new Iterable<String>(){

                @Override
                public Iterator<String> iterator() {
                    int i;
                    final Object[] tMap = table;
                    for (i = 0; i < table.length && tMap[i] == null; i += 2) {
                    }
                    final int startPos = i;
                    return new Iterator<String>(){
                        private Object[] map;
                        private int pos;
                        {
                            this.map = tMap;
                            this.pos = startPos;
                        }

                        @Override
                        public boolean hasNext() {
                            return this.pos < table.length;
                        }

                        @Override
                        public String next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            String ret = (String)this.map[this.pos];
                            this.pos += 2;
                            while (this.pos < table.length && tMap[this.pos] == null) {
                                this.pos += 2;
                            }
                            return ret;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }

        ImmutableSubstringMap<V> build() {
            return new ImmutableSubstringMap(this.table);
        }
    }
}

