/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.slf4j.LoggerFactory;
import twitter4j.JULLogger;
import twitter4j.Log4JLogger;
import twitter4j.SLF4JLogger;

abstract class Logger {
    private static final Function<String, Logger> factory;

    Logger() {
    }

    public static Logger getLogger() {
        String className = new Throwable().getStackTrace()[1].getClassName();
        return factory.apply(className);
    }

    public abstract boolean isDebugEnabled();

    public abstract boolean isInfoEnabled();

    public abstract boolean isWarnEnabled();

    public abstract boolean isErrorEnabled();

    public abstract void debug(String var1);

    public abstract void debug(String var1, String var2);

    public abstract void info(String var1);

    public abstract void info(String var1, String var2);

    public abstract void warn(String var1);

    public abstract void warn(String var1, String var2);

    public abstract void warn(String var1, Throwable var2);

    public abstract void error(String var1);

    public abstract void error(String var1, Throwable var2);

    static {
        Function<String, Logger> factoryTemp;
        try {
            Class.forName("org.slf4j.impl.StaticLoggerBinder");
            factoryTemp = className -> new SLF4JLogger(LoggerFactory.getLogger((String)className));
        }
        catch (ClassNotFoundException ignore) {
            try {
                Class.forName("org.apache.logging.log4j.Logger");
                factoryTemp = className -> new Log4JLogger(LogManager.getLogger((String)className));
            }
            catch (ClassNotFoundException e) {
                factoryTemp = className -> new JULLogger(java.util.logging.Logger.getLogger(className));
            }
        }
        factory = factoryTemp;
    }
}

