/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions.util;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.NotFoundException;
import java.util.Map;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticatorUtil;
import org.keycloak.authentication.authenticators.util.LoAUtil;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.CredentialTypeMetadata;
import org.keycloak.credential.CredentialTypeMetadataContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class CredentialDeleteHelper {
    private static final Logger logger = Logger.getLogger(CredentialDeleteHelper.class);

    public static CredentialModel removeCredential(KeycloakSession session, UserModel user, String credentialId, Supplier<Integer> currentLoAProvider) {
        CredentialModel credential = user.credentialManager().getStoredCredentialById(credentialId);
        if (credential == null) {
            if (user.isFederated() && (credential = (CredentialModel)user.credentialManager().getFederatedCredentialsStream().filter(c -> credentialId.equals(c.getId())).findAny().orElse(null)) != null) {
                String type = credential.getType();
                CredentialDeleteHelper.checkIfCanBeRemoved(session, user, type, currentLoAProvider);
                user.credentialManager().disableCredentialType(type);
                return null;
            }
            if (credentialId.endsWith("-id")) {
                String credentialType = credentialId.substring(0, credentialId.length() - 3);
                CredentialDeleteHelper.checkIfCanBeRemoved(session, user, credentialType, currentLoAProvider);
                user.credentialManager().disableCredentialType(credentialType);
                return null;
            }
            throw new NotFoundException("Credential not found");
        }
        CredentialDeleteHelper.checkIfCanBeRemoved(session, user, credential.getType(), currentLoAProvider);
        user.credentialManager().removeStoredCredentialById(credentialId);
        return credential;
    }

    private static void checkIfCanBeRemoved(KeycloakSession session, UserModel user, String credentialType, Supplier<Integer> currentLoAProvider) {
        CredentialProvider credentialProvider = AuthenticatorUtil.getCredentialProviders(session).filter(credentialProvider1 -> credentialProvider1.supportsCredentialType(credentialType)).findAny().orElse(null);
        if (credentialProvider == null) {
            logger.warnf("Credential provider %s not found", (Object)credentialType);
            throw new NotFoundException("Credential provider not found");
        }
        CredentialTypeMetadataContext ctx = CredentialTypeMetadataContext.builder().user(user).build(session);
        CredentialTypeMetadata metadata = credentialProvider.getCredentialTypeMetadata(ctx);
        if (!metadata.isRemoveable()) {
            logger.warnf("Credential type %s cannot be removed", (Object)credentialType);
            throw new BadRequestException("Credential type cannot be removed");
        }
        CredentialDeleteHelper.checkAuthenticatedLoASufficientForCredentialRemove(session, credentialType, currentLoAProvider);
    }

    private static void checkAuthenticatedLoASufficientForCredentialRemove(KeycloakSession session, String credentialType, Supplier<Integer> currentLoAProvider) {
        int requestedLoaForCredentialRemove = CredentialDeleteHelper.getRequestedLoaForCredential(session, session.getContext().getRealm(), credentialType);
        int currentAuthenticatedLevel = currentLoAProvider.get();
        if (currentAuthenticatedLevel < requestedLoaForCredentialRemove) {
            throw new ForbiddenException("Insufficient level of authentication for removing credential of type '" + credentialType + "'.");
        }
    }

    private static int getRequestedLoaForCredential(KeycloakSession session, RealmModel realm, String credentialType) {
        Map<String, Integer> credentialTypesToLoa = LoAUtil.getCredentialTypesToLoAMap(session, realm, realm.getBrowserFlow());
        return credentialTypesToLoa.getOrDefault(credentialType, -1);
    }
}

