/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.providers.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.resolve.calls.overloads.ConeEquivalentCallConflictResolver;
import org.jetbrains.kotlin.fir.resolve.providers.FirCompositeSymbolNamesProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolNamesProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderInternals;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001;B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010 2\u0006\u0010!\u001a\u00020\u000fH\u0016J\"\u0010\"\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J*\u0010'\u001a\u00020(2\u0010\u0010)\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170*2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0017J&\u0010+\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020,0*2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0017J&\u0010-\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020.0*2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0017J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020$H\u0016JD\u00102\u001a\b\u0012\u0004\u0012\u0002H30\f\"\b\b\u0000\u00104*\u000205\"\u000e\b\u0001\u00103*\b\u0012\u0004\u0012\u0002H40\u00172\f\u00106\u001a\b\u0012\u0004\u0012\u0002H30\f2\f\u00107\u001a\b\u0012\u0004\u0012\u0002H30\fH\u0002J\u0018\u00108\u001a\u0002002\u0006\u00109\u001a\u0002052\u0006\u0010:\u001a\u000205H\u0002R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0015\u001a\u0018\u0012\u0004\u0012\u00020\u0016\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\f0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\u0018\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0017\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0012R\"\u0010\u001a\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0017\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirCommonDeclarationsMappingSymbolProvider;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "commonSymbolProvider", "platformSymbolProvider", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;)V", "getCommonSymbolProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "getPlatformSymbolProvider", "providers", "", "classMapping", "", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirCommonDeclarationsMappingSymbolProvider$ClassPair;", "getClassMapping", "()Ljava/util/Map;", "_classMapping", "", "processedCallables", "Lorg/jetbrains/kotlin/name/CallableId;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "commonCallableToPlatformCallableMap", "getCommonCallableToPlatformCallableMap", "_commonCallableToPlatformCallableMap", "symbolNamesProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "getSymbolNamesProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "getClassLikeSymbolByClassId", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "classId", "getTopLevelCallableSymbols", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getTopLevelCallableSymbolsTo", "", "destination", "", "getTopLevelFunctionSymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getTopLevelPropertySymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "hasPackage", "", "fqName", "preferPlatformDeclarations", "S", "D", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "commonDeclarations", "platformDeclarations", "areEquivalentTopLevelCallables", "first", "second", "ClassPair", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirCommonDeclarationsMappingSymbolProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCommonDeclarationsMappingSymbolProvider.kt\norg/jetbrains/kotlin/fir/resolve/providers/impl/FirCommonDeclarationsMappingSymbolProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1#2:133\n822#3,2:134\n822#3,2:136\n1807#3,3:138\n296#3,2:141\n*S KotlinDebug\n*F\n+ 1 FirCommonDeclarationsMappingSymbolProvider.kt\norg/jetbrains/kotlin/fir/resolve/providers/impl/FirCommonDeclarationsMappingSymbolProvider\n*L\n90#1:134,2\n95#1:136,2\n99#1:138,3\n109#1:141,2\n*E\n"})
public final class FirCommonDeclarationsMappingSymbolProvider
extends FirSymbolProvider {
    @NotNull
    private final FirSymbolProvider commonSymbolProvider;
    @NotNull
    private final FirSymbolProvider platformSymbolProvider;
    @NotNull
    private final List<FirSymbolProvider> providers;
    @NotNull
    private final Map<ClassId, ClassPair> _classMapping;
    @NotNull
    private final Map<CallableId, List<FirCallableSymbol<?>>> processedCallables;
    @NotNull
    private final Map<FirCallableSymbol<?>, FirCallableSymbol<?>> _commonCallableToPlatformCallableMap;
    @NotNull
    private final FirSymbolNamesProvider symbolNamesProvider;

    public FirCommonDeclarationsMappingSymbolProvider(@NotNull FirSession session, @NotNull FirSymbolProvider commonSymbolProvider, @NotNull FirSymbolProvider platformSymbolProvider) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(commonSymbolProvider, "commonSymbolProvider");
        Intrinsics.checkNotNullParameter(platformSymbolProvider, "platformSymbolProvider");
        super(session);
        this.commonSymbolProvider = commonSymbolProvider;
        this.platformSymbolProvider = platformSymbolProvider;
        FirSymbolProvider[] firSymbolProviderArray = new FirSymbolProvider[]{this.commonSymbolProvider, this.platformSymbolProvider};
        this.providers = CollectionsKt.listOf(firSymbolProviderArray);
        this._classMapping = new LinkedHashMap();
        this.processedCallables = new HashMap();
        this._commonCallableToPlatformCallableMap = new LinkedHashMap();
        this.symbolNamesProvider = FirCompositeSymbolNamesProvider.Companion.fromSymbolProviders(this.providers);
    }

    @NotNull
    public final FirSymbolProvider getCommonSymbolProvider() {
        return this.commonSymbolProvider;
    }

    @NotNull
    public final FirSymbolProvider getPlatformSymbolProvider() {
        return this.platformSymbolProvider;
    }

    @NotNull
    public final Map<ClassId, ClassPair> getClassMapping() {
        return this._classMapping;
    }

    @NotNull
    public final Map<FirCallableSymbol<?>, FirCallableSymbol<?>> getCommonCallableToPlatformCallableMap() {
        return this._commonCallableToPlatformCallableMap;
    }

    @Override
    @NotNull
    public FirSymbolNamesProvider getSymbolNamesProvider() {
        return this.symbolNamesProvider;
    }

    @Override
    @Nullable
    public FirClassLikeSymbol<?> getClassLikeSymbolByClassId(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        FirClassLikeSymbol<?> commonSymbol = this.commonSymbolProvider.getClassLikeSymbolByClassId(classId);
        FirClassLikeSymbol<?> platformSymbol = this.platformSymbolProvider.getClassLikeSymbolByClassId(classId);
        if (commonSymbol == null && platformSymbol == null) {
            return null;
        }
        this._classMapping.put(classId, new ClassPair(commonSymbol, platformSymbol));
        return commonSymbol == null ? platformSymbol : (platformSymbol == null ? commonSymbol : (Intrinsics.areEqual(commonSymbol, platformSymbol) ? commonSymbol : platformSymbol));
    }

    @Override
    @NotNull
    public List<FirCallableSymbol<?>> getTopLevelCallableSymbols(@NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(name2, "name");
        CallableId callableId = new CallableId(packageFqName, name2);
        List<FirCallableSymbol<?>> list = this.processedCallables.get(callableId);
        if (list != null) {
            List<FirCallableSymbol<?>> it = list;
            boolean bl = false;
            return it;
        }
        List<FirCallableSymbol<?>> commonDeclarations = this.commonSymbolProvider.getTopLevelCallableSymbols(packageFqName, name2);
        List<FirCallableSymbol<?>> platformDeclarations = this.platformSymbolProvider.getTopLevelCallableSymbols(packageFqName, name2);
        List<FirCallableSymbol<?>> resultingDeclarations = this.preferPlatformDeclarations(commonDeclarations, platformDeclarations);
        this.processedCallables.put(callableId, resultingDeclarations);
        return resultingDeclarations;
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelCallableSymbolsTo(@NotNull List<FirCallableSymbol<?>> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(name2, "name");
        CollectionsKt.addAll((Collection)destination, (Iterable)this.getTopLevelCallableSymbols(packageFqName, name2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @FirSymbolProviderInternals
    public void getTopLevelFunctionSymbolsTo(@NotNull List<FirNamedFunctionSymbol> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        void $this$filterIsInstanceTo$iv;
        Intrinsics.checkNotNullParameter(destination, "destination");
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(name2, "name");
        Iterable iterable = this.getTopLevelCallableSymbols(packageFqName, name2);
        Collection destination$iv = destination;
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv : $this$filterIsInstanceTo$iv) {
            if (!(element$iv instanceof FirNamedFunctionSymbol)) continue;
            destination$iv.add(element$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @FirSymbolProviderInternals
    public void getTopLevelPropertySymbolsTo(@NotNull List<FirPropertySymbol> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        void $this$filterIsInstanceTo$iv;
        Intrinsics.checkNotNullParameter(destination, "destination");
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(name2, "name");
        Iterable iterable = this.getTopLevelCallableSymbols(packageFqName, name2);
        Collection destination$iv = destination;
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv : $this$filterIsInstanceTo$iv) {
            if (!(element$iv instanceof FirPropertySymbol)) continue;
            destination$iv.add(element$iv);
        }
    }

    @Override
    public boolean hasPackage(@NotNull FqName fqName) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(fqName, "fqName");
            Iterable $this$any$iv = this.providers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirSymbolProvider it = (FirSymbolProvider)element$iv;
                    boolean bl2 = false;
                    if (!it.hasPackage(fqName)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final <D extends FirCallableDeclaration, S extends FirCallableSymbol<? extends D>> List<S> preferPlatformDeclarations(List<? extends S> commonDeclarations, List<? extends S> platformDeclarations) {
        List result2 = CollectionsKt.toMutableList((Collection)platformDeclarations);
        for (FirCallableSymbol commonSymbol : commonDeclarations) {
            Object v0;
            block3: {
                Iterable $this$firstOrNull$iv = platformDeclarations;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FirCallableSymbol it = (FirCallableSymbol)element$iv;
                    boolean bl = false;
                    if (!this.areEquivalentTopLevelCallables((FirCallableDeclaration)it.getFir(), (FirCallableDeclaration)commonSymbol.getFir())) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            FirCallableSymbol matchingPlatformSymbol = v0;
            if (matchingPlatformSymbol != null) {
                this._commonCallableToPlatformCallableMap.put(commonSymbol, matchingPlatformSymbol);
                continue;
            }
            ((Collection)result2).add(commonSymbol);
        }
        return result2;
    }

    private final boolean areEquivalentTopLevelCallables(FirCallableDeclaration first, FirCallableDeclaration second) {
        return ConeEquivalentCallConflictResolver.Companion.areEquivalentTopLevelCallables(first, second, this.getSession(), null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003H\u00c6\u0003J)\u0010\f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003H\u00c6\u0001J\u0014\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirCommonDeclarationsMappingSymbolProvider$ClassPair;", "", "commonClass", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "platformClass", "<init>", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;)V", "getCommonClass", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "getPlatformClass", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "resolve"})
    public static final class ClassPair {
        @Nullable
        private final FirClassLikeSymbol<?> commonClass;
        @Nullable
        private final FirClassLikeSymbol<?> platformClass;

        public ClassPair(@Nullable FirClassLikeSymbol<?> commonClass, @Nullable FirClassLikeSymbol<?> platformClass) {
            this.commonClass = commonClass;
            this.platformClass = platformClass;
        }

        @Nullable
        public final FirClassLikeSymbol<?> getCommonClass() {
            return this.commonClass;
        }

        @Nullable
        public final FirClassLikeSymbol<?> getPlatformClass() {
            return this.platformClass;
        }

        @Nullable
        public final FirClassLikeSymbol<?> component1() {
            return this.commonClass;
        }

        @Nullable
        public final FirClassLikeSymbol<?> component2() {
            return this.platformClass;
        }

        @NotNull
        public final ClassPair copy(@Nullable FirClassLikeSymbol<?> commonClass, @Nullable FirClassLikeSymbol<?> platformClass) {
            return new ClassPair(commonClass, platformClass);
        }

        public static /* synthetic */ ClassPair copy$default(ClassPair classPair, FirClassLikeSymbol firClassLikeSymbol, FirClassLikeSymbol firClassLikeSymbol2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                firClassLikeSymbol = classPair.commonClass;
            }
            if ((n2 & 2) != 0) {
                firClassLikeSymbol2 = classPair.platformClass;
            }
            return classPair.copy(firClassLikeSymbol, firClassLikeSymbol2);
        }

        @NotNull
        public String toString() {
            return "ClassPair(commonClass=" + this.commonClass + ", platformClass=" + this.platformClass + ')';
        }

        public int hashCode() {
            int result2 = this.commonClass == null ? 0 : this.commonClass.hashCode();
            result2 = result2 * 31 + (this.platformClass == null ? 0 : this.platformClass.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClassPair)) {
                return false;
            }
            ClassPair classPair = (ClassPair)other;
            if (!Intrinsics.areEqual(this.commonClass, classPair.commonClass)) {
                return false;
            }
            return Intrinsics.areEqual(this.platformClass, classPair.platformClass);
        }
    }
}

