RSpec.describe Mdm::ExploitAttempt, type: :model do
  it_should_behave_like 'Metasploit::Concern.run'

  context 'associations' do
    it { is_expected.to belong_to(:host).class_name('Mdm::Host') }
  end

  context 'database' do

    context 'timestamps'do
      it { is_expected.to have_db_column(:attempted_at).of_type(:datetime) }
    end

    context 'columns' do
      it { is_expected.to have_db_column(:host_id).of_type(:integer) }
      it { is_expected.to have_db_column(:service_id).of_type(:integer) }
      it { is_expected.to have_db_column(:vuln_id).of_type(:integer) }
      it { is_expected.to have_db_column(:exploited).of_type(:boolean) }
      it { is_expected.to have_db_column(:fail_reason).of_type(:string) }
      it { is_expected.to have_db_column(:username).of_type(:string) }
      it { is_expected.to have_db_column(:module).of_type(:text) }
      it { is_expected.to have_db_column(:session_id).of_type(:integer) }
      it { is_expected.to have_db_column(:loot_id).of_type(:integer) }
      it { is_expected.to have_db_column(:port).of_type(:integer) }
      it { is_expected.to have_db_column(:proto).of_type(:string) }
      it { is_expected.to have_db_column(:fail_detail).of_type(:text) }
    end
  end

  context '#destroy' do
    it 'should successfully destroy the object and all dependent objects' do
      exploit_attempt = FactoryBot.create(:mdm_exploit_attempt)
      expect {
        exploit_attempt.destroy
      }.to_not raise_error
      expect {
        exploit_attempt.reload
      }.to raise_error(ActiveRecord::RecordNotFound)

    end
  end

  context 'validations' do
    it 'should only be valid with a host_id' do
      orphaned_attempt = FactoryBot.build(:mdm_exploit_attempt, :host => nil)
      expect(orphaned_attempt).not_to be_valid
      expect(orphaned_attempt.errors[:host_id]).to include("can't be blank")
      propper_attempt = FactoryBot.create(:mdm_exploit_attempt)
      expect(propper_attempt).to be_valid
    end
  end

  context 'factory' do
    it 'should be valid' do
      exploit_attempt = FactoryBot.create(:mdm_exploit_attempt)
      expect(exploit_attempt).to be_valid
    end
  end
end
