/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal;

import java.io.IOException;
import oracle.security.pki.util.CertType;
import oracle.security.pki.util.TrustFlags;

public class OracleTrustFlagHelper {
    public static String evaluateTrustFlagForCert(String string, String string2, int n, String string3) {
        String string4 = TrustFlags.NZTF_NULL.getDisplayName();
        if (null != string2 && null != string) {
            string4 = string2.equalsIgnoreCase(string) ? (n != -1 && string3.equals((Object)CertType.TRUSTED) ? TrustFlags.NZTF_SERVER_AUTH.getDisplayName() : TrustFlags.NZTF_VALID_PEER.getDisplayName()) : (string3.equals((Object)CertType.USER) ? TrustFlags.NZTF_USER_CERT.getDisplayName() : (n == -1 ? TrustFlags.NZTF_VALID_PEER.getDisplayName() : TrustFlags.NZTF_NULL.getDisplayName()));
        }
        return string4;
    }

    public static String recalculateTrustFlagforTrustCert(String string, String string2, int n, String string3) throws IOException {
        if (null == string2) {
            string3 = TrustFlags.NZTF_NULL.getDisplayName();
        } else if (null == string3 || string3.equals("") || string3.equals(TrustFlags.NZTF_NONE.getDisplayName())) {
            string3 = string2 != null && string != null && string2.equals(string) ? TrustFlags.NZTF_SERVER_AUTH.getDisplayName() : (n != -1 ? TrustFlags.NZTF_NULL.getDisplayName() : TrustFlags.NZTF_VALID_PEER.getDisplayName());
        } else if (null != string3) {
            if (string3.equals(TrustFlags.NZTF_VALID_PEER.getDisplayName()) && n != -1) {
                throw new IOException("Cannot assign VALID_PEER flag to a CA certificate.");
            }
            if ((string3.contains(TrustFlags.NZTF_SERVER_AUTH.getDisplayName()) || string3.contains(TrustFlags.NZTF_CLIENT_AUTH.getDisplayName())) && n == -1) {
                throw new IOException("Cannot assign CLIENT_AUTH or SERVER_AUTH flag to a end entity certificate.");
            }
        }
        return string3;
    }

    public static boolean validateTrustFlags(String string) {
        boolean bl = true;
        if ((string = string.trim()) == null || "".equals(string)) {
            return false;
        }
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
            if (string.length() > TrustFlags.NZTF_VALID_PEER.getDisplayName().length() && TrustFlags.NZTF_VALID_PEER.getDisplayName().equals(stringArray[i])) {
                bl = false;
                break;
            }
            if (string.length() > TrustFlags.NZTF_NULL.getDisplayName().length() && TrustFlags.NZTF_NULL.getDisplayName().equals(stringArray[i])) {
                bl = false;
                break;
            }
            if (TrustFlags.NZTF_TRUSTED.getDisplayName().equals(stringArray[i])) {
                bl = false;
                break;
            }
            if ("".equals(stringArray[i])) {
                bl = false;
                break;
            }
            if (TrustFlags.NZTF_CLIENT_AUTH.getDisplayName().equals(stringArray[i]) || TrustFlags.NZTF_SERVER_AUTH.getDisplayName().equals(stringArray[i]) || TrustFlags.NZTF_NULL.getDisplayName().equals(stringArray[i]) || TrustFlags.NZTF_VALID_PEER.getDisplayName().equals(stringArray[i])) continue;
            bl = false;
            break;
        }
        return bl;
    }
}

