/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.streamingingestion;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.opensearch.action.admin.indices.streamingingestion.IngestionStateShardFailure;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

@ExperimentalApi
public class IngestionUpdateStateResponse
extends AcknowledgedResponse {
    protected static final String SHARD_ACK = "shards_acknowledged";
    protected static final String ERROR = "error";
    protected static final String FAILURES = "failures";
    protected boolean shardsAcknowledged;
    protected IngestionStateShardFailure[] shardFailuresList;
    protected String errorMessage;

    public IngestionUpdateStateResponse(StreamInput in) throws IOException {
        super(in);
        this.shardFailuresList = (IngestionStateShardFailure[])in.readArray(IngestionStateShardFailure::new, IngestionStateShardFailure[]::new);
        this.errorMessage = in.readString();
        this.shardsAcknowledged = in.readBoolean();
    }

    public IngestionUpdateStateResponse(boolean acknowledged, boolean shardsAcknowledged, IngestionStateShardFailure[] shardFailuresList, String errorMessage) {
        super(acknowledged);
        this.shardFailuresList = shardFailuresList;
        this.shardsAcknowledged = shardsAcknowledged;
        this.errorMessage = errorMessage;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeArray((Writeable[])this.shardFailuresList);
        out.writeString(this.errorMessage);
        out.writeBoolean(this.shardsAcknowledged);
    }

    @Override
    protected void addCustomFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.addCustomFields(builder, params);
        builder.field(SHARD_ACK, this.shardsAcknowledged);
        if (!Strings.isEmpty((CharSequence)this.errorMessage)) {
            builder.field(ERROR, this.errorMessage);
        }
        if (this.shardFailuresList.length > 0) {
            Map<String, List<IngestionStateShardFailure>> shardFailuresByIndex = IngestionStateShardFailure.groupShardFailuresByIndex(this.shardFailuresList);
            builder.startObject(FAILURES);
            for (Map.Entry<String, List<IngestionStateShardFailure>> indexShardFailures : shardFailuresByIndex.entrySet()) {
                builder.startArray(indexShardFailures.getKey());
                for (IngestionStateShardFailure shardFailure : indexShardFailures.getValue()) {
                    shardFailure.toXContent(builder, params);
                }
                builder.endArray();
            }
            builder.endObject();
        }
    }

    public String toString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
    }

    public boolean isShardsAcknowledged() {
        return this.shardsAcknowledged;
    }

    public IngestionStateShardFailure[] getShardFailures() {
        return this.shardFailuresList;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

