/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.response.exceptions.shardoperationfailedexception;

import java.io.IOException;
import org.opensearch.action.admin.indices.close.CloseIndexResponse;
import org.opensearch.action.admin.indices.readonly.AddIndexBlockResponse;
import org.opensearch.action.admin.indices.shards.IndicesShardStoresResponse;
import org.opensearch.core.action.support.DefaultShardOperationFailedException;
import org.opensearch.protobufs.ShardFailure;
import org.opensearch.transport.grpc.proto.response.exceptions.opensearchexception.OpenSearchExceptionProtoUtils;

public class DefaultShardOperationFailedExceptionProtoUtils {
    private DefaultShardOperationFailedExceptionProtoUtils() {
    }

    public static ShardFailure toProto(DefaultShardOperationFailedException exception) throws IOException {
        ShardFailure.Builder shardFailureBuilder = ShardFailure.newBuilder();
        if (exception instanceof AddIndexBlockResponse.AddBlockShardResult.Failure) {
            DefaultShardOperationFailedExceptionProtoUtils.innerToProto(shardFailureBuilder, (AddIndexBlockResponse.AddBlockShardResult.Failure)exception);
        } else if (exception instanceof IndicesShardStoresResponse.Failure) {
            DefaultShardOperationFailedExceptionProtoUtils.innerToProto(shardFailureBuilder, (IndicesShardStoresResponse.Failure)exception);
        } else if (exception instanceof CloseIndexResponse.ShardResult.Failure) {
            DefaultShardOperationFailedExceptionProtoUtils.innerToProto(shardFailureBuilder, (CloseIndexResponse.ShardResult.Failure)exception);
        } else {
            DefaultShardOperationFailedExceptionProtoUtils.parentInnerToProto(shardFailureBuilder, exception);
        }
        return shardFailureBuilder.build();
    }

    public static void innerToProto(ShardFailure.Builder shardFailureBuilder, AddIndexBlockResponse.AddBlockShardResult.Failure exception) throws IOException {
        if (exception.getNodeId() != null) {
            shardFailureBuilder.setNode(exception.getNodeId());
        }
        DefaultShardOperationFailedExceptionProtoUtils.parentInnerToProto(shardFailureBuilder, (DefaultShardOperationFailedException)exception);
    }

    public static void innerToProto(ShardFailure.Builder shardFailureBuilder, IndicesShardStoresResponse.Failure exception) throws IOException {
        shardFailureBuilder.setNode(exception.nodeId());
        DefaultShardOperationFailedExceptionProtoUtils.parentInnerToProto(shardFailureBuilder, (DefaultShardOperationFailedException)exception);
    }

    public static void innerToProto(ShardFailure.Builder shardFailureBuilder, CloseIndexResponse.ShardResult.Failure exception) throws IOException {
        if (exception.getNodeId() != null) {
            shardFailureBuilder.setNode(exception.getNodeId());
        }
        DefaultShardOperationFailedExceptionProtoUtils.parentInnerToProto(shardFailureBuilder, (DefaultShardOperationFailedException)exception);
    }

    public static void parentInnerToProto(ShardFailure.Builder shardFailureBuilder, DefaultShardOperationFailedException exception) throws IOException {
        shardFailureBuilder.setShard(exception.shardId());
        if (exception.index() != null) {
            shardFailureBuilder.setIndex(exception.index());
        }
        shardFailureBuilder.setStatus(exception.status().name());
        if (exception.reason() != null) {
            shardFailureBuilder.setReason(OpenSearchExceptionProtoUtils.generateThrowableProto(exception.getCause()));
        }
    }
}

