/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.filecache;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.opensearch.index.store.remote.filecache.FileCache;

public class FileCachedIndexInput
extends IndexInput
implements RandomAccessInput {
    protected final FileCache cache;
    protected Path filePath;
    protected IndexInput luceneIndexInput;
    protected final boolean isClone;
    protected final AtomicBoolean closed = new AtomicBoolean(false);

    public FileCachedIndexInput(FileCache cache, Path filePath, IndexInput underlyingIndexInput) {
        this(cache, filePath, underlyingIndexInput, false);
    }

    FileCachedIndexInput(FileCache cache, Path filePath, IndexInput underlyingIndexInput, boolean isClone) {
        super("FileCachedIndexInput (path=" + filePath.toString() + ")");
        this.cache = cache;
        this.filePath = filePath;
        this.luceneIndexInput = underlyingIndexInput;
        this.isClone = isClone;
    }

    public long getFilePointer() {
        return this.luceneIndexInput.getFilePointer();
    }

    public void seek(long pos) throws IOException {
        this.luceneIndexInput.seek(pos);
    }

    public long length() {
        return this.luceneIndexInput.length();
    }

    public byte readByte() throws IOException {
        return this.luceneIndexInput.readByte();
    }

    public short readShort() throws IOException {
        return this.luceneIndexInput.readShort();
    }

    public int readInt() throws IOException {
        return this.luceneIndexInput.readInt();
    }

    public long readLong() throws IOException {
        return this.luceneIndexInput.readLong();
    }

    public final int readVInt() throws IOException {
        return this.luceneIndexInput.readVInt();
    }

    public final long readVLong() throws IOException {
        return this.luceneIndexInput.readVLong();
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        this.luceneIndexInput.readBytes(b, offset, len);
    }

    public byte readByte(long pos) throws IOException {
        return ((RandomAccessInput)this.luceneIndexInput).readByte(pos);
    }

    public short readShort(long pos) throws IOException {
        return ((RandomAccessInput)this.luceneIndexInput).readShort(pos);
    }

    public int readInt(long pos) throws IOException {
        return ((RandomAccessInput)this.luceneIndexInput).readInt(pos);
    }

    public long readLong(long pos) throws IOException {
        return ((RandomAccessInput)this.luceneIndexInput).readLong(pos);
    }

    public FileCachedIndexInput clone() {
        this.cache.incRef(this.filePath);
        return new FileCachedIndexInput(this.cache, this.filePath, this.luceneIndexInput.clone(), true);
    }

    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        throw new UnsupportedOperationException("FileCachedIndexInput couldn't be sliced.");
    }

    public void close() throws IOException {
        if (!this.closed.get()) {
            this.luceneIndexInput.close();
            this.luceneIndexInput = null;
            if (this.isClone) {
                this.cache.decRef(this.filePath);
            }
            this.closed.set(true);
        }
    }
}

