/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.util;

import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.ForecastDescriptor;
import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import com.amazon.randomcutforest.parkservices.returntypes.RCFComputeDescriptor;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opensearch.ad.ml.ThresholdingResult;
import org.opensearch.ad.model.ImputedFeatureResult;
import org.opensearch.forecast.ml.RCFCasterResult;
import org.opensearch.timeseries.dataprocessor.ImputationMethod;
import org.opensearch.timeseries.dataprocessor.ImputationOption;
import org.opensearch.timeseries.model.Config;

public class ModelUtil {
    public static ImputedFeatureResult calculateImputedFeatures(AnomalyDescriptor anomalyDescriptor, double[] point, boolean isImputed, Config config) {
        double[] actual;
        boolean[] isFeatureImputed;
        block8: {
            int inputLength = anomalyDescriptor.getInputLength();
            isFeatureImputed = null;
            actual = point;
            if (!isImputed) break block8;
            actual = new double[inputLength];
            isFeatureImputed = new boolean[inputLength];
            ImputationOption imputationOption = config.getImputationOption();
            if (imputationOption != null && imputationOption.getMethod() == ImputationMethod.ZERO) {
                for (int i = 0; i < point.length; ++i) {
                    if (!Double.isNaN(point[i])) continue;
                    isFeatureImputed[i] = true;
                    actual[i] = 0.0;
                }
            } else if (imputationOption != null && imputationOption.getMethod() == ImputationMethod.FIXED_VALUES) {
                Map<String, Double> defaultFills = imputationOption.getDefaultFill();
                List<String> enabledFeatureNames = config.getEnabledFeatureNames();
                for (int i = 0; i < point.length; ++i) {
                    if (!Double.isNaN(point[i])) continue;
                    isFeatureImputed[i] = true;
                    actual[i] = defaultFills.get(enabledFeatureNames.get(i));
                }
            } else {
                float[] rcfPoint = anomalyDescriptor.getRCFPoint();
                if (rcfPoint == null) {
                    return new ImputedFeatureResult(isFeatureImputed, actual);
                }
                float[] transformedInput = new float[inputLength];
                System.arraycopy(rcfPoint, rcfPoint.length - inputLength, transformedInput, 0, inputLength);
                double[] scale = anomalyDescriptor.getScale();
                double[] shift = anomalyDescriptor.getShift();
                for (int i = 0; i < point.length; ++i) {
                    if (!Double.isNaN(point[i])) continue;
                    isFeatureImputed[i] = true;
                    actual[i] = (double)transformedInput[i] * scale[i] + shift[i];
                }
            }
        }
        return new ImputedFeatureResult(isFeatureImputed, actual);
    }

    public static RCFCasterResult toResult(RandomCutForest forecast, ForecastDescriptor castDescriptor, double[] point, boolean isImputed) {
        if (castDescriptor instanceof ForecastDescriptor) {
            ForecastDescriptor forecastDescriptor = castDescriptor;
            return new RCFCasterResult(forecastDescriptor.getTimedForecast().rangeVector, forecastDescriptor.getDataConfidence(), forecast.getTotalUpdates(), forecastDescriptor.getRCFScore());
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Unsupported type of AnomalyDescriptor : %s", castDescriptor));
    }

    public static ThresholdingResult toResult(RandomCutForest rcf, AnomalyDescriptor anomalyDescriptor, double[] point, boolean isImputed, Config config) {
        ImputedFeatureResult result = ModelUtil.calculateImputedFeatures(anomalyDescriptor, point, isImputed, config);
        return new ThresholdingResult(anomalyDescriptor.getAnomalyGrade(), anomalyDescriptor.getDataConfidence(), anomalyDescriptor.getRCFScore(), anomalyDescriptor.getTotalUpdates(), anomalyDescriptor.getRelativeIndex(), ModelUtil.normalizeAttribution(rcf, anomalyDescriptor.getRelevantAttribution()), anomalyDescriptor.getPastValues(), anomalyDescriptor.getExpectedValuesList(), anomalyDescriptor.getLikelihoodOfValues(), anomalyDescriptor.getThreshold(), anomalyDescriptor.getNumberOfTrees(), result.getActual(), result.getIsFeatureImputed());
    }

    public static double[] normalizeAttribution(RandomCutForest forest, double[] rawAttribution) {
        double sum;
        if (forest == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Empty forest", new Object[0]));
        }
        double[] attribution = ModelUtil.createEmptyAttribution(forest);
        if (rawAttribution != null && rawAttribution.length > 0 && (sum = Arrays.stream(rawAttribution).sum()) > 0.0) {
            if (rawAttribution.length != attribution.length) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Unexpected attribution array length: expected %d but is %d", attribution.length, rawAttribution.length));
            }
            int numFeatures = rawAttribution.length;
            attribution = new double[numFeatures];
            for (int i = 0; i < numFeatures; ++i) {
                attribution[i] = rawAttribution[i] / sum;
            }
        }
        return attribution;
    }

    public static double[] createEmptyAttribution(RandomCutForest forest) {
        int shingleSize = forest.getShingleSize();
        if (shingleSize <= 0) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "zero shingle size", new Object[0]));
        }
        int baseDimensions = forest.getDimensions() / shingleSize;
        return new double[baseDimensions];
    }

    public static long getLastInputTimestampSeconds(ThresholdedRandomCutForest model) {
        if (model == null || model.getPredictorCorrector() == null) {
            return 0L;
        }
        RCFComputeDescriptor last = model.getPredictorCorrector().getLastDescriptor();
        return last != null ? last.getInputTimestamp() : 0L;
    }
}

