/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AddIpamOperatingRegion;
import software.amazon.awssdk.services.ec2.model.AddIpamOperatingRegionSetCopier;
import software.amazon.awssdk.services.ec2.model.AddIpamOrganizationalUnitExclusion;
import software.amazon.awssdk.services.ec2.model.AddIpamOrganizationalUnitExclusionSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.RemoveIpamOperatingRegion;
import software.amazon.awssdk.services.ec2.model.RemoveIpamOperatingRegionSetCopier;
import software.amazon.awssdk.services.ec2.model.RemoveIpamOrganizationalUnitExclusion;
import software.amazon.awssdk.services.ec2.model.RemoveIpamOrganizationalUnitExclusionSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyIpamResourceDiscoveryRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyIpamResourceDiscoveryRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyIpamResourceDiscoveryRequest.getter(ModifyIpamResourceDiscoveryRequest::dryRun)).setter(ModifyIpamResourceDiscoveryRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> IPAM_RESOURCE_DISCOVERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamResourceDiscoveryId").getter(ModifyIpamResourceDiscoveryRequest.getter(ModifyIpamResourceDiscoveryRequest::ipamResourceDiscoveryId)).setter(ModifyIpamResourceDiscoveryRequest.setter(Builder::ipamResourceDiscoveryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamResourceDiscoveryId").unmarshallLocationName("IpamResourceDiscoveryId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ModifyIpamResourceDiscoveryRequest.getter(ModifyIpamResourceDiscoveryRequest::description)).setter(ModifyIpamResourceDiscoveryRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<List<AddIpamOperatingRegion>> ADD_OPERATING_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddOperatingRegions").getter(ModifyIpamResourceDiscoveryRequest.getter(ModifyIpamResourceDiscoveryRequest::addOperatingRegions)).setter(ModifyIpamResourceDiscoveryRequest.setter(Builder::addOperatingRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddOperatingRegion").unmarshallLocationName("AddOperatingRegion").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddIpamOperatingRegion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RemoveIpamOperatingRegion>> REMOVE_OPERATING_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveOperatingRegions").getter(ModifyIpamResourceDiscoveryRequest.getter(ModifyIpamResourceDiscoveryRequest::removeOperatingRegions)).setter(ModifyIpamResourceDiscoveryRequest.setter(Builder::removeOperatingRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveOperatingRegion").unmarshallLocationName("RemoveOperatingRegion").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RemoveIpamOperatingRegion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AddIpamOrganizationalUnitExclusion>> ADD_ORGANIZATIONAL_UNIT_EXCLUSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddOrganizationalUnitExclusions").getter(ModifyIpamResourceDiscoveryRequest.getter(ModifyIpamResourceDiscoveryRequest::addOrganizationalUnitExclusions)).setter(ModifyIpamResourceDiscoveryRequest.setter(Builder::addOrganizationalUnitExclusions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddOrganizationalUnitExclusion").unmarshallLocationName("AddOrganizationalUnitExclusion").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddIpamOrganizationalUnitExclusion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RemoveIpamOrganizationalUnitExclusion>> REMOVE_ORGANIZATIONAL_UNIT_EXCLUSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveOrganizationalUnitExclusions").getter(ModifyIpamResourceDiscoveryRequest.getter(ModifyIpamResourceDiscoveryRequest::removeOrganizationalUnitExclusions)).setter(ModifyIpamResourceDiscoveryRequest.setter(Builder::removeOrganizationalUnitExclusions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveOrganizationalUnitExclusion").unmarshallLocationName("RemoveOrganizationalUnitExclusion").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RemoveIpamOrganizationalUnitExclusion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, IPAM_RESOURCE_DISCOVERY_ID_FIELD, DESCRIPTION_FIELD, ADD_OPERATING_REGIONS_FIELD, REMOVE_OPERATING_REGIONS_FIELD, ADD_ORGANIZATIONAL_UNIT_EXCLUSIONS_FIELD, REMOVE_ORGANIZATIONAL_UNIT_EXCLUSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyIpamResourceDiscoveryRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final String ipamResourceDiscoveryId;
    private final String description;
    private final List<AddIpamOperatingRegion> addOperatingRegions;
    private final List<RemoveIpamOperatingRegion> removeOperatingRegions;
    private final List<AddIpamOrganizationalUnitExclusion> addOrganizationalUnitExclusions;
    private final List<RemoveIpamOrganizationalUnitExclusion> removeOrganizationalUnitExclusions;

    private ModifyIpamResourceDiscoveryRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.ipamResourceDiscoveryId = builder.ipamResourceDiscoveryId;
        this.description = builder.description;
        this.addOperatingRegions = builder.addOperatingRegions;
        this.removeOperatingRegions = builder.removeOperatingRegions;
        this.addOrganizationalUnitExclusions = builder.addOrganizationalUnitExclusions;
        this.removeOrganizationalUnitExclusions = builder.removeOrganizationalUnitExclusions;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String ipamResourceDiscoveryId() {
        return this.ipamResourceDiscoveryId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasAddOperatingRegions() {
        return this.addOperatingRegions != null && !(this.addOperatingRegions instanceof SdkAutoConstructList);
    }

    public final List<AddIpamOperatingRegion> addOperatingRegions() {
        return this.addOperatingRegions;
    }

    public final boolean hasRemoveOperatingRegions() {
        return this.removeOperatingRegions != null && !(this.removeOperatingRegions instanceof SdkAutoConstructList);
    }

    public final List<RemoveIpamOperatingRegion> removeOperatingRegions() {
        return this.removeOperatingRegions;
    }

    public final boolean hasAddOrganizationalUnitExclusions() {
        return this.addOrganizationalUnitExclusions != null && !(this.addOrganizationalUnitExclusions instanceof SdkAutoConstructList);
    }

    public final List<AddIpamOrganizationalUnitExclusion> addOrganizationalUnitExclusions() {
        return this.addOrganizationalUnitExclusions;
    }

    public final boolean hasRemoveOrganizationalUnitExclusions() {
        return this.removeOrganizationalUnitExclusions != null && !(this.removeOrganizationalUnitExclusions instanceof SdkAutoConstructList);
    }

    public final List<RemoveIpamOrganizationalUnitExclusion> removeOrganizationalUnitExclusions() {
        return this.removeOrganizationalUnitExclusions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamResourceDiscoveryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddOperatingRegions() ? this.addOperatingRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveOperatingRegions() ? this.removeOperatingRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddOrganizationalUnitExclusions() ? this.addOrganizationalUnitExclusions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveOrganizationalUnitExclusions() ? this.removeOrganizationalUnitExclusions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIpamResourceDiscoveryRequest)) {
            return false;
        }
        ModifyIpamResourceDiscoveryRequest other = (ModifyIpamResourceDiscoveryRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.ipamResourceDiscoveryId(), other.ipamResourceDiscoveryId()) && Objects.equals(this.description(), other.description()) && this.hasAddOperatingRegions() == other.hasAddOperatingRegions() && Objects.equals(this.addOperatingRegions(), other.addOperatingRegions()) && this.hasRemoveOperatingRegions() == other.hasRemoveOperatingRegions() && Objects.equals(this.removeOperatingRegions(), other.removeOperatingRegions()) && this.hasAddOrganizationalUnitExclusions() == other.hasAddOrganizationalUnitExclusions() && Objects.equals(this.addOrganizationalUnitExclusions(), other.addOrganizationalUnitExclusions()) && this.hasRemoveOrganizationalUnitExclusions() == other.hasRemoveOrganizationalUnitExclusions() && Objects.equals(this.removeOrganizationalUnitExclusions(), other.removeOrganizationalUnitExclusions());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyIpamResourceDiscoveryRequest").add("DryRun", (Object)this.dryRun()).add("IpamResourceDiscoveryId", (Object)this.ipamResourceDiscoveryId()).add("Description", (Object)this.description()).add("AddOperatingRegions", this.hasAddOperatingRegions() ? this.addOperatingRegions() : null).add("RemoveOperatingRegions", this.hasRemoveOperatingRegions() ? this.removeOperatingRegions() : null).add("AddOrganizationalUnitExclusions", this.hasAddOrganizationalUnitExclusions() ? this.addOrganizationalUnitExclusions() : null).add("RemoveOrganizationalUnitExclusions", this.hasRemoveOrganizationalUnitExclusions() ? this.removeOrganizationalUnitExclusions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "IpamResourceDiscoveryId": {
                return Optional.ofNullable(clazz.cast(this.ipamResourceDiscoveryId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AddOperatingRegions": {
                return Optional.ofNullable(clazz.cast(this.addOperatingRegions()));
            }
            case "RemoveOperatingRegions": {
                return Optional.ofNullable(clazz.cast(this.removeOperatingRegions()));
            }
            case "AddOrganizationalUnitExclusions": {
                return Optional.ofNullable(clazz.cast(this.addOrganizationalUnitExclusions()));
            }
            case "RemoveOrganizationalUnitExclusions": {
                return Optional.ofNullable(clazz.cast(this.removeOrganizationalUnitExclusions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("IpamResourceDiscoveryId", IPAM_RESOURCE_DISCOVERY_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("AddOperatingRegion", ADD_OPERATING_REGIONS_FIELD);
        map.put("RemoveOperatingRegion", REMOVE_OPERATING_REGIONS_FIELD);
        map.put("AddOrganizationalUnitExclusion", ADD_ORGANIZATIONAL_UNIT_EXCLUSIONS_FIELD);
        map.put("RemoveOrganizationalUnitExclusion", REMOVE_ORGANIZATIONAL_UNIT_EXCLUSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyIpamResourceDiscoveryRequest, T> g) {
        return obj -> g.apply((ModifyIpamResourceDiscoveryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String ipamResourceDiscoveryId;
        private String description;
        private List<AddIpamOperatingRegion> addOperatingRegions = DefaultSdkAutoConstructList.getInstance();
        private List<RemoveIpamOperatingRegion> removeOperatingRegions = DefaultSdkAutoConstructList.getInstance();
        private List<AddIpamOrganizationalUnitExclusion> addOrganizationalUnitExclusions = DefaultSdkAutoConstructList.getInstance();
        private List<RemoveIpamOrganizationalUnitExclusion> removeOrganizationalUnitExclusions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyIpamResourceDiscoveryRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.ipamResourceDiscoveryId(model.ipamResourceDiscoveryId);
            this.description(model.description);
            this.addOperatingRegions(model.addOperatingRegions);
            this.removeOperatingRegions(model.removeOperatingRegions);
            this.addOrganizationalUnitExclusions(model.addOrganizationalUnitExclusions);
            this.removeOrganizationalUnitExclusions(model.removeOrganizationalUnitExclusions);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getIpamResourceDiscoveryId() {
            return this.ipamResourceDiscoveryId;
        }

        public final void setIpamResourceDiscoveryId(String ipamResourceDiscoveryId) {
            this.ipamResourceDiscoveryId = ipamResourceDiscoveryId;
        }

        @Override
        public final Builder ipamResourceDiscoveryId(String ipamResourceDiscoveryId) {
            this.ipamResourceDiscoveryId = ipamResourceDiscoveryId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<AddIpamOperatingRegion.Builder> getAddOperatingRegions() {
            List<AddIpamOperatingRegion.Builder> result = AddIpamOperatingRegionSetCopier.copyToBuilder(this.addOperatingRegions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddOperatingRegions(Collection<AddIpamOperatingRegion.BuilderImpl> addOperatingRegions) {
            this.addOperatingRegions = AddIpamOperatingRegionSetCopier.copyFromBuilder(addOperatingRegions);
        }

        @Override
        public final Builder addOperatingRegions(Collection<AddIpamOperatingRegion> addOperatingRegions) {
            this.addOperatingRegions = AddIpamOperatingRegionSetCopier.copy(addOperatingRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOperatingRegions(AddIpamOperatingRegion ... addOperatingRegions) {
            this.addOperatingRegions(Arrays.asList(addOperatingRegions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOperatingRegions(Consumer<AddIpamOperatingRegion.Builder> ... addOperatingRegions) {
            this.addOperatingRegions(Stream.of(addOperatingRegions).map(c -> (AddIpamOperatingRegion)((AddIpamOperatingRegion.Builder)AddIpamOperatingRegion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RemoveIpamOperatingRegion.Builder> getRemoveOperatingRegions() {
            List<RemoveIpamOperatingRegion.Builder> result = RemoveIpamOperatingRegionSetCopier.copyToBuilder(this.removeOperatingRegions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoveOperatingRegions(Collection<RemoveIpamOperatingRegion.BuilderImpl> removeOperatingRegions) {
            this.removeOperatingRegions = RemoveIpamOperatingRegionSetCopier.copyFromBuilder(removeOperatingRegions);
        }

        @Override
        public final Builder removeOperatingRegions(Collection<RemoveIpamOperatingRegion> removeOperatingRegions) {
            this.removeOperatingRegions = RemoveIpamOperatingRegionSetCopier.copy(removeOperatingRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeOperatingRegions(RemoveIpamOperatingRegion ... removeOperatingRegions) {
            this.removeOperatingRegions(Arrays.asList(removeOperatingRegions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeOperatingRegions(Consumer<RemoveIpamOperatingRegion.Builder> ... removeOperatingRegions) {
            this.removeOperatingRegions(Stream.of(removeOperatingRegions).map(c -> (RemoveIpamOperatingRegion)((RemoveIpamOperatingRegion.Builder)RemoveIpamOperatingRegion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AddIpamOrganizationalUnitExclusion.Builder> getAddOrganizationalUnitExclusions() {
            List<AddIpamOrganizationalUnitExclusion.Builder> result = AddIpamOrganizationalUnitExclusionSetCopier.copyToBuilder(this.addOrganizationalUnitExclusions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddOrganizationalUnitExclusions(Collection<AddIpamOrganizationalUnitExclusion.BuilderImpl> addOrganizationalUnitExclusions) {
            this.addOrganizationalUnitExclusions = AddIpamOrganizationalUnitExclusionSetCopier.copyFromBuilder(addOrganizationalUnitExclusions);
        }

        @Override
        public final Builder addOrganizationalUnitExclusions(Collection<AddIpamOrganizationalUnitExclusion> addOrganizationalUnitExclusions) {
            this.addOrganizationalUnitExclusions = AddIpamOrganizationalUnitExclusionSetCopier.copy(addOrganizationalUnitExclusions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOrganizationalUnitExclusions(AddIpamOrganizationalUnitExclusion ... addOrganizationalUnitExclusions) {
            this.addOrganizationalUnitExclusions(Arrays.asList(addOrganizationalUnitExclusions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOrganizationalUnitExclusions(Consumer<AddIpamOrganizationalUnitExclusion.Builder> ... addOrganizationalUnitExclusions) {
            this.addOrganizationalUnitExclusions(Stream.of(addOrganizationalUnitExclusions).map(c -> (AddIpamOrganizationalUnitExclusion)((AddIpamOrganizationalUnitExclusion.Builder)AddIpamOrganizationalUnitExclusion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RemoveIpamOrganizationalUnitExclusion.Builder> getRemoveOrganizationalUnitExclusions() {
            List<RemoveIpamOrganizationalUnitExclusion.Builder> result = RemoveIpamOrganizationalUnitExclusionSetCopier.copyToBuilder(this.removeOrganizationalUnitExclusions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoveOrganizationalUnitExclusions(Collection<RemoveIpamOrganizationalUnitExclusion.BuilderImpl> removeOrganizationalUnitExclusions) {
            this.removeOrganizationalUnitExclusions = RemoveIpamOrganizationalUnitExclusionSetCopier.copyFromBuilder(removeOrganizationalUnitExclusions);
        }

        @Override
        public final Builder removeOrganizationalUnitExclusions(Collection<RemoveIpamOrganizationalUnitExclusion> removeOrganizationalUnitExclusions) {
            this.removeOrganizationalUnitExclusions = RemoveIpamOrganizationalUnitExclusionSetCopier.copy(removeOrganizationalUnitExclusions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeOrganizationalUnitExclusions(RemoveIpamOrganizationalUnitExclusion ... removeOrganizationalUnitExclusions) {
            this.removeOrganizationalUnitExclusions(Arrays.asList(removeOrganizationalUnitExclusions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeOrganizationalUnitExclusions(Consumer<RemoveIpamOrganizationalUnitExclusion.Builder> ... removeOrganizationalUnitExclusions) {
            this.removeOrganizationalUnitExclusions(Stream.of(removeOrganizationalUnitExclusions).map(c -> (RemoveIpamOrganizationalUnitExclusion)((RemoveIpamOrganizationalUnitExclusion.Builder)RemoveIpamOrganizationalUnitExclusion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyIpamResourceDiscoveryRequest build() {
            return new ModifyIpamResourceDiscoveryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyIpamResourceDiscoveryRequest> {
        public Builder dryRun(Boolean var1);

        public Builder ipamResourceDiscoveryId(String var1);

        public Builder description(String var1);

        public Builder addOperatingRegions(Collection<AddIpamOperatingRegion> var1);

        public Builder addOperatingRegions(AddIpamOperatingRegion ... var1);

        public Builder addOperatingRegions(Consumer<AddIpamOperatingRegion.Builder> ... var1);

        public Builder removeOperatingRegions(Collection<RemoveIpamOperatingRegion> var1);

        public Builder removeOperatingRegions(RemoveIpamOperatingRegion ... var1);

        public Builder removeOperatingRegions(Consumer<RemoveIpamOperatingRegion.Builder> ... var1);

        public Builder addOrganizationalUnitExclusions(Collection<AddIpamOrganizationalUnitExclusion> var1);

        public Builder addOrganizationalUnitExclusions(AddIpamOrganizationalUnitExclusion ... var1);

        public Builder addOrganizationalUnitExclusions(Consumer<AddIpamOrganizationalUnitExclusion.Builder> ... var1);

        public Builder removeOrganizationalUnitExclusions(Collection<RemoveIpamOrganizationalUnitExclusion> var1);

        public Builder removeOrganizationalUnitExclusions(RemoveIpamOrganizationalUnitExclusion ... var1);

        public Builder removeOrganizationalUnitExclusions(Consumer<RemoveIpamOrganizationalUnitExclusion.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

