/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class BoolQuery
extends QueryBase
implements QueryVariant,
ToCopyableBuilder<Builder, BoolQuery> {
    @Nullable
    private final Boolean adjustPureNegative;
    @Nonnull
    private final List<Query> filter;
    @Nullable
    private final String minimumShouldMatch;
    @Nonnull
    private final List<Query> must;
    @Nonnull
    private final List<Query> mustNot;
    @Nonnull
    private final List<Query> should;
    public static final JsonpDeserializer<BoolQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BoolQuery::setupBoolQueryDeserializer);

    private BoolQuery(Builder builder) {
        super(builder);
        this.adjustPureNegative = builder.adjustPureNegative;
        this.filter = ApiTypeHelper.unmodifiable(builder.filter);
        this.minimumShouldMatch = builder.minimumShouldMatch;
        this.must = ApiTypeHelper.unmodifiable(builder.must);
        this.mustNot = ApiTypeHelper.unmodifiable(builder.mustNot);
        this.should = ApiTypeHelper.unmodifiable(builder.should);
    }

    public static BoolQuery of(Function<Builder, ObjectBuilder<BoolQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Bool;
    }

    @Nullable
    public final Boolean adjustPureNegative() {
        return this.adjustPureNegative;
    }

    @Nonnull
    public final List<Query> filter() {
        return this.filter;
    }

    @Nullable
    public final String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    @Nonnull
    public final List<Query> must() {
        return this.must;
    }

    @Nonnull
    public final List<Query> mustNot() {
        return this.mustNot;
    }

    @Nonnull
    public final List<Query> should() {
        return this.should;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.adjustPureNegative != null) {
            generator.writeKey("adjust_pure_negative");
            generator.write(this.adjustPureNegative.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.filter)) {
            generator.writeKey("filter");
            generator.writeStartArray();
            for (Query item0 : this.filter) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.minimumShouldMatch != null) {
            generator.writeKey("minimum_should_match");
            generator.write(this.minimumShouldMatch);
        }
        if (ApiTypeHelper.isDefined(this.must)) {
            generator.writeKey("must");
            generator.writeStartArray();
            for (Query item0 : this.must) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.mustNot)) {
            generator.writeKey("must_not");
            generator.writeStartArray();
            for (Query item0 : this.mustNot) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.should)) {
            generator.writeKey("should");
            generator.writeStartArray();
            for (Query item0 : this.should) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupBoolQueryDeserializer(ObjectDeserializer<Builder> op) {
        BoolQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::adjustPureNegative, JsonpDeserializer.booleanDeserializer(), "adjust_pure_negative");
        op.add(Builder::filter, JsonpDeserializer.arrayDeserializer(Query._DESERIALIZER), "filter");
        op.add(Builder::minimumShouldMatch, JsonpDeserializer.stringDeserializer(), "minimum_should_match");
        op.add(Builder::must, JsonpDeserializer.arrayDeserializer(Query._DESERIALIZER), "must");
        op.add(Builder::mustNot, JsonpDeserializer.arrayDeserializer(Query._DESERIALIZER), "must_not");
        op.add(Builder::should, JsonpDeserializer.arrayDeserializer(Query._DESERIALIZER), "should");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.adjustPureNegative);
        result = 31 * result + Objects.hashCode(this.filter);
        result = 31 * result + Objects.hashCode(this.minimumShouldMatch);
        result = 31 * result + Objects.hashCode(this.must);
        result = 31 * result + Objects.hashCode(this.mustNot);
        result = 31 * result + Objects.hashCode(this.should);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoolQuery other = (BoolQuery)o;
        return Objects.equals(this.adjustPureNegative, other.adjustPureNegative) && Objects.equals(this.filter, other.filter) && Objects.equals(this.minimumShouldMatch, other.minimumShouldMatch) && Objects.equals(this.must, other.must) && Objects.equals(this.mustNot, other.mustNot) && Objects.equals(this.should, other.should);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, BoolQuery> {
        @Nullable
        private Boolean adjustPureNegative;
        @Nullable
        private List<Query> filter;
        @Nullable
        private String minimumShouldMatch;
        @Nullable
        private List<Query> must;
        @Nullable
        private List<Query> mustNot;
        @Nullable
        private List<Query> should;

        public Builder() {
        }

        private Builder(BoolQuery o) {
            super(o);
            this.adjustPureNegative = o.adjustPureNegative;
            this.filter = Builder._listCopy(o.filter);
            this.minimumShouldMatch = o.minimumShouldMatch;
            this.must = Builder._listCopy(o.must);
            this.mustNot = Builder._listCopy(o.mustNot);
            this.should = Builder._listCopy(o.should);
        }

        private Builder(Builder o) {
            super(o);
            this.adjustPureNegative = o.adjustPureNegative;
            this.filter = Builder._listCopy(o.filter);
            this.minimumShouldMatch = o.minimumShouldMatch;
            this.must = Builder._listCopy(o.must);
            this.mustNot = Builder._listCopy(o.mustNot);
            this.should = Builder._listCopy(o.should);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder adjustPureNegative(@Nullable Boolean value) {
            this.adjustPureNegative = value;
            return this;
        }

        @Nonnull
        public final Builder filter(List<Query> list) {
            this.filter = Builder._listAddAll(this.filter, list);
            return this;
        }

        @Nonnull
        public final Builder filter(Query value, Query ... values) {
            this.filter = Builder._listAdd(this.filter, value, values);
            return this;
        }

        @Nonnull
        public final Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build(), new Query[0]);
        }

        @Nonnull
        public final Builder minimumShouldMatch(@Nullable String value) {
            this.minimumShouldMatch = value;
            return this;
        }

        @Nonnull
        public final Builder must(List<Query> list) {
            this.must = Builder._listAddAll(this.must, list);
            return this;
        }

        @Nonnull
        public final Builder must(Query value, Query ... values) {
            this.must = Builder._listAdd(this.must, value, values);
            return this;
        }

        @Nonnull
        public final Builder must(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.must(fn.apply(new Query.Builder()).build(), new Query[0]);
        }

        @Nonnull
        public final Builder mustNot(List<Query> list) {
            this.mustNot = Builder._listAddAll(this.mustNot, list);
            return this;
        }

        @Nonnull
        public final Builder mustNot(Query value, Query ... values) {
            this.mustNot = Builder._listAdd(this.mustNot, value, values);
            return this;
        }

        @Nonnull
        public final Builder mustNot(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.mustNot(fn.apply(new Query.Builder()).build(), new Query[0]);
        }

        @Nonnull
        public final Builder should(List<Query> list) {
            this.should = Builder._listAddAll(this.should, list);
            return this;
        }

        @Nonnull
        public final Builder should(Query value, Query ... values) {
            this.should = Builder._listAdd(this.should, value, values);
            return this;
        }

        @Nonnull
        public final Builder should(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.should(fn.apply(new Query.Builder()).build(), new Query[0]);
        }

        @Override
        @Nonnull
        public BoolQuery build() {
            this._checkSingleUse();
            return new BoolQuery(this);
        }
    }
}

