/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class CachePoolStats {
    private final long bytesNeeded;
    private final long bytesCached;
    private final long bytesOverlimit;
    private final long filesNeeded;
    private final long filesCached;

    private CachePoolStats(long bytesNeeded, long bytesCached, long bytesOverlimit, long filesNeeded, long filesCached) {
        this.bytesNeeded = bytesNeeded;
        this.bytesCached = bytesCached;
        this.bytesOverlimit = bytesOverlimit;
        this.filesNeeded = filesNeeded;
        this.filesCached = filesCached;
    }

    public long getBytesNeeded() {
        return this.bytesNeeded;
    }

    public long getBytesCached() {
        return this.bytesCached;
    }

    public long getBytesOverlimit() {
        return this.bytesOverlimit;
    }

    public long getFilesNeeded() {
        return this.filesNeeded;
    }

    public long getFilesCached() {
        return this.filesCached;
    }

    public String toString() {
        return "{bytesNeeded:" + this.bytesNeeded + ", bytesCached:" + this.bytesCached + ", bytesOverlimit:" + this.bytesOverlimit + ", filesNeeded:" + this.filesNeeded + ", filesCached:" + this.filesCached + "}";
    }

    public static class Builder {
        private long bytesNeeded;
        private long bytesCached;
        private long bytesOverlimit;
        private long filesNeeded;
        private long filesCached;

        public Builder setBytesNeeded(long bytesNeeded) {
            this.bytesNeeded = bytesNeeded;
            return this;
        }

        public Builder setBytesCached(long bytesCached) {
            this.bytesCached = bytesCached;
            return this;
        }

        public Builder setBytesOverlimit(long bytesOverlimit) {
            this.bytesOverlimit = bytesOverlimit;
            return this;
        }

        public Builder setFilesNeeded(long filesNeeded) {
            this.filesNeeded = filesNeeded;
            return this;
        }

        public Builder setFilesCached(long filesCached) {
            this.filesCached = filesCached;
            return this;
        }

        public CachePoolStats build() {
            return new CachePoolStats(this.bytesNeeded, this.bytesCached, this.bytesOverlimit, this.filesNeeded, this.filesCached);
        }
    }
}

