/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn.matchers;

import com.nulabinc.zxcvbn.Context;
import com.nulabinc.zxcvbn.Scoring;
import com.nulabinc.zxcvbn.WipeableString;
import com.nulabinc.zxcvbn.matchers.BaseMatcher;
import com.nulabinc.zxcvbn.matchers.Match;
import com.nulabinc.zxcvbn.matchers.MatchFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateMatcher
extends BaseMatcher {
    private static final int DATE_MAX_YEAR = 2050;
    private static final int DATE_MIN_YEAR = 1000;
    private static final int[][][] DATE_SPLITS = new int[9][][];
    private static final Pattern MAYBE_DATE_NO_SEPARATOR = Pattern.compile("^\\d{4,8}$");
    private static final Pattern MAYBE_DATE_WITH_SEPARATOR = Pattern.compile("^(\\d{1,4})([\\s/\\\\_.-])(\\d{1,2})\\2(\\d{1,4})$");

    public DateMatcher(Context context) {
        super(context);
    }

    @Override
    public List<Match> execute(CharSequence password) {
        ArrayList<Match> matches = new ArrayList<Match>();
        DateMatcher.findDatesWithoutSeparator(password, matches);
        DateMatcher.findDatesWithSeparator(password, matches);
        return this.filterSubMatches(matches);
    }

    private static void findDatesWithoutSeparator(CharSequence password, List<Match> matches) {
        for (int startIndex = 0; startIndex <= password.length() - 4; ++startIndex) {
            for (int endIndex = startIndex + 3; endIndex <= startIndex + 7 && endIndex < password.length(); ++endIndex) {
                WipeableString token = WipeableString.copy(password, startIndex, endIndex + 1);
                if (!MAYBE_DATE_NO_SEPARATOR.matcher(token).find()) {
                    token.wipe();
                    continue;
                }
                DateMatcher.extractDateCandidates(matches, startIndex, endIndex, token);
            }
        }
    }

    private static void extractDateCandidates(List<Match> matches, int startIndex, int endIndex, WipeableString token) {
        List<Dmy> candidates = DateMatcher.generateDateCandidates(token);
        if (candidates.isEmpty()) {
            token.wipe();
            return;
        }
        Dmy bestCandidate = DateMatcher.selectBestDateCandidate(candidates);
        matches.add(MatchFactory.createDateMatch(startIndex, endIndex, token, "", bestCandidate.year, bestCandidate.month, bestCandidate.day));
    }

    private static List<Dmy> generateDateCandidates(WipeableString token) {
        ArrayList<Dmy> candidates = new ArrayList<Dmy>();
        for (int[] date : DATE_SPLITS[token.length()]) {
            int[] extractedInts = DateMatcher.extractIntsFromToken(token, date);
            Dmy dmy = DateMatcher.mapIntsToDmy(extractedInts);
            if (dmy == null) continue;
            candidates.add(dmy);
        }
        return candidates;
    }

    private static int[] extractIntsFromToken(WipeableString token, int[] date) {
        try {
            int[] ints = new int[]{WipeableString.parseInt(token.subSequence(0, date[0])), WipeableString.parseInt(token.subSequence(date[0], date[1])), WipeableString.parseInt(token.subSequence(date[1], token.length()))};
            return ints;
        }
        catch (NumberFormatException e) {
            return new int[0];
        }
    }

    private static Dmy selectBestDateCandidate(List<Dmy> candidates) {
        Dmy bestCandidate = candidates.get(0);
        int minDistance = DateMatcher.metric(candidates.get(0));
        for (Dmy candidate : candidates.subList(1, candidates.size())) {
            int distance = DateMatcher.metric(candidate);
            if (distance >= minDistance) continue;
            bestCandidate = candidate;
            minDistance = distance;
        }
        return bestCandidate;
    }

    private static void findDatesWithSeparator(CharSequence password, List<Match> matches) {
        for (int startIndex = 0; startIndex <= password.length() - 6; ++startIndex) {
            for (int endIndex = startIndex + 5; endIndex <= startIndex + 9 && endIndex < password.length(); ++endIndex) {
                WipeableString token = WipeableString.copy(password, startIndex, endIndex + 1);
                Matcher rxMatch = MAYBE_DATE_WITH_SEPARATOR.matcher(token);
                if (rxMatch.find()) {
                    int[] extractedInts = DateMatcher.extractIntsFromMatcher(rxMatch);
                    Dmy dmy = DateMatcher.mapIntsToDmy(extractedInts);
                    if (dmy != null) {
                        matches.add(MatchFactory.createDateMatch(startIndex, endIndex, token, rxMatch.group(2), dmy.year, dmy.month, dmy.day));
                        continue;
                    }
                    token.wipe();
                    continue;
                }
                token.wipe();
            }
        }
    }

    private static int[] extractIntsFromMatcher(Matcher matcher) {
        try {
            int[] ints = new int[]{WipeableString.parseInt(matcher.group(1)), WipeableString.parseInt(matcher.group(3)), WipeableString.parseInt(matcher.group(4))};
            return ints;
        }
        catch (NumberFormatException e) {
            return new int[0];
        }
    }

    private List<Match> filterSubMatches(List<Match> matches) {
        ArrayList<Match> targetMatches = new ArrayList<Match>();
        for (Match match : matches) {
            boolean isSubMatch = false;
            for (Match otherMatch : matches) {
                if (match.equals(otherMatch) || otherMatch.i > match.i || otherMatch.j < match.j) continue;
                isSubMatch = true;
                break;
            }
            if (isSubMatch) continue;
            targetMatches.add(match);
        }
        return this.sorted(targetMatches);
    }

    private static int metric(Dmy candidate) {
        return Math.abs(candidate.year - Scoring.REFERENCE_YEAR);
    }

    private static Dmy mapIntsToDmy(int[] ints) {
        if (ints.length == 0 || !DateMatcher.isValidDay(ints[1])) {
            return null;
        }
        for (int i : ints) {
            if (!DateMatcher.isOutOfRange(i)) continue;
            return null;
        }
        ThresholdCounts counts = DateMatcher.calculateThresholdCounts(ints);
        if (!DateMatcher.isValidThresholdCounts(counts)) {
            return null;
        }
        Dmy dmyFromFourDigitYear = DateMatcher.getDmyFromFourDigitYear(ints);
        if (dmyFromFourDigitYear != null) {
            return dmyFromFourDigitYear;
        }
        return DateMatcher.getDmyFromTwoDigitYear(ints);
    }

    private static boolean isValidDay(int day) {
        return 1 <= day && day <= 31;
    }

    private static boolean isOutOfRange(int value) {
        return 99 < value && value < 1000 || value > 2050;
    }

    private static boolean isValidThresholdCounts(ThresholdCounts counts) {
        return counts.over31 < 2 && counts.over12 != 3 && counts.under1 < 2;
    }

    private static Dmy getDmyFromFourDigitYear(int[] ints) {
        int[][] possibleYearSplits;
        for (int[] split : possibleYearSplits = DateMatcher.getPossibleYearSplits(ints)) {
            int year = split[0];
            if (!DateMatcher.isYearInRange(year)) continue;
            Dm dm = DateMatcher.mapIntsToDm(new int[]{split[1], split[2]});
            if (dm != null) {
                return new Dmy(dm.day, dm.month, year);
            }
            return null;
        }
        return null;
    }

    private static Dmy getDmyFromTwoDigitYear(int[] ints) {
        int[][] possibleYearSplits;
        for (int[] split : possibleYearSplits = DateMatcher.getPossibleYearSplits(ints)) {
            Dm dm = DateMatcher.mapIntsToDm(new int[]{split[1], split[2]});
            if (dm == null) continue;
            int year = DateMatcher.twoToFourDigitYear(split[0]);
            return new Dmy(dm.day, dm.month, year);
        }
        return null;
    }

    private static int[][] getPossibleYearSplits(int[] ints) {
        return new int[][]{{ints[2], ints[0], ints[1]}, {ints[0], ints[1], ints[2]}};
    }

    private static ThresholdCounts calculateThresholdCounts(int[] ints) {
        int over12 = 0;
        int over31 = 0;
        int under1 = 0;
        for (int i : ints) {
            if (i > 31) {
                ++over31;
            }
            if (i > 12) {
                ++over12;
            }
            if (i > 0) continue;
            ++under1;
        }
        return new ThresholdCounts(over31, over12, under1);
    }

    private static boolean isYearInRange(int year) {
        return 1000 <= year && year <= 2050;
    }

    private static Dm mapIntsToDm(int[] ints) {
        int[] copy = Arrays.copyOf(ints, ints.length);
        DateMatcher.reverse(copy);
        for (int[] ref : new int[][]{ints, copy}) {
            int d = ref[0];
            int m = ref[1];
            if (1 > d || d > 31 || 1 > m || m > 12) continue;
            return new Dm(d, m);
        }
        return null;
    }

    private static void reverse(int[] array) {
        for (int i = 0; i < array.length / 2; ++i) {
            int temp = array[i];
            array[i] = array[array.length - 1 - i];
            array[array.length - 1 - i] = temp;
        }
    }

    private static int twoToFourDigitYear(int year) {
        if (year > 99) {
            return year;
        }
        if (year > 50) {
            return year + 1900;
        }
        return year + 2000;
    }

    static {
        DateMatcher.DATE_SPLITS[4] = new int[][]{{1, 2}, {2, 3}};
        DateMatcher.DATE_SPLITS[5] = new int[][]{{1, 3}, {2, 3}};
        DateMatcher.DATE_SPLITS[6] = new int[][]{{1, 2}, {2, 4}, {4, 5}};
        DateMatcher.DATE_SPLITS[7] = new int[][]{{1, 3}, {2, 3}, {4, 5}, {4, 6}};
        DateMatcher.DATE_SPLITS[8] = new int[][]{{2, 4}, {4, 6}};
    }

    private static class ThresholdCounts {
        int over31;
        int over12;
        int under1;

        ThresholdCounts(int over31, int over12, int under1) {
            this.over31 = over31;
            this.over12 = over12;
            this.under1 = under1;
        }
    }

    private static class Dmy
    extends Dm {
        final int year;

        public Dmy(int day, int month, int year) {
            super(day, month);
            this.year = year;
        }
    }

    private static class Dm {
        final int day;
        final int month;

        public Dm(int day, int month) {
            this.day = day;
            this.month = month;
        }
    }
}

