/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.decoding.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLRuntimeException;
import org.opensaml.saml.common.binding.BindingDescriptor;
import org.opensaml.saml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.saml.common.binding.impl.SAMLSOAPDecoderBodyHandler;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.slf4j.Logger;

public class HttpClientResponseSOAP11Decoder
extends org.opensaml.soap.client.soap11.decoder.http.impl.HttpClientResponseSOAP11Decoder
implements SAMLMessageDecoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HttpClientResponseSOAP11Decoder.class);
    @Nullable
    private BindingDescriptor bindingDescriptor;

    public HttpClientResponseSOAP11Decoder() {
        SAMLSOAPDecoderBodyHandler bodyHandler = new SAMLSOAPDecoderBodyHandler();
        try {
            bodyHandler.initialize();
        }
        catch (ComponentInitializationException e) {
            throw new SAMLRuntimeException("Error initializing SOAP decoder body handler", e);
        }
        this.setBodyHandler(bodyHandler);
        this.setProtocolMessageLoggerSubCategory("SAML");
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:SOAP";
    }

    @Nullable
    public BindingDescriptor getBindingDescriptor() {
        return this.bindingDescriptor;
    }

    public void setBindingDescriptor(@Nullable BindingDescriptor descriptor) {
        this.bindingDescriptor = descriptor;
    }

    @Override
    protected void doDecode() throws MessageDecodingException {
        super.doDecode();
        MessageContext msgCtx = this.getMessageContext();
        assert (msgCtx != null);
        this.populateBindingContext(msgCtx);
        Object samlMessage = msgCtx.getMessage();
        if (!(samlMessage instanceof SAMLObject)) {
            throw new MessageDecodingException("Decoded SOAP message did not contain SAMLObject");
        }
        this.log.debug("Decoded SOAP message which included SAML message of type {}", (Object)((SAMLObject)samlMessage).getElementQName());
    }

    protected void populateBindingContext(@Nonnull MessageContext messageContext) {
        SAMLBindingContext bindingContext = messageContext.ensureSubcontext(SAMLBindingContext.class);
        bindingContext.setBindingUri(this.getBindingURI());
        bindingContext.setBindingDescriptor(this.bindingDescriptor);
        bindingContext.setHasBindingSignature(false);
        bindingContext.setIntendedDestinationEndpointURIRequired(false);
    }
}

