/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.agui;

import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.agui.BaseEvent;

public class MessagesSnapshotEvent
extends BaseEvent {
    public static final String TYPE = "MESSAGES_SNAPSHOT";
    private List<Object> messages;

    public MessagesSnapshotEvent(List<Object> messages) {
        super(TYPE, System.currentTimeMillis(), null);
        this.messages = messages;
    }

    public MessagesSnapshotEvent(StreamInput input) throws IOException {
        super(input);
        this.messages = input.readList(StreamInput::readGenericValue);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeCollection(this.messages, StreamOutput::writeGenericValue);
    }

    @Override
    protected void addEventSpecificFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("messages", this.messages);
    }

    @Generated
    public List<Object> getMessages() {
        return this.messages;
    }

    @Generated
    public void setMessages(List<Object> messages) {
        this.messages = messages;
    }

    @Override
    @Generated
    public String toString() {
        return "MessagesSnapshotEvent(messages=" + String.valueOf(this.getMessages()) + ")";
    }

    @Generated
    public MessagesSnapshotEvent() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessagesSnapshotEvent)) {
            return false;
        }
        MessagesSnapshotEvent other = (MessagesSnapshotEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Object> this$messages = this.getMessages();
        List<Object> other$messages = other.getMessages();
        return !(this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MessagesSnapshotEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Object> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        return result;
    }
}

