/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.compaction;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.math.DoubleMath;
import java.util.List;
import org.eclipse.elk.alg.common.compaction.oned.CNode;
import org.eclipse.elk.alg.common.compaction.oned.CompareFuzzy;
import org.eclipse.elk.alg.common.compaction.oned.Quadruplet;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;

public final class VerticalSegment
implements Comparable<VerticalSegment> {
    public List<CNode> potentialGroupParents = Lists.newArrayList();
    public List<LEdge> representedLEdges = Lists.newArrayList();
    public List<KVector> affectedBends = Lists.newArrayList();
    public List<ElkRectangle> affectedBoundingBoxes = Lists.newArrayList();
    public ElkRectangle hitbox = new ElkRectangle();
    public KVectorChain junctionPoints = new KVectorChain();
    public Quadruplet ignoreSpacing = new Quadruplet();
    public List<VerticalSegment> constraints = Lists.newArrayList();
    public LPort aPort;
    public List<VerticalSegment> joined = Lists.newArrayList();

    public VerticalSegment(KVector bend1, KVector bend2, CNode cNode, LEdge lEdge) {
        this.affectedBends.add(bend1);
        this.affectedBends.add(bend2);
        this.hitbox.x = Math.min(bend1.x, bend2.x);
        this.hitbox.y = Math.min(bend1.y, bend2.y);
        this.hitbox.width = Math.abs(bend1.x - bend2.x);
        this.hitbox.height = Math.abs(bend1.y - bend2.y);
        KVectorChain inJPs = lEdge.getProperty(LayeredOptions.JUNCTION_POINTS);
        if (inJPs != null) {
            for (KVector jp : inJPs) {
                if (!CompareFuzzy.eq(jp.x, bend1.x)) continue;
                this.junctionPoints.add(jp);
            }
        }
        if (cNode != null) {
            this.potentialGroupParents.add(cNode);
        }
        this.representedLEdges.add(lEdge);
    }

    public VerticalSegment joinWith(VerticalSegment other) {
        this.representedLEdges.addAll(other.representedLEdges);
        this.affectedBends.addAll(other.affectedBends);
        this.affectedBoundingBoxes.addAll(other.affectedBoundingBoxes);
        this.junctionPoints.addAll(other.junctionPoints);
        this.constraints.addAll(other.constraints);
        this.potentialGroupParents.addAll(other.potentialGroupParents);
        double newX = Math.min(this.hitbox.x, other.hitbox.x);
        double newY = Math.min(this.hitbox.y, other.hitbox.y);
        double maxX = Math.max(this.hitbox.x + this.hitbox.width, other.hitbox.x + other.hitbox.width);
        double newW = maxX - newX;
        double maxY = Math.max(this.hitbox.y + this.hitbox.height, other.hitbox.y + other.hitbox.height);
        double newH = maxY - newY;
        this.hitbox.setRect(newX, newY, newW, newH);
        this.ignoreSpacing.applyOr(other.ignoreSpacing);
        if (this.aPort == null) {
            this.aPort = other.aPort;
        }
        this.joined.addAll(other.joined);
        this.joined.add(other);
        return this;
    }

    public boolean intersects(VerticalSegment o) {
        return CompareFuzzy.eq(this.hitbox.x, o.hitbox.x) && !CompareFuzzy.lt(this.hitbox.getBottomLeft().y, o.hitbox.y) && !CompareFuzzy.lt(o.hitbox.getBottomLeft().y, this.hitbox.y);
    }

    @Override
    public int compareTo(VerticalSegment o) {
        int d = DoubleMath.fuzzyCompare(this.hitbox.x, o.hitbox.x, 1.0E-4);
        if (d == 0) {
            return Double.compare(this.hitbox.y, o.hitbox.y);
        }
        return d;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("VerticalSegment ");
        sb.append(this.hitbox);
        sb.append(" ");
        sb.append(Joiner.on(", ").join(this.representedLEdges));
        return sb.toString();
    }
}

