/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.presentation;

import java.util.AbstractList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

final class TransformingList<FROM, TO>
extends AbstractList<TO> {
    private final List<? extends FROM> source;
    private final Function<? super FROM, ? extends TO> transform;

    TransformingList(List<? extends FROM> source2, Function<? super FROM, ? extends TO> transform2) {
        this.source = Objects.requireNonNull(source2, "source list");
        this.transform = Objects.requireNonNull(transform2, "transform function");
    }

    @Override
    public TO get(int index) {
        return this.transform.apply(this.source.get(index));
    }

    @Override
    public int size() {
        return this.source.size();
    }
}

