/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.fus;

import com.intellij.codeWithMe.ClientId;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.jsonSchema.fus.JsonFeatureUsageCollector;
import com.jetbrains.jsonSchema.fus.JsonSchemaFusAllowedListFeature;
import com.jetbrains.jsonSchema.fus.JsonSchemaFusCountedFeature;
import com.jetbrains.jsonSchema.fus.JsonSchemaFusCountedUniqueFeature;
import com.jetbrains.jsonSchema.fus.JsonSchemaFusFeature;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0001\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012J\f\u0010\u0013\u001a\u00060\u0006R\u00020\u0000H\u0002J\u000e\u0010\u0014\u001a\b\u0018\u00010\u0006R\u00020\u0000H\u0002J\b\u0010\u0015\u001a\u00020\bH\u0002J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u0017\u001a\u00020\bH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00122\u0006\u0010\t\u001a\u00020\nH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0018\u00010\u0006R\u00020\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/jsonSchema/fus/JsonSchemaHighlightingSessionStatisticsCollector;", "", "<init>", "()V", "currentHighlightingSession", "Ljava/lang/ThreadLocal;", "Lcom/jetbrains/jsonSchema/fus/JsonSchemaHighlightingSessionStatisticsCollector$JsonSchemaHighlightingSession;", "recordSchemaFeaturesUsage", "", "schemaRoot", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaObject;", "operation", "Ljava/lang/Runnable;", "reportSchemaUsageFeature", "featureKind", "Lcom/jetbrains/jsonSchema/fus/JsonSchemaFusCountedFeature;", "reportUniqueUrlDownloadRequestUsage", "schemaUrl", "", "createNewSession", "getCurrentSession", "cleanupHighlightingSessionDataNoFlush", "startCollectingSchemaHighlightingFus", "flushHighlightingSessionDataToFus", "guessBestSchemaId", "Companion", "JsonSchemaHighlightingSession", "intellij.json.backend"})
@SourceDebugExtension(value={"SMAP\nJsonSchemaHighlightingSessionStatisticsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonSchemaHighlightingSessionStatisticsCollector.kt\ncom/jetbrains/jsonSchema/fus/JsonSchemaHighlightingSessionStatisticsCollector\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n23#2:98\n23#2:107\n23#2:108\n1563#3:99\n1634#3,3:100\n1563#3:103\n1634#3,3:104\n*S KotlinDebug\n*F\n+ 1 JsonSchemaHighlightingSessionStatisticsCollector.kt\ncom/jetbrains/jsonSchema/fus/JsonSchemaHighlightingSessionStatisticsCollector\n*L\n74#1:98\n87#1:107\n89#1:108\n79#1:99\n79#1:100,3\n80#1:103\n80#1:104,3\n*E\n"})
public final class JsonSchemaHighlightingSessionStatisticsCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ThreadLocal<JsonSchemaHighlightingSession> currentHighlightingSession = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void recordSchemaFeaturesUsage(@NotNull JsonSchemaObject schemaRoot, @NotNull Runnable operation) {
        Intrinsics.checkNotNullParameter((Object)schemaRoot, (String)"schemaRoot");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        try {
            this.startCollectingSchemaHighlightingFus(schemaRoot);
            operation.run();
        }
        catch (CancellationException exception) {
            this.cleanupHighlightingSessionDataNoFlush();
            throw exception;
        }
        finally {
            this.flushHighlightingSessionDataToFus();
        }
    }

    public final void reportSchemaUsageFeature(@NotNull JsonSchemaFusCountedFeature featureKind) {
        Intrinsics.checkNotNullParameter((Object)featureKind, (String)"featureKind");
        JsonSchemaHighlightingSession jsonSchemaHighlightingSession = this.getCurrentSession();
        if (jsonSchemaHighlightingSession == null) {
            return;
        }
        JsonSchemaHighlightingSession currentSession = jsonSchemaHighlightingSession;
        ((Map)currentSession.getFeaturesWithCount()).put(featureKind, ((Number)currentSession.getFeaturesWithCount().getOrDefault(featureKind, 0)).intValue() + 1);
    }

    public final void reportUniqueUrlDownloadRequestUsage(@NotNull String schemaUrl) {
        Intrinsics.checkNotNullParameter((Object)schemaUrl, (String)"schemaUrl");
        JsonSchemaHighlightingSession jsonSchemaHighlightingSession = this.getCurrentSession();
        if (jsonSchemaHighlightingSession == null) {
            return;
        }
        JsonSchemaHighlightingSession currentSession = jsonSchemaHighlightingSession;
        currentSession.getRequestedRemoteSchemas().add(schemaUrl);
    }

    private final JsonSchemaHighlightingSession createNewSession() {
        JsonSchemaHighlightingSession newSession = new JsonSchemaHighlightingSession();
        this.currentHighlightingSession.set(newSession);
        return newSession;
    }

    private final JsonSchemaHighlightingSession getCurrentSession() {
        return this.currentHighlightingSession.get();
    }

    private final void cleanupHighlightingSessionDataNoFlush() {
        this.currentHighlightingSession.set(null);
    }

    private final void startCollectingSchemaHighlightingFus(JsonSchemaObject schemaRoot) {
        JsonSchemaHighlightingSession currentSession = this.createNewSession();
        currentSession.setSchemaType(this.guessBestSchemaId(schemaRoot));
    }

    /*
     * WARNING - void declaration
     */
    private final void flushHighlightingSessionDataToFus() {
        Collection collection;
        JsonSchemaFusCountedFeature jsonSchemaFusCountedFeature;
        Iterable $this$mapTo$iv$iv;
        JsonSchemaHighlightingSession sessionData = this.getCurrentSession();
        if (sessionData == null) {
            JsonSchemaHighlightingSessionStatisticsCollector $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JsonSchemaHighlightingSessionStatisticsCollector.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("No JSON schema highlighting session FUS to collect");
            return;
        }
        Iterable $this$map$iv = (Iterable)JsonSchemaFusCountedFeature.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void feature;
            jsonSchemaFusCountedFeature = (JsonSchemaFusCountedFeature)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)feature, (Object)sessionData.getFeaturesWithCount().getOrDefault(feature, 0)));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            jsonSchemaFusCountedFeature = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JsonSchemaFusCountedFeature feature = (JsonSchemaFusCountedFeature)jsonSchemaFusCountedFeature.component1();
            Object object = jsonSchemaFusCountedFeature.component2();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component2(...)");
            Integer usagesCount = (Integer)object;
            collection.add(feature.getEvent().with((Object)usagesCount));
        }
        List allCountEventsDuringSession = (List)destination$iv$iv;
        EventPair uniqueSchemasCount = JsonSchemaFusCountedUniqueFeature.UniqueRemoteUrlDownloadRequest.getEvent().with((Object)sessionData.getRequestedRemoteSchemas().size());
        EventPair schemaId = JsonSchemaFusAllowedListFeature.JsonFusSchemaId.getEvent().with((Object)sessionData.getSchemaType());
        List allDataAccumulated = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)allCountEventsDuringSession, (Object)uniqueSchemasCount), (Object)schemaId);
        JsonFeatureUsageCollector.INSTANCE.getJsonSchemaHighlightingSessionData$intellij_json_backend().log(allDataAccumulated);
        JsonSchemaHighlightingSessionStatisticsCollector $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(JsonSchemaHighlightingSessionStatisticsCollector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        if (logger.isDebugEnabled()) {
            String printableStatistics = CollectionsKt.joinToString$default((Iterable)allDataAccumulated, (CharSequence)"\n", (CharSequence)"\n", (CharSequence)"\n", (int)0, null, JsonSchemaHighlightingSessionStatisticsCollector::flushHighlightingSessionDataToFus$lambda$2, (int)24, null);
            JsonSchemaHighlightingSessionStatisticsCollector $this$thisLogger$iv2 = this;
            boolean $i$f$thisLogger2 = false;
            Logger logger2 = Logger.getInstance(JsonSchemaHighlightingSessionStatisticsCollector.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.debug("JSON schema highlighting session statistics: " + printableStatistics);
        }
    }

    private final String guessBestSchemaId(JsonSchemaObject schemaRoot) {
        String rawSchemaIdentifier;
        String string = schemaRoot.getId();
        if (string == null) {
            VirtualFile virtualFile = schemaRoot.getRawFile();
            string = virtualFile != null ? virtualFile.getName() : null;
        }
        String string2 = rawSchemaIdentifier = string;
        return string2 != null ? StringsKt.replace$default((String)string2, (String)"http://", (String)"https://", (boolean)false, (int)4, null) : null;
    }

    private static final CharSequence flushHighlightingSessionDataToFus$lambda$2(EventPair eventPair) {
        Intrinsics.checkNotNullParameter((Object)eventPair, (String)"eventPair");
        return eventPair.getField().getName() + ": " + eventPair.getData();
    }

    @JvmStatic
    @NotNull
    public static final JsonSchemaHighlightingSessionStatisticsCollector getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/jsonSchema/fus/JsonSchemaHighlightingSessionStatisticsCollector$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/jsonSchema/fus/JsonSchemaHighlightingSessionStatisticsCollector;", "intellij.json.backend"})
    @SourceDebugExtension(value={"SMAP\nJsonSchemaHighlightingSessionStatisticsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonSchemaHighlightingSessionStatisticsCollector.kt\ncom/jetbrains/jsonSchema/fus/JsonSchemaHighlightingSessionStatisticsCollector$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,97:1\n42#2,3:98\n*S KotlinDebug\n*F\n+ 1 JsonSchemaHighlightingSessionStatisticsCollector.kt\ncom/jetbrains/jsonSchema/fus/JsonSchemaHighlightingSessionStatisticsCollector$Companion\n*L\n15#1:98,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JsonSchemaHighlightingSessionStatisticsCollector getInstance() {
            boolean $i$f$service = false;
            Class<JsonSchemaHighlightingSessionStatisticsCollector> serviceClass$iv = JsonSchemaHighlightingSessionStatisticsCollector.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (JsonSchemaHighlightingSessionStatisticsCollector)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R-\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R!\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\f0\u0012j\b\u0012\u0004\u0012\u00020\f`\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/jsonSchema/fus/JsonSchemaHighlightingSessionStatisticsCollector$JsonSchemaHighlightingSession;", "", "<init>", "(Lcom/jetbrains/jsonSchema/fus/JsonSchemaHighlightingSessionStatisticsCollector;)V", "featuresWithCount", "Ljava/util/HashMap;", "Lcom/jetbrains/jsonSchema/fus/JsonSchemaFusFeature;", "", "Lkotlin/collections/HashMap;", "getFeaturesWithCount", "()Ljava/util/HashMap;", "schemaType", "", "getSchemaType", "()Ljava/lang/String;", "setSchemaType", "(Ljava/lang/String;)V", "requestedRemoteSchemas", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getRequestedRemoteSchemas", "()Ljava/util/HashSet;", "intellij.json.backend"})
    private final class JsonSchemaHighlightingSession {
        @NotNull
        private final HashMap<JsonSchemaFusFeature, Integer> featuresWithCount = new HashMap();
        @Nullable
        private String schemaType;
        @NotNull
        private final HashSet<String> requestedRemoteSchemas = new HashSet();

        @NotNull
        public final HashMap<JsonSchemaFusFeature, Integer> getFeaturesWithCount() {
            return this.featuresWithCount;
        }

        @Nullable
        public final String getSchemaType() {
            return this.schemaType;
        }

        public final void setSchemaType(@Nullable String string) {
            this.schemaType = string;
        }

        @NotNull
        public final HashSet<String> getRequestedRemoteSchemas() {
            return this.requestedRemoteSchemas;
        }
    }
}

