/*
 * Decompiled with CFR 0.152.
 */
package it.krzeminski.snakeyaml.engine.kmp.composer;

import it.krzeminski.snakeyaml.engine.kmp.api.LoadSettings;
import it.krzeminski.snakeyaml.engine.kmp.comments.CommentEventsCollector;
import it.krzeminski.snakeyaml.engine.kmp.comments.CommentLine;
import it.krzeminski.snakeyaml.engine.kmp.comments.CommentType;
import it.krzeminski.snakeyaml.engine.kmp.common.Anchor;
import it.krzeminski.snakeyaml.engine.kmp.common.FlowStyle;
import it.krzeminski.snakeyaml.engine.kmp.common.ScalarStyle;
import it.krzeminski.snakeyaml.engine.kmp.events.AliasEvent;
import it.krzeminski.snakeyaml.engine.kmp.events.Event;
import it.krzeminski.snakeyaml.engine.kmp.events.MappingStartEvent;
import it.krzeminski.snakeyaml.engine.kmp.events.NodeEvent;
import it.krzeminski.snakeyaml.engine.kmp.events.ScalarEvent;
import it.krzeminski.snakeyaml.engine.kmp.events.SequenceStartEvent;
import it.krzeminski.snakeyaml.engine.kmp.exceptions.ComposerException;
import it.krzeminski.snakeyaml.engine.kmp.exceptions.Mark;
import it.krzeminski.snakeyaml.engine.kmp.exceptions.YamlEngineException;
import it.krzeminski.snakeyaml.engine.kmp.nodes.MappingNode;
import it.krzeminski.snakeyaml.engine.kmp.nodes.Node;
import it.krzeminski.snakeyaml.engine.kmp.nodes.NodeTuple;
import it.krzeminski.snakeyaml.engine.kmp.nodes.NodeType;
import it.krzeminski.snakeyaml.engine.kmp.nodes.ScalarNode;
import it.krzeminski.snakeyaml.engine.kmp.nodes.SequenceNode;
import it.krzeminski.snakeyaml.engine.kmp.nodes.Tag;
import it.krzeminski.snakeyaml.engine.kmp.parser.Parser;
import it.krzeminski.snakeyaml.engine.kmp.resolver.ScalarResolver;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u0015\u001a\u00020\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002J\t\u0010\u0018\u001a\u00020\u0002H\u0096\u0002J\u0012\u0010\u0019\u001a\u00020\u00022\b\u0010\u001a\u001a\u0004\u0018\u00010\u0002H\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u0002H\u0002J \u0010\u001f\u001a\u00020 2\b\u0010\u001d\u001a\u0004\u0018\u00010\r2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0002J\u0012\u0010$\u001a\u00020%2\b\u0010\u001d\u001a\u0004\u0018\u00010\rH\u0002J\u0012\u0010&\u001a\u00020'2\b\u0010\u001d\u001a\u0004\u0018\u00010\rH\u0002J\u001e\u0010(\u001a\u00020\u001c2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010\u001e\u001a\u00020'H\u0002J\u0010\u0010,\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020'H\u0002J\u0010\u0010-\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020'H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lit/krzeminski/snakeyaml/engine/kmp/composer/Composer;", "", "Lit/krzeminski/snakeyaml/engine/kmp/nodes/Node;", "settings", "Lit/krzeminski/snakeyaml/engine/kmp/api/LoadSettings;", "parser", "Lit/krzeminski/snakeyaml/engine/kmp/parser/Parser;", "<init>", "(Lit/krzeminski/snakeyaml/engine/kmp/api/LoadSettings;Lit/krzeminski/snakeyaml/engine/kmp/parser/Parser;)V", "scalarResolver", "Lit/krzeminski/snakeyaml/engine/kmp/resolver/ScalarResolver;", "anchors", "", "Lit/krzeminski/snakeyaml/engine/kmp/common/Anchor;", "recursiveNodes", "", "blockCommentsCollector", "Lit/krzeminski/snakeyaml/engine/kmp/comments/CommentEventsCollector;", "inlineCommentsCollector", "nonScalarAliasesCount", "", "hasNext", "", "getSingleNode", "next", "composeNode", "parent", "registerAnchor", "", "anchor", "node", "composeScalarNode", "Lit/krzeminski/snakeyaml/engine/kmp/nodes/ScalarNode;", "blockComments", "", "Lit/krzeminski/snakeyaml/engine/kmp/comments/CommentLine;", "composeSequenceNode", "Lit/krzeminski/snakeyaml/engine/kmp/nodes/SequenceNode;", "composeMappingNode", "Lit/krzeminski/snakeyaml/engine/kmp/nodes/MappingNode;", "composeMappingChildren", "children", "", "Lit/krzeminski/snakeyaml/engine/kmp/nodes/NodeTuple;", "composeKeyNode", "composeValueNode", "snakeyaml-engine-kmp"})
public final class Composer
implements Iterator<Node>,
KMappedMarker {
    @NotNull
    private final LoadSettings settings;
    @NotNull
    private final Parser parser;
    @NotNull
    private final ScalarResolver scalarResolver;
    @NotNull
    private final Map<Anchor, Node> anchors;
    @NotNull
    private final Set<Node> recursiveNodes;
    @NotNull
    private final CommentEventsCollector blockCommentsCollector;
    @NotNull
    private final CommentEventsCollector inlineCommentsCollector;
    private int nonScalarAliasesCount;

    public Composer(@NotNull LoadSettings settings, @NotNull Parser parser) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        this.settings = settings;
        this.parser = parser;
        this.scalarResolver = this.settings.schema.getScalarResolver();
        this.anchors = new LinkedHashMap();
        this.recursiveNodes = new LinkedHashSet();
        CommentType[] commentTypeArray = new CommentType[]{CommentType.BLANK_LINE, CommentType.BLOCK};
        this.blockCommentsCollector = new CommentEventsCollector(this.parser, commentTypeArray);
        commentTypeArray = new CommentType[]{CommentType.IN_LINE};
        this.inlineCommentsCollector = new CommentEventsCollector(this.parser, commentTypeArray);
    }

    @Override
    public boolean hasNext() {
        if (this.parser.checkEvent(Event.ID.StreamStart)) {
            this.parser.next();
        }
        return !this.parser.checkEvent(Event.ID.StreamEnd);
    }

    @Nullable
    public final Node getSingleNode() {
        Node document;
        this.parser.next();
        Node node = document = !this.parser.checkEvent(Event.ID.StreamEnd) ? this.next() : null;
        if (!this.parser.checkEvent(Event.ID.StreamEnd)) {
            Event event = this.parser.next();
            Node node2 = document;
            Mark previousDocMark = node2 != null ? node2.getStartMark() : null;
            throw new ComposerException("expected a single document in the stream", previousDocMark, "but found another document", event.getStartMark());
        }
        this.parser.next();
        return document;
    }

    @Override
    @NotNull
    public Node next() {
        this.blockCommentsCollector.collectEvents();
        if (this.parser.checkEvent(Event.ID.StreamEnd)) {
            List<CommentLine> commentLines = this.blockCommentsCollector.consume();
            Mark startMark = ((CommentLine)CollectionsKt.first(commentLines)).startMark;
            List children = new ArrayList();
            Tag tag = Tag.COMMENT;
            FlowStyle flowStyle = FlowStyle.BLOCK;
            Node node = new MappingNode(tag, children, flowStyle, false, startMark, null);
            node.setBlockComments(commentLines);
            return node;
        }
        this.parser.next();
        Node node = this.composeNode(null);
        this.blockCommentsCollector.collectEvents();
        if (!this.blockCommentsCollector.isEmpty()) {
            node.setEndComments(this.blockCommentsCollector.consume());
        }
        this.parser.next();
        this.anchors.clear();
        this.recursiveNodes.clear();
        this.nonScalarAliasesCount = 0;
        return node;
    }

    private final Node composeNode(Node parent) {
        this.blockCommentsCollector.collectEvents();
        if (parent != null) {
            this.recursiveNodes.add(parent);
        }
        Node node = null;
        if (this.parser.checkEvent(Event.ID.Alias)) {
            Event event = this.parser.next();
            Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type it.krzeminski.snakeyaml.engine.kmp.events.AliasEvent");
            AliasEvent event2 = (AliasEvent)event;
            Anchor anchor = event2.getAlias();
            Node node2 = this.anchors.get(anchor);
            if (node2 == null) {
                throw new ComposerException("found undefined alias " + anchor, event2.getStartMark(), null, null, 12, null);
            }
            node = node2;
            if (node.getNodeType() != NodeType.SCALAR) {
                int n = this.nonScalarAliasesCount;
                this.nonScalarAliasesCount = n + 1;
                if (this.nonScalarAliasesCount > this.settings.maxAliasesForCollections) {
                    throw new YamlEngineException("Number of aliases for non-scalar nodes exceeds the specified max=" + this.settings.maxAliasesForCollections);
                }
            }
            if (this.recursiveNodes.remove(node)) {
                node.setRecursive(true);
            }
            this.blockCommentsCollector.consume();
            this.inlineCommentsCollector.collectEvents().consume();
        } else {
            Event event = this.parser.peekEvent();
            Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type it.krzeminski.snakeyaml.engine.kmp.events.NodeEvent");
            NodeEvent event3 = (NodeEvent)event;
            Anchor anchor = event3.getAnchor();
            Node node3 = this.parser.checkEvent(Event.ID.Scalar) ? (Node)this.composeScalarNode(anchor, this.blockCommentsCollector.consume()) : (node = this.parser.checkEvent(Event.ID.SequenceStart) ? (Node)this.composeSequenceNode(anchor) : (Node)this.composeMappingNode(anchor));
        }
        if (parent != null) {
            this.recursiveNodes.remove(parent);
        }
        return node;
    }

    private final void registerAnchor(Anchor anchor, Node node) {
        this.anchors.put(anchor, node);
        node.setAnchor(anchor);
    }

    private final ScalarNode composeScalarNode(Anchor anchor, List<CommentLine> blockComments) {
        Event event = this.parser.next();
        Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type it.krzeminski.snakeyaml.engine.kmp.events.ScalarEvent");
        ScalarEvent ev = (ScalarEvent)event;
        String tag = ev.getTag();
        boolean resolved = false;
        Tag nodeTag = null;
        if (tag == null || Intrinsics.areEqual((Object)tag, (Object)"!")) {
            nodeTag = this.scalarResolver.resolve(ev.getValue(), ev.getImplicit().canOmitTagInPlainScalar());
            resolved = true;
        } else {
            nodeTag = new Tag(tag);
            resolved = false;
        }
        String string = ev.getValue();
        ScalarStyle scalarStyle = ev.getScalarStyle();
        Mark mark = ev.getStartMark();
        Mark mark2 = ev.getEndMark();
        ScalarNode node = new ScalarNode(nodeTag, string, scalarStyle, resolved, mark, mark2);
        if (anchor != null) {
            this.registerAnchor(anchor, node);
        }
        node.setBlockComments(blockComments);
        node.setInLineComments(this.inlineCommentsCollector.collectEvents().consume());
        return node;
    }

    private final SequenceNode composeSequenceNode(Anchor anchor) {
        Event event = this.parser.next();
        Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type it.krzeminski.snakeyaml.engine.kmp.events.SequenceStartEvent");
        SequenceStartEvent startEvent = (SequenceStartEvent)event;
        String tag = startEvent.getTag();
        Tag nodeTag = null;
        boolean resolved = false;
        if (tag == null || Intrinsics.areEqual((Object)tag, (Object)"!")) {
            nodeTag = Tag.SEQ;
            resolved = true;
        } else {
            nodeTag = new Tag(tag);
            resolved = false;
        }
        ArrayList<Node> children = new ArrayList<Node>();
        SequenceNode node = new SequenceNode(nodeTag, (List<? extends Node>)children, startEvent.getFlowStyle(), resolved, startEvent.getStartMark(), null);
        if (startEvent.isFlow()) {
            node.setBlockComments(this.blockCommentsCollector.consume());
        }
        if (anchor != null) {
            this.registerAnchor(anchor, node);
        }
        while (!this.parser.checkEvent(Event.ID.SequenceEnd)) {
            this.blockCommentsCollector.collectEvents();
            if (this.parser.checkEvent(Event.ID.SequenceEnd)) break;
            children.add(this.composeNode(node));
        }
        if (startEvent.isFlow()) {
            node.setInLineComments(this.inlineCommentsCollector.collectEvents().consume());
        }
        Event endEvent = this.parser.next();
        node.setEndMark(endEvent.getEndMark());
        this.inlineCommentsCollector.collectEvents();
        if (!this.inlineCommentsCollector.isEmpty()) {
            node.setInLineComments(this.inlineCommentsCollector.consume());
        }
        return node;
    }

    private final MappingNode composeMappingNode(Anchor anchor) {
        Event event = this.parser.next();
        Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type it.krzeminski.snakeyaml.engine.kmp.events.MappingStartEvent");
        MappingStartEvent startEvent = (MappingStartEvent)event;
        String tag = startEvent.getTag();
        Tag nodeTag = null;
        boolean resolved = false;
        if (tag == null || Intrinsics.areEqual((Object)tag, (Object)"!")) {
            nodeTag = Tag.MAP;
            resolved = true;
        } else {
            nodeTag = new Tag(tag);
            resolved = false;
        }
        List children = new ArrayList();
        MappingNode node = new MappingNode(nodeTag, children, startEvent.getFlowStyle(), resolved, startEvent.getStartMark(), null);
        if (startEvent.isFlow()) {
            node.setBlockComments(this.blockCommentsCollector.consume());
        }
        if (anchor != null) {
            this.registerAnchor(anchor, node);
        }
        while (!this.parser.checkEvent(Event.ID.MappingEnd)) {
            this.blockCommentsCollector.collectEvents();
            if (this.parser.checkEvent(Event.ID.MappingEnd)) break;
            this.composeMappingChildren(children, node);
        }
        if (startEvent.isFlow()) {
            node.setInLineComments(this.inlineCommentsCollector.collectEvents().consume());
        }
        Event endEvent = this.parser.next();
        node.setEndMark(endEvent.getEndMark());
        this.inlineCommentsCollector.collectEvents();
        if (!this.inlineCommentsCollector.isEmpty()) {
            node.setInLineComments(this.inlineCommentsCollector.consume());
        }
        return node;
    }

    private final void composeMappingChildren(List<NodeTuple> children, MappingNode node) {
        Node itemKey = this.composeKeyNode(node);
        Node itemValue = this.composeValueNode(node);
        children.add(new NodeTuple(itemKey, itemValue));
    }

    private final Node composeKeyNode(MappingNode node) {
        return this.composeNode(node);
    }

    private final Node composeValueNode(MappingNode node) {
        return this.composeNode(node);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

