/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.pager.PagerState;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.input.nestedscroll.NestedScrollConnection;
import androidx.compose.ui.input.nestedscroll.NestedScrollSource;
import androidx.compose.ui.unit.Velocity;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0019\u0010\f\u001a\u00020\r*\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J'\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ \u0010\u001b\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rH\u0096@\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0013\u0010\u001e\u001a\u00020\u001f*\u00020\u0011H\u0002\u00a2\u0006\u0004\b \u0010!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\""}, d2={"Landroidx/compose/foundation/pager/DefaultPagerNestedScrollConnection;", "Landroidx/compose/ui/input/nestedscroll/NestedScrollConnection;", "state", "Landroidx/compose/foundation/pager/PagerState;", "orientation", "Landroidx/compose/foundation/gestures/Orientation;", "<init>", "(Landroidx/compose/foundation/pager/PagerState;Landroidx/compose/foundation/gestures/Orientation;)V", "getState", "()Landroidx/compose/foundation/pager/PagerState;", "getOrientation", "()Landroidx/compose/foundation/gestures/Orientation;", "consumeOnOrientation", "Landroidx/compose/ui/unit/Velocity;", "consumeOnOrientation-QWom1Mo", "(JLandroidx/compose/foundation/gestures/Orientation;)J", "onPreScroll", "Landroidx/compose/ui/geometry/Offset;", "available", "source", "Landroidx/compose/ui/input/nestedscroll/NestedScrollSource;", "onPreScroll-OzD1aCk", "(JI)J", "onPostScroll", "consumed", "onPostScroll-DzOQY0M", "(JJI)J", "onPostFling", "onPostFling-RZ2iAVY", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "mainAxis", "", "mainAxis-k-4lQ0M", "(J)F", "foundation"})
@SourceDebugExtension(value={"SMAP\nPager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pager.kt\nandroidx/compose/foundation/pager/DefaultPagerNestedScrollConnection\n+ 2 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n*L\n1#1,592:1\n65#2:593\n69#2:596\n65#2:598\n69#2:601\n65#2:604\n69#2:607\n60#3:594\n70#3:597\n60#3:599\n70#3:602\n60#3:605\n70#3:608\n22#4:595\n22#4:600\n22#4:603\n22#4:606\n*S KotlinDebug\n*F\n+ 1 Pager.kt\nandroidx/compose/foundation/pager/DefaultPagerNestedScrollConnection\n*L\n505#1:593\n505#1:596\n510#1:598\n511#1:601\n534#1:604\n534#1:607\n505#1:594\n505#1:597\n510#1:599\n511#1:602\n534#1:605\n534#1:608\n505#1:595\n510#1:600\n511#1:603\n534#1:606\n*E\n"})
final class DefaultPagerNestedScrollConnection
implements NestedScrollConnection {
    @NotNull
    private final PagerState state;
    @NotNull
    private final Orientation orientation;

    public DefaultPagerNestedScrollConnection(@NotNull PagerState state, @NotNull Orientation orientation) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        this.state = state;
        this.orientation = orientation;
    }

    @NotNull
    public final PagerState getState() {
        return this.state;
    }

    @NotNull
    public final Orientation getOrientation() {
        return this.orientation;
    }

    public final long consumeOnOrientation-QWom1Mo(long $this$consumeOnOrientation_u2dQWom1Mo, @NotNull Orientation orientation) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        return orientation == Orientation.Vertical ? Velocity.copy-OhffZ5M$default($this$consumeOnOrientation_u2dQWom1Mo, 0.0f, 0.0f, 2, null) : Velocity.copy-OhffZ5M$default($this$consumeOnOrientation_u2dQWom1Mo, 0.0f, 0.0f, 1, null);
    }

    @Override
    public long onPreScroll-OzD1aCk(long available, int source) {
        long l;
        if (NestedScrollSource.equals-impl0(source, NestedScrollSource.Companion.getUserInput-WNlRxjI()) && (double)Math.abs(this.state.getCurrentPageOffsetFraction()) > 1.0E-6) {
            float f;
            boolean $i$f$floatFromBits;
            int bits$iv$iv$iv;
            float f2;
            float f3;
            boolean $i$f$floatFromBits2;
            int bits$iv$iv$iv2;
            long value$iv$iv;
            long arg0$iv;
            float currentPageOffset = this.state.getCurrentPageOffsetFraction() * (float)this.state.getPageSize$foundation();
            int pageAvailableSpace = this.state.getLayoutInfo().getPageSize() + this.state.getLayoutInfo().getPageSpacing();
            float nextClosestPageOffset = currentPageOffset + (float)pageAvailableSpace * -Math.signum(this.state.getCurrentPageOffsetFraction());
            float minBound = 0.0f;
            float maxBound = 0.0f;
            if (this.state.getCurrentPageOffsetFraction() > 0.0f) {
                minBound = nextClosestPageOffset;
                maxBound = currentPageOffset;
            } else {
                minBound = currentPageOffset;
                maxBound = nextClosestPageOffset;
            }
            if (this.orientation == Orientation.Horizontal) {
                arg0$iv = available;
                boolean bl = false;
                value$iv$iv = arg0$iv;
                boolean $i$f$unpackFloat1 = false;
                bits$iv$iv$iv2 = (int)(value$iv$iv >> 32);
                $i$f$floatFromBits2 = false;
                f3 = Float.intBitsToFloat(bits$iv$iv$iv2);
            } else {
                arg0$iv = available;
                boolean bl = false;
                value$iv$iv = arg0$iv;
                boolean $i$f$unpackFloat2 = false;
                bits$iv$iv$iv2 = (int)(value$iv$iv & 0xFFFFFFFFL);
                $i$f$floatFromBits2 = false;
                f3 = Float.intBitsToFloat(bits$iv$iv$iv2);
            }
            float delta = f3;
            float coerced = RangesKt.coerceIn((float)delta, (float)minBound, (float)maxBound);
            float consumed = -this.state.dispatchRawDelta(-coerced);
            if (this.orientation == Orientation.Horizontal) {
                f2 = consumed;
            } else {
                long arg0$iv2 = available;
                boolean bl = false;
                long value$iv$iv2 = arg0$iv2;
                boolean $i$f$unpackFloat1 = false;
                bits$iv$iv$iv = (int)(value$iv$iv2 >> 32);
                $i$f$floatFromBits = false;
                f2 = Float.intBitsToFloat(bits$iv$iv$iv);
            }
            if (this.orientation == Orientation.Vertical) {
                f = consumed;
            } else {
                long arg0$iv3 = available;
                boolean bl = false;
                long value$iv$iv3 = arg0$iv3;
                boolean $i$f$unpackFloat2 = false;
                bits$iv$iv$iv = (int)(value$iv$iv3 & 0xFFFFFFFFL);
                $i$f$floatFromBits = false;
                f = Float.intBitsToFloat(bits$iv$iv$iv);
            }
            l = Offset.copy-dBAh8RU(available, f2, f);
        } else {
            l = Offset.Companion.getZero-F1C5BW0();
        }
        return l;
    }

    @Override
    public long onPostScroll-DzOQY0M(long consumed, long available, int source) {
        if (NestedScrollSource.equals-impl0(source, NestedScrollSource.Companion.getSideEffect-WNlRxjI()) && !(this.mainAxis-k-4lQ0M(available) == 0.0f)) {
            throw new CancellationException("Scroll cancelled");
        }
        return Offset.Companion.getZero-F1C5BW0();
    }

    @Override
    @Nullable
    public Object onPostFling-RZ2iAVY(long consumed, long available, @NotNull Continuation<? super Velocity> $completion) {
        return Velocity.box-impl(this.consumeOnOrientation-QWom1Mo(available, this.orientation));
    }

    private final float mainAxis-k-4lQ0M(long $this$mainAxis_u2dk_u2d4lQ0M) {
        float f;
        if (this.orientation == Orientation.Horizontal) {
            long arg0$iv = $this$mainAxis_u2dk_u2d4lQ0M;
            boolean bl = false;
            long value$iv$iv = arg0$iv;
            boolean $i$f$unpackFloat1 = false;
            int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
            boolean $i$f$floatFromBits = false;
            f = Float.intBitsToFloat(bits$iv$iv$iv);
        } else {
            long arg0$iv = $this$mainAxis_u2dk_u2d4lQ0M;
            boolean bl = false;
            long value$iv$iv = arg0$iv;
            boolean $i$f$unpackFloat2 = false;
            int bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
            boolean $i$f$floatFromBits = false;
            f = Float.intBitsToFloat(bits$iv$iv$iv);
        }
        return f;
    }
}

