/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vcs.actions.AnnotationFieldGutter;
import com.intellij.openapi.vcs.annotate.AnnotationSource;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.TextAnnotationPresentation;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import java.awt.Color;
import java.util.Map;
import java.util.function.Consumer;

final class MergeSourceAvailableMarkerGutter
extends AnnotationFieldGutter
implements Consumer<AnnotationSource> {
    private boolean myTurnedOn;

    MergeSourceAvailableMarkerGutter(FileAnnotation annotation, TextAnnotationPresentation highlighting, Couple<Map<VcsRevisionNumber, Color>> colorScheme) {
        super(annotation, highlighting, colorScheme);
    }

    @Override
    public ColorKey getColor(int line, Editor editor) {
        return AnnotationSource.LOCAL.getColor();
    }

    public String getLineText(int line, Editor editor) {
        if (this.myTurnedOn) {
            return "";
        }
        AnnotationSourceSwitcher switcher = this.myAnnotation.getAnnotationSourceSwitcher();
        if (switcher == null) {
            return "";
        }
        return switcher.mergeSourceAvailable(line) ? "M" : "";
    }

    @Override
    public void accept(AnnotationSource annotationSource) {
        this.myTurnedOn = annotationSource.showMerged();
    }
}

