/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.common;

import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.openapi.diagnostic.Logger;
import java.net.URL;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@TestOnly
@ApiStatus.Internal
public final class PlatformPrefix {
    private static final String[] PREFIX_CANDIDATES = new String[]{"Rider", "GoLand", "CLion", "FleetBackend", null, "AppCode", "Python", "DataSpell", "PyCharmCore", "DataGrip", "Ruby", "PhpStorm", "RustRover", "UltimateLangXml", "Idea", "PlatformLangXml"};
    private static boolean ourPlatformPrefixInitialized;

    private PlatformPrefix() {
    }

    public static void autodetectPlatformPrefix() {
        if (ourPlatformPrefixInitialized) {
            return;
        }
        if (System.getProperty("idea.platform.prefix") != null) {
            ourPlatformPrefixInitialized = true;
            return;
        }
        for (String candidate : PREFIX_CANDIDATES) {
            Object markerPath = candidate == null ? "idea/ApplicationInfo.xml" : (PluginDescriptorLoader.isProductWithTheOnlyDescriptor((String)candidate) ? "idea/" + candidate + "ApplicationInfo.xml" : "META-INF/" + candidate + "Plugin.xml");
            URL resource = PlatformPrefix.class.getClassLoader().getResource((String)markerPath);
            if (resource == null) continue;
            if (candidate == null) break;
            PlatformPrefix.setPlatformPrefix(candidate);
            Logger logger = Logger.getInstance(PlatformPrefix.class);
            logger.info(String.format("Platform prefix (IDE that is emulated by this test): %s. File %s", candidate, resource));
            break;
        }
    }

    private static void setPlatformPrefix(@NotNull String prefix) {
        if (prefix == null) {
            PlatformPrefix.$$$reportNull$$$0(0);
        }
        System.setProperty("idea.platform.prefix", prefix);
        ourPlatformPrefixInitialized = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/testFramework/common/PlatformPrefix", "setPlatformPrefix"));
    }
}

