/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxVarChar;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.TraceFlag;
import java.io.IOException;
import java.sql.SQLException;

public class IfxLvarchar
extends IfxVarChar {
    protected String defaultEncoding = "ISO8859_1";

    IfxLvarchar() throws SQLException {
        this.setIfxType(43);
        this.setExtendedId(1);
    }

    public IfxLvarchar(String str) throws SQLException {
        this.value = str;
        if (this.value != null) {
            this.unnullify();
        }
        this.setIfxType(43);
        this.setExtendedId(1);
    }

    @Override
    public byte[] toIfx() throws SQLException {
        try {
            String dbEnc = this.conn.getdbEncoding();
            byte[] bData = ((IfxSqliConnect)this.conn).javatoifx.JavaToIfxLvarchar(this.value, dbEnc, ((IfxSqliConnect)this.conn).encoption);
            byte[] bIfxData = new byte[bData.length + 4];
            byte[] bLength = JavaToIfxType.JavaToIfxInt(bData.length);
            System.arraycopy(bLength, 0, bIfxData, 0, bLength.length);
            System.arraycopy(bData, 0, bIfxData, 4, bData.length);
            return bIfxData;
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public byte[] toIfxTuple() throws SQLException {
        try {
            int dataLength = 0;
            byte[] bData = null;
            if (!this.isNull()) {
                String dbEnc = this.conn.getdbEncoding();
                bData = dbEnc != null ? this.value.toString().getBytes(dbEnc) : this.value.toString().getBytes(this.defaultEncoding);
                dataLength = this.encodedLength > 0 ? Math.min(bData.length, this.encodedLength) : bData.length;
            }
            int tupleLength = 5 + dataLength;
            byte[] bTuple = new byte[tupleLength];
            byte[] bTupleLength = JavaToIfxType.JavaToIfxInt(dataLength);
            bTuple[0] = 0;
            System.arraycopy(bTupleLength, 0, bTuple, 1, bTupleLength.length);
            if (this.isNull()) {
                bTuple[0] = 1;
                return bTuple;
            }
            System.arraycopy(bData, 0, bTuple, 5, dataLength);
            return bTuple;
        }
        catch (IOException e) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public Object toObject(boolean notused) throws SQLException {
        return this.value;
    }

    @Override
    public void fromIfx(byte[] b, String dbEnc) throws SQLException {
        this.fromIfx(b, 0, b.length, dbEnc);
    }

    @Override
    public void fromIfx(byte[] b, int offset, int length, String dbEnc) throws SQLException {
        try {
            if (b.length < offset + 1 + 4 || b[offset] == 1) {
                this.value = null;
                this.nullify();
                return;
            }
            int datalength = IfxToJavaType.IfxToJavaInt(b, offset + 1);
            if (datalength == 0) {
                this.value = new String("");
            } else {
                if (dbEnc == null) {
                    dbEnc = this.conn.getdbEncoding();
                }
                if (length > 0) {
                    datalength = Math.min(datalength, length);
                }
                if (b[offset + 4 + datalength] == 0) {
                    --datalength;
                }
                this.value = IfxToJavaType.IfxToJavaChar(b, offset + 1 + 4, datalength, dbEnc, ((IfxSqliConnect)this.conn).encoption);
            }
            this.unnullify();
        }
        catch (IOException e) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public void fromIfx(byte[] b) throws SQLException {
        this.fromIfx(b, 0, b.length);
    }

    @Override
    public void fromIfx(byte[] b, int offset, int length) throws SQLException {
        this.fromIfx(b, offset, length, null);
    }

    @Override
    public void fromCDC(byte[] b, int offset, int length) throws SQLException {
        this.fromCDC(b, offset, length, null);
    }

    public void fromCDC(byte[] b, int offset, int length, String dbEnc) throws SQLException {
        try {
            if (b.length < offset + 1 + 2) {
                this.value = null;
                this.nullify();
                return;
            }
            if (length == 0 && b[offset + 1] == 1 && b[offset + 2] == 1) {
                this.value = null;
                this.nullify();
                return;
            }
            if (length == 0 && b[offset + 1] == 1 && b[offset + 2] == 0) {
                this.value = "";
            } else {
                if (dbEnc == null) {
                    dbEnc = this.conn.getdbEncoding();
                }
                if (b[offset + 2 + length] == 0) {
                    --length;
                }
                this.value = IfxToJavaType.IfxToJavaChar(b, offset + 1 + 2, length, dbEnc, ((IfxSqliConnect)this.conn).encoption);
            }
            this.unnullify();
        }
        catch (IOException e) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public void fromString(String str) throws SQLException {
        this.fromString(str, false);
    }

    @Override
    public void fromString(String str, boolean trimString) throws SQLException {
        if (str == null) {
            this.nullify();
        } else {
            this.clearWarning();
            this.value = trimString ? str.trim() : str;
            this.unnullify();
        }
    }

    @Override
    public void fromBytes(byte[] str) throws SQLException {
        block6: {
            if (TraceFlag.isTraceEnabled()) {
                this.writeTrace(99, "IfxLvarchar.fromBytes() called");
            }
            if (str == null) {
                this.nullify();
            } else {
                try {
                    int byte_len = str.length;
                    String dbEnc = this.conn.getdbEncoding();
                    this.value = IfxToJavaType.IfxToJavaChar(str, 0, byte_len, dbEnc, ((IfxSqliConnect)this.conn).encoption);
                    this.unnullify();
                }
                catch (Exception e) {
                    this.value = null;
                    if (!(e instanceof IOException)) break block6;
                    throw IfxErrMsg.getSQLException(-79783, this.conn);
                }
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(99, "IfxLvarchar.fromBytes() exited");
        }
    }

    @Override
    public byte[] toBytes() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(99, "IfxLvarchar.toBytes() exited");
        }
        byte[] b = null;
        if (this.value == null) {
            this.nullify();
        } else {
            try {
                String cliEnc = ((IfxSqliConnect)this.conn).returnEnc();
                byte[] temp = ((IfxSqliConnect)this.conn).javatoifx.JavaToIfxChar(this.value, cliEnc, ((IfxSqliConnect)this.conn).encoption);
                int x = temp.length;
                b = new byte[x - 2];
                System.arraycopy(temp, 2, b, 0, x - 2);
            }
            catch (Exception e) {
                this.value = null;
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw IfxErrMsg.getSQLException(-79783, this.conn);
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(99, "IfxLvarchar.toBytes() exited");
        }
        return b;
    }
}

