/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.sql.SQLException;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.InfoProcessor;
import org.firebirdsql.gds.ng.listeners.ExceptionListenable;

public interface FbBlob
extends ExceptionListenable,
AutoCloseable {
    public static final long NO_BLOB_ID = 0L;

    public long getBlobId();

    public int getHandle();

    public FbDatabase getDatabase();

    public void open() throws SQLException;

    public boolean isOpen();

    public boolean isEof();

    @Override
    public void close() throws SQLException;

    public void cancel() throws SQLException;

    public boolean isOutput();

    public byte[] getSegment(int var1) throws SQLException;

    public int get(byte[] var1, int var2, int var3) throws SQLException;

    public int get(byte[] var1, int var2, int var3, float var4) throws SQLException;

    public void putSegment(byte[] var1) throws SQLException;

    public void put(byte[] var1, int var2, int var3) throws SQLException;

    public void seek(int var1, SeekMode var2) throws SQLException;

    public int getMaximumSegmentSize();

    public <T> T getBlobInfo(byte[] var1, int var2, InfoProcessor<T> var3) throws SQLException;

    public long length() throws SQLException;

    public byte[] getBlobInfo(byte[] var1, int var2) throws SQLException;

    public static enum SeekMode {
        ABSOLUTE(0),
        RELATIVE(1),
        ABSOLUTE_FROM_END(2);

        final int seekModeId;

        private SeekMode(int seekModeId) {
            this.seekModeId = seekModeId;
        }

        public int getSeekModeId() {
            return this.seekModeId;
        }

        public static SeekMode getById(int seekModeId) {
            for (SeekMode seekMode : SeekMode.values()) {
                if (seekMode.getSeekModeId() != seekModeId) continue;
                return seekMode;
            }
            throw new IllegalArgumentException(String.format("No SeekMode with id %d", seekModeId));
        }
    }
}

