/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal;

import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigFileMonitorTask
extends TimerTask {
    private long lastFileModificationTime_ = -1L;
    private File configFile_;
    private long oldTracePollingInterval_;

    public ConfigFileMonitorTask(String string, long l2) throws URISyntaxException {
        this.oldTracePollingInterval_ = l2;
        this.configFile_ = string.startsWith("file:") ? new File(new URI(string)) : new File(string);
        this.lastFileModificationTime_ = this.configFile_.lastModified();
        if (this.lastFileModificationTime_ == 0L) {
            throw new URISyntaxException(string, "Unable to obtain file mod time for file URI");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            long l2 = this.configFile_.lastModified();
            if (!DataProperties.isDataPropertiesInitialized()) {
                return;
            }
            if (this.lastFileModificationTime_ == l2) {
                return;
            }
            if (this.lastFileModificationTime_ != l2) {
                long l3;
                Object object;
                Log.getGlobalLogger().info("Detected change to CMX runtime config file (pdq.properties)");
                this.lastFileModificationTime_ = l2;
                Properties properties = DataProperties.cloneProperties();
                Properties properties2 = DataProperties.getPolledPropertiesFromFile(this.configFile_);
                DataProperties.mergeDynamicProperties(properties2);
                if (DataProperties.isDataPropertiesInitialized()) {
                    object = Log.initializeLock__;
                    synchronized (object) {
                        Log.configureLogger(false, true, properties);
                    }
                }
                Log.getGlobalLogger().info("CMX runtime logger has been reconfigured");
                object = DataProperties.getProperty("pdq.enableTracePolling");
                if (!((String)object).trim().equals("ON")) {
                    this.cancel();
                    DataProperties.traceTimer_.purge();
                    return;
                }
                String string = DataProperties.getProperty("pdq.tracePollingInterval");
                long l4 = l3 = Long.valueOf("30").longValue();
                try {
                    l4 = string == null ? l3 : Long.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    l4 = l3;
                }
                if (l4 <= 0L) {
                    l4 = l3;
                }
                if (l4 != this.oldTracePollingInterval_) {
                    try {
                        DataProperties.traceTimer_.schedule((TimerTask)this, l4 * 1000L, l4 * 1000L);
                        this.oldTracePollingInterval_ = l4;
                    }
                    catch (Exception exception) {
                        Logger logger = Log.getGlobalLogger();
                        if (logger == null) {
                            exception.printStackTrace();
                        }
                        logger.logp(Level.WARNING, "ConfigFileMonitorTask", "run", "Unable to reschedule the config file polling interval for trace", exception);
                    }
                }
            }
            DataLogger.logRuntimeMemoryUsage(Log.getGlobalLogger());
        }
        catch (Exception exception) {
            Logger logger = Log.getGlobalLogger();
            if (logger == null) {
                exception.printStackTrace();
            }
            logger.logp(Level.WARNING, "ConfigFileMonitorTask", "run", "Unable to poll property file", exception);
        }
    }
}

