/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateInline
@GenerateUncached
public abstract class PyObjectFormat
extends PNodeWithContext {
    public final Object executeNonInlined(VirtualFrame frame, Object obj, Object formatSpec) {
        return this.execute(frame, null, obj, formatSpec);
    }

    public abstract Object execute(VirtualFrame var1, Node var2, Object var3, Object var4);

    @Specialization
    static Object doNone(VirtualFrame frame, Node inliningTarget, Object obj, PNone formatSpec, @Cached.Shared(value="impl") @Cached PyObjectFormatStr formatStr) {
        return formatStr.execute((Frame)frame, inliningTarget, obj, StringLiterals.T_EMPTY_STRING);
    }

    @Fallback
    static Object doOthers(VirtualFrame frame, Node inliningTarget, Object obj, Object formatSpec, @Cached.Shared(value="impl") @Cached PyObjectFormatStr formatStr) {
        return formatStr.execute((Frame)frame, inliningTarget, obj, formatSpec);
    }

    @GenerateInline
    @GenerateUncached
    @GenerateCached(value=false)
    public static abstract class PyObjectFormatStr
    extends PNodeWithContext {
        public abstract Object execute(Frame var1, Node var2, Object var3, Object var4);

        static boolean isEmptyString(Object formatSpec) {
            return formatSpec instanceof TruffleString && ((TruffleString)formatSpec).isEmpty();
        }

        @Specialization(guards={"isString(obj)", "isEmptyString(formatSpec)"})
        static Object doString(Object obj, Object formatSpec) {
            return obj;
        }

        @Specialization(guards={"isEmptyString(formatSpec)"})
        static Object doLong(long obj, Object formatSpec) {
            return obj;
        }

        @Specialization(guards={"isString(formatSpec)"})
        static Object doGeneric(VirtualFrame frame, Node inliningTarget, Object obj, Object formatSpec, @Cached GetClassNode getClassNode, @Cached LookupSpecialMethodNode.Dynamic lookupFormat, @Cached CallBinaryMethodNode callFormat, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            Object formatMethod = lookupFormat.execute((Frame)frame, inliningTarget, getClassNode.execute(inliningTarget, obj), SpecialMethodNames.T___FORMAT__, obj);
            if (formatMethod != PNone.NO_VALUE) {
                Object res = callFormat.executeObject(frame, obj, formatSpec);
                if (!PGuards.isString(res)) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.S_MUST_RETURN_S_NOT_P, SpecialMethodNames.T___FORMAT__, "str", res);
                }
                return res;
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.TYPE_DOESNT_DEFINE_FORMAT, obj);
        }

        @Fallback
        static Object doNonStringFormat(Object obj, Object formatSpec, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.S_MUST_BE_S_NOT_P, "Format specifier", "a string", formatSpec);
        }
    }
}

