/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.bytecode.MatchKeysNodeGen;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;

@GenerateInline(value=false)
public abstract class MatchKeysNode
extends PNodeWithContext {
    public abstract Object execute(Frame var1, Object var2, Object[] var3);

    @Specialization(guards={"keys.length == keysLen", "keysLen > 0", "keysLen <= 32"}, limit="1")
    static Object matchCached(VirtualFrame frame, Object map, @NeverDefault Object[] keys, @Bind Node inliningTarget, @Cached(value="keys.length") int keysLen, @Cached.Shared @Cached PyObjectRichCompareBool compareNode, @Cached.Shared @Cached PyObjectCallMethodObjArgs callMethod, @Cached.Shared @Cached PRaiseNode raise) {
        Object[] values = MatchKeysNode.getValues(frame, inliningTarget, map, keys, keysLen, compareNode, callMethod, raise);
        return values != null ? PFactory.createTuple(PythonLanguage.get(inliningTarget), values) : PNone.NONE;
    }

    @ExplodeLoop
    private static Object[] getValues(VirtualFrame frame, Node inliningTarget, Object map, Object[] keys, int keysLen, PyObjectRichCompareBool compareNode, PyObjectCallMethodObjArgs callMethod, PRaiseNode raise) {
        CompilerAsserts.partialEvaluationConstant((int)keysLen);
        Object[] values = new Object[keysLen];
        Object dummy = new Object();
        Object[] seen = new Object[keysLen];
        for (int i = 0; i < values.length; ++i) {
            Object key = keys[i];
            MatchKeysNode.checkSeen(frame, inliningTarget, raise, seen, key, compareNode);
            seen[i] = key;
            Object value = callMethod.execute((Frame)frame, inliningTarget, map, SpecialMethodNames.T_GET, key, dummy);
            if (value == dummy) {
                return null;
            }
            values[i] = value;
        }
        return values;
    }

    @ExplodeLoop
    private static void checkSeen(VirtualFrame frame, Node inliningTarget, PRaiseNode raise, Object[] seen, Object key, PyObjectRichCompareBool compareNode) {
        for (int i = 0; i < seen.length; ++i) {
            if (seen[i] == null || !compareNode.executeEq((Frame)frame, inliningTarget, seen[i], key)) continue;
            raise.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.MAPPING_PATTERN_CHECKS_DUPE_KEY_S, key);
        }
    }

    @Specialization(guards={"keys.length > 0"}, replaces={"matchCached"})
    static Object match(VirtualFrame frame, Object map, Object[] keys, @Bind Node inliningTarget, @Cached.Shared @Cached PyObjectRichCompareBool compareNode, @Cached.Shared @Cached PyObjectCallMethodObjArgs callMethod, @Cached.Shared @Cached PRaiseNode raise) {
        if (keys.length == 0) {
            return PFactory.createTuple(PythonLanguage.get(inliningTarget), PythonUtils.EMPTY_OBJECT_ARRAY);
        }
        Object[] values = MatchKeysNode.getValuesLongArray(frame, inliningTarget, map, keys, compareNode, callMethod, raise);
        return values != null ? PFactory.createTuple(PythonLanguage.get(inliningTarget), values) : PNone.NONE;
    }

    private static Object[] getValuesLongArray(VirtualFrame frame, Node inliningTarget, Object map, Object[] keys, PyObjectRichCompareBool compareNode, PyObjectCallMethodObjArgs callMethod, PRaiseNode raise) {
        Object[] values = new Object[keys.length];
        Object dummy = new Object();
        Object[] seen = new Object[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            MatchKeysNode.checkSeenLongArray(frame, inliningTarget, raise, seen, key, compareNode);
            seen[i] = key;
            Object value = callMethod.execute((Frame)frame, inliningTarget, map, SpecialMethodNames.T_GET, key, dummy);
            if (value == dummy) {
                return null;
            }
            values[i] = value;
        }
        return values;
    }

    private static void checkSeenLongArray(VirtualFrame frame, Node inliningTarget, PRaiseNode raise, Object[] seen, Object key, PyObjectRichCompareBool compareNode) {
        for (int i = 0; i < seen.length; ++i) {
            if (seen[i] == null || !compareNode.executeEq((Frame)frame, inliningTarget, seen[i], key)) continue;
            raise.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.MAPPING_PATTERN_CHECKS_DUPE_KEY_S, key);
        }
    }

    @Specialization(guards={"keys.length == 0"})
    static Object matchNoKeys(Object map, Object[] keys, @Bind PythonLanguage language) {
        return PFactory.createTuple(language, PythonUtils.EMPTY_OBJECT_ARRAY);
    }

    @NeverDefault
    public static MatchKeysNode create() {
        return MatchKeysNodeGen.create();
    }
}

