/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline.command;

import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import picocli.CommandLine;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.schemacrawler.exceptions.ConfigurationException;
import schemacrawler.tools.command.text.diagram.options.DiagramOutputFormat;
import schemacrawler.tools.commandline.command.CommandOptions;
import schemacrawler.tools.commandline.command.CommandOutputOptions;
import schemacrawler.tools.commandline.shell.AvailableCommandsCommand;
import schemacrawler.tools.commandline.state.BaseStateHolder;
import schemacrawler.tools.commandline.state.ShellState;
import schemacrawler.tools.commandline.utility.CommandLineUtility;
import schemacrawler.tools.commandline.utility.OutputOptionsConfig;
import schemacrawler.tools.executable.SchemaCrawlerExecutable;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputOptionsBuilder;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.string.ObjectToStringFormat;
import us.fatehi.utility.string.StringFormat;

@CommandLine.Command(name="execute", header={"** Execute a SchemaCrawler command"}, description={""}, headerHeading="", synopsisHeading="Shell Command:%n", customSynopsis={"execute"}, optionListHeading="Options:%n", footer={"", "For additional options, specific to individual SchemaCrawler commands,", "run SchemaCrawler with: `-h commands`", "or from the SchemaCrawler interactive shell: `help commands`"})
public class ExecuteCommand
extends BaseStateHolder
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(AvailableCommandsCommand.class.getName());
    @CommandLine.Mixin
    private CommandOptions commandOptions;
    @CommandLine.Mixin
    private CommandOutputOptions commandOutputOptions;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;

    public ExecuteCommand(ShellState state) {
        super(state);
    }

    @Override
    public void run() {
        try {
            this.saveCommandOptions();
            SchemaCrawlerExecutable executable = this.configureExecutable();
            if (!this.state.isLoaded() && !this.state.isDeferCatalogLoad()) {
                throw new CommandLine.ExecutionException(this.spec.commandLine(), "Database metadata is not loaded");
            }
            if (!this.state.isConnected()) {
                throw new CommandLine.ExecutionException(this.spec.commandLine(), "Not able to make database connection");
            }
            SchemaRetrievalOptions schemaRetrievalOptions = this.state.getSchemaRetrievalOptions();
            DatabaseConnectionSource dataSource = this.state.getDataSource();
            Catalog catalog = this.state.getCatalog();
            executable.setSchemaRetrievalOptions(schemaRetrievalOptions);
            executable.setDataSource(dataSource);
            executable.setCatalog(catalog);
            executable.execute();
        }
        catch (Exception e) {
            throw new CommandLine.ExecutionException(this.spec.commandLine(), "Cannot execute SchemaCrawler command", (Throwable)e);
        }
    }

    private SchemaCrawlerExecutable configureExecutable() {
        OutputOptionsBuilder outputOptionsBuilder = OutputOptionsConfig.fromConfig(null, this.state.getConfig());
        if (this.commandOutputOptions.getOutputFile().isPresent()) {
            outputOptionsBuilder.withOutputFile(this.commandOutputOptions.getOutputFile().get());
        } else {
            outputOptionsBuilder.withConsoleOutput();
        }
        this.commandOutputOptions.getOutputFormatValue().ifPresent(arg_0 -> ((OutputOptionsBuilder)outputOptionsBuilder).withOutputFormatValue(arg_0));
        this.commandOutputOptions.getTitle().ifPresent(arg_0 -> ((OutputOptionsBuilder)outputOptionsBuilder).title(arg_0));
        SchemaCrawlerOptions schemaCrawlerOptions = this.state.getSchemaCrawlerOptions();
        OutputOptions outputOptions = outputOptionsBuilder.toOptions();
        Config additionalConfig = this.state.getConfig();
        if (DiagramOutputFormat.isSupportedFormat((String)outputOptions.getOutputFormatValue()) && this.commandOutputOptions.getOutputFile().isEmpty()) {
            throw new ConfigurationException("Output file has to be specified for schema diagrams");
        }
        String command = this.commandOptions.getCommand();
        LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Setting up SchemaCrawler command <%s>", new Object[]{command}));
        LOGGER.log(Level.CONFIG, (Supplier<String>)new ObjectToStringFormat((Object)outputOptions));
        SchemaCrawlerExecutable executable = new SchemaCrawlerExecutable(command);
        executable.setSchemaCrawlerOptions(schemaCrawlerOptions);
        executable.setOutputOptions(outputOptions);
        executable.setAdditionalConfiguration(additionalConfig);
        return executable;
    }

    private void saveCommandOptions() {
        CommandLine.ParseResult parseResult = this.spec.commandLine().getParseResult();
        Map<String, Object> commandConfig = CommandLineUtility.matchedOptionValues(parseResult);
        LOGGER.log(Level.INFO, "Loaded command config");
        LOGGER.log(Level.CONFIG, (Supplier<String>)new ObjectToStringFormat(commandConfig));
        this.state.setCommandOptions(commandConfig);
    }
}

