/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.host;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.StopIterationException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnknownKeyException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedExactClassProfile;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.host.HostClassCache;
import com.oracle.truffle.host.HostContext;
import com.oracle.truffle.host.HostContextFactory;
import com.oracle.truffle.host.HostExecuteNode;
import com.oracle.truffle.host.HostExecuteNodeGen;
import com.oracle.truffle.host.HostObject;
import com.oracle.truffle.host.HostObjectFactory;
import com.oracle.truffle.host.HostToTypeNode;
import com.oracle.truffle.host.HostToTypeNodeGen;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Objects;

@GeneratedBy(value=HostObject.class)
final class HostObjectGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private HostObjectGen() {
    }

    static {
        LibraryExport.register(HostObject.class, new InteropLibraryExports());
    }

    @GeneratedBy(value=HostObject.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, HostObject.class, false, false, 0);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof HostObject);
            Uncached uncached = new Uncached();
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof HostObject);
            return new Cached();
        }

        @GeneratedBy(value=HostObject.class)
        @DenyReplace
        private static final class Uncached
        extends InteropLibrary
        implements UnadoptableNode {
            protected Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof HostObject) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof HostObject;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                return HostObject.IsMemberReadable.doUncached(arg0Value, arg1Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                return HostObject.IsMemberModifiable.doUncached(arg0Value, arg1Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInternal(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                return HostObject.IsMemberInternal.doUncached(arg0Value, arg1Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                return HostObject.IsMemberInvocable.doUncached(arg0Value, arg1Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.IsArrayElementReadable.doNull(arg0Value, arg1Value);
                }
                if (!arg0Value.isNull() && arg0Value.isArray(arg0Value.getHostClassCache())) {
                    return HostObject.IsArrayElementReadable.doArray(arg0Value, arg1Value, arg0Value.getHostClassCache());
                }
                if (!arg0Value.isNull() && arg0Value.isList(arg0Value.getHostClassCache())) {
                    return HostObject.IsArrayElementReadable.doList(arg0Value, arg1Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached());
                }
                if (!arg0Value.isNull() && arg0Value.isMapEntry(arg0Value.getHostClassCache())) {
                    return HostObject.IsArrayElementReadable.doMapEntry(arg0Value, arg1Value, arg0Value.getHostClassCache());
                }
                if (!(arg0Value.isNull() || arg0Value.isList(arg0Value.getHostClassCache()) || arg0Value.isArray(arg0Value.getHostClassCache()) || arg0Value.isMapEntry(arg0Value.getHostClassCache()))) {
                    return HostObject.IsArrayElementReadable.doNotArrayOrList(arg0Value, arg1Value, arg0Value.getHostClassCache());
                }
                throw Uncached.newUnsupportedSpecializationException2LJ(this, arg0Value, arg1Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.IsArrayElementModifiable.doNull(arg0Value, arg1Value);
                }
                if (!arg0Value.isNull() && arg0Value.isArray(arg0Value.getHostClassCache())) {
                    return HostObject.IsArrayElementModifiable.doArray(arg0Value, arg1Value, arg0Value.getHostClassCache());
                }
                if (!arg0Value.isNull() && arg0Value.isList(arg0Value.getHostClassCache())) {
                    return HostObject.IsArrayElementModifiable.doList(arg0Value, arg1Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached());
                }
                if (!arg0Value.isNull() && arg0Value.isMapEntry(arg0Value.getHostClassCache())) {
                    return HostObject.IsArrayElementModifiable.doMapEntry(arg0Value, arg1Value, arg0Value.getHostClassCache());
                }
                if (!(arg0Value.isNull() || arg0Value.isList(arg0Value.getHostClassCache()) || arg0Value.isArray(arg0Value.getHostClassCache()) || arg0Value.isMapEntry(arg0Value.getHostClassCache()))) {
                    return HostObject.IsArrayElementModifiable.doNotArrayOrList(arg0Value, arg1Value, arg0Value.getHostClassCache());
                }
                throw Uncached.newUnsupportedSpecializationException2LJ(this, arg0Value, arg1Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementInsertable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.IsArrayElementInsertable.doNull(arg0Value, arg1Value);
                }
                if (!arg0Value.isNull()) {
                    return HostObject.IsArrayElementInsertable.doNonNull(arg0Value, arg1Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached());
                }
                throw Uncached.newUnsupportedSpecializationException2LJ(this, arg0Value, arg1Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, InvalidArrayIndexException, UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    HostObject.WriteArrayElement.doNull(arg0Value, arg1Value, arg2Value);
                    return;
                }
                if (!arg0Value.isNull() && arg0Value.isArray(arg0Value.getHostClassCache())) {
                    HostObject.WriteArrayElement.doArray(arg0Value, arg1Value, arg2Value, this, HostToTypeNodeGen.getUncached(), arg0Value.getHostClassCache(), HostObjectFactory.ArraySetNodeGen.getUncached(), InlinedBranchProfile.getUncached());
                    return;
                }
                if (!arg0Value.isNull() && arg0Value.isList(arg0Value.getHostClassCache())) {
                    HostObject.WriteArrayElement.doList(arg0Value, arg1Value, arg2Value, this, arg0Value.getHostClassCache(), HostToTypeNodeGen.getUncached(), InlinedBranchProfile.getUncached());
                    return;
                }
                if (!arg0Value.isNull() && arg0Value.isMapEntry(arg0Value.getHostClassCache())) {
                    HostObject.WriteArrayElement.doMapEntry(arg0Value, arg1Value, arg2Value, this, arg0Value.getHostClassCache(), HostToTypeNodeGen.getUncached(), InlinedBranchProfile.getUncached());
                    return;
                }
                if (!(arg0Value.isNull() || arg0Value.isList(arg0Value.getHostClassCache()) || arg0Value.isArray(arg0Value.getHostClassCache()) || arg0Value.isMapEntry(arg0Value.getHostClassCache()))) {
                    HostObject.WriteArrayElement.doNotArrayOrList(arg0Value, arg1Value, arg2Value, arg0Value.getHostClassCache());
                    return;
                }
                throw Uncached.newUnsupportedSpecializationException3LJL(this, arg0Value, arg1Value, arg2Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementRemovable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.IsArrayElementRemovable.doNull(arg0Value, arg1Value);
                }
                if (!arg0Value.isNull() && arg0Value.isList(arg0Value.getHostClassCache())) {
                    return HostObject.IsArrayElementRemovable.doList(arg0Value, arg1Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached());
                }
                if (!arg0Value.isNull() && !arg0Value.isList(arg0Value.getHostClassCache())) {
                    return HostObject.IsArrayElementRemovable.doOther(arg0Value, arg1Value, arg0Value.getHostClassCache());
                }
                throw Uncached.newUnsupportedSpecializationException2LJ(this, arg0Value, arg1Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void removeArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    HostObject.RemoveArrayElement.doNull(arg0Value, arg1Value);
                    return;
                }
                if (!arg0Value.isNull() && arg0Value.isList(arg0Value.getHostClassCache())) {
                    HostObject.RemoveArrayElement.doList(arg0Value, arg1Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached());
                    return;
                }
                if (!arg0Value.isNull() && !arg0Value.isList(arg0Value.getHostClassCache())) {
                    HostObject.RemoveArrayElement.doOther(arg0Value, arg1Value, arg0Value.getHostClassCache());
                    return;
                }
                throw Uncached.newUnsupportedSpecializationException2LJ(this, arg0Value, arg1Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasArrayElements(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.HasArrayElements.doNull(arg0Value);
                }
                if (!arg0Value.isNull()) {
                    return HostObject.HasArrayElements.doNotNull(arg0Value, arg0Value.getHostClassCache());
                }
                throw Uncached.newUnsupportedSpecializationException1(this, arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.ReadArrayElement.doNull(arg0Value, arg1Value);
                }
                if (!arg0Value.isNull() && arg0Value.isArray(arg0Value.getHostClassCache())) {
                    return HostObject.ReadArrayElement.doArray(arg0Value, arg1Value, this, HostObjectFactory.ArrayGetNodeGen.getUncached(), arg0Value.getHostClassCache(), HostContextFactory.ToGuestValueNodeGen.getUncached(), InlinedBranchProfile.getUncached());
                }
                if (!arg0Value.isNull() && arg0Value.isList(arg0Value.getHostClassCache())) {
                    return HostObject.ReadArrayElement.doList(arg0Value, arg1Value, this, arg0Value.getHostClassCache(), HostContextFactory.ToGuestValueNodeGen.getUncached(), InlinedBranchProfile.getUncached());
                }
                if (!arg0Value.isNull() && arg0Value.isMapEntry(arg0Value.getHostClassCache())) {
                    return HostObject.ReadArrayElement.doMapEntry(arg0Value, arg1Value, this, arg0Value.getHostClassCache(), HostContextFactory.ToGuestValueNodeGen.getUncached(), InlinedBranchProfile.getUncached());
                }
                if (!(arg0Value.isNull() || arg0Value.isArray(arg0Value.getHostClassCache()) || arg0Value.isList(arg0Value.getHostClassCache()) || arg0Value.isMapEntry(arg0Value.getHostClassCache()))) {
                    return HostObject.ReadArrayElement.doNotArrayOrList(arg0Value, arg1Value, arg0Value.getHostClassCache());
                }
                throw Uncached.newUnsupportedSpecializationException2LJ(this, arg0Value, arg1Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.GetArraySize.doNull(arg0Value);
                }
                if (!arg0Value.isNull() && arg0Value.isArray(arg0Value.getHostClassCache())) {
                    return HostObject.GetArraySize.doArray(arg0Value, arg0Value.getHostClassCache());
                }
                if (!arg0Value.isNull() && arg0Value.isList(arg0Value.getHostClassCache())) {
                    return HostObject.GetArraySize.doList(arg0Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached());
                }
                if (!arg0Value.isNull() && arg0Value.isMapEntry(arg0Value.getHostClassCache())) {
                    return HostObject.GetArraySize.doMapEntry(arg0Value, arg0Value.getHostClassCache());
                }
                if (!(arg0Value.isNull() || arg0Value.isArray(arg0Value.getHostClassCache()) || arg0Value.isList(arg0Value.getHostClassCache()) || arg0Value.isMapEntry(arg0Value.getHostClassCache()))) {
                    return HostObject.GetArraySize.doNotArrayOrList(arg0Value, arg0Value.getHostClassCache());
                }
                throw Uncached.newUnsupportedSpecializationException1(this, arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasBufferElements(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.HasBufferElements.doNull(arg0Value);
                }
                if (arg0Value.isByteSequence()) {
                    return HostObject.HasBufferElements.doByteSequence(arg0Value, arg0Value.getHostClassCache());
                }
                if (!arg0Value.isNull() && !arg0Value.isByteSequence()) {
                    return HostObject.HasBufferElements.doOther(arg0Value, arg0Value.getHostClassCache());
                }
                throw Uncached.newUnsupportedSpecializationException1(this, arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isBufferWritable(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.IsBufferWritable.doNull(arg0Value);
                }
                if (arg0Value.isByteSequence()) {
                    return HostObject.IsBufferWritable.doByteSequence(arg0Value);
                }
                if (!arg0Value.isNull() && !arg0Value.isByteSequence()) {
                    return HostObject.IsBufferWritable.doOther(arg0Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached());
                }
                throw Uncached.newUnsupportedSpecializationException1(this, arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getBufferSize(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.GetBufferSize.doNull(arg0Value);
                }
                if (arg0Value.isByteSequence()) {
                    return HostObject.GetBufferSize.doByteSequence(arg0Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached());
                }
                if (!arg0Value.isNull() && !arg0Value.isByteSequence()) {
                    return HostObject.GetBufferSize.doOther(arg0Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached());
                }
                throw Uncached.newUnsupportedSpecializationException1(this, arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public byte readBufferByte(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.ReadBufferByte.doNull(arg0Value, arg1Value);
                }
                if (arg0Value.isByteSequence()) {
                    return HostObject.ReadBufferByte.doByteSequence(arg0Value, arg1Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached());
                }
                if (!arg0Value.isNull() && !arg0Value.isByteSequence()) {
                    return HostObject.ReadBufferByte.doOther(arg0Value, arg1Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached(), InlinedExactClassProfile.getUncached());
                }
                throw Uncached.newUnsupportedSpecializationException2LJ(this, arg0Value, arg1Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeBufferByte(Object arg0Value_, long arg1Value, byte arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    HostObject.WriteBufferByte.doNull(arg0Value, arg1Value, arg2Value);
                    return;
                }
                if (!arg0Value.isNull()) {
                    HostObject.WriteBufferByte.doNonNull(arg0Value, arg1Value, arg2Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached(), InlinedExactClassProfile.getUncached());
                    return;
                }
                throw Uncached.newUnsupportedSpecializationException3LJB(this, arg0Value, arg1Value, arg2Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public short readBufferShort(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.ReadBufferShort.doNull(arg0Value, arg1Value, arg2Value);
                }
                if (arg0Value.isByteSequence()) {
                    return HostObject.ReadBufferShort.doByteSequence(arg0Value, arg1Value, arg2Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached());
                }
                if (!arg0Value.isNull() && !arg0Value.isByteSequence()) {
                    return HostObject.ReadBufferShort.doOther(arg0Value, arg1Value, arg2Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached(), InlinedExactClassProfile.getUncached());
                }
                throw Uncached.newUnsupportedSpecializationException3LLJ(this, arg0Value, arg1Value, arg2Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeBufferShort(Object arg0Value_, ByteOrder arg1Value, long arg2Value, short arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    HostObject.WriteBufferShort.doNull(arg0Value, arg1Value, arg2Value, arg3Value);
                    return;
                }
                if (!arg0Value.isNull()) {
                    HostObject.WriteBufferShort.doNonNull(arg0Value, arg1Value, arg2Value, arg3Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached(), InlinedExactClassProfile.getUncached());
                    return;
                }
                throw Uncached.newUnsupportedSpecializationException4LLJS(this, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int readBufferInt(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.ReadBufferInt.doNull(arg0Value, arg1Value, arg2Value);
                }
                if (arg0Value.isByteSequence()) {
                    return HostObject.ReadBufferInt.doByteSequence(arg0Value, arg1Value, arg2Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached());
                }
                if (!arg0Value.isNull() && !arg0Value.isByteSequence()) {
                    return HostObject.ReadBufferInt.doOther(arg0Value, arg1Value, arg2Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached(), InlinedExactClassProfile.getUncached());
                }
                throw Uncached.newUnsupportedSpecializationException3LLJ(this, arg0Value, arg1Value, arg2Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeBufferInt(Object arg0Value_, ByteOrder arg1Value, long arg2Value, int arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    HostObject.WriteBufferInt.doNull(arg0Value, arg1Value, arg2Value, arg3Value);
                    return;
                }
                if (!arg0Value.isNull()) {
                    HostObject.WriteBufferInt.doNonNull(arg0Value, arg1Value, arg2Value, arg3Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached(), InlinedExactClassProfile.getUncached());
                    return;
                }
                throw Uncached.newUnsupportedSpecializationException4LLJI(this, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long readBufferLong(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.ReadBufferLong.doNull(arg0Value, arg1Value, arg2Value);
                }
                if (arg0Value.isByteSequence()) {
                    return HostObject.ReadBufferLong.doByteSequence(arg0Value, arg1Value, arg2Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached());
                }
                if (!arg0Value.isNull() && !arg0Value.isByteSequence()) {
                    return HostObject.ReadBufferLong.doOther(arg0Value, arg1Value, arg2Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached(), InlinedExactClassProfile.getUncached());
                }
                throw Uncached.newUnsupportedSpecializationException3LLJ(this, arg0Value, arg1Value, arg2Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeBufferLong(Object arg0Value_, ByteOrder arg1Value, long arg2Value, long arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    HostObject.WriteBufferLong.doNull(arg0Value, arg1Value, arg2Value, arg3Value);
                    return;
                }
                if (!arg0Value.isNull()) {
                    HostObject.WriteBufferLong.doNonNull(arg0Value, arg1Value, arg2Value, arg3Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached(), InlinedExactClassProfile.getUncached());
                    return;
                }
                throw Uncached.newUnsupportedSpecializationException4LLJJ(this, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public float readBufferFloat(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.ReadBufferFloat.doNull(arg0Value, arg1Value, arg2Value);
                }
                if (arg0Value.isByteSequence()) {
                    return HostObject.ReadBufferFloat.doByteSequence(arg0Value, arg1Value, arg2Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached());
                }
                if (!arg0Value.isNull() && !arg0Value.isByteSequence()) {
                    return HostObject.ReadBufferFloat.doOther(arg0Value, arg1Value, arg2Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached(), InlinedExactClassProfile.getUncached());
                }
                throw Uncached.newUnsupportedSpecializationException3LLJ(this, arg0Value, arg1Value, arg2Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeBufferFloat(Object arg0Value_, ByteOrder arg1Value, long arg2Value, float arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    HostObject.WriteBufferFloat.doNull(arg0Value, arg1Value, arg2Value, arg3Value);
                    return;
                }
                if (!arg0Value.isNull()) {
                    HostObject.WriteBufferFloat.doNonNull(arg0Value, arg1Value, arg2Value, arg3Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached(), InlinedExactClassProfile.getUncached());
                    return;
                }
                throw Uncached.newUnsupportedSpecializationException4LLJF(this, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public double readBufferDouble(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.ReadBufferDouble.doNull(arg0Value, arg1Value, arg2Value);
                }
                if (arg0Value.isByteSequence()) {
                    return HostObject.ReadBufferDouble.doByteSequence(arg0Value, arg1Value, arg2Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached());
                }
                if (!arg0Value.isNull() && !arg0Value.isByteSequence()) {
                    return HostObject.ReadBufferDouble.doOther(arg0Value, arg1Value, arg2Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached(), InlinedExactClassProfile.getUncached());
                }
                throw Uncached.newUnsupportedSpecializationException3LLJ(this, arg0Value, arg1Value, arg2Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeBufferDouble(Object arg0Value_, ByteOrder arg1Value, long arg2Value, double arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    HostObject.WriteBufferDouble.doNull(arg0Value, arg1Value, arg2Value, arg3Value);
                    return;
                }
                if (!arg0Value.isNull()) {
                    HostObject.WriteBufferDouble.doNonNull(arg0Value, arg1Value, arg2Value, arg3Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached(), InlinedExactClassProfile.getUncached());
                    return;
                }
                throw Uncached.newUnsupportedSpecializationException4LLJD(this, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void readBuffer(Object arg0Value_, long arg1Value, byte[] arg2Value, int arg3Value, int arg4Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    HostObject.ReadBuffer.doNull(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                    return;
                }
                if (arg0Value.isByteSequence()) {
                    HostObject.ReadBuffer.doByteSequence(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached());
                    return;
                }
                if (!arg0Value.isNull() && !arg0Value.isByteSequence()) {
                    HostObject.ReadBuffer.doOther(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached(), InlinedExactClassProfile.getUncached());
                    return;
                }
                throw Uncached.newUnsupportedSpecializationException5LJLII(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isInstantiable(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (!arg0Value.isClass()) {
                    return HostObject.IsInstantiable.doUnsupported(arg0Value);
                }
                if (arg0Value.isArrayClass()) {
                    return HostObject.IsInstantiable.doArrayCached(arg0Value);
                }
                if (arg0Value.isDefaultClass()) {
                    return HostObject.IsInstantiable.doObjectCached(arg0Value, this, HostObjectFactory.LookupConstructorNodeGen.getUncached());
                }
                throw Uncached.newUnsupportedSpecializationException1(this, arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object instantiate(Object arg0Value_, Object ... arg1Value) throws UnsupportedMessageException, UnsupportedTypeException, ArityException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (!arg0Value.isClass()) {
                    return HostObject.Instantiate.doUnsupported(arg0Value, arg1Value);
                }
                if (arg0Value.isArrayClass()) {
                    return HostObject.Instantiate.doArrayCached(arg0Value, arg1Value, this, INTEROP_LIBRARY_.getUncached(), InlinedBranchProfile.getUncached());
                }
                if (arg0Value.isDefaultClass()) {
                    return HostObject.Instantiate.doObjectCached(arg0Value, arg1Value, this, HostObjectFactory.LookupConstructorNodeGen.getUncached(), HostExecuteNodeGen.getUncached(), InlinedBranchProfile.getUncached());
                }
                throw Uncached.newUnsupportedSpecializationException2(this, arg0Value, arg1Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isNumber(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.IsNumber.doNull(arg0Value);
                }
                if (arg0Value.isBigInteger()) {
                    return HostObject.IsNumber.doBigInteger(arg0Value, arg0Value.getHostClassCache());
                }
                if (!arg0Value.isNull() && !arg0Value.isBigInteger()) {
                    return HostObject.IsNumber.doOther(arg0Value, this, InlinedExactClassProfile.getUncached());
                }
                throw Uncached.newUnsupportedSpecializationException1(this, arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean fitsInByte(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.FitsInByte.doNull(arg0Value);
                }
                if (arg0Value.isBigInteger()) {
                    return HostObject.FitsInByte.doBigInteger(arg0Value, arg0Value.getHostClassCache());
                }
                if (!arg0Value.isNull() && !arg0Value.isBigInteger()) {
                    return HostObject.FitsInByte.doOther(arg0Value, this, INTEROP_LIBRARY_.getUncached());
                }
                throw Uncached.newUnsupportedSpecializationException1(this, arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean fitsInShort(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.FitsInShort.doNull(arg0Value);
                }
                if (arg0Value.isBigInteger()) {
                    return HostObject.FitsInShort.doBigInteger(arg0Value, arg0Value.getHostClassCache());
                }
                if (!arg0Value.isNull() && !arg0Value.isBigInteger()) {
                    return HostObject.FitsInShort.doOther(arg0Value, this, INTEROP_LIBRARY_.getUncached());
                }
                throw Uncached.newUnsupportedSpecializationException1(this, arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean fitsInInt(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.FitsInInt.doNull(arg0Value);
                }
                if (arg0Value.isBigInteger()) {
                    return HostObject.FitsInInt.doBigInteger(arg0Value, arg0Value.getHostClassCache());
                }
                if (!arg0Value.isNull() && !arg0Value.isBigInteger()) {
                    return HostObject.FitsInInt.doOther(arg0Value, this, INTEROP_LIBRARY_.getUncached());
                }
                throw Uncached.newUnsupportedSpecializationException1(this, arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean fitsInLong(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.FitsInLong.doNull(arg0Value);
                }
                if (arg0Value.isBigInteger()) {
                    return HostObject.FitsInLong.doBigInteger(arg0Value, arg0Value.getHostClassCache());
                }
                if (!arg0Value.isNull() && !arg0Value.isBigInteger()) {
                    return HostObject.FitsInLong.doOther(arg0Value, this, INTEROP_LIBRARY_.getUncached());
                }
                throw Uncached.newUnsupportedSpecializationException1(this, arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean fitsInBigInteger(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.FitsInBigInteger.doNull(arg0Value);
                }
                if (arg0Value.isBigInteger()) {
                    return HostObject.FitsInBigInteger.doBigInteger(arg0Value, arg0Value.getHostClassCache());
                }
                if (!arg0Value.isNull() && !arg0Value.isBigInteger()) {
                    return HostObject.FitsInBigInteger.doOther(arg0Value, this, INTEROP_LIBRARY_.getUncached());
                }
                throw Uncached.newUnsupportedSpecializationException1(this, arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean fitsInFloat(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.FitsInFloat.doNull(arg0Value);
                }
                if (arg0Value.isBigInteger()) {
                    return HostObject.FitsInFloat.doBigInteger(arg0Value, arg0Value.getHostClassCache());
                }
                if (!arg0Value.isNull() && !arg0Value.isBigInteger()) {
                    return HostObject.FitsInFloat.doOther(arg0Value, this, INTEROP_LIBRARY_.getUncached());
                }
                throw Uncached.newUnsupportedSpecializationException1(this, arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean fitsInDouble(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.FitsInDouble.doNull(arg0Value);
                }
                if (arg0Value.isBigInteger()) {
                    return HostObject.FitsInDouble.doBigInteger(arg0Value, arg0Value.getHostClassCache());
                }
                if (!arg0Value.isNull() && !arg0Value.isBigInteger()) {
                    return HostObject.FitsInDouble.doOther(arg0Value, this, INTEROP_LIBRARY_.getUncached());
                }
                throw Uncached.newUnsupportedSpecializationException1(this, arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public byte asByte(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.AsByte.doNull(arg0Value);
                }
                if (arg0Value.isBigInteger()) {
                    return HostObject.AsByte.doBigInteger(arg0Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached());
                }
                if (!arg0Value.isNull() && !arg0Value.isBigInteger()) {
                    return HostObject.AsByte.doOther(arg0Value, this, this, INTEROP_LIBRARY_.getUncached(), InlinedBranchProfile.getUncached());
                }
                throw Uncached.newUnsupportedSpecializationException1(this, arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public short asShort(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.AsShort.doNull(arg0Value);
                }
                if (arg0Value.isBigInteger()) {
                    return HostObject.AsShort.doBigInteger(arg0Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached());
                }
                if (!arg0Value.isNull() && !arg0Value.isBigInteger()) {
                    return HostObject.AsShort.doOther(arg0Value, this, this, INTEROP_LIBRARY_.getUncached(), InlinedBranchProfile.getUncached());
                }
                throw Uncached.newUnsupportedSpecializationException1(this, arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int asInt(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.AsInt.doNull(arg0Value);
                }
                if (arg0Value.isBigInteger()) {
                    return HostObject.AsInt.doBigInteger(arg0Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached());
                }
                if (!arg0Value.isNull() && !arg0Value.isBigInteger()) {
                    return HostObject.AsInt.doOther(arg0Value, this, this, INTEROP_LIBRARY_.getUncached(), InlinedBranchProfile.getUncached());
                }
                throw Uncached.newUnsupportedSpecializationException1(this, arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long asLong(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.AsLong.doNull(arg0Value);
                }
                if (arg0Value.isBigInteger()) {
                    return HostObject.AsLong.doBigInteger(arg0Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached());
                }
                if (!arg0Value.isNull() && !arg0Value.isBigInteger()) {
                    return HostObject.AsLong.doOther(arg0Value, this, this, INTEROP_LIBRARY_.getUncached(), InlinedBranchProfile.getUncached());
                }
                throw Uncached.newUnsupportedSpecializationException1(this, arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public BigInteger asBigInteger(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.AsBigInteger.doNull(arg0Value);
                }
                if (arg0Value.isBigInteger()) {
                    return HostObject.AsBigInteger.doBigInteger(arg0Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached());
                }
                if (!arg0Value.isNull() && !arg0Value.isBigInteger()) {
                    return HostObject.AsBigInteger.doOther(arg0Value, this, this, INTEROP_LIBRARY_.getUncached(), InlinedBranchProfile.getUncached());
                }
                throw Uncached.newUnsupportedSpecializationException1(this, arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public float asFloat(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.AsFloat.doNull(arg0Value);
                }
                if (arg0Value.isBigInteger()) {
                    return HostObject.AsFloat.doBigInteger(arg0Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached());
                }
                if (!arg0Value.isNull() && !arg0Value.isBigInteger()) {
                    return HostObject.AsFloat.doOther(arg0Value, this, this, INTEROP_LIBRARY_.getUncached(), InlinedBranchProfile.getUncached());
                }
                throw Uncached.newUnsupportedSpecializationException1(this, arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public double asDouble(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.AsDouble.doNull(arg0Value);
                }
                if (arg0Value.isBigInteger()) {
                    return HostObject.AsDouble.doBigInteger(arg0Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached());
                }
                if (!arg0Value.isNull() && !arg0Value.isBigInteger()) {
                    return HostObject.AsDouble.doOther(arg0Value, this, this, INTEROP_LIBRARY_.getUncached(), InlinedBranchProfile.getUncached());
                }
                throw Uncached.newUnsupportedSpecializationException1(this, arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasIterator(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.HasIterator.doNull(arg0Value);
                }
                if (!arg0Value.isNull()) {
                    return HostObject.HasIterator.doNonNull(arg0Value, arg0Value.getHostClassCache());
                }
                throw Uncached.newUnsupportedSpecializationException1(this, arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getIterator(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.GetIterator.doNull(arg0Value);
                }
                if (!arg0Value.isNull() && arg0Value.isArray(arg0Value.getHostClassCache())) {
                    return HostObject.GetIterator.doArray(arg0Value, this, arg0Value.getHostClassCache(), HostContextFactory.ToGuestValueNodeGen.getUncached());
                }
                if (!arg0Value.isNull() && arg0Value.isIterable(arg0Value.getHostClassCache())) {
                    return HostObject.GetIterator.doIterable(arg0Value, this, arg0Value.getHostClassCache(), HostContextFactory.ToGuestValueNodeGen.getUncached(), InlinedBranchProfile.getUncached());
                }
                if (!(arg0Value.isNull() || arg0Value.isArray(arg0Value.getHostClassCache()) || arg0Value.isIterable(arg0Value.getHostClassCache()))) {
                    return HostObject.GetIterator.doNotArrayOrIterable(arg0Value, arg0Value.getHostClassCache());
                }
                throw Uncached.newUnsupportedSpecializationException1(this, arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isIterator(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.IsIterator.doNull(arg0Value);
                }
                if (!arg0Value.isNull()) {
                    return HostObject.IsIterator.doNonNull(arg0Value, arg0Value.getHostClassCache());
                }
                throw Uncached.newUnsupportedSpecializationException1(this, arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasIteratorNextElement(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.HasIteratorNextElement.doNull(arg0Value);
                }
                if (!arg0Value.isNull() && arg0Value.isIteratorLocal(arg0Value.getHostClassCache())) {
                    return HostObject.HasIteratorNextElement.doIterator(arg0Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached());
                }
                if (!arg0Value.isNull() && !arg0Value.isIteratorLocal(arg0Value.getHostClassCache())) {
                    return HostObject.HasIteratorNextElement.doNotIterator(arg0Value, arg0Value.getHostClassCache());
                }
                throw Uncached.newUnsupportedSpecializationException1(this, arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getIteratorNextElement(Object arg0Value_) throws UnsupportedMessageException, StopIterationException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.GetIteratorNextElement.doNull(arg0Value);
                }
                if (!arg0Value.isNull() && arg0Value.isIteratorLocal(arg0Value.getHostClassCache())) {
                    return HostObject.GetIteratorNextElement.doIterator(arg0Value, this, arg0Value.getHostClassCache(), HostContextFactory.ToGuestValueNodeGen.getUncached(), InlinedBranchProfile.getUncached(), InlinedBranchProfile.getUncached());
                }
                if (!arg0Value.isNull() && !arg0Value.isIteratorLocal(arg0Value.getHostClassCache())) {
                    return HostObject.GetIteratorNextElement.doNotIterator(arg0Value, arg0Value.getHostClassCache());
                }
                throw Uncached.newUnsupportedSpecializationException1(this, arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasHashEntries(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.HasHashEntries.doNull(arg0Value);
                }
                if (!arg0Value.isNull()) {
                    return HostObject.HasHashEntries.doNonNull(arg0Value, arg0Value.getHostClassCache());
                }
                throw Uncached.newUnsupportedSpecializationException1(this, arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getHashSize(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.GetHashSize.doNull(arg0Value);
                }
                if (!arg0Value.isNull() && arg0Value.isMap(arg0Value.getHostClassCache())) {
                    return HostObject.GetHashSize.doMap(arg0Value, this, arg0Value.getHostClassCache(), InlinedBranchProfile.getUncached());
                }
                if (!arg0Value.isNull() && !arg0Value.isMap(arg0Value.getHostClassCache())) {
                    return HostObject.GetHashSize.doNotMap(arg0Value, arg0Value.getHostClassCache());
                }
                throw Uncached.newUnsupportedSpecializationException1(this, arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isHashEntryReadable(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.IsHashEntryReadable.doNull(arg0Value, arg1Value);
                }
                if (!arg0Value.isNull()) {
                    return HostObject.IsHashEntryReadable.doNonNull(arg0Value, arg1Value, this, HostObjectFactory.ContainsKeyNodeGen.getUncached(), arg0Value.getHostClassCache());
                }
                throw Uncached.newUnsupportedSpecializationException2(this, arg0Value, arg1Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isHashEntryModifiable(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.IsHashEntryReadable.doNull(arg0Value, arg1Value);
                }
                if (!arg0Value.isNull()) {
                    return HostObject.IsHashEntryReadable.doNonNull(arg0Value, arg1Value, this, HostObjectFactory.ContainsKeyNodeGen.getUncached(), arg0Value.getHostClassCache());
                }
                throw Uncached.newUnsupportedSpecializationException2(this, arg0Value, arg1Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isHashEntryRemovable(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.IsHashEntryReadable.doNull(arg0Value, arg1Value);
                }
                if (!arg0Value.isNull()) {
                    return HostObject.IsHashEntryReadable.doNonNull(arg0Value, arg1Value, this, HostObjectFactory.ContainsKeyNodeGen.getUncached(), arg0Value.getHostClassCache());
                }
                throw Uncached.newUnsupportedSpecializationException2(this, arg0Value, arg1Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readHashValue(Object arg0Value_, Object arg1Value) throws UnsupportedMessageException, UnknownKeyException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.ReadHashValue.doNull(arg0Value, arg1Value);
                }
                if (!arg0Value.isNull() && arg0Value.isMap(arg0Value.getHostClassCache())) {
                    return HostObject.ReadHashValue.doMap(arg0Value, arg1Value, this, arg0Value.getHostClassCache(), HostToTypeNodeGen.getUncached(), HostContextFactory.ToGuestValueNodeGen.getUncached(), InlinedBranchProfile.getUncached());
                }
                if (!arg0Value.isNull() && !arg0Value.isMap(arg0Value.getHostClassCache())) {
                    return HostObject.ReadHashValue.doNotMap(arg0Value, arg1Value, arg0Value.getHostClassCache());
                }
                throw Uncached.newUnsupportedSpecializationException2(this, arg0Value, arg1Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isHashEntryInsertable(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.IsHashEntryInsertable.doNull(arg0Value, arg1Value);
                }
                if (!arg0Value.isNull()) {
                    return HostObject.IsHashEntryInsertable.doNonNull(arg0Value, arg1Value, this, HostObjectFactory.ContainsKeyNodeGen.getUncached(), arg0Value.getHostClassCache());
                }
                throw Uncached.newUnsupportedSpecializationException2(this, arg0Value, arg1Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeHashEntry(Object arg0Value_, Object arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    HostObject.WriteHashEntry.doNull(arg0Value, arg1Value, arg2Value);
                    return;
                }
                if (!arg0Value.isNull() && arg0Value.isMap(arg0Value.getHostClassCache())) {
                    HostObject.WriteHashEntry.doMap(arg0Value, arg1Value, arg2Value, this, arg0Value.getHostClassCache(), HostToTypeNodeGen.getUncached(), InlinedBranchProfile.getUncached());
                    return;
                }
                if (!arg0Value.isNull() && !arg0Value.isMap(arg0Value.getHostClassCache())) {
                    HostObject.WriteHashEntry.doNotMap(arg0Value, arg1Value, arg2Value, arg0Value.getHostClassCache());
                    return;
                }
                throw Uncached.newUnsupportedSpecializationException3(this, arg0Value, arg1Value, arg2Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void removeHashEntry(Object arg0Value_, Object arg1Value) throws UnsupportedMessageException, UnknownKeyException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    HostObject.RemoveHashEntry.doNull(arg0Value, arg1Value);
                    return;
                }
                if (!arg0Value.isNull() && arg0Value.isMap(arg0Value.getHostClassCache())) {
                    HostObject.RemoveHashEntry.doMap(arg0Value, arg1Value, this, arg0Value.getHostClassCache(), HostToTypeNodeGen.getUncached(), InlinedBranchProfile.getUncached());
                    return;
                }
                if (!arg0Value.isNull() && !arg0Value.isMap(arg0Value.getHostClassCache())) {
                    HostObject.RemoveHashEntry.doNotMap(arg0Value, arg1Value, arg0Value.getHostClassCache());
                    return;
                }
                throw Uncached.newUnsupportedSpecializationException2(this, arg0Value, arg1Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getHashEntriesIterator(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg0Value.isNull()) {
                    return HostObject.GetHashEntriesIterator.doNull(arg0Value);
                }
                if (!arg0Value.isNull() && arg0Value.isMap(arg0Value.getHostClassCache())) {
                    return HostObject.GetHashEntriesIterator.doMap(arg0Value, this, arg0Value.getHostClassCache(), HostContextFactory.ToGuestValueNodeGen.getUncached(), InlinedBranchProfile.getUncached());
                }
                if (!arg0Value.isNull() && !arg0Value.isMap(arg0Value.getHostClassCache())) {
                    return HostObject.GetHashEntriesIterator.doNotMap(arg0Value, arg0Value.getHostClassCache());
                }
                throw Uncached.newUnsupportedSpecializationException1(this, arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                if (arg1Value instanceof HostObject) {
                    HostObject arg1Value_ = (HostObject)arg1Value;
                    return HostObject.IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                }
                return HostObject.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject)receiver).hasMembers();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject)receiver).getMembers(includeInternal);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                return arg0Value.readMember(arg1Value, this, HostObjectFactory.LookupFieldNodeGen.getUncached(), HostObjectFactory.ReadFieldNodeGen.getUncached(), HostObjectFactory.LookupMethodNodeGen.getUncached(), HostObjectFactory.LookupInnerClassNodeGen.getUncached(), InlinedBranchProfile.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInsertable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject)receiver).isMemberInsertable(member);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                arg0Value.writeMember(arg1Value, arg2Value, this, HostObjectFactory.LookupFieldNodeGen.getUncached(), HostObjectFactory.WriteFieldNodeGen.getUncached(), InlinedBranchProfile.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                return arg0Value.invokeMember(arg1Value, arg2Value, this, HostObjectFactory.LookupMethodNodeGen.getUncached(), HostExecuteNodeGen.getUncached(), HostObjectFactory.LookupFieldNodeGen.getUncached(), HostObjectFactory.ReadFieldNodeGen.getUncached(), INTEROP_LIBRARY_.getUncached(), InlinedBranchProfile.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isNull(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject)receiver).isNull();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isExecutable(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                return arg0Value.isExecutable(this, HostObjectFactory.LookupFunctionalMethodNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedMessageException, UnsupportedTypeException, ArityException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                return arg0Value.execute(arg1Value, this, HostExecuteNodeGen.getUncached(), HostObjectFactory.LookupFunctionalMethodNodeGen.getUncached(), InlinedBranchProfile.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isString(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                return arg0Value.isString(this, InlinedExactClassProfile.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public String asString(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                return arg0Value.asString(this, this, INTEROP_LIBRARY_.getUncached(), InlinedBranchProfile.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isBoolean(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject)receiver).isBoolean();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean asBoolean(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                return arg0Value.asBoolean(this, InlinedBranchProfile.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isDate(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject)receiver).isDate();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public LocalDate asDate(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject)receiver).asDate();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isTime(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject)receiver).isTime();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public LocalTime asTime(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject)receiver).asTime();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isTimeZone(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject)receiver).isTimeZone();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public ZoneId asTimeZone(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject)receiver).asTimeZone();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Instant asInstant(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject)receiver).asInstant();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isDuration(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject)receiver).isDuration();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Duration asDuration(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject)receiver).asDuration();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isException(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject)receiver).isException();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public ExceptionType getExceptionType(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                return arg0Value.getExceptionType(this, InlinedBranchProfile.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isExceptionIncompleteSource(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                return arg0Value.isExceptionIncompleteSource(this, InlinedBranchProfile.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int getExceptionExitStatus(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                return arg0Value.getExceptionExitStatus(this, InlinedBranchProfile.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasExceptionMessage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject)receiver).hasExceptionMessage();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getExceptionMessage(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                return arg0Value.getExceptionMessage(this, InlinedBranchProfile.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasExceptionCause(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject)receiver).hasExceptionCause();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getExceptionCause(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject)receiver).getExceptionCause();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasExceptionStackTrace(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject)receiver).hasExceptionStackTrace();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getExceptionStackTrace(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject)receiver).getExceptionStackTrace();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public RuntimeException throwException(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                return arg0Value.throwException(this, InlinedBranchProfile.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject)receiver).hasLanguage();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject)receiver).getLanguage();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject)receiver).toDisplayString(allowSideEffects);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject)receiver).hasMetaObject();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject)receiver).getMetaObject();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject)receiver).isMetaObject();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getMetaQualifiedName(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject)receiver).getMetaQualifiedName();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getMetaSimpleName(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject)receiver).getMetaSimpleName();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMetaInstance(Object arg0Value_, Object arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = (HostObject)arg0Value_;
                return arg0Value.isMetaInstance(arg1Value, this, this, InlinedBranchProfile.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasMetaParents(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject)receiver).hasMetaParents();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getMetaParents(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject)receiver).getMetaParents();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return HostObject.identityHashCode((HostObject)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            private static UnsupportedSpecializationException newUnsupportedSpecializationException2LJ(Node thisNode_, Object arg0Value, long arg1Value) {
                return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value);
            }

            @CompilerDirectives.TruffleBoundary
            private static UnsupportedSpecializationException newUnsupportedSpecializationException3LJL(Node thisNode_, Object arg0Value, long arg1Value, Object arg2Value) {
                return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value);
            }

            @CompilerDirectives.TruffleBoundary
            private static UnsupportedSpecializationException newUnsupportedSpecializationException1(Node thisNode_, Object arg0Value) {
                return new UnsupportedSpecializationException(thisNode_, null, arg0Value);
            }

            @CompilerDirectives.TruffleBoundary
            private static UnsupportedSpecializationException newUnsupportedSpecializationException3LJB(Node thisNode_, Object arg0Value, long arg1Value, byte arg2Value) {
                return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value);
            }

            @CompilerDirectives.TruffleBoundary
            private static UnsupportedSpecializationException newUnsupportedSpecializationException3LLJ(Node thisNode_, Object arg0Value, Object arg1Value, long arg2Value) {
                return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value);
            }

            @CompilerDirectives.TruffleBoundary
            private static UnsupportedSpecializationException newUnsupportedSpecializationException4LLJS(Node thisNode_, Object arg0Value, Object arg1Value, long arg2Value, short arg3Value) {
                return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            @CompilerDirectives.TruffleBoundary
            private static UnsupportedSpecializationException newUnsupportedSpecializationException4LLJI(Node thisNode_, Object arg0Value, Object arg1Value, long arg2Value, int arg3Value) {
                return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            @CompilerDirectives.TruffleBoundary
            private static UnsupportedSpecializationException newUnsupportedSpecializationException4LLJJ(Node thisNode_, Object arg0Value, Object arg1Value, long arg2Value, long arg3Value) {
                return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            @CompilerDirectives.TruffleBoundary
            private static UnsupportedSpecializationException newUnsupportedSpecializationException4LLJF(Node thisNode_, Object arg0Value, Object arg1Value, long arg2Value, float arg3Value) {
                return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, Float.valueOf(arg3Value));
            }

            @CompilerDirectives.TruffleBoundary
            private static UnsupportedSpecializationException newUnsupportedSpecializationException4LLJD(Node thisNode_, Object arg0Value, Object arg1Value, long arg2Value, double arg3Value) {
                return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            @CompilerDirectives.TruffleBoundary
            private static UnsupportedSpecializationException newUnsupportedSpecializationException5LJLII(Node thisNode_, Object arg0Value, long arg1Value, Object arg2Value, int arg3Value, int arg4Value) {
                return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            @CompilerDirectives.TruffleBoundary
            private static UnsupportedSpecializationException newUnsupportedSpecializationException2(Node thisNode_, Object arg0Value, Object arg1Value) {
                return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value);
            }

            @CompilerDirectives.TruffleBoundary
            private static UnsupportedSpecializationException newUnsupportedSpecializationException3(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value) {
                return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value);
            }
        }

        @GeneratedBy(value=HostObject.class)
        private static final class Cached
        extends InteropLibrary {
            private static final InlineSupport.StateField STATE_5_UPDATER = InlineSupport.StateField.create(MethodHandles.lookup(), "state_5_");
            private static final InlinedBranchProfile INLINED_ERROR = InlinedBranchProfile.inline(InlineSupport.InlineTarget.create(InlinedBranchProfile.class, STATE_5_UPDATER.subUpdater(15, 1)));
            private static final HostToTypeNode INLINED_TO_HOST = HostToTypeNodeGen.inline(InlineSupport.InlineTarget.create(HostToTypeNode.class, STATE_5_UPDATER.subUpdater(16, 2), InlineSupport.ReferenceField.create(MethodHandles.lookup(), "toHost_field1_", Node.class)));
            private static final HostContext.ToGuestValueNode INLINED_TO_GUEST = HostContextFactory.ToGuestValueNodeGen.inline(InlineSupport.InlineTarget.create(HostContext.ToGuestValueNode.class, STATE_5_UPDATER.subUpdater(27, 3), InlineSupport.ReferenceField.create(MethodHandles.lookup(), "toGuest_field1_", Object.class)));
            private static final InlinedExactClassProfile INLINED_CLASS_PROFILE = InlinedExactClassProfile.inline(InlineSupport.InlineTarget.create(InlinedExactClassProfile.class, STATE_5_UPDATER.subUpdater(30, 2), InlineSupport.ReferenceField.create(MethodHandles.lookup(), "classProfile_field1_", Class.class)));
            private static final InlineSupport.StateField STATE_6_UPDATER = InlineSupport.StateField.create(MethodHandles.lookup(), "state_6_");
            private static final HostObject.LookupConstructorNode INLINED_LOOKUP_CONSTRUCTOR = HostObjectFactory.LookupConstructorNodeGen.inline(InlineSupport.InlineTarget.create(HostObject.LookupConstructorNode.class, STATE_6_UPDATER.subUpdater(9, 2), InlineSupport.ReferenceField.create(MethodHandles.lookup(), "lookupConstructor_field1_", Object.class)));
            private static final InlineSupport.StateField STATE_7_UPDATER = InlineSupport.StateField.create(MethodHandles.lookup(), "state_7_");
            private static final HostExecuteNode INLINED_HOST_EXECUTE = HostExecuteNodeGen.inline(InlineSupport.InlineTarget.create(HostExecuteNode.class, STATE_7_UPDATER.subUpdater(0, 18), InlineSupport.ReferenceField.create(MethodHandles.lookup(), "hostExecute_field1_", Node.class), InlineSupport.ReferenceField.create(MethodHandles.lookup(), "hostExecute_field2_", Object.class), InlineSupport.ReferenceField.create(MethodHandles.lookup(), "hostExecute_field3_", Object.class), InlineSupport.ReferenceField.create(MethodHandles.lookup(), "hostExecute_field4_", Node.class), InlineSupport.ReferenceField.create(MethodHandles.lookup(), "hostExecute_field5_", Node.class), InlineSupport.ReferenceField.create(MethodHandles.lookup(), "hostExecute_field6_", Node.class)));
            private static final HostObject.ContainsKeyNode INLINED_CONTAINS_KEY = HostObjectFactory.ContainsKeyNodeGen.inline(InlineSupport.InlineTarget.create(HostObject.ContainsKeyNode.class, STATE_6_UPDATER.subUpdater(12, 5), InlineSupport.ReferenceField.create(MethodHandles.lookup(), "containsKey_field1_", Node.class)));
            private static final HostObject.LookupFieldNode INLINED_LOOKUP_FIELD = HostObjectFactory.LookupFieldNodeGen.inline(InlineSupport.InlineTarget.create(HostObject.LookupFieldNode.class, STATE_6_UPDATER.subUpdater(17, 2), InlineSupport.ReferenceField.create(MethodHandles.lookup(), "lookupField_field1_", Object.class)));
            private static final HostObject.ReadFieldNode INLINED_READ_FIELD = HostObjectFactory.ReadFieldNodeGen.inline(InlineSupport.InlineTarget.create(HostObject.ReadFieldNode.class, STATE_6_UPDATER.subUpdater(19, 2), InlineSupport.ReferenceField.create(MethodHandles.lookup(), "readField_field1_", Node.class)));
            private static final HostObject.LookupMethodNode INLINED_LOOKUP_METHOD = HostObjectFactory.LookupMethodNodeGen.inline(InlineSupport.InlineTarget.create(HostObject.LookupMethodNode.class, STATE_6_UPDATER.subUpdater(21, 2), InlineSupport.ReferenceField.create(MethodHandles.lookup(), "lookupMethod_field1_", Object.class)));
            private static final HostObject.LookupFunctionalMethodNode INLINED_LOOKUP_FUNCTIONAL_METHOD = HostObjectFactory.LookupFunctionalMethodNodeGen.inline(InlineSupport.InlineTarget.create(HostObject.LookupFunctionalMethodNode.class, STATE_6_UPDATER.subUpdater(23, 2), InlineSupport.ReferenceField.create(MethodHandles.lookup(), "lookupFunctionalMethod_field1_", Object.class)));
            private static final InlineSupport.StateField STATE_5_WriteArrayElement_UPDATER = InlineSupport.StateField.create(MethodHandles.lookup(), "state_5_");
            private static final HostObject.ArraySet INLINED_WRITE_ARRAY_ELEMENT_ARRAY_ARRAY_SET_ = HostObjectFactory.ArraySetNodeGen.inline(InlineSupport.InlineTarget.create(HostObject.ArraySet.class, STATE_5_WriteArrayElement_UPDATER.subUpdater(18, 9)));
            private static final InlineSupport.StateField STATE_6_ReadArrayElement_UPDATER = InlineSupport.StateField.create(MethodHandles.lookup(), "state_6_");
            private static final HostObject.ArrayGet INLINED_READ_ARRAY_ELEMENT_ARRAY_ARRAY_GET_ = HostObjectFactory.ArrayGetNodeGen.inline(InlineSupport.InlineTarget.create(HostObject.ArrayGet.class, STATE_6_ReadArrayElement_UPDATER.subUpdater(0, 9)));
            private static final InlineSupport.StateField STATE_6_GetIteratorNextElement_UPDATER = InlineSupport.StateField.create(MethodHandles.lookup(), "state_6_");
            private static final InlinedBranchProfile INLINED_GET_ITERATOR_NEXT_ELEMENT_ITERATOR_STOP_ITERATION_ = InlinedBranchProfile.inline(InlineSupport.InlineTarget.create(InlinedBranchProfile.class, STATE_6_GetIteratorNextElement_UPDATER.subUpdater(11, 1)));
            private static final InlineSupport.StateField STATE_6_ReadMemberNode__UPDATER = InlineSupport.StateField.create(MethodHandles.lookup(), "state_6_");
            private static final HostObject.LookupFieldNode INLINED_READ_MEMBER_LOOKUP_FIELD = HostObjectFactory.LookupFieldNodeGen.inline(InlineSupport.InlineTarget.create(HostObject.LookupFieldNode.class, STATE_6_ReadMemberNode__UPDATER.subUpdater(17, 2), InlineSupport.ReferenceField.create(MethodHandles.lookup(), "lookupField_field1_", Object.class)));
            private static final HostObject.ReadFieldNode INLINED_READ_MEMBER_READ_FIELD = HostObjectFactory.ReadFieldNodeGen.inline(InlineSupport.InlineTarget.create(HostObject.ReadFieldNode.class, STATE_6_ReadMemberNode__UPDATER.subUpdater(19, 2), InlineSupport.ReferenceField.create(MethodHandles.lookup(), "readField_field1_", Node.class)));
            private static final HostObject.LookupMethodNode INLINED_READ_MEMBER_LOOKUP_METHOD = HostObjectFactory.LookupMethodNodeGen.inline(InlineSupport.InlineTarget.create(HostObject.LookupMethodNode.class, STATE_6_ReadMemberNode__UPDATER.subUpdater(21, 2), InlineSupport.ReferenceField.create(MethodHandles.lookup(), "lookupMethod_field1_", Object.class)));
            private static final InlineSupport.StateField READ_MEMBER_READ_MEMBER_NODE__READ_MEMBER_STATE_0_UPDATER = InlineSupport.StateField.create(ReadMemberNode_ReadMemberData.lookup_(), "readMember_state_0_");
            private static final HostObject.LookupInnerClassNode INLINED_READ_MEMBER_NODE__READ_MEMBER_LOOKUP_INNER_CLASS_ = HostObjectFactory.LookupInnerClassNodeGen.inline(InlineSupport.InlineTarget.create(HostObject.LookupInnerClassNode.class, READ_MEMBER_READ_MEMBER_NODE__READ_MEMBER_STATE_0_UPDATER.subUpdater(0, 2), InlineSupport.ReferenceField.create(ReadMemberNode_ReadMemberData.lookup_(), "readMemberNode__readMember_lookupInnerClass__field1_", Object.class)));
            private static final InlineSupport.StateField STATE_5_ReadMemberNode__UPDATER = InlineSupport.StateField.create(MethodHandles.lookup(), "state_5_");
            private static final InlinedBranchProfile INLINED_READ_MEMBER_ERROR = InlinedBranchProfile.inline(InlineSupport.InlineTarget.create(InlinedBranchProfile.class, STATE_5_ReadMemberNode__UPDATER.subUpdater(15, 1)));
            private static final InlineSupport.StateField STATE_6_WriteMemberNode__UPDATER = InlineSupport.StateField.create(MethodHandles.lookup(), "state_6_");
            private static final HostObject.LookupFieldNode INLINED_WRITE_MEMBER_LOOKUP_FIELD = HostObjectFactory.LookupFieldNodeGen.inline(InlineSupport.InlineTarget.create(HostObject.LookupFieldNode.class, STATE_6_WriteMemberNode__UPDATER.subUpdater(17, 2), InlineSupport.ReferenceField.create(MethodHandles.lookup(), "lookupField_field1_", Object.class)));
            private static final InlineSupport.StateField WRITE_MEMBER_WRITE_MEMBER_NODE__WRITE_MEMBER_STATE_0_UPDATER = InlineSupport.StateField.create(WriteMemberNode_WriteMemberData.lookup_(), "writeMember_state_0_");
            private static final HostObject.WriteFieldNode INLINED_WRITE_MEMBER_NODE__WRITE_MEMBER_WRITE_FIELD_ = HostObjectFactory.WriteFieldNodeGen.inline(InlineSupport.InlineTarget.create(HostObject.WriteFieldNode.class, WRITE_MEMBER_WRITE_MEMBER_NODE__WRITE_MEMBER_STATE_0_UPDATER.subUpdater(0, 2), InlineSupport.ReferenceField.create(WriteMemberNode_WriteMemberData.lookup_(), "writeMemberNode__writeMember_writeField__field1_", Node.class)));
            private static final InlineSupport.StateField STATE_5_WriteMemberNode__UPDATER = InlineSupport.StateField.create(MethodHandles.lookup(), "state_5_");
            private static final InlinedBranchProfile INLINED_WRITE_MEMBER_ERROR = InlinedBranchProfile.inline(InlineSupport.InlineTarget.create(InlinedBranchProfile.class, STATE_5_WriteMemberNode__UPDATER.subUpdater(15, 1)));
            static final InlineSupport.ReferenceField<IsMemberReadableCachedData> IS_MEMBER_READABLE_CACHED_CACHE_UPDATER = InlineSupport.ReferenceField.create(MethodHandles.lookup(), "isMemberReadable_cached_cache", IsMemberReadableCachedData.class);
            static final InlineSupport.ReferenceField<IsMemberModifiableCachedData> IS_MEMBER_MODIFIABLE_CACHED_CACHE_UPDATER = InlineSupport.ReferenceField.create(MethodHandles.lookup(), "isMemberModifiable_cached_cache", IsMemberModifiableCachedData.class);
            static final InlineSupport.ReferenceField<IsMemberInternalCachedData> IS_MEMBER_INTERNAL_CACHED_CACHE_UPDATER = InlineSupport.ReferenceField.create(MethodHandles.lookup(), "isMemberInternal_cached_cache", IsMemberInternalCachedData.class);
            static final InlineSupport.ReferenceField<IsMemberInvocableCachedData> IS_MEMBER_INVOCABLE_CACHED_CACHE_UPDATER = InlineSupport.ReferenceField.create(MethodHandles.lookup(), "isMemberInvocable_cached_cache", IsMemberInvocableCachedData.class);
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @CompilerDirectives.CompilationFinal
            private int state_1_;
            @CompilerDirectives.CompilationFinal
            private int state_2_;
            @CompilerDirectives.CompilationFinal
            private int state_3_;
            @CompilerDirectives.CompilationFinal
            private int state_4_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_5_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_6_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_7_;
            @CompilerDirectives.CompilationFinal
            private HostClassCache hostClassCache;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node toHost_field1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object toGuest_field1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Class<?> classProfile_field1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object lookupConstructor_field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node hostExecute_field1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object hostExecute_field2_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object hostExecute_field3_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node hostExecute_field4_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node hostExecute_field5_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node hostExecute_field6_;
            @Node.Child
            private InteropLibrary numbers;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node containsKey_field1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object lookupField_field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node readField_field1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object lookupMethod_field1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object lookupFunctionalMethod_field1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private IsMemberReadableCachedData isMemberReadable_cached_cache;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private IsMemberModifiableCachedData isMemberModifiable_cached_cache;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private IsMemberInternalCachedData isMemberInternal_cached_cache;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private IsMemberInvocableCachedData isMemberInvocable_cached_cache;
            @Node.Child
            private InteropLibrary instantiate_arrayCached_indexes_;
            @Node.Child
            private ReadMemberNode_ReadMemberData readMemberNode__readMember_cache;
            @Node.Child
            private WriteMemberNode_WriteMemberData writeMemberNode__writeMember_cache;
            @Node.Child
            private InteropLibrary invokeMemberNode__invokeMember_fieldValues_;

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof HostObject) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof HostObject;
            }

            @Override
            @ExplodeLoop
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0 && arg0Value.isStaticClass()) {
                        IsMemberReadableCachedData s0_ = this.isMemberReadable_cached_cache;
                        while (s0_ != null) {
                            if (arg0Value.isStaticClass() == s0_.cachedStatic_ && arg0Value.getLookupClass() == s0_.cachedClazz_ && s0_.cachedName_.equals(arg1Value)) {
                                return HostObject.IsMemberReadable.doCached(arg0Value, arg1Value, s0_.cachedStatic_, s0_.cachedClazz_, s0_.cachedName_, s0_.cachedReadable_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 2) != 0) {
                        return HostObject.IsMemberReadable.doUncached(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberReadableAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberReadableAndSpecialize(HostObject arg0Value, String arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 2) == 0 && arg0Value.isStaticClass()) {
                    IsMemberReadableCachedData s0_;
                    block4: {
                        IsMemberReadableCachedData s0_original;
                        do {
                            int count0_ = 0;
                            s0_original = s0_ = IS_MEMBER_READABLE_CACHED_CACHE_UPDATER.getVolatile(this);
                            while (!(s0_ == null || arg0Value.isStaticClass() == s0_.cachedStatic_ && arg0Value.getLookupClass() == s0_.cachedClazz_ && s0_.cachedName_.equals(arg1Value))) {
                                ++count0_;
                                s0_ = s0_.next_;
                            }
                            if (s0_ != null) break block4;
                            boolean cachedStatic__ = arg0Value.isStaticClass();
                            if (arg0Value.isStaticClass() != cachedStatic__) break block4;
                            Class<?> cachedClazz__ = arg0Value.getLookupClass();
                            if (arg0Value.getLookupClass() != cachedClazz__ || count0_ >= 5) break block4;
                            s0_ = new IsMemberReadableCachedData(s0_original);
                            s0_.cachedStatic_ = cachedStatic__;
                            s0_.cachedClazz_ = cachedClazz__;
                            s0_.cachedName_ = arg1Value;
                            s0_.cachedReadable_ = HostObject.IsMemberReadable.doUncached(arg0Value, arg1Value);
                        } while (!IS_MEMBER_READABLE_CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_));
                        this.state_0_ = state_0 |= 1;
                    }
                    if (s0_ != null) {
                        return HostObject.IsMemberReadable.doCached(arg0Value, arg1Value, s0_.cachedStatic_, s0_.cachedClazz_, s0_.cachedName_, s0_.cachedReadable_);
                    }
                }
                this.isMemberReadable_cached_cache = null;
                state_0 &= 0xFFFFFFFE;
                this.state_0_ = state_0 |= 2;
                return HostObject.IsMemberReadable.doUncached(arg0Value, arg1Value);
            }

            @Override
            @ExplodeLoop
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0xC) != 0) {
                    if ((state_0 & 4) != 0 && arg0Value.isStaticClass()) {
                        IsMemberModifiableCachedData s0_ = this.isMemberModifiable_cached_cache;
                        while (s0_ != null) {
                            if (arg0Value.isStaticClass() == s0_.cachedStatic_ && arg0Value.getLookupClass() == s0_.cachedClazz_ && s0_.cachedName_.equals(arg1Value)) {
                                return HostObject.IsMemberModifiable.doCached(arg0Value, arg1Value, s0_.cachedStatic_, s0_.cachedClazz_, s0_.cachedName_, s0_.cachedModifiable_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 8) != 0) {
                        return HostObject.IsMemberModifiable.doUncached(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberModifiableAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberModifiableAndSpecialize(HostObject arg0Value, String arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 8) == 0 && arg0Value.isStaticClass()) {
                    IsMemberModifiableCachedData s0_;
                    block4: {
                        IsMemberModifiableCachedData s0_original;
                        do {
                            int count0_ = 0;
                            s0_original = s0_ = IS_MEMBER_MODIFIABLE_CACHED_CACHE_UPDATER.getVolatile(this);
                            while (!(s0_ == null || arg0Value.isStaticClass() == s0_.cachedStatic_ && arg0Value.getLookupClass() == s0_.cachedClazz_ && s0_.cachedName_.equals(arg1Value))) {
                                ++count0_;
                                s0_ = s0_.next_;
                            }
                            if (s0_ != null) break block4;
                            boolean cachedStatic__ = arg0Value.isStaticClass();
                            if (arg0Value.isStaticClass() != cachedStatic__) break block4;
                            Class<?> cachedClazz__ = arg0Value.getLookupClass();
                            if (arg0Value.getLookupClass() != cachedClazz__ || count0_ >= 5) break block4;
                            s0_ = new IsMemberModifiableCachedData(s0_original);
                            s0_.cachedStatic_ = cachedStatic__;
                            s0_.cachedClazz_ = cachedClazz__;
                            s0_.cachedName_ = arg1Value;
                            s0_.cachedModifiable_ = HostObject.IsMemberModifiable.doUncached(arg0Value, arg1Value);
                        } while (!IS_MEMBER_MODIFIABLE_CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_));
                        this.state_0_ = state_0 |= 4;
                    }
                    if (s0_ != null) {
                        return HostObject.IsMemberModifiable.doCached(arg0Value, arg1Value, s0_.cachedStatic_, s0_.cachedClazz_, s0_.cachedName_, s0_.cachedModifiable_);
                    }
                }
                this.isMemberModifiable_cached_cache = null;
                state_0 &= 0xFFFFFFFB;
                this.state_0_ = state_0 |= 8;
                return HostObject.IsMemberModifiable.doUncached(arg0Value, arg1Value);
            }

            @Override
            @ExplodeLoop
            public boolean isMemberInternal(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x30) != 0) {
                    if ((state_0 & 0x10) != 0 && arg0Value.isStaticClass()) {
                        IsMemberInternalCachedData s0_ = this.isMemberInternal_cached_cache;
                        while (s0_ != null) {
                            if (arg0Value.isStaticClass() == s0_.cachedStatic_ && arg0Value.getLookupClass() == s0_.cachedClazz_ && s0_.cachedName_.equals(arg1Value)) {
                                return HostObject.IsMemberInternal.doCached(arg0Value, arg1Value, s0_.cachedStatic_, s0_.cachedClazz_, s0_.cachedName_, s0_.cachedInternal_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0x20) != 0) {
                        return HostObject.IsMemberInternal.doUncached(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberInternalAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberInternalAndSpecialize(HostObject arg0Value, String arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x20) == 0 && arg0Value.isStaticClass()) {
                    IsMemberInternalCachedData s0_;
                    block4: {
                        IsMemberInternalCachedData s0_original;
                        do {
                            int count0_ = 0;
                            s0_original = s0_ = IS_MEMBER_INTERNAL_CACHED_CACHE_UPDATER.getVolatile(this);
                            while (!(s0_ == null || arg0Value.isStaticClass() == s0_.cachedStatic_ && arg0Value.getLookupClass() == s0_.cachedClazz_ && s0_.cachedName_.equals(arg1Value))) {
                                ++count0_;
                                s0_ = s0_.next_;
                            }
                            if (s0_ != null) break block4;
                            boolean cachedStatic__ = arg0Value.isStaticClass();
                            if (arg0Value.isStaticClass() != cachedStatic__) break block4;
                            Class<?> cachedClazz__ = arg0Value.getLookupClass();
                            if (arg0Value.getLookupClass() != cachedClazz__ || count0_ >= 5) break block4;
                            s0_ = new IsMemberInternalCachedData(s0_original);
                            s0_.cachedStatic_ = cachedStatic__;
                            s0_.cachedClazz_ = cachedClazz__;
                            s0_.cachedName_ = arg1Value;
                            s0_.cachedInternal_ = HostObject.IsMemberInternal.doUncached(arg0Value, arg1Value);
                        } while (!IS_MEMBER_INTERNAL_CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_));
                        this.state_0_ = state_0 |= 0x10;
                    }
                    if (s0_ != null) {
                        return HostObject.IsMemberInternal.doCached(arg0Value, arg1Value, s0_.cachedStatic_, s0_.cachedClazz_, s0_.cachedName_, s0_.cachedInternal_);
                    }
                }
                this.isMemberInternal_cached_cache = null;
                state_0 &= 0xFFFFFFEF;
                this.state_0_ = state_0 |= 0x20;
                return HostObject.IsMemberInternal.doUncached(arg0Value, arg1Value);
            }

            @Override
            @ExplodeLoop
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0xC0) != 0) {
                    if ((state_0 & 0x40) != 0 && arg0Value.isStaticClass()) {
                        IsMemberInvocableCachedData s0_ = this.isMemberInvocable_cached_cache;
                        while (s0_ != null) {
                            if (arg0Value.isStaticClass() == s0_.cachedStatic_ && arg0Value.getLookupClass() == s0_.cachedClazz_ && s0_.cachedName_.equals(arg1Value)) {
                                return HostObject.IsMemberInvocable.doCached(arg0Value, arg1Value, s0_.cachedStatic_, s0_.cachedClazz_, s0_.cachedName_, s0_.cachedInvokable_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0x80) != 0) {
                        return HostObject.IsMemberInvocable.doUncached(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberInvocableAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberInvocableAndSpecialize(HostObject arg0Value, String arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x80) == 0 && arg0Value.isStaticClass()) {
                    IsMemberInvocableCachedData s0_;
                    block4: {
                        IsMemberInvocableCachedData s0_original;
                        do {
                            int count0_ = 0;
                            s0_original = s0_ = IS_MEMBER_INVOCABLE_CACHED_CACHE_UPDATER.getVolatile(this);
                            while (!(s0_ == null || arg0Value.isStaticClass() == s0_.cachedStatic_ && arg0Value.getLookupClass() == s0_.cachedClazz_ && s0_.cachedName_.equals(arg1Value))) {
                                ++count0_;
                                s0_ = s0_.next_;
                            }
                            if (s0_ != null) break block4;
                            boolean cachedStatic__ = arg0Value.isStaticClass();
                            if (arg0Value.isStaticClass() != cachedStatic__) break block4;
                            Class<?> cachedClazz__ = arg0Value.getLookupClass();
                            if (arg0Value.getLookupClass() != cachedClazz__ || count0_ >= 5) break block4;
                            s0_ = new IsMemberInvocableCachedData(s0_original);
                            s0_.cachedStatic_ = cachedStatic__;
                            s0_.cachedClazz_ = cachedClazz__;
                            s0_.cachedName_ = arg1Value;
                            s0_.cachedInvokable_ = HostObject.IsMemberInvocable.doUncached(arg0Value, arg1Value);
                        } while (!IS_MEMBER_INVOCABLE_CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_));
                        this.state_0_ = state_0 |= 0x40;
                    }
                    if (s0_ != null) {
                        return HostObject.IsMemberInvocable.doCached(arg0Value, arg1Value, s0_.cachedStatic_, s0_.cachedClazz_, s0_.cachedName_, s0_.cachedInvokable_);
                    }
                }
                this.isMemberInvocable_cached_cache = null;
                state_0 &= 0xFFFFFFBF;
                this.state_0_ = state_0 |= 0x80;
                return HostObject.IsMemberInvocable.doUncached(arg0Value, arg1Value);
            }

            @Override
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x1F00) != 0) {
                    HostClassCache hostClassCache_3;
                    HostClassCache hostClassCache_2;
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_;
                    if ((state_0 & 0x100) != 0 && arg0Value.isNull()) {
                        return HostObject.IsArrayElementReadable.doNull(arg0Value, arg1Value);
                    }
                    if ((state_0 & 0x200) != 0 && (hostClassCache_ = this.hostClassCache) != null && !arg0Value.isNull() && arg0Value.isArray(hostClassCache_)) {
                        return HostObject.IsArrayElementReadable.doArray(arg0Value, arg1Value, hostClassCache_);
                    }
                    if ((state_0 & 0x400) != 0 && (hostClassCache_1 = this.hostClassCache) != null && !arg0Value.isNull() && arg0Value.isList(hostClassCache_1)) {
                        Cached node__ = this;
                        return HostObject.IsArrayElementReadable.doList(arg0Value, arg1Value, node__, hostClassCache_1, INLINED_ERROR);
                    }
                    if ((state_0 & 0x800) != 0 && (hostClassCache_2 = this.hostClassCache) != null && !arg0Value.isNull() && arg0Value.isMapEntry(hostClassCache_2)) {
                        return HostObject.IsArrayElementReadable.doMapEntry(arg0Value, arg1Value, hostClassCache_2);
                    }
                    if (!((state_0 & 0x1000) == 0 || (hostClassCache_3 = this.hostClassCache) == null || arg0Value.isNull() || arg0Value.isList(hostClassCache_3) || arg0Value.isArray(hostClassCache_3) || arg0Value.isMapEntry(hostClassCache_3))) {
                        return HostObject.IsArrayElementReadable.doNotArrayOrList(arg0Value, arg1Value, hostClassCache_3);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementReadableAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isArrayElementReadableAndSpecialize(HostObject arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                if (arg0Value.isNull()) {
                    this.state_0_ = state_0 |= 0x100;
                    return HostObject.IsArrayElementReadable.doNull(arg0Value, arg1Value);
                }
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (arg0Value.isArray(hostClassCache_)) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        this.state_0_ = state_0 |= 0x200;
                        return HostObject.IsArrayElementReadable.doArray(arg0Value, arg1Value, hostClassCache_);
                    }
                }
                Cached node__ = null;
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = arg0Value.getHostClassCache();
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (arg0Value.isList(hostClassCache_1)) {
                        node__ = this;
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_1;
                        }
                        this.state_0_ = state_0 |= 0x400;
                        return HostObject.IsArrayElementReadable.doList(arg0Value, arg1Value, node__, hostClassCache_1, INLINED_ERROR);
                    }
                }
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_2;
                    HostClassCache hostClassCache_2_shared = this.hostClassCache;
                    if (hostClassCache_2_shared != null) {
                        hostClassCache_2 = hostClassCache_2_shared;
                    } else {
                        hostClassCache_2 = arg0Value.getHostClassCache();
                        if (hostClassCache_2 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (arg0Value.isMapEntry(hostClassCache_2)) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_2;
                        }
                        this.state_0_ = state_0 |= 0x800;
                        return HostObject.IsArrayElementReadable.doMapEntry(arg0Value, arg1Value, hostClassCache_2);
                    }
                }
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_3;
                    HostClassCache hostClassCache_3_shared = this.hostClassCache;
                    if (hostClassCache_3_shared != null) {
                        hostClassCache_3 = hostClassCache_3_shared;
                    } else {
                        hostClassCache_3 = arg0Value.getHostClassCache();
                        if (hostClassCache_3 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (!(arg0Value.isList(hostClassCache_3) || arg0Value.isArray(hostClassCache_3) || arg0Value.isMapEntry(hostClassCache_3))) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_3;
                        }
                        this.state_0_ = state_0 |= 0x1000;
                        return HostObject.IsArrayElementReadable.doNotArrayOrList(arg0Value, arg1Value, hostClassCache_3);
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
            }

            @Override
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x3E000) != 0) {
                    HostClassCache hostClassCache_3;
                    HostClassCache hostClassCache_2;
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_;
                    if ((state_0 & 0x2000) != 0 && arg0Value.isNull()) {
                        return HostObject.IsArrayElementModifiable.doNull(arg0Value, arg1Value);
                    }
                    if ((state_0 & 0x4000) != 0 && (hostClassCache_ = this.hostClassCache) != null && !arg0Value.isNull() && arg0Value.isArray(hostClassCache_)) {
                        return HostObject.IsArrayElementModifiable.doArray(arg0Value, arg1Value, hostClassCache_);
                    }
                    if ((state_0 & 0x8000) != 0 && (hostClassCache_1 = this.hostClassCache) != null && !arg0Value.isNull() && arg0Value.isList(hostClassCache_1)) {
                        Cached node__ = this;
                        return HostObject.IsArrayElementModifiable.doList(arg0Value, arg1Value, node__, hostClassCache_1, INLINED_ERROR);
                    }
                    if ((state_0 & 0x10000) != 0 && (hostClassCache_2 = this.hostClassCache) != null && !arg0Value.isNull() && arg0Value.isMapEntry(hostClassCache_2)) {
                        return HostObject.IsArrayElementModifiable.doMapEntry(arg0Value, arg1Value, hostClassCache_2);
                    }
                    if (!((state_0 & 0x20000) == 0 || (hostClassCache_3 = this.hostClassCache) == null || arg0Value.isNull() || arg0Value.isList(hostClassCache_3) || arg0Value.isArray(hostClassCache_3) || arg0Value.isMapEntry(hostClassCache_3))) {
                        return HostObject.IsArrayElementModifiable.doNotArrayOrList(arg0Value, arg1Value, hostClassCache_3);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementModifiableAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isArrayElementModifiableAndSpecialize(HostObject arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                if (arg0Value.isNull()) {
                    this.state_0_ = state_0 |= 0x2000;
                    return HostObject.IsArrayElementModifiable.doNull(arg0Value, arg1Value);
                }
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (arg0Value.isArray(hostClassCache_)) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        this.state_0_ = state_0 |= 0x4000;
                        return HostObject.IsArrayElementModifiable.doArray(arg0Value, arg1Value, hostClassCache_);
                    }
                }
                Cached node__ = null;
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = arg0Value.getHostClassCache();
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (arg0Value.isList(hostClassCache_1)) {
                        node__ = this;
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_1;
                        }
                        this.state_0_ = state_0 |= 0x8000;
                        return HostObject.IsArrayElementModifiable.doList(arg0Value, arg1Value, node__, hostClassCache_1, INLINED_ERROR);
                    }
                }
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_2;
                    HostClassCache hostClassCache_2_shared = this.hostClassCache;
                    if (hostClassCache_2_shared != null) {
                        hostClassCache_2 = hostClassCache_2_shared;
                    } else {
                        hostClassCache_2 = arg0Value.getHostClassCache();
                        if (hostClassCache_2 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (arg0Value.isMapEntry(hostClassCache_2)) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_2;
                        }
                        this.state_0_ = state_0 |= 0x10000;
                        return HostObject.IsArrayElementModifiable.doMapEntry(arg0Value, arg1Value, hostClassCache_2);
                    }
                }
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_3;
                    HostClassCache hostClassCache_3_shared = this.hostClassCache;
                    if (hostClassCache_3_shared != null) {
                        hostClassCache_3 = hostClassCache_3_shared;
                    } else {
                        hostClassCache_3 = arg0Value.getHostClassCache();
                        if (hostClassCache_3 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (!(arg0Value.isList(hostClassCache_3) || arg0Value.isArray(hostClassCache_3) || arg0Value.isMapEntry(hostClassCache_3))) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_3;
                        }
                        this.state_0_ = state_0 |= 0x20000;
                        return HostObject.IsArrayElementModifiable.doNotArrayOrList(arg0Value, arg1Value, hostClassCache_3);
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
            }

            @Override
            public boolean isArrayElementInsertable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0xC0000) != 0) {
                    HostClassCache hostClassCache_;
                    if ((state_0 & 0x40000) != 0 && arg0Value.isNull()) {
                        return HostObject.IsArrayElementInsertable.doNull(arg0Value, arg1Value);
                    }
                    if ((state_0 & 0x80000) != 0 && (hostClassCache_ = this.hostClassCache) != null && !arg0Value.isNull()) {
                        Cached node__ = this;
                        return HostObject.IsArrayElementInsertable.doNonNull(arg0Value, arg1Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementInsertableAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isArrayElementInsertableAndSpecialize(HostObject arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                if (arg0Value.isNull()) {
                    this.state_0_ = state_0 |= 0x40000;
                    return HostObject.IsArrayElementInsertable.doNull(arg0Value, arg1Value);
                }
                Cached node__ = null;
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_;
                    node__ = this;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_0_ = state_0 |= 0x80000;
                    return HostObject.IsArrayElementInsertable.doNonNull(arg0Value, arg1Value, node__, hostClassCache_, INLINED_ERROR);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
            }

            @Override
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x1F00000) != 0) {
                    HostClassCache hostClassCache_3;
                    HostClassCache hostClassCache_2;
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_;
                    if ((state_0 & 0x100000) != 0 && arg0Value.isNull()) {
                        HostObject.WriteArrayElement.doNull(arg0Value, arg1Value, arg2Value);
                        return;
                    }
                    if ((state_0 & 0x200000) != 0 && (hostClassCache_ = this.hostClassCache) != null && !arg0Value.isNull() && arg0Value.isArray(hostClassCache_)) {
                        Cached node__ = this;
                        HostObject.WriteArrayElement.doArray(arg0Value, arg1Value, arg2Value, node__, INLINED_TO_HOST, hostClassCache_, INLINED_WRITE_ARRAY_ELEMENT_ARRAY_ARRAY_SET_, INLINED_ERROR);
                        return;
                    }
                    if ((state_0 & 0x400000) != 0 && (hostClassCache_1 = this.hostClassCache) != null && !arg0Value.isNull() && arg0Value.isList(hostClassCache_1)) {
                        Cached node__1 = this;
                        HostObject.WriteArrayElement.doList(arg0Value, arg1Value, arg2Value, node__1, hostClassCache_1, INLINED_TO_HOST, INLINED_ERROR);
                        return;
                    }
                    if ((state_0 & 0x800000) != 0 && (hostClassCache_2 = this.hostClassCache) != null && !arg0Value.isNull() && arg0Value.isMapEntry(hostClassCache_2)) {
                        Cached node__2 = this;
                        HostObject.WriteArrayElement.doMapEntry(arg0Value, arg1Value, arg2Value, node__2, hostClassCache_2, INLINED_TO_HOST, INLINED_ERROR);
                        return;
                    }
                    if (!((state_0 & 0x1000000) == 0 || (hostClassCache_3 = this.hostClassCache) == null || arg0Value.isNull() || arg0Value.isList(hostClassCache_3) || arg0Value.isArray(hostClassCache_3) || arg0Value.isMapEntry(hostClassCache_3))) {
                        HostObject.WriteArrayElement.doNotArrayOrList(arg0Value, arg1Value, arg2Value, hostClassCache_3);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeArrayElementAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeArrayElementAndSpecialize(HostObject arg0Value, long arg1Value, Object arg2Value) throws UnsupportedMessageException, InvalidArrayIndexException, UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (arg0Value.isNull()) {
                    this.state_0_ = state_0 |= 0x100000;
                    HostObject.WriteArrayElement.doNull(arg0Value, arg1Value, arg2Value);
                    return;
                }
                Cached node__ = null;
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (arg0Value.isArray(hostClassCache_)) {
                        node__ = this;
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        this.state_0_ = state_0 |= 0x200000;
                        HostObject.WriteArrayElement.doArray(arg0Value, arg1Value, arg2Value, node__, INLINED_TO_HOST, hostClassCache_, INLINED_WRITE_ARRAY_ELEMENT_ARRAY_ARRAY_SET_, INLINED_ERROR);
                        return;
                    }
                }
                Cached node__1 = null;
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = arg0Value.getHostClassCache();
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (arg0Value.isList(hostClassCache_1)) {
                        node__1 = this;
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_1;
                        }
                        this.state_0_ = state_0 |= 0x400000;
                        HostObject.WriteArrayElement.doList(arg0Value, arg1Value, arg2Value, node__1, hostClassCache_1, INLINED_TO_HOST, INLINED_ERROR);
                        return;
                    }
                }
                Cached node__2 = null;
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_2;
                    HostClassCache hostClassCache_2_shared = this.hostClassCache;
                    if (hostClassCache_2_shared != null) {
                        hostClassCache_2 = hostClassCache_2_shared;
                    } else {
                        hostClassCache_2 = arg0Value.getHostClassCache();
                        if (hostClassCache_2 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (arg0Value.isMapEntry(hostClassCache_2)) {
                        node__2 = this;
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_2;
                        }
                        this.state_0_ = state_0 |= 0x800000;
                        HostObject.WriteArrayElement.doMapEntry(arg0Value, arg1Value, arg2Value, node__2, hostClassCache_2, INLINED_TO_HOST, INLINED_ERROR);
                        return;
                    }
                }
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_3;
                    HostClassCache hostClassCache_3_shared = this.hostClassCache;
                    if (hostClassCache_3_shared != null) {
                        hostClassCache_3 = hostClassCache_3_shared;
                    } else {
                        hostClassCache_3 = arg0Value.getHostClassCache();
                        if (hostClassCache_3 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (!(arg0Value.isList(hostClassCache_3) || arg0Value.isArray(hostClassCache_3) || arg0Value.isMapEntry(hostClassCache_3))) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_3;
                        }
                        this.state_0_ = state_0 |= 0x1000000;
                        HostObject.WriteArrayElement.doNotArrayOrList(arg0Value, arg1Value, arg2Value, hostClassCache_3);
                        return;
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value);
            }

            @Override
            public boolean isArrayElementRemovable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0xE000000) != 0) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_;
                    if ((state_0 & 0x2000000) != 0 && arg0Value.isNull()) {
                        return HostObject.IsArrayElementRemovable.doNull(arg0Value, arg1Value);
                    }
                    if ((state_0 & 0x4000000) != 0 && (hostClassCache_ = this.hostClassCache) != null && !arg0Value.isNull() && arg0Value.isList(hostClassCache_)) {
                        Cached node__ = this;
                        return HostObject.IsArrayElementRemovable.doList(arg0Value, arg1Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                    if ((state_0 & 0x8000000) != 0 && (hostClassCache_1 = this.hostClassCache) != null && !arg0Value.isNull() && !arg0Value.isList(hostClassCache_1)) {
                        return HostObject.IsArrayElementRemovable.doOther(arg0Value, arg1Value, hostClassCache_1);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementRemovableAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isArrayElementRemovableAndSpecialize(HostObject arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                if (arg0Value.isNull()) {
                    this.state_0_ = state_0 |= 0x2000000;
                    return HostObject.IsArrayElementRemovable.doNull(arg0Value, arg1Value);
                }
                Cached node__ = null;
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (arg0Value.isList(hostClassCache_)) {
                        node__ = this;
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        this.state_0_ = state_0 |= 0x4000000;
                        return HostObject.IsArrayElementRemovable.doList(arg0Value, arg1Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                }
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = arg0Value.getHostClassCache();
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (!arg0Value.isList(hostClassCache_1)) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_1;
                        }
                        this.state_0_ = state_0 |= 0x8000000;
                        return HostObject.IsArrayElementRemovable.doOther(arg0Value, arg1Value, hostClassCache_1);
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
            }

            @Override
            public void removeArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x70000000) != 0) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_;
                    if ((state_0 & 0x10000000) != 0 && arg0Value.isNull()) {
                        HostObject.RemoveArrayElement.doNull(arg0Value, arg1Value);
                        return;
                    }
                    if ((state_0 & 0x20000000) != 0 && (hostClassCache_ = this.hostClassCache) != null && !arg0Value.isNull() && arg0Value.isList(hostClassCache_)) {
                        Cached node__ = this;
                        HostObject.RemoveArrayElement.doList(arg0Value, arg1Value, node__, hostClassCache_, INLINED_ERROR);
                        return;
                    }
                    if ((state_0 & 0x40000000) != 0 && (hostClassCache_1 = this.hostClassCache) != null && !arg0Value.isNull() && !arg0Value.isList(hostClassCache_1)) {
                        HostObject.RemoveArrayElement.doOther(arg0Value, arg1Value, hostClassCache_1);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.removeArrayElementAndSpecialize(arg0Value, arg1Value);
            }

            private void removeArrayElementAndSpecialize(HostObject arg0Value, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                int state_0 = this.state_0_;
                if (arg0Value.isNull()) {
                    this.state_0_ = state_0 |= 0x10000000;
                    HostObject.RemoveArrayElement.doNull(arg0Value, arg1Value);
                    return;
                }
                Cached node__ = null;
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (arg0Value.isList(hostClassCache_)) {
                        node__ = this;
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        this.state_0_ = state_0 |= 0x20000000;
                        HostObject.RemoveArrayElement.doList(arg0Value, arg1Value, node__, hostClassCache_, INLINED_ERROR);
                        return;
                    }
                }
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = arg0Value.getHostClassCache();
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (!arg0Value.isList(hostClassCache_1)) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_1;
                        }
                        this.state_0_ = state_0 |= 0x40000000;
                        HostObject.RemoveArrayElement.doOther(arg0Value, arg1Value, hostClassCache_1);
                        return;
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
            }

            @Override
            public boolean hasArrayElements(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_0 = this.state_0_;
                int state_1 = this.state_1_;
                if ((state_0 & Integer.MIN_VALUE) != 0 || (state_1 & 1) != 0) {
                    HostClassCache hostClassCache_;
                    if ((state_0 & Integer.MIN_VALUE) != 0 && arg0Value.isNull()) {
                        return HostObject.HasArrayElements.doNull(arg0Value);
                    }
                    if ((state_1 & 1) != 0 && (hostClassCache_ = this.hostClassCache) != null && !arg0Value.isNull()) {
                        return HostObject.HasArrayElements.doNotNull(arg0Value, hostClassCache_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.hasArrayElementsAndSpecialize(arg0Value);
            }

            private boolean hasArrayElementsAndSpecialize(HostObject arg0Value) {
                int state_0 = this.state_0_;
                int state_1 = this.state_1_;
                if (arg0Value.isNull()) {
                    this.state_0_ = state_0 |= Integer.MIN_VALUE;
                    return HostObject.HasArrayElements.doNull(arg0Value);
                }
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_1_ = state_1 |= 1;
                    return HostObject.HasArrayElements.doNotNull(arg0Value, hostClassCache_);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @Override
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x3E) != 0) {
                    HostClassCache hostClassCache_3;
                    HostClassCache hostClassCache_2;
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_;
                    if ((state_1 & 2) != 0 && arg0Value.isNull()) {
                        return HostObject.ReadArrayElement.doNull(arg0Value, arg1Value);
                    }
                    if ((state_1 & 4) != 0 && (hostClassCache_ = this.hostClassCache) != null && !arg0Value.isNull() && arg0Value.isArray(hostClassCache_)) {
                        Cached node__ = this;
                        return HostObject.ReadArrayElement.doArray(arg0Value, arg1Value, node__, INLINED_READ_ARRAY_ELEMENT_ARRAY_ARRAY_GET_, hostClassCache_, INLINED_TO_GUEST, INLINED_ERROR);
                    }
                    if ((state_1 & 8) != 0 && (hostClassCache_1 = this.hostClassCache) != null && !arg0Value.isNull() && arg0Value.isList(hostClassCache_1)) {
                        Cached node__1 = this;
                        return HostObject.ReadArrayElement.doList(arg0Value, arg1Value, node__1, hostClassCache_1, INLINED_TO_GUEST, INLINED_ERROR);
                    }
                    if ((state_1 & 0x10) != 0 && (hostClassCache_2 = this.hostClassCache) != null && !arg0Value.isNull() && arg0Value.isMapEntry(hostClassCache_2)) {
                        Cached node__2 = this;
                        return HostObject.ReadArrayElement.doMapEntry(arg0Value, arg1Value, node__2, hostClassCache_2, INLINED_TO_GUEST, INLINED_ERROR);
                    }
                    if (!((state_1 & 0x20) == 0 || (hostClassCache_3 = this.hostClassCache) == null || arg0Value.isNull() || arg0Value.isArray(hostClassCache_3) || arg0Value.isList(hostClassCache_3) || arg0Value.isMapEntry(hostClassCache_3))) {
                        return HostObject.ReadArrayElement.doNotArrayOrList(arg0Value, arg1Value, hostClassCache_3);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readArrayElementAndSpecialize(arg0Value, arg1Value);
            }

            private Object readArrayElementAndSpecialize(HostObject arg0Value, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                int state_1 = this.state_1_;
                if (arg0Value.isNull()) {
                    this.state_1_ = state_1 |= 2;
                    return HostObject.ReadArrayElement.doNull(arg0Value, arg1Value);
                }
                Cached node__ = null;
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (arg0Value.isArray(hostClassCache_)) {
                        node__ = this;
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        this.state_1_ = state_1 |= 4;
                        return HostObject.ReadArrayElement.doArray(arg0Value, arg1Value, node__, INLINED_READ_ARRAY_ELEMENT_ARRAY_ARRAY_GET_, hostClassCache_, INLINED_TO_GUEST, INLINED_ERROR);
                    }
                }
                Cached node__1 = null;
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = arg0Value.getHostClassCache();
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (arg0Value.isList(hostClassCache_1)) {
                        node__1 = this;
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_1;
                        }
                        this.state_1_ = state_1 |= 8;
                        return HostObject.ReadArrayElement.doList(arg0Value, arg1Value, node__1, hostClassCache_1, INLINED_TO_GUEST, INLINED_ERROR);
                    }
                }
                Cached node__2 = null;
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_2;
                    HostClassCache hostClassCache_2_shared = this.hostClassCache;
                    if (hostClassCache_2_shared != null) {
                        hostClassCache_2 = hostClassCache_2_shared;
                    } else {
                        hostClassCache_2 = arg0Value.getHostClassCache();
                        if (hostClassCache_2 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (arg0Value.isMapEntry(hostClassCache_2)) {
                        node__2 = this;
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_2;
                        }
                        this.state_1_ = state_1 |= 0x10;
                        return HostObject.ReadArrayElement.doMapEntry(arg0Value, arg1Value, node__2, hostClassCache_2, INLINED_TO_GUEST, INLINED_ERROR);
                    }
                }
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_3;
                    HostClassCache hostClassCache_3_shared = this.hostClassCache;
                    if (hostClassCache_3_shared != null) {
                        hostClassCache_3 = hostClassCache_3_shared;
                    } else {
                        hostClassCache_3 = arg0Value.getHostClassCache();
                        if (hostClassCache_3 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (!(arg0Value.isArray(hostClassCache_3) || arg0Value.isList(hostClassCache_3) || arg0Value.isMapEntry(hostClassCache_3))) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_3;
                        }
                        this.state_1_ = state_1 |= 0x20;
                        return HostObject.ReadArrayElement.doNotArrayOrList(arg0Value, arg1Value, hostClassCache_3);
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
            }

            @Override
            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x7C0) != 0) {
                    HostClassCache hostClassCache_3;
                    HostClassCache hostClassCache_2;
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_;
                    if ((state_1 & 0x40) != 0 && arg0Value.isNull()) {
                        return HostObject.GetArraySize.doNull(arg0Value);
                    }
                    if ((state_1 & 0x80) != 0 && (hostClassCache_ = this.hostClassCache) != null && !arg0Value.isNull() && arg0Value.isArray(hostClassCache_)) {
                        return HostObject.GetArraySize.doArray(arg0Value, hostClassCache_);
                    }
                    if ((state_1 & 0x100) != 0 && (hostClassCache_1 = this.hostClassCache) != null && !arg0Value.isNull() && arg0Value.isList(hostClassCache_1)) {
                        Cached node__ = this;
                        return HostObject.GetArraySize.doList(arg0Value, node__, hostClassCache_1, INLINED_ERROR);
                    }
                    if ((state_1 & 0x200) != 0 && (hostClassCache_2 = this.hostClassCache) != null && !arg0Value.isNull() && arg0Value.isMapEntry(hostClassCache_2)) {
                        return HostObject.GetArraySize.doMapEntry(arg0Value, hostClassCache_2);
                    }
                    if (!((state_1 & 0x400) == 0 || (hostClassCache_3 = this.hostClassCache) == null || arg0Value.isNull() || arg0Value.isArray(hostClassCache_3) || arg0Value.isList(hostClassCache_3) || arg0Value.isMapEntry(hostClassCache_3))) {
                        return HostObject.GetArraySize.doNotArrayOrList(arg0Value, hostClassCache_3);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getArraySizeAndSpecialize(arg0Value);
            }

            private long getArraySizeAndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                int state_1 = this.state_1_;
                if (arg0Value.isNull()) {
                    this.state_1_ = state_1 |= 0x40;
                    return HostObject.GetArraySize.doNull(arg0Value);
                }
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (arg0Value.isArray(hostClassCache_)) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        this.state_1_ = state_1 |= 0x80;
                        return HostObject.GetArraySize.doArray(arg0Value, hostClassCache_);
                    }
                }
                Cached node__ = null;
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = arg0Value.getHostClassCache();
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (arg0Value.isList(hostClassCache_1)) {
                        node__ = this;
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_1;
                        }
                        this.state_1_ = state_1 |= 0x100;
                        return HostObject.GetArraySize.doList(arg0Value, node__, hostClassCache_1, INLINED_ERROR);
                    }
                }
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_2;
                    HostClassCache hostClassCache_2_shared = this.hostClassCache;
                    if (hostClassCache_2_shared != null) {
                        hostClassCache_2 = hostClassCache_2_shared;
                    } else {
                        hostClassCache_2 = arg0Value.getHostClassCache();
                        if (hostClassCache_2 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (arg0Value.isMapEntry(hostClassCache_2)) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_2;
                        }
                        this.state_1_ = state_1 |= 0x200;
                        return HostObject.GetArraySize.doMapEntry(arg0Value, hostClassCache_2);
                    }
                }
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_3;
                    HostClassCache hostClassCache_3_shared = this.hostClassCache;
                    if (hostClassCache_3_shared != null) {
                        hostClassCache_3 = hostClassCache_3_shared;
                    } else {
                        hostClassCache_3 = arg0Value.getHostClassCache();
                        if (hostClassCache_3 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (!(arg0Value.isArray(hostClassCache_3) || arg0Value.isList(hostClassCache_3) || arg0Value.isMapEntry(hostClassCache_3))) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_3;
                        }
                        this.state_1_ = state_1 |= 0x400;
                        return HostObject.GetArraySize.doNotArrayOrList(arg0Value, hostClassCache_3);
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @Override
            public boolean hasBufferElements(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x3800) != 0) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_;
                    if ((state_1 & 0x800) != 0 && arg0Value.isNull()) {
                        return HostObject.HasBufferElements.doNull(arg0Value);
                    }
                    if ((state_1 & 0x1000) != 0 && (hostClassCache_ = this.hostClassCache) != null && arg0Value.isByteSequence()) {
                        return HostObject.HasBufferElements.doByteSequence(arg0Value, hostClassCache_);
                    }
                    if ((state_1 & 0x2000) != 0 && (hostClassCache_1 = this.hostClassCache) != null && !arg0Value.isNull() && !arg0Value.isByteSequence()) {
                        return HostObject.HasBufferElements.doOther(arg0Value, hostClassCache_1);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.hasBufferElementsAndSpecialize(arg0Value);
            }

            private boolean hasBufferElementsAndSpecialize(HostObject arg0Value) {
                int state_1 = this.state_1_;
                if (arg0Value.isNull()) {
                    this.state_1_ = state_1 |= 0x800;
                    return HostObject.HasBufferElements.doNull(arg0Value);
                }
                if (arg0Value.isByteSequence()) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_1_ = state_1 |= 0x1000;
                    return HostObject.HasBufferElements.doByteSequence(arg0Value, hostClassCache_);
                }
                if (!arg0Value.isNull() && !arg0Value.isByteSequence()) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = arg0Value.getHostClassCache();
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_1;
                    }
                    this.state_1_ = state_1 |= 0x2000;
                    return HostObject.HasBufferElements.doOther(arg0Value, hostClassCache_1);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @Override
            public boolean isBufferWritable(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x1C000) != 0) {
                    HostClassCache hostClassCache_;
                    if ((state_1 & 0x4000) != 0 && arg0Value.isNull()) {
                        return HostObject.IsBufferWritable.doNull(arg0Value);
                    }
                    if ((state_1 & 0x8000) != 0 && arg0Value.isByteSequence()) {
                        return HostObject.IsBufferWritable.doByteSequence(arg0Value);
                    }
                    if ((state_1 & 0x10000) != 0 && (hostClassCache_ = this.hostClassCache) != null && !arg0Value.isNull() && !arg0Value.isByteSequence()) {
                        Cached node__ = this;
                        return HostObject.IsBufferWritable.doOther(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isBufferWritableAndSpecialize(arg0Value);
            }

            private boolean isBufferWritableAndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                int state_1 = this.state_1_;
                if (arg0Value.isNull()) {
                    this.state_1_ = state_1 |= 0x4000;
                    return HostObject.IsBufferWritable.doNull(arg0Value);
                }
                if (arg0Value.isByteSequence()) {
                    this.state_1_ = state_1 |= 0x8000;
                    return HostObject.IsBufferWritable.doByteSequence(arg0Value);
                }
                Cached node__ = null;
                if (!arg0Value.isNull() && !arg0Value.isByteSequence()) {
                    HostClassCache hostClassCache_;
                    node__ = this;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_1_ = state_1 |= 0x10000;
                    return HostObject.IsBufferWritable.doOther(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @Override
            public long getBufferSize(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0xE0000) != 0) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_;
                    if ((state_1 & 0x20000) != 0 && arg0Value.isNull()) {
                        return HostObject.GetBufferSize.doNull(arg0Value);
                    }
                    if ((state_1 & 0x40000) != 0 && (hostClassCache_ = this.hostClassCache) != null && arg0Value.isByteSequence()) {
                        Cached node__ = this;
                        return HostObject.GetBufferSize.doByteSequence(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                    if ((state_1 & 0x80000) != 0 && (hostClassCache_1 = this.hostClassCache) != null && !arg0Value.isNull() && !arg0Value.isByteSequence()) {
                        Cached node__1 = this;
                        return HostObject.GetBufferSize.doOther(arg0Value, node__1, hostClassCache_1, INLINED_ERROR);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getBufferSizeAndSpecialize(arg0Value);
            }

            private long getBufferSizeAndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                int state_1 = this.state_1_;
                if (arg0Value.isNull()) {
                    this.state_1_ = state_1 |= 0x20000;
                    return HostObject.GetBufferSize.doNull(arg0Value);
                }
                Cached node__ = null;
                if (arg0Value.isByteSequence()) {
                    HostClassCache hostClassCache_;
                    node__ = this;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_1_ = state_1 |= 0x40000;
                    return HostObject.GetBufferSize.doByteSequence(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                }
                Cached node__1 = null;
                if (!arg0Value.isNull() && !arg0Value.isByteSequence()) {
                    HostClassCache hostClassCache_1;
                    node__1 = this;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = arg0Value.getHostClassCache();
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_1;
                    }
                    this.state_1_ = state_1 |= 0x80000;
                    return HostObject.GetBufferSize.doOther(arg0Value, node__1, hostClassCache_1, INLINED_ERROR);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @Override
            public byte readBufferByte(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x700000) != 0) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_;
                    if ((state_1 & 0x100000) != 0 && arg0Value.isNull()) {
                        return HostObject.ReadBufferByte.doNull(arg0Value, arg1Value);
                    }
                    if ((state_1 & 0x200000) != 0 && (hostClassCache_ = this.hostClassCache) != null && arg0Value.isByteSequence()) {
                        Cached node__ = this;
                        return HostObject.ReadBufferByte.doByteSequence(arg0Value, arg1Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                    if ((state_1 & 0x400000) != 0 && (hostClassCache_1 = this.hostClassCache) != null && !arg0Value.isNull() && !arg0Value.isByteSequence()) {
                        Cached node__1 = this;
                        return HostObject.ReadBufferByte.doOther(arg0Value, arg1Value, node__1, hostClassCache_1, INLINED_ERROR, INLINED_CLASS_PROFILE);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readBufferByteAndSpecialize(arg0Value, arg1Value);
            }

            private byte readBufferByteAndSpecialize(HostObject arg0Value, long arg1Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_1 = this.state_1_;
                if (arg0Value.isNull()) {
                    this.state_1_ = state_1 |= 0x100000;
                    return HostObject.ReadBufferByte.doNull(arg0Value, arg1Value);
                }
                Cached node__ = null;
                if (arg0Value.isByteSequence()) {
                    HostClassCache hostClassCache_;
                    node__ = this;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_1_ = state_1 |= 0x200000;
                    return HostObject.ReadBufferByte.doByteSequence(arg0Value, arg1Value, node__, hostClassCache_, INLINED_ERROR);
                }
                Cached node__1 = null;
                if (!arg0Value.isNull() && !arg0Value.isByteSequence()) {
                    HostClassCache hostClassCache_1;
                    node__1 = this;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = arg0Value.getHostClassCache();
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_1;
                    }
                    this.state_1_ = state_1 |= 0x400000;
                    return HostObject.ReadBufferByte.doOther(arg0Value, arg1Value, node__1, hostClassCache_1, INLINED_ERROR, INLINED_CLASS_PROFILE);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
            }

            @Override
            public void writeBufferByte(Object arg0Value_, long arg1Value, byte arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x1800000) != 0) {
                    HostClassCache hostClassCache_;
                    if ((state_1 & 0x800000) != 0 && arg0Value.isNull()) {
                        HostObject.WriteBufferByte.doNull(arg0Value, arg1Value, arg2Value);
                        return;
                    }
                    if ((state_1 & 0x1000000) != 0 && (hostClassCache_ = this.hostClassCache) != null && !arg0Value.isNull()) {
                        Cached node__ = this;
                        HostObject.WriteBufferByte.doNonNull(arg0Value, arg1Value, arg2Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeBufferByteAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeBufferByteAndSpecialize(HostObject arg0Value, long arg1Value, byte arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_1 = this.state_1_;
                if (arg0Value.isNull()) {
                    this.state_1_ = state_1 |= 0x800000;
                    HostObject.WriteBufferByte.doNull(arg0Value, arg1Value, arg2Value);
                    return;
                }
                Cached node__ = null;
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_;
                    node__ = this;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_1_ = state_1 |= 0x1000000;
                    HostObject.WriteBufferByte.doNonNull(arg0Value, arg1Value, arg2Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                    return;
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value);
            }

            @Override
            public short readBufferShort(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0xE000000) != 0) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_;
                    if ((state_1 & 0x2000000) != 0 && arg0Value.isNull()) {
                        return HostObject.ReadBufferShort.doNull(arg0Value, arg1Value, arg2Value);
                    }
                    if ((state_1 & 0x4000000) != 0 && (hostClassCache_ = this.hostClassCache) != null && arg0Value.isByteSequence()) {
                        Cached node__ = this;
                        return HostObject.ReadBufferShort.doByteSequence(arg0Value, arg1Value, arg2Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                    if ((state_1 & 0x8000000) != 0 && (hostClassCache_1 = this.hostClassCache) != null && !arg0Value.isNull() && !arg0Value.isByteSequence()) {
                        Cached node__1 = this;
                        return HostObject.ReadBufferShort.doOther(arg0Value, arg1Value, arg2Value, node__1, hostClassCache_1, INLINED_ERROR, INLINED_CLASS_PROFILE);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readBufferShortAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private short readBufferShortAndSpecialize(HostObject arg0Value, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_1 = this.state_1_;
                if (arg0Value.isNull()) {
                    this.state_1_ = state_1 |= 0x2000000;
                    return HostObject.ReadBufferShort.doNull(arg0Value, arg1Value, arg2Value);
                }
                Cached node__ = null;
                if (arg0Value.isByteSequence()) {
                    HostClassCache hostClassCache_;
                    node__ = this;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_1_ = state_1 |= 0x4000000;
                    return HostObject.ReadBufferShort.doByteSequence(arg0Value, arg1Value, arg2Value, node__, hostClassCache_, INLINED_ERROR);
                }
                Cached node__1 = null;
                if (!arg0Value.isNull() && !arg0Value.isByteSequence()) {
                    HostClassCache hostClassCache_1;
                    node__1 = this;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = arg0Value.getHostClassCache();
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_1;
                    }
                    this.state_1_ = state_1 |= 0x8000000;
                    return HostObject.ReadBufferShort.doOther(arg0Value, arg1Value, arg2Value, node__1, hostClassCache_1, INLINED_ERROR, INLINED_CLASS_PROFILE);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value);
            }

            @Override
            public void writeBufferShort(Object arg0Value_, ByteOrder arg1Value, long arg2Value, short arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x30000000) != 0) {
                    HostClassCache hostClassCache_;
                    if ((state_1 & 0x10000000) != 0 && arg0Value.isNull()) {
                        HostObject.WriteBufferShort.doNull(arg0Value, arg1Value, arg2Value, arg3Value);
                        return;
                    }
                    if ((state_1 & 0x20000000) != 0 && (hostClassCache_ = this.hostClassCache) != null && !arg0Value.isNull()) {
                        Cached node__ = this;
                        HostObject.WriteBufferShort.doNonNull(arg0Value, arg1Value, arg2Value, arg3Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeBufferShortAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private void writeBufferShortAndSpecialize(HostObject arg0Value, ByteOrder arg1Value, long arg2Value, short arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_1 = this.state_1_;
                if (arg0Value.isNull()) {
                    this.state_1_ = state_1 |= 0x10000000;
                    HostObject.WriteBufferShort.doNull(arg0Value, arg1Value, arg2Value, arg3Value);
                    return;
                }
                Cached node__ = null;
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_;
                    node__ = this;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_1_ = state_1 |= 0x20000000;
                    HostObject.WriteBufferShort.doNonNull(arg0Value, arg1Value, arg2Value, arg3Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                    return;
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            @Override
            public int readBufferInt(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_1 = this.state_1_;
                int state_2 = this.state_2_;
                if ((state_1 & 0xC0000000) != 0 || (state_2 & 1) != 0) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_;
                    if ((state_1 & 0x40000000) != 0 && arg0Value.isNull()) {
                        return HostObject.ReadBufferInt.doNull(arg0Value, arg1Value, arg2Value);
                    }
                    if ((state_1 & Integer.MIN_VALUE) != 0 && (hostClassCache_ = this.hostClassCache) != null && arg0Value.isByteSequence()) {
                        Cached node__ = this;
                        return HostObject.ReadBufferInt.doByteSequence(arg0Value, arg1Value, arg2Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                    if ((state_2 & 1) != 0 && (hostClassCache_1 = this.hostClassCache) != null && !arg0Value.isNull() && !arg0Value.isByteSequence()) {
                        Cached node__1 = this;
                        return HostObject.ReadBufferInt.doOther(arg0Value, arg1Value, arg2Value, node__1, hostClassCache_1, INLINED_ERROR, INLINED_CLASS_PROFILE);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readBufferIntAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private int readBufferIntAndSpecialize(HostObject arg0Value, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_1 = this.state_1_;
                int state_2 = this.state_2_;
                if (arg0Value.isNull()) {
                    this.state_1_ = state_1 |= 0x40000000;
                    return HostObject.ReadBufferInt.doNull(arg0Value, arg1Value, arg2Value);
                }
                Cached node__ = null;
                if (arg0Value.isByteSequence()) {
                    HostClassCache hostClassCache_;
                    node__ = this;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_1_ = state_1 |= Integer.MIN_VALUE;
                    return HostObject.ReadBufferInt.doByteSequence(arg0Value, arg1Value, arg2Value, node__, hostClassCache_, INLINED_ERROR);
                }
                Cached node__1 = null;
                if (!arg0Value.isNull() && !arg0Value.isByteSequence()) {
                    HostClassCache hostClassCache_1;
                    node__1 = this;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = arg0Value.getHostClassCache();
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_1;
                    }
                    this.state_2_ = state_2 |= 1;
                    return HostObject.ReadBufferInt.doOther(arg0Value, arg1Value, arg2Value, node__1, hostClassCache_1, INLINED_ERROR, INLINED_CLASS_PROFILE);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value);
            }

            @Override
            public void writeBufferInt(Object arg0Value_, ByteOrder arg1Value, long arg2Value, int arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_2 = this.state_2_;
                if ((state_2 & 6) != 0) {
                    HostClassCache hostClassCache_;
                    if ((state_2 & 2) != 0 && arg0Value.isNull()) {
                        HostObject.WriteBufferInt.doNull(arg0Value, arg1Value, arg2Value, arg3Value);
                        return;
                    }
                    if ((state_2 & 4) != 0 && (hostClassCache_ = this.hostClassCache) != null && !arg0Value.isNull()) {
                        Cached node__ = this;
                        HostObject.WriteBufferInt.doNonNull(arg0Value, arg1Value, arg2Value, arg3Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeBufferIntAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private void writeBufferIntAndSpecialize(HostObject arg0Value, ByteOrder arg1Value, long arg2Value, int arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_2 = this.state_2_;
                if (arg0Value.isNull()) {
                    this.state_2_ = state_2 |= 2;
                    HostObject.WriteBufferInt.doNull(arg0Value, arg1Value, arg2Value, arg3Value);
                    return;
                }
                Cached node__ = null;
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_;
                    node__ = this;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_2_ = state_2 |= 4;
                    HostObject.WriteBufferInt.doNonNull(arg0Value, arg1Value, arg2Value, arg3Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                    return;
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            @Override
            public long readBufferLong(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_2 = this.state_2_;
                if ((state_2 & 0x38) != 0) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_;
                    if ((state_2 & 8) != 0 && arg0Value.isNull()) {
                        return HostObject.ReadBufferLong.doNull(arg0Value, arg1Value, arg2Value);
                    }
                    if ((state_2 & 0x10) != 0 && (hostClassCache_ = this.hostClassCache) != null && arg0Value.isByteSequence()) {
                        Cached node__ = this;
                        return HostObject.ReadBufferLong.doByteSequence(arg0Value, arg1Value, arg2Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                    if ((state_2 & 0x20) != 0 && (hostClassCache_1 = this.hostClassCache) != null && !arg0Value.isNull() && !arg0Value.isByteSequence()) {
                        Cached node__1 = this;
                        return HostObject.ReadBufferLong.doOther(arg0Value, arg1Value, arg2Value, node__1, hostClassCache_1, INLINED_ERROR, INLINED_CLASS_PROFILE);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readBufferLongAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private long readBufferLongAndSpecialize(HostObject arg0Value, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_2 = this.state_2_;
                if (arg0Value.isNull()) {
                    this.state_2_ = state_2 |= 8;
                    return HostObject.ReadBufferLong.doNull(arg0Value, arg1Value, arg2Value);
                }
                Cached node__ = null;
                if (arg0Value.isByteSequence()) {
                    HostClassCache hostClassCache_;
                    node__ = this;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_2_ = state_2 |= 0x10;
                    return HostObject.ReadBufferLong.doByteSequence(arg0Value, arg1Value, arg2Value, node__, hostClassCache_, INLINED_ERROR);
                }
                Cached node__1 = null;
                if (!arg0Value.isNull() && !arg0Value.isByteSequence()) {
                    HostClassCache hostClassCache_1;
                    node__1 = this;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = arg0Value.getHostClassCache();
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_1;
                    }
                    this.state_2_ = state_2 |= 0x20;
                    return HostObject.ReadBufferLong.doOther(arg0Value, arg1Value, arg2Value, node__1, hostClassCache_1, INLINED_ERROR, INLINED_CLASS_PROFILE);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value);
            }

            @Override
            public void writeBufferLong(Object arg0Value_, ByteOrder arg1Value, long arg2Value, long arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_2 = this.state_2_;
                if ((state_2 & 0xC0) != 0) {
                    HostClassCache hostClassCache_;
                    if ((state_2 & 0x40) != 0 && arg0Value.isNull()) {
                        HostObject.WriteBufferLong.doNull(arg0Value, arg1Value, arg2Value, arg3Value);
                        return;
                    }
                    if ((state_2 & 0x80) != 0 && (hostClassCache_ = this.hostClassCache) != null && !arg0Value.isNull()) {
                        Cached node__ = this;
                        HostObject.WriteBufferLong.doNonNull(arg0Value, arg1Value, arg2Value, arg3Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeBufferLongAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private void writeBufferLongAndSpecialize(HostObject arg0Value, ByteOrder arg1Value, long arg2Value, long arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_2 = this.state_2_;
                if (arg0Value.isNull()) {
                    this.state_2_ = state_2 |= 0x40;
                    HostObject.WriteBufferLong.doNull(arg0Value, arg1Value, arg2Value, arg3Value);
                    return;
                }
                Cached node__ = null;
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_;
                    node__ = this;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_2_ = state_2 |= 0x80;
                    HostObject.WriteBufferLong.doNonNull(arg0Value, arg1Value, arg2Value, arg3Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                    return;
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            @Override
            public float readBufferFloat(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_2 = this.state_2_;
                if ((state_2 & 0x700) != 0) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_;
                    if ((state_2 & 0x100) != 0 && arg0Value.isNull()) {
                        return HostObject.ReadBufferFloat.doNull(arg0Value, arg1Value, arg2Value);
                    }
                    if ((state_2 & 0x200) != 0 && (hostClassCache_ = this.hostClassCache) != null && arg0Value.isByteSequence()) {
                        Cached node__ = this;
                        return HostObject.ReadBufferFloat.doByteSequence(arg0Value, arg1Value, arg2Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                    if ((state_2 & 0x400) != 0 && (hostClassCache_1 = this.hostClassCache) != null && !arg0Value.isNull() && !arg0Value.isByteSequence()) {
                        Cached node__1 = this;
                        return HostObject.ReadBufferFloat.doOther(arg0Value, arg1Value, arg2Value, node__1, hostClassCache_1, INLINED_ERROR, INLINED_CLASS_PROFILE);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readBufferFloatAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private float readBufferFloatAndSpecialize(HostObject arg0Value, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_2 = this.state_2_;
                if (arg0Value.isNull()) {
                    this.state_2_ = state_2 |= 0x100;
                    return HostObject.ReadBufferFloat.doNull(arg0Value, arg1Value, arg2Value);
                }
                Cached node__ = null;
                if (arg0Value.isByteSequence()) {
                    HostClassCache hostClassCache_;
                    node__ = this;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_2_ = state_2 |= 0x200;
                    return HostObject.ReadBufferFloat.doByteSequence(arg0Value, arg1Value, arg2Value, node__, hostClassCache_, INLINED_ERROR);
                }
                Cached node__1 = null;
                if (!arg0Value.isNull() && !arg0Value.isByteSequence()) {
                    HostClassCache hostClassCache_1;
                    node__1 = this;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = arg0Value.getHostClassCache();
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_1;
                    }
                    this.state_2_ = state_2 |= 0x400;
                    return HostObject.ReadBufferFloat.doOther(arg0Value, arg1Value, arg2Value, node__1, hostClassCache_1, INLINED_ERROR, INLINED_CLASS_PROFILE);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value);
            }

            @Override
            public void writeBufferFloat(Object arg0Value_, ByteOrder arg1Value, long arg2Value, float arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_2 = this.state_2_;
                if ((state_2 & 0x1800) != 0) {
                    HostClassCache hostClassCache_;
                    if ((state_2 & 0x800) != 0 && arg0Value.isNull()) {
                        HostObject.WriteBufferFloat.doNull(arg0Value, arg1Value, arg2Value, arg3Value);
                        return;
                    }
                    if ((state_2 & 0x1000) != 0 && (hostClassCache_ = this.hostClassCache) != null && !arg0Value.isNull()) {
                        Cached node__ = this;
                        HostObject.WriteBufferFloat.doNonNull(arg0Value, arg1Value, arg2Value, arg3Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeBufferFloatAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private void writeBufferFloatAndSpecialize(HostObject arg0Value, ByteOrder arg1Value, long arg2Value, float arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_2 = this.state_2_;
                if (arg0Value.isNull()) {
                    this.state_2_ = state_2 |= 0x800;
                    HostObject.WriteBufferFloat.doNull(arg0Value, arg1Value, arg2Value, arg3Value);
                    return;
                }
                Cached node__ = null;
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_;
                    node__ = this;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_2_ = state_2 |= 0x1000;
                    HostObject.WriteBufferFloat.doNonNull(arg0Value, arg1Value, arg2Value, arg3Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                    return;
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value, Float.valueOf(arg3Value));
            }

            @Override
            public double readBufferDouble(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_2 = this.state_2_;
                if ((state_2 & 0xE000) != 0) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_;
                    if ((state_2 & 0x2000) != 0 && arg0Value.isNull()) {
                        return HostObject.ReadBufferDouble.doNull(arg0Value, arg1Value, arg2Value);
                    }
                    if ((state_2 & 0x4000) != 0 && (hostClassCache_ = this.hostClassCache) != null && arg0Value.isByteSequence()) {
                        Cached node__ = this;
                        return HostObject.ReadBufferDouble.doByteSequence(arg0Value, arg1Value, arg2Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                    if ((state_2 & 0x8000) != 0 && (hostClassCache_1 = this.hostClassCache) != null && !arg0Value.isNull() && !arg0Value.isByteSequence()) {
                        Cached node__1 = this;
                        return HostObject.ReadBufferDouble.doOther(arg0Value, arg1Value, arg2Value, node__1, hostClassCache_1, INLINED_ERROR, INLINED_CLASS_PROFILE);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readBufferDoubleAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private double readBufferDoubleAndSpecialize(HostObject arg0Value, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_2 = this.state_2_;
                if (arg0Value.isNull()) {
                    this.state_2_ = state_2 |= 0x2000;
                    return HostObject.ReadBufferDouble.doNull(arg0Value, arg1Value, arg2Value);
                }
                Cached node__ = null;
                if (arg0Value.isByteSequence()) {
                    HostClassCache hostClassCache_;
                    node__ = this;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_2_ = state_2 |= 0x4000;
                    return HostObject.ReadBufferDouble.doByteSequence(arg0Value, arg1Value, arg2Value, node__, hostClassCache_, INLINED_ERROR);
                }
                Cached node__1 = null;
                if (!arg0Value.isNull() && !arg0Value.isByteSequence()) {
                    HostClassCache hostClassCache_1;
                    node__1 = this;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = arg0Value.getHostClassCache();
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_1;
                    }
                    this.state_2_ = state_2 |= 0x8000;
                    return HostObject.ReadBufferDouble.doOther(arg0Value, arg1Value, arg2Value, node__1, hostClassCache_1, INLINED_ERROR, INLINED_CLASS_PROFILE);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value);
            }

            @Override
            public void writeBufferDouble(Object arg0Value_, ByteOrder arg1Value, long arg2Value, double arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_2 = this.state_2_;
                if ((state_2 & 0x30000) != 0) {
                    HostClassCache hostClassCache_;
                    if ((state_2 & 0x10000) != 0 && arg0Value.isNull()) {
                        HostObject.WriteBufferDouble.doNull(arg0Value, arg1Value, arg2Value, arg3Value);
                        return;
                    }
                    if ((state_2 & 0x20000) != 0 && (hostClassCache_ = this.hostClassCache) != null && !arg0Value.isNull()) {
                        Cached node__ = this;
                        HostObject.WriteBufferDouble.doNonNull(arg0Value, arg1Value, arg2Value, arg3Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeBufferDoubleAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private void writeBufferDoubleAndSpecialize(HostObject arg0Value, ByteOrder arg1Value, long arg2Value, double arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_2 = this.state_2_;
                if (arg0Value.isNull()) {
                    this.state_2_ = state_2 |= 0x10000;
                    HostObject.WriteBufferDouble.doNull(arg0Value, arg1Value, arg2Value, arg3Value);
                    return;
                }
                Cached node__ = null;
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_;
                    node__ = this;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_2_ = state_2 |= 0x20000;
                    HostObject.WriteBufferDouble.doNonNull(arg0Value, arg1Value, arg2Value, arg3Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                    return;
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            @Override
            public void readBuffer(Object arg0Value_, long arg1Value, byte[] arg2Value, int arg3Value, int arg4Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_2 = this.state_2_;
                if ((state_2 & 0x1C0000) != 0) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_;
                    if ((state_2 & 0x40000) != 0 && arg0Value.isNull()) {
                        HostObject.ReadBuffer.doNull(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                        return;
                    }
                    if ((state_2 & 0x80000) != 0 && (hostClassCache_ = this.hostClassCache) != null && arg0Value.isByteSequence()) {
                        Cached node__ = this;
                        HostObject.ReadBuffer.doByteSequence(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, node__, hostClassCache_, INLINED_ERROR);
                        return;
                    }
                    if ((state_2 & 0x100000) != 0 && (hostClassCache_1 = this.hostClassCache) != null && !arg0Value.isNull() && !arg0Value.isByteSequence()) {
                        Cached node__1 = this;
                        HostObject.ReadBuffer.doOther(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, node__1, hostClassCache_1, INLINED_ERROR, INLINED_CLASS_PROFILE);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readBufferAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            private void readBufferAndSpecialize(HostObject arg0Value, long arg1Value, byte[] arg2Value, int arg3Value, int arg4Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_2 = this.state_2_;
                if (arg0Value.isNull()) {
                    this.state_2_ = state_2 |= 0x40000;
                    HostObject.ReadBuffer.doNull(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                    return;
                }
                Cached node__ = null;
                if (arg0Value.isByteSequence()) {
                    HostClassCache hostClassCache_;
                    node__ = this;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_2_ = state_2 |= 0x80000;
                    HostObject.ReadBuffer.doByteSequence(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, node__, hostClassCache_, INLINED_ERROR);
                    return;
                }
                Cached node__1 = null;
                if (!arg0Value.isNull() && !arg0Value.isByteSequence()) {
                    HostClassCache hostClassCache_1;
                    node__1 = this;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = arg0Value.getHostClassCache();
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_1;
                    }
                    this.state_2_ = state_2 |= 0x100000;
                    HostObject.ReadBuffer.doOther(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, node__1, hostClassCache_1, INLINED_ERROR, INLINED_CLASS_PROFILE);
                    return;
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            @Override
            public boolean isInstantiable(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_2 = this.state_2_;
                if ((state_2 & 0xE00000) != 0) {
                    if ((state_2 & 0x200000) != 0 && !arg0Value.isClass()) {
                        return HostObject.IsInstantiable.doUnsupported(arg0Value);
                    }
                    if ((state_2 & 0x400000) != 0 && arg0Value.isArrayClass()) {
                        return HostObject.IsInstantiable.doArrayCached(arg0Value);
                    }
                    if ((state_2 & 0x800000) != 0 && arg0Value.isDefaultClass()) {
                        Cached node__ = this;
                        return HostObject.IsInstantiable.doObjectCached(arg0Value, node__, INLINED_LOOKUP_CONSTRUCTOR);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isInstantiableAndSpecialize(arg0Value);
            }

            private boolean isInstantiableAndSpecialize(HostObject arg0Value) {
                int state_2 = this.state_2_;
                if (!arg0Value.isClass()) {
                    this.state_2_ = state_2 |= 0x200000;
                    return HostObject.IsInstantiable.doUnsupported(arg0Value);
                }
                if (arg0Value.isArrayClass()) {
                    this.state_2_ = state_2 |= 0x400000;
                    return HostObject.IsInstantiable.doArrayCached(arg0Value);
                }
                Cached node__ = null;
                if (arg0Value.isDefaultClass()) {
                    node__ = this;
                    this.state_2_ = state_2 |= 0x800000;
                    return HostObject.IsInstantiable.doObjectCached(arg0Value, node__, INLINED_LOOKUP_CONSTRUCTOR);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @Override
            public Object instantiate(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_2 = this.state_2_;
                if ((state_2 & 0x7000000) != 0) {
                    InteropLibrary indexes__;
                    if ((state_2 & 0x1000000) != 0 && !arg0Value.isClass()) {
                        return HostObject.Instantiate.doUnsupported(arg0Value, arg1Value);
                    }
                    if ((state_2 & 0x2000000) != 0 && (indexes__ = this.instantiate_arrayCached_indexes_) != null && arg0Value.isArrayClass()) {
                        Cached node__ = this;
                        return HostObject.Instantiate.doArrayCached(arg0Value, arg1Value, node__, indexes__, INLINED_ERROR);
                    }
                    if ((state_2 & 0x4000000) != 0 && arg0Value.isDefaultClass()) {
                        Cached node__1 = this;
                        return HostObject.Instantiate.doObjectCached(arg0Value, arg1Value, node__1, INLINED_LOOKUP_CONSTRUCTOR, INLINED_HOST_EXECUTE, INLINED_ERROR);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.instantiateAndSpecialize(arg0Value, arg1Value);
            }

            private Object instantiateAndSpecialize(HostObject arg0Value, Object[] arg1Value) throws UnsupportedMessageException, UnsupportedTypeException, ArityException {
                int state_2 = this.state_2_;
                if (!arg0Value.isClass()) {
                    this.state_2_ = state_2 |= 0x1000000;
                    return HostObject.Instantiate.doUnsupported(arg0Value, arg1Value);
                }
                Cached node__ = null;
                if (arg0Value.isArrayClass()) {
                    node__ = this;
                    InteropLibrary indexes__ = this.insert(INTEROP_LIBRARY_.createDispatched(1));
                    Objects.requireNonNull(indexes__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.instantiate_arrayCached_indexes_ = indexes__;
                    this.state_2_ = state_2 |= 0x2000000;
                    return HostObject.Instantiate.doArrayCached(arg0Value, arg1Value, node__, indexes__, INLINED_ERROR);
                }
                Cached node__1 = null;
                if (arg0Value.isDefaultClass()) {
                    node__1 = this;
                    this.state_2_ = state_2 |= 0x4000000;
                    return HostObject.Instantiate.doObjectCached(arg0Value, arg1Value, node__1, INLINED_LOOKUP_CONSTRUCTOR, INLINED_HOST_EXECUTE, INLINED_ERROR);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
            }

            @Override
            public boolean isNumber(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_2 = this.state_2_;
                if ((state_2 & 0x38000000) != 0) {
                    HostClassCache hostClassCache_;
                    if ((state_2 & 0x8000000) != 0 && arg0Value.isNull()) {
                        return HostObject.IsNumber.doNull(arg0Value);
                    }
                    if ((state_2 & 0x10000000) != 0 && (hostClassCache_ = this.hostClassCache) != null && arg0Value.isBigInteger()) {
                        return HostObject.IsNumber.doBigInteger(arg0Value, hostClassCache_);
                    }
                    if ((state_2 & 0x20000000) != 0 && !arg0Value.isNull() && !arg0Value.isBigInteger()) {
                        Cached node__ = this;
                        return HostObject.IsNumber.doOther(arg0Value, node__, INLINED_CLASS_PROFILE);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isNumberAndSpecialize(arg0Value);
            }

            private boolean isNumberAndSpecialize(HostObject arg0Value) {
                int state_2 = this.state_2_;
                if (arg0Value.isNull()) {
                    this.state_2_ = state_2 |= 0x8000000;
                    return HostObject.IsNumber.doNull(arg0Value);
                }
                if (arg0Value.isBigInteger()) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_2_ = state_2 |= 0x10000000;
                    return HostObject.IsNumber.doBigInteger(arg0Value, hostClassCache_);
                }
                Cached node__ = null;
                if (!arg0Value.isNull() && !arg0Value.isBigInteger()) {
                    node__ = this;
                    this.state_2_ = state_2 |= 0x20000000;
                    return HostObject.IsNumber.doOther(arg0Value, node__, INLINED_CLASS_PROFILE);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @Override
            public boolean fitsInByte(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_2 = this.state_2_;
                int state_3 = this.state_3_;
                if ((state_2 & 0xC0000000) != 0 || (state_3 & 1) != 0) {
                    InteropLibrary numbers_;
                    HostClassCache hostClassCache_;
                    if ((state_2 & 0x40000000) != 0 && arg0Value.isNull()) {
                        return HostObject.FitsInByte.doNull(arg0Value);
                    }
                    if ((state_2 & Integer.MIN_VALUE) != 0 && (hostClassCache_ = this.hostClassCache) != null && arg0Value.isBigInteger()) {
                        return HostObject.FitsInByte.doBigInteger(arg0Value, hostClassCache_);
                    }
                    if ((state_3 & 1) != 0 && (numbers_ = this.numbers) != null && !arg0Value.isNull() && !arg0Value.isBigInteger()) {
                        Cached receiverLibrary__ = this;
                        return HostObject.FitsInByte.doOther(arg0Value, receiverLibrary__, numbers_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.fitsInByteAndSpecialize(arg0Value);
            }

            private boolean fitsInByteAndSpecialize(HostObject arg0Value) {
                int state_2 = this.state_2_;
                int state_3 = this.state_3_;
                if (arg0Value.isNull()) {
                    this.state_2_ = state_2 |= 0x40000000;
                    return HostObject.FitsInByte.doNull(arg0Value);
                }
                if (arg0Value.isBigInteger()) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_2_ = state_2 |= Integer.MIN_VALUE;
                    return HostObject.FitsInByte.doBigInteger(arg0Value, hostClassCache_);
                }
                Cached receiverLibrary__ = null;
                if (!arg0Value.isNull() && !arg0Value.isBigInteger()) {
                    InteropLibrary numbers_;
                    receiverLibrary__ = this;
                    InteropLibrary numbers__shared = this.numbers;
                    if (numbers__shared != null) {
                        numbers_ = numbers__shared;
                    } else {
                        numbers_ = this.insert(INTEROP_LIBRARY_.createDispatched(5));
                        if (numbers_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.numbers == null) {
                        VarHandle.storeStoreFence();
                        this.numbers = numbers_;
                    }
                    this.state_3_ = state_3 |= 1;
                    return HostObject.FitsInByte.doOther(arg0Value, receiverLibrary__, numbers_);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @Override
            public boolean fitsInShort(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_3 = this.state_3_;
                if ((state_3 & 0xE) != 0) {
                    InteropLibrary numbers_;
                    HostClassCache hostClassCache_;
                    if ((state_3 & 2) != 0 && arg0Value.isNull()) {
                        return HostObject.FitsInShort.doNull(arg0Value);
                    }
                    if ((state_3 & 4) != 0 && (hostClassCache_ = this.hostClassCache) != null && arg0Value.isBigInteger()) {
                        return HostObject.FitsInShort.doBigInteger(arg0Value, hostClassCache_);
                    }
                    if ((state_3 & 8) != 0 && (numbers_ = this.numbers) != null && !arg0Value.isNull() && !arg0Value.isBigInteger()) {
                        Cached receiverLibrary__ = this;
                        return HostObject.FitsInShort.doOther(arg0Value, receiverLibrary__, numbers_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.fitsInShortAndSpecialize(arg0Value);
            }

            private boolean fitsInShortAndSpecialize(HostObject arg0Value) {
                int state_3 = this.state_3_;
                if (arg0Value.isNull()) {
                    this.state_3_ = state_3 |= 2;
                    return HostObject.FitsInShort.doNull(arg0Value);
                }
                if (arg0Value.isBigInteger()) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_3_ = state_3 |= 4;
                    return HostObject.FitsInShort.doBigInteger(arg0Value, hostClassCache_);
                }
                Cached receiverLibrary__ = null;
                if (!arg0Value.isNull() && !arg0Value.isBigInteger()) {
                    InteropLibrary numbers_;
                    receiverLibrary__ = this;
                    InteropLibrary numbers__shared = this.numbers;
                    if (numbers__shared != null) {
                        numbers_ = numbers__shared;
                    } else {
                        numbers_ = this.insert(INTEROP_LIBRARY_.createDispatched(5));
                        if (numbers_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.numbers == null) {
                        VarHandle.storeStoreFence();
                        this.numbers = numbers_;
                    }
                    this.state_3_ = state_3 |= 8;
                    return HostObject.FitsInShort.doOther(arg0Value, receiverLibrary__, numbers_);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @Override
            public boolean fitsInInt(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_3 = this.state_3_;
                if ((state_3 & 0x70) != 0) {
                    InteropLibrary numbers_;
                    HostClassCache hostClassCache_;
                    if ((state_3 & 0x10) != 0 && arg0Value.isNull()) {
                        return HostObject.FitsInInt.doNull(arg0Value);
                    }
                    if ((state_3 & 0x20) != 0 && (hostClassCache_ = this.hostClassCache) != null && arg0Value.isBigInteger()) {
                        return HostObject.FitsInInt.doBigInteger(arg0Value, hostClassCache_);
                    }
                    if ((state_3 & 0x40) != 0 && (numbers_ = this.numbers) != null && !arg0Value.isNull() && !arg0Value.isBigInteger()) {
                        Cached receiverLibrary__ = this;
                        return HostObject.FitsInInt.doOther(arg0Value, receiverLibrary__, numbers_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.fitsInIntAndSpecialize(arg0Value);
            }

            private boolean fitsInIntAndSpecialize(HostObject arg0Value) {
                int state_3 = this.state_3_;
                if (arg0Value.isNull()) {
                    this.state_3_ = state_3 |= 0x10;
                    return HostObject.FitsInInt.doNull(arg0Value);
                }
                if (arg0Value.isBigInteger()) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_3_ = state_3 |= 0x20;
                    return HostObject.FitsInInt.doBigInteger(arg0Value, hostClassCache_);
                }
                Cached receiverLibrary__ = null;
                if (!arg0Value.isNull() && !arg0Value.isBigInteger()) {
                    InteropLibrary numbers_;
                    receiverLibrary__ = this;
                    InteropLibrary numbers__shared = this.numbers;
                    if (numbers__shared != null) {
                        numbers_ = numbers__shared;
                    } else {
                        numbers_ = this.insert(INTEROP_LIBRARY_.createDispatched(5));
                        if (numbers_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.numbers == null) {
                        VarHandle.storeStoreFence();
                        this.numbers = numbers_;
                    }
                    this.state_3_ = state_3 |= 0x40;
                    return HostObject.FitsInInt.doOther(arg0Value, receiverLibrary__, numbers_);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @Override
            public boolean fitsInLong(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_3 = this.state_3_;
                if ((state_3 & 0x380) != 0) {
                    InteropLibrary numbers_;
                    HostClassCache hostClassCache_;
                    if ((state_3 & 0x80) != 0 && arg0Value.isNull()) {
                        return HostObject.FitsInLong.doNull(arg0Value);
                    }
                    if ((state_3 & 0x100) != 0 && (hostClassCache_ = this.hostClassCache) != null && arg0Value.isBigInteger()) {
                        return HostObject.FitsInLong.doBigInteger(arg0Value, hostClassCache_);
                    }
                    if ((state_3 & 0x200) != 0 && (numbers_ = this.numbers) != null && !arg0Value.isNull() && !arg0Value.isBigInteger()) {
                        Cached receiverLibrary__ = this;
                        return HostObject.FitsInLong.doOther(arg0Value, receiverLibrary__, numbers_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.fitsInLongAndSpecialize(arg0Value);
            }

            private boolean fitsInLongAndSpecialize(HostObject arg0Value) {
                int state_3 = this.state_3_;
                if (arg0Value.isNull()) {
                    this.state_3_ = state_3 |= 0x80;
                    return HostObject.FitsInLong.doNull(arg0Value);
                }
                if (arg0Value.isBigInteger()) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_3_ = state_3 |= 0x100;
                    return HostObject.FitsInLong.doBigInteger(arg0Value, hostClassCache_);
                }
                Cached receiverLibrary__ = null;
                if (!arg0Value.isNull() && !arg0Value.isBigInteger()) {
                    InteropLibrary numbers_;
                    receiverLibrary__ = this;
                    InteropLibrary numbers__shared = this.numbers;
                    if (numbers__shared != null) {
                        numbers_ = numbers__shared;
                    } else {
                        numbers_ = this.insert(INTEROP_LIBRARY_.createDispatched(5));
                        if (numbers_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.numbers == null) {
                        VarHandle.storeStoreFence();
                        this.numbers = numbers_;
                    }
                    this.state_3_ = state_3 |= 0x200;
                    return HostObject.FitsInLong.doOther(arg0Value, receiverLibrary__, numbers_);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @Override
            public boolean fitsInBigInteger(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_3 = this.state_3_;
                if ((state_3 & 0x1C00) != 0) {
                    InteropLibrary numbers_;
                    HostClassCache hostClassCache_;
                    if ((state_3 & 0x400) != 0 && arg0Value.isNull()) {
                        return HostObject.FitsInBigInteger.doNull(arg0Value);
                    }
                    if ((state_3 & 0x800) != 0 && (hostClassCache_ = this.hostClassCache) != null && arg0Value.isBigInteger()) {
                        return HostObject.FitsInBigInteger.doBigInteger(arg0Value, hostClassCache_);
                    }
                    if ((state_3 & 0x1000) != 0 && (numbers_ = this.numbers) != null && !arg0Value.isNull() && !arg0Value.isBigInteger()) {
                        Cached receiverLibrary__ = this;
                        return HostObject.FitsInBigInteger.doOther(arg0Value, receiverLibrary__, numbers_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.fitsInBigIntegerAndSpecialize(arg0Value);
            }

            private boolean fitsInBigIntegerAndSpecialize(HostObject arg0Value) {
                int state_3 = this.state_3_;
                if (arg0Value.isNull()) {
                    this.state_3_ = state_3 |= 0x400;
                    return HostObject.FitsInBigInteger.doNull(arg0Value);
                }
                if (arg0Value.isBigInteger()) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_3_ = state_3 |= 0x800;
                    return HostObject.FitsInBigInteger.doBigInteger(arg0Value, hostClassCache_);
                }
                Cached receiverLibrary__ = null;
                if (!arg0Value.isNull() && !arg0Value.isBigInteger()) {
                    InteropLibrary numbers_;
                    receiverLibrary__ = this;
                    InteropLibrary numbers__shared = this.numbers;
                    if (numbers__shared != null) {
                        numbers_ = numbers__shared;
                    } else {
                        numbers_ = this.insert(INTEROP_LIBRARY_.createDispatched(5));
                        if (numbers_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.numbers == null) {
                        VarHandle.storeStoreFence();
                        this.numbers = numbers_;
                    }
                    this.state_3_ = state_3 |= 0x1000;
                    return HostObject.FitsInBigInteger.doOther(arg0Value, receiverLibrary__, numbers_);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @Override
            public boolean fitsInFloat(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_3 = this.state_3_;
                if ((state_3 & 0xE000) != 0) {
                    InteropLibrary numbers_;
                    HostClassCache hostClassCache_;
                    if ((state_3 & 0x2000) != 0 && arg0Value.isNull()) {
                        return HostObject.FitsInFloat.doNull(arg0Value);
                    }
                    if ((state_3 & 0x4000) != 0 && (hostClassCache_ = this.hostClassCache) != null && arg0Value.isBigInteger()) {
                        return HostObject.FitsInFloat.doBigInteger(arg0Value, hostClassCache_);
                    }
                    if ((state_3 & 0x8000) != 0 && (numbers_ = this.numbers) != null && !arg0Value.isNull() && !arg0Value.isBigInteger()) {
                        Cached receiverLibrary__ = this;
                        return HostObject.FitsInFloat.doOther(arg0Value, receiverLibrary__, numbers_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.fitsInFloatAndSpecialize(arg0Value);
            }

            private boolean fitsInFloatAndSpecialize(HostObject arg0Value) {
                int state_3 = this.state_3_;
                if (arg0Value.isNull()) {
                    this.state_3_ = state_3 |= 0x2000;
                    return HostObject.FitsInFloat.doNull(arg0Value);
                }
                if (arg0Value.isBigInteger()) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_3_ = state_3 |= 0x4000;
                    return HostObject.FitsInFloat.doBigInteger(arg0Value, hostClassCache_);
                }
                Cached receiverLibrary__ = null;
                if (!arg0Value.isNull() && !arg0Value.isBigInteger()) {
                    InteropLibrary numbers_;
                    receiverLibrary__ = this;
                    InteropLibrary numbers__shared = this.numbers;
                    if (numbers__shared != null) {
                        numbers_ = numbers__shared;
                    } else {
                        numbers_ = this.insert(INTEROP_LIBRARY_.createDispatched(5));
                        if (numbers_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.numbers == null) {
                        VarHandle.storeStoreFence();
                        this.numbers = numbers_;
                    }
                    this.state_3_ = state_3 |= 0x8000;
                    return HostObject.FitsInFloat.doOther(arg0Value, receiverLibrary__, numbers_);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @Override
            public boolean fitsInDouble(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_3 = this.state_3_;
                if ((state_3 & 0x70000) != 0) {
                    InteropLibrary numbers_;
                    HostClassCache hostClassCache_;
                    if ((state_3 & 0x10000) != 0 && arg0Value.isNull()) {
                        return HostObject.FitsInDouble.doNull(arg0Value);
                    }
                    if ((state_3 & 0x20000) != 0 && (hostClassCache_ = this.hostClassCache) != null && arg0Value.isBigInteger()) {
                        return HostObject.FitsInDouble.doBigInteger(arg0Value, hostClassCache_);
                    }
                    if ((state_3 & 0x40000) != 0 && (numbers_ = this.numbers) != null && !arg0Value.isNull() && !arg0Value.isBigInteger()) {
                        Cached receiverLibrary__ = this;
                        return HostObject.FitsInDouble.doOther(arg0Value, receiverLibrary__, numbers_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.fitsInDoubleAndSpecialize(arg0Value);
            }

            private boolean fitsInDoubleAndSpecialize(HostObject arg0Value) {
                int state_3 = this.state_3_;
                if (arg0Value.isNull()) {
                    this.state_3_ = state_3 |= 0x10000;
                    return HostObject.FitsInDouble.doNull(arg0Value);
                }
                if (arg0Value.isBigInteger()) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_3_ = state_3 |= 0x20000;
                    return HostObject.FitsInDouble.doBigInteger(arg0Value, hostClassCache_);
                }
                Cached receiverLibrary__ = null;
                if (!arg0Value.isNull() && !arg0Value.isBigInteger()) {
                    InteropLibrary numbers_;
                    receiverLibrary__ = this;
                    InteropLibrary numbers__shared = this.numbers;
                    if (numbers__shared != null) {
                        numbers_ = numbers__shared;
                    } else {
                        numbers_ = this.insert(INTEROP_LIBRARY_.createDispatched(5));
                        if (numbers_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.numbers == null) {
                        VarHandle.storeStoreFence();
                        this.numbers = numbers_;
                    }
                    this.state_3_ = state_3 |= 0x40000;
                    return HostObject.FitsInDouble.doOther(arg0Value, receiverLibrary__, numbers_);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @Override
            public byte asByte(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_3 = this.state_3_;
                if ((state_3 & 0x380000) != 0) {
                    InteropLibrary numbers_;
                    HostClassCache hostClassCache_;
                    if ((state_3 & 0x80000) != 0 && arg0Value.isNull()) {
                        return HostObject.AsByte.doNull(arg0Value);
                    }
                    if ((state_3 & 0x100000) != 0 && (hostClassCache_ = this.hostClassCache) != null && arg0Value.isBigInteger()) {
                        Cached node__ = this;
                        return HostObject.AsByte.doBigInteger(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                    if ((state_3 & 0x200000) != 0 && (numbers_ = this.numbers) != null && !arg0Value.isNull() && !arg0Value.isBigInteger()) {
                        Cached node__1 = this;
                        Cached receiverLibrary__ = this;
                        return HostObject.AsByte.doOther(arg0Value, node__1, receiverLibrary__, numbers_, INLINED_ERROR);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asByteAndSpecialize(arg0Value);
            }

            private byte asByteAndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                int state_3 = this.state_3_;
                if (arg0Value.isNull()) {
                    this.state_3_ = state_3 |= 0x80000;
                    return HostObject.AsByte.doNull(arg0Value);
                }
                Cached node__ = null;
                if (arg0Value.isBigInteger()) {
                    HostClassCache hostClassCache_;
                    node__ = this;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_3_ = state_3 |= 0x100000;
                    return HostObject.AsByte.doBigInteger(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                }
                Cached receiverLibrary__ = null;
                Cached node__1 = null;
                if (!arg0Value.isNull() && !arg0Value.isBigInteger()) {
                    InteropLibrary numbers_;
                    node__1 = this;
                    receiverLibrary__ = this;
                    InteropLibrary numbers__shared = this.numbers;
                    if (numbers__shared != null) {
                        numbers_ = numbers__shared;
                    } else {
                        numbers_ = this.insert(INTEROP_LIBRARY_.createDispatched(5));
                        if (numbers_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.numbers == null) {
                        VarHandle.storeStoreFence();
                        this.numbers = numbers_;
                    }
                    this.state_3_ = state_3 |= 0x200000;
                    return HostObject.AsByte.doOther(arg0Value, node__1, receiverLibrary__, numbers_, INLINED_ERROR);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @Override
            public short asShort(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_3 = this.state_3_;
                if ((state_3 & 0x1C00000) != 0) {
                    InteropLibrary numbers_;
                    HostClassCache hostClassCache_;
                    if ((state_3 & 0x400000) != 0 && arg0Value.isNull()) {
                        return HostObject.AsShort.doNull(arg0Value);
                    }
                    if ((state_3 & 0x800000) != 0 && (hostClassCache_ = this.hostClassCache) != null && arg0Value.isBigInteger()) {
                        Cached node__ = this;
                        return HostObject.AsShort.doBigInteger(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                    if ((state_3 & 0x1000000) != 0 && (numbers_ = this.numbers) != null && !arg0Value.isNull() && !arg0Value.isBigInteger()) {
                        Cached node__1 = this;
                        Cached receiverLibrary__ = this;
                        return HostObject.AsShort.doOther(arg0Value, node__1, receiverLibrary__, numbers_, INLINED_ERROR);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asShortAndSpecialize(arg0Value);
            }

            private short asShortAndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                int state_3 = this.state_3_;
                if (arg0Value.isNull()) {
                    this.state_3_ = state_3 |= 0x400000;
                    return HostObject.AsShort.doNull(arg0Value);
                }
                Cached node__ = null;
                if (arg0Value.isBigInteger()) {
                    HostClassCache hostClassCache_;
                    node__ = this;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_3_ = state_3 |= 0x800000;
                    return HostObject.AsShort.doBigInteger(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                }
                Cached receiverLibrary__ = null;
                Cached node__1 = null;
                if (!arg0Value.isNull() && !arg0Value.isBigInteger()) {
                    InteropLibrary numbers_;
                    node__1 = this;
                    receiverLibrary__ = this;
                    InteropLibrary numbers__shared = this.numbers;
                    if (numbers__shared != null) {
                        numbers_ = numbers__shared;
                    } else {
                        numbers_ = this.insert(INTEROP_LIBRARY_.createDispatched(5));
                        if (numbers_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.numbers == null) {
                        VarHandle.storeStoreFence();
                        this.numbers = numbers_;
                    }
                    this.state_3_ = state_3 |= 0x1000000;
                    return HostObject.AsShort.doOther(arg0Value, node__1, receiverLibrary__, numbers_, INLINED_ERROR);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @Override
            public int asInt(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_3 = this.state_3_;
                if ((state_3 & 0xE000000) != 0) {
                    InteropLibrary numbers_;
                    HostClassCache hostClassCache_;
                    if ((state_3 & 0x2000000) != 0 && arg0Value.isNull()) {
                        return HostObject.AsInt.doNull(arg0Value);
                    }
                    if ((state_3 & 0x4000000) != 0 && (hostClassCache_ = this.hostClassCache) != null && arg0Value.isBigInteger()) {
                        Cached node__ = this;
                        return HostObject.AsInt.doBigInteger(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                    if ((state_3 & 0x8000000) != 0 && (numbers_ = this.numbers) != null && !arg0Value.isNull() && !arg0Value.isBigInteger()) {
                        Cached node__1 = this;
                        Cached receiverLibrary__ = this;
                        return HostObject.AsInt.doOther(arg0Value, node__1, receiverLibrary__, numbers_, INLINED_ERROR);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asIntAndSpecialize(arg0Value);
            }

            private int asIntAndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                int state_3 = this.state_3_;
                if (arg0Value.isNull()) {
                    this.state_3_ = state_3 |= 0x2000000;
                    return HostObject.AsInt.doNull(arg0Value);
                }
                Cached node__ = null;
                if (arg0Value.isBigInteger()) {
                    HostClassCache hostClassCache_;
                    node__ = this;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_3_ = state_3 |= 0x4000000;
                    return HostObject.AsInt.doBigInteger(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                }
                Cached receiverLibrary__ = null;
                Cached node__1 = null;
                if (!arg0Value.isNull() && !arg0Value.isBigInteger()) {
                    InteropLibrary numbers_;
                    node__1 = this;
                    receiverLibrary__ = this;
                    InteropLibrary numbers__shared = this.numbers;
                    if (numbers__shared != null) {
                        numbers_ = numbers__shared;
                    } else {
                        numbers_ = this.insert(INTEROP_LIBRARY_.createDispatched(5));
                        if (numbers_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.numbers == null) {
                        VarHandle.storeStoreFence();
                        this.numbers = numbers_;
                    }
                    this.state_3_ = state_3 |= 0x8000000;
                    return HostObject.AsInt.doOther(arg0Value, node__1, receiverLibrary__, numbers_, INLINED_ERROR);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @Override
            public long asLong(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_3 = this.state_3_;
                if ((state_3 & 0x70000000) != 0) {
                    InteropLibrary numbers_;
                    HostClassCache hostClassCache_;
                    if ((state_3 & 0x10000000) != 0 && arg0Value.isNull()) {
                        return HostObject.AsLong.doNull(arg0Value);
                    }
                    if ((state_3 & 0x20000000) != 0 && (hostClassCache_ = this.hostClassCache) != null && arg0Value.isBigInteger()) {
                        Cached node__ = this;
                        return HostObject.AsLong.doBigInteger(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                    if ((state_3 & 0x40000000) != 0 && (numbers_ = this.numbers) != null && !arg0Value.isNull() && !arg0Value.isBigInteger()) {
                        Cached node__1 = this;
                        Cached receiverLibrary__ = this;
                        return HostObject.AsLong.doOther(arg0Value, node__1, receiverLibrary__, numbers_, INLINED_ERROR);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asLongAndSpecialize(arg0Value);
            }

            private long asLongAndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                int state_3 = this.state_3_;
                if (arg0Value.isNull()) {
                    this.state_3_ = state_3 |= 0x10000000;
                    return HostObject.AsLong.doNull(arg0Value);
                }
                Cached node__ = null;
                if (arg0Value.isBigInteger()) {
                    HostClassCache hostClassCache_;
                    node__ = this;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_3_ = state_3 |= 0x20000000;
                    return HostObject.AsLong.doBigInteger(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                }
                Cached receiverLibrary__ = null;
                Cached node__1 = null;
                if (!arg0Value.isNull() && !arg0Value.isBigInteger()) {
                    InteropLibrary numbers_;
                    node__1 = this;
                    receiverLibrary__ = this;
                    InteropLibrary numbers__shared = this.numbers;
                    if (numbers__shared != null) {
                        numbers_ = numbers__shared;
                    } else {
                        numbers_ = this.insert(INTEROP_LIBRARY_.createDispatched(5));
                        if (numbers_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.numbers == null) {
                        VarHandle.storeStoreFence();
                        this.numbers = numbers_;
                    }
                    this.state_3_ = state_3 |= 0x40000000;
                    return HostObject.AsLong.doOther(arg0Value, node__1, receiverLibrary__, numbers_, INLINED_ERROR);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @Override
            public BigInteger asBigInteger(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_3 = this.state_3_;
                int state_4 = this.state_4_;
                if ((state_3 & Integer.MIN_VALUE) != 0 || (state_4 & 3) != 0) {
                    InteropLibrary numbers_;
                    HostClassCache hostClassCache_;
                    if ((state_3 & Integer.MIN_VALUE) != 0 && arg0Value.isNull()) {
                        return HostObject.AsBigInteger.doNull(arg0Value);
                    }
                    if ((state_4 & 1) != 0 && (hostClassCache_ = this.hostClassCache) != null && arg0Value.isBigInteger()) {
                        Cached node__ = this;
                        return HostObject.AsBigInteger.doBigInteger(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                    if ((state_4 & 2) != 0 && (numbers_ = this.numbers) != null && !arg0Value.isNull() && !arg0Value.isBigInteger()) {
                        Cached node__1 = this;
                        Cached receiverLibrary__ = this;
                        return HostObject.AsBigInteger.doOther(arg0Value, node__1, receiverLibrary__, numbers_, INLINED_ERROR);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asBigIntegerAndSpecialize(arg0Value);
            }

            private BigInteger asBigIntegerAndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                int state_3 = this.state_3_;
                int state_4 = this.state_4_;
                if (arg0Value.isNull()) {
                    this.state_3_ = state_3 |= Integer.MIN_VALUE;
                    return HostObject.AsBigInteger.doNull(arg0Value);
                }
                Cached node__ = null;
                if (arg0Value.isBigInteger()) {
                    HostClassCache hostClassCache_;
                    node__ = this;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_4_ = state_4 |= 1;
                    return HostObject.AsBigInteger.doBigInteger(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                }
                Cached receiverLibrary__ = null;
                Cached node__1 = null;
                if (!arg0Value.isNull() && !arg0Value.isBigInteger()) {
                    InteropLibrary numbers_;
                    node__1 = this;
                    receiverLibrary__ = this;
                    InteropLibrary numbers__shared = this.numbers;
                    if (numbers__shared != null) {
                        numbers_ = numbers__shared;
                    } else {
                        numbers_ = this.insert(INTEROP_LIBRARY_.createDispatched(5));
                        if (numbers_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.numbers == null) {
                        VarHandle.storeStoreFence();
                        this.numbers = numbers_;
                    }
                    this.state_4_ = state_4 |= 2;
                    return HostObject.AsBigInteger.doOther(arg0Value, node__1, receiverLibrary__, numbers_, INLINED_ERROR);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @Override
            public float asFloat(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_4 = this.state_4_;
                if ((state_4 & 0x1C) != 0) {
                    InteropLibrary numbers_;
                    HostClassCache hostClassCache_;
                    if ((state_4 & 4) != 0 && arg0Value.isNull()) {
                        return HostObject.AsFloat.doNull(arg0Value);
                    }
                    if ((state_4 & 8) != 0 && (hostClassCache_ = this.hostClassCache) != null && arg0Value.isBigInteger()) {
                        Cached node__ = this;
                        return HostObject.AsFloat.doBigInteger(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                    if ((state_4 & 0x10) != 0 && (numbers_ = this.numbers) != null && !arg0Value.isNull() && !arg0Value.isBigInteger()) {
                        Cached node__1 = this;
                        Cached receiverLibrary__ = this;
                        return HostObject.AsFloat.doOther(arg0Value, node__1, receiverLibrary__, numbers_, INLINED_ERROR);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asFloatAndSpecialize(arg0Value);
            }

            private float asFloatAndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                int state_4 = this.state_4_;
                if (arg0Value.isNull()) {
                    this.state_4_ = state_4 |= 4;
                    return HostObject.AsFloat.doNull(arg0Value);
                }
                Cached node__ = null;
                if (arg0Value.isBigInteger()) {
                    HostClassCache hostClassCache_;
                    node__ = this;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_4_ = state_4 |= 8;
                    return HostObject.AsFloat.doBigInteger(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                }
                Cached receiverLibrary__ = null;
                Cached node__1 = null;
                if (!arg0Value.isNull() && !arg0Value.isBigInteger()) {
                    InteropLibrary numbers_;
                    node__1 = this;
                    receiverLibrary__ = this;
                    InteropLibrary numbers__shared = this.numbers;
                    if (numbers__shared != null) {
                        numbers_ = numbers__shared;
                    } else {
                        numbers_ = this.insert(INTEROP_LIBRARY_.createDispatched(5));
                        if (numbers_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.numbers == null) {
                        VarHandle.storeStoreFence();
                        this.numbers = numbers_;
                    }
                    this.state_4_ = state_4 |= 0x10;
                    return HostObject.AsFloat.doOther(arg0Value, node__1, receiverLibrary__, numbers_, INLINED_ERROR);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @Override
            public double asDouble(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_4 = this.state_4_;
                if ((state_4 & 0xE0) != 0) {
                    InteropLibrary numbers_;
                    HostClassCache hostClassCache_;
                    if ((state_4 & 0x20) != 0 && arg0Value.isNull()) {
                        return HostObject.AsDouble.doNull(arg0Value);
                    }
                    if ((state_4 & 0x40) != 0 && (hostClassCache_ = this.hostClassCache) != null && arg0Value.isBigInteger()) {
                        Cached node__ = this;
                        return HostObject.AsDouble.doBigInteger(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                    if ((state_4 & 0x80) != 0 && (numbers_ = this.numbers) != null && !arg0Value.isNull() && !arg0Value.isBigInteger()) {
                        Cached node__1 = this;
                        Cached receiverLibrary__ = this;
                        return HostObject.AsDouble.doOther(arg0Value, node__1, receiverLibrary__, numbers_, INLINED_ERROR);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asDoubleAndSpecialize(arg0Value);
            }

            private double asDoubleAndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                int state_4 = this.state_4_;
                if (arg0Value.isNull()) {
                    this.state_4_ = state_4 |= 0x20;
                    return HostObject.AsDouble.doNull(arg0Value);
                }
                Cached node__ = null;
                if (arg0Value.isBigInteger()) {
                    HostClassCache hostClassCache_;
                    node__ = this;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_4_ = state_4 |= 0x40;
                    return HostObject.AsDouble.doBigInteger(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                }
                Cached receiverLibrary__ = null;
                Cached node__1 = null;
                if (!arg0Value.isNull() && !arg0Value.isBigInteger()) {
                    InteropLibrary numbers_;
                    node__1 = this;
                    receiverLibrary__ = this;
                    InteropLibrary numbers__shared = this.numbers;
                    if (numbers__shared != null) {
                        numbers_ = numbers__shared;
                    } else {
                        numbers_ = this.insert(INTEROP_LIBRARY_.createDispatched(5));
                        if (numbers_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.numbers == null) {
                        VarHandle.storeStoreFence();
                        this.numbers = numbers_;
                    }
                    this.state_4_ = state_4 |= 0x80;
                    return HostObject.AsDouble.doOther(arg0Value, node__1, receiverLibrary__, numbers_, INLINED_ERROR);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @Override
            public boolean hasIterator(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_4 = this.state_4_;
                if ((state_4 & 0x300) != 0) {
                    HostClassCache hostClassCache_;
                    if ((state_4 & 0x100) != 0 && arg0Value.isNull()) {
                        return HostObject.HasIterator.doNull(arg0Value);
                    }
                    if ((state_4 & 0x200) != 0 && (hostClassCache_ = this.hostClassCache) != null && !arg0Value.isNull()) {
                        return HostObject.HasIterator.doNonNull(arg0Value, hostClassCache_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.hasIteratorAndSpecialize(arg0Value);
            }

            private boolean hasIteratorAndSpecialize(HostObject arg0Value) {
                int state_4 = this.state_4_;
                if (arg0Value.isNull()) {
                    this.state_4_ = state_4 |= 0x100;
                    return HostObject.HasIterator.doNull(arg0Value);
                }
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_4_ = state_4 |= 0x200;
                    return HostObject.HasIterator.doNonNull(arg0Value, hostClassCache_);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @Override
            public Object getIterator(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_4 = this.state_4_;
                if ((state_4 & 0x3C00) != 0) {
                    HostClassCache hostClassCache_2;
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_;
                    if ((state_4 & 0x400) != 0 && arg0Value.isNull()) {
                        return HostObject.GetIterator.doNull(arg0Value);
                    }
                    if ((state_4 & 0x800) != 0 && (hostClassCache_ = this.hostClassCache) != null && !arg0Value.isNull() && arg0Value.isArray(hostClassCache_)) {
                        Cached node__ = this;
                        return HostObject.GetIterator.doArray(arg0Value, node__, hostClassCache_, INLINED_TO_GUEST);
                    }
                    if ((state_4 & 0x1000) != 0 && (hostClassCache_1 = this.hostClassCache) != null && !arg0Value.isNull() && arg0Value.isIterable(hostClassCache_1)) {
                        Cached node__1 = this;
                        return HostObject.GetIterator.doIterable(arg0Value, node__1, hostClassCache_1, INLINED_TO_GUEST, INLINED_ERROR);
                    }
                    if (!((state_4 & 0x2000) == 0 || (hostClassCache_2 = this.hostClassCache) == null || arg0Value.isNull() || arg0Value.isArray(hostClassCache_2) || arg0Value.isIterable(hostClassCache_2))) {
                        return HostObject.GetIterator.doNotArrayOrIterable(arg0Value, hostClassCache_2);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getIteratorAndSpecialize(arg0Value);
            }

            private Object getIteratorAndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                int state_4 = this.state_4_;
                if (arg0Value.isNull()) {
                    this.state_4_ = state_4 |= 0x400;
                    return HostObject.GetIterator.doNull(arg0Value);
                }
                Cached node__ = null;
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (arg0Value.isArray(hostClassCache_)) {
                        node__ = this;
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        this.state_4_ = state_4 |= 0x800;
                        return HostObject.GetIterator.doArray(arg0Value, node__, hostClassCache_, INLINED_TO_GUEST);
                    }
                }
                Cached node__1 = null;
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = arg0Value.getHostClassCache();
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (arg0Value.isIterable(hostClassCache_1)) {
                        node__1 = this;
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_1;
                        }
                        this.state_4_ = state_4 |= 0x1000;
                        return HostObject.GetIterator.doIterable(arg0Value, node__1, hostClassCache_1, INLINED_TO_GUEST, INLINED_ERROR);
                    }
                }
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_2;
                    HostClassCache hostClassCache_2_shared = this.hostClassCache;
                    if (hostClassCache_2_shared != null) {
                        hostClassCache_2 = hostClassCache_2_shared;
                    } else {
                        hostClassCache_2 = arg0Value.getHostClassCache();
                        if (hostClassCache_2 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (!arg0Value.isArray(hostClassCache_2) && !arg0Value.isIterable(hostClassCache_2)) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_2;
                        }
                        this.state_4_ = state_4 |= 0x2000;
                        return HostObject.GetIterator.doNotArrayOrIterable(arg0Value, hostClassCache_2);
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @Override
            public boolean isIterator(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_4 = this.state_4_;
                if ((state_4 & 0xC000) != 0) {
                    HostClassCache hostClassCache_;
                    if ((state_4 & 0x4000) != 0 && arg0Value.isNull()) {
                        return HostObject.IsIterator.doNull(arg0Value);
                    }
                    if ((state_4 & 0x8000) != 0 && (hostClassCache_ = this.hostClassCache) != null && !arg0Value.isNull()) {
                        return HostObject.IsIterator.doNonNull(arg0Value, hostClassCache_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isIteratorAndSpecialize(arg0Value);
            }

            private boolean isIteratorAndSpecialize(HostObject arg0Value) {
                int state_4 = this.state_4_;
                if (arg0Value.isNull()) {
                    this.state_4_ = state_4 |= 0x4000;
                    return HostObject.IsIterator.doNull(arg0Value);
                }
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_4_ = state_4 |= 0x8000;
                    return HostObject.IsIterator.doNonNull(arg0Value, hostClassCache_);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @Override
            public boolean hasIteratorNextElement(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_4 = this.state_4_;
                if ((state_4 & 0x70000) != 0) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_;
                    if ((state_4 & 0x10000) != 0 && arg0Value.isNull()) {
                        return HostObject.HasIteratorNextElement.doNull(arg0Value);
                    }
                    if ((state_4 & 0x20000) != 0 && (hostClassCache_ = this.hostClassCache) != null && !arg0Value.isNull() && arg0Value.isIteratorLocal(hostClassCache_)) {
                        Cached node__ = this;
                        return HostObject.HasIteratorNextElement.doIterator(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                    if ((state_4 & 0x40000) != 0 && (hostClassCache_1 = this.hostClassCache) != null && !arg0Value.isNull() && !arg0Value.isIteratorLocal(hostClassCache_1)) {
                        return HostObject.HasIteratorNextElement.doNotIterator(arg0Value, hostClassCache_1);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.hasIteratorNextElementAndSpecialize(arg0Value);
            }

            private boolean hasIteratorNextElementAndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                int state_4 = this.state_4_;
                if (arg0Value.isNull()) {
                    this.state_4_ = state_4 |= 0x10000;
                    return HostObject.HasIteratorNextElement.doNull(arg0Value);
                }
                Cached node__ = null;
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (arg0Value.isIteratorLocal(hostClassCache_)) {
                        node__ = this;
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        this.state_4_ = state_4 |= 0x20000;
                        return HostObject.HasIteratorNextElement.doIterator(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                }
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = arg0Value.getHostClassCache();
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (!arg0Value.isIteratorLocal(hostClassCache_1)) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_1;
                        }
                        this.state_4_ = state_4 |= 0x40000;
                        return HostObject.HasIteratorNextElement.doNotIterator(arg0Value, hostClassCache_1);
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @Override
            public Object getIteratorNextElement(Object arg0Value_) throws UnsupportedMessageException, StopIterationException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_4 = this.state_4_;
                if ((state_4 & 0x380000) != 0) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_;
                    if ((state_4 & 0x80000) != 0 && arg0Value.isNull()) {
                        return HostObject.GetIteratorNextElement.doNull(arg0Value);
                    }
                    if ((state_4 & 0x100000) != 0 && (hostClassCache_ = this.hostClassCache) != null && !arg0Value.isNull() && arg0Value.isIteratorLocal(hostClassCache_)) {
                        Cached node__ = this;
                        return HostObject.GetIteratorNextElement.doIterator(arg0Value, node__, hostClassCache_, INLINED_TO_GUEST, INLINED_ERROR, INLINED_GET_ITERATOR_NEXT_ELEMENT_ITERATOR_STOP_ITERATION_);
                    }
                    if ((state_4 & 0x200000) != 0 && (hostClassCache_1 = this.hostClassCache) != null && !arg0Value.isNull() && !arg0Value.isIteratorLocal(hostClassCache_1)) {
                        return HostObject.GetIteratorNextElement.doNotIterator(arg0Value, hostClassCache_1);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getIteratorNextElementAndSpecialize(arg0Value);
            }

            private Object getIteratorNextElementAndSpecialize(HostObject arg0Value) throws UnsupportedMessageException, StopIterationException {
                int state_4 = this.state_4_;
                if (arg0Value.isNull()) {
                    this.state_4_ = state_4 |= 0x80000;
                    return HostObject.GetIteratorNextElement.doNull(arg0Value);
                }
                Cached node__ = null;
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (arg0Value.isIteratorLocal(hostClassCache_)) {
                        node__ = this;
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        this.state_4_ = state_4 |= 0x100000;
                        return HostObject.GetIteratorNextElement.doIterator(arg0Value, node__, hostClassCache_, INLINED_TO_GUEST, INLINED_ERROR, INLINED_GET_ITERATOR_NEXT_ELEMENT_ITERATOR_STOP_ITERATION_);
                    }
                }
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = arg0Value.getHostClassCache();
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (!arg0Value.isIteratorLocal(hostClassCache_1)) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_1;
                        }
                        this.state_4_ = state_4 |= 0x200000;
                        return HostObject.GetIteratorNextElement.doNotIterator(arg0Value, hostClassCache_1);
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @Override
            public boolean hasHashEntries(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_4 = this.state_4_;
                if ((state_4 & 0xC00000) != 0) {
                    HostClassCache hostClassCache_;
                    if ((state_4 & 0x400000) != 0 && arg0Value.isNull()) {
                        return HostObject.HasHashEntries.doNull(arg0Value);
                    }
                    if ((state_4 & 0x800000) != 0 && (hostClassCache_ = this.hostClassCache) != null && !arg0Value.isNull()) {
                        return HostObject.HasHashEntries.doNonNull(arg0Value, hostClassCache_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.hasHashEntriesAndSpecialize(arg0Value);
            }

            private boolean hasHashEntriesAndSpecialize(HostObject arg0Value) {
                int state_4 = this.state_4_;
                if (arg0Value.isNull()) {
                    this.state_4_ = state_4 |= 0x400000;
                    return HostObject.HasHashEntries.doNull(arg0Value);
                }
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_4_ = state_4 |= 0x800000;
                    return HostObject.HasHashEntries.doNonNull(arg0Value, hostClassCache_);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @Override
            public long getHashSize(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_4 = this.state_4_;
                if ((state_4 & 0x7000000) != 0) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_;
                    if ((state_4 & 0x1000000) != 0 && arg0Value.isNull()) {
                        return HostObject.GetHashSize.doNull(arg0Value);
                    }
                    if ((state_4 & 0x2000000) != 0 && (hostClassCache_ = this.hostClassCache) != null && !arg0Value.isNull() && arg0Value.isMap(hostClassCache_)) {
                        Cached node__ = this;
                        return HostObject.GetHashSize.doMap(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                    if ((state_4 & 0x4000000) != 0 && (hostClassCache_1 = this.hostClassCache) != null && !arg0Value.isNull() && !arg0Value.isMap(hostClassCache_1)) {
                        return HostObject.GetHashSize.doNotMap(arg0Value, hostClassCache_1);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getHashSizeAndSpecialize(arg0Value);
            }

            private long getHashSizeAndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                int state_4 = this.state_4_;
                if (arg0Value.isNull()) {
                    this.state_4_ = state_4 |= 0x1000000;
                    return HostObject.GetHashSize.doNull(arg0Value);
                }
                Cached node__ = null;
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (arg0Value.isMap(hostClassCache_)) {
                        node__ = this;
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        this.state_4_ = state_4 |= 0x2000000;
                        return HostObject.GetHashSize.doMap(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                }
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = arg0Value.getHostClassCache();
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (!arg0Value.isMap(hostClassCache_1)) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_1;
                        }
                        this.state_4_ = state_4 |= 0x4000000;
                        return HostObject.GetHashSize.doNotMap(arg0Value, hostClassCache_1);
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @Override
            public boolean isHashEntryReadable(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_4 = this.state_4_;
                if ((state_4 & 0x18000000) != 0) {
                    HostClassCache hostClassCache_;
                    if ((state_4 & 0x8000000) != 0 && arg0Value.isNull()) {
                        return HostObject.IsHashEntryReadable.doNull(arg0Value, arg1Value);
                    }
                    if ((state_4 & 0x10000000) != 0 && (hostClassCache_ = this.hostClassCache) != null && !arg0Value.isNull()) {
                        Cached node__ = this;
                        return HostObject.IsHashEntryReadable.doNonNull(arg0Value, arg1Value, node__, INLINED_CONTAINS_KEY, hostClassCache_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isHashEntryReadableAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isHashEntryReadableAndSpecialize(HostObject arg0Value, Object arg1Value) {
                int state_4 = this.state_4_;
                if (arg0Value.isNull()) {
                    this.state_4_ = state_4 |= 0x8000000;
                    return HostObject.IsHashEntryReadable.doNull(arg0Value, arg1Value);
                }
                Cached node__ = null;
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_;
                    node__ = this;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_4_ = state_4 |= 0x10000000;
                    return HostObject.IsHashEntryReadable.doNonNull(arg0Value, arg1Value, node__, INLINED_CONTAINS_KEY, hostClassCache_);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
            }

            @Override
            public boolean isHashEntryModifiable(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_4 = this.state_4_;
                if ((state_4 & 0x18000000) != 0) {
                    HostClassCache hostClassCache_;
                    if ((state_4 & 0x8000000) != 0 && arg0Value.isNull()) {
                        return HostObject.IsHashEntryReadable.doNull(arg0Value, arg1Value);
                    }
                    if ((state_4 & 0x10000000) != 0 && (hostClassCache_ = this.hostClassCache) != null && !arg0Value.isNull()) {
                        Cached node__ = this;
                        return HostObject.IsHashEntryReadable.doNonNull(arg0Value, arg1Value, node__, INLINED_CONTAINS_KEY, hostClassCache_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isHashEntryReadableAndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public boolean isHashEntryRemovable(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_4 = this.state_4_;
                if ((state_4 & 0x18000000) != 0) {
                    HostClassCache hostClassCache_;
                    if ((state_4 & 0x8000000) != 0 && arg0Value.isNull()) {
                        return HostObject.IsHashEntryReadable.doNull(arg0Value, arg1Value);
                    }
                    if ((state_4 & 0x10000000) != 0 && (hostClassCache_ = this.hostClassCache) != null && !arg0Value.isNull()) {
                        Cached node__ = this;
                        return HostObject.IsHashEntryReadable.doNonNull(arg0Value, arg1Value, node__, INLINED_CONTAINS_KEY, hostClassCache_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isHashEntryReadableAndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public Object readHashValue(Object arg0Value_, Object arg1Value) throws UnsupportedMessageException, UnknownKeyException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_4 = this.state_4_;
                if ((state_4 & 0xE0000000) != 0) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_;
                    if ((state_4 & 0x20000000) != 0 && arg0Value.isNull()) {
                        return HostObject.ReadHashValue.doNull(arg0Value, arg1Value);
                    }
                    if ((state_4 & 0x40000000) != 0 && (hostClassCache_ = this.hostClassCache) != null && !arg0Value.isNull() && arg0Value.isMap(hostClassCache_)) {
                        Cached node__ = this;
                        return HostObject.ReadHashValue.doMap(arg0Value, arg1Value, node__, hostClassCache_, INLINED_TO_HOST, INLINED_TO_GUEST, INLINED_ERROR);
                    }
                    if ((state_4 & Integer.MIN_VALUE) != 0 && (hostClassCache_1 = this.hostClassCache) != null && !arg0Value.isNull() && !arg0Value.isMap(hostClassCache_1)) {
                        return HostObject.ReadHashValue.doNotMap(arg0Value, arg1Value, hostClassCache_1);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readHashValueAndSpecialize(arg0Value, arg1Value);
            }

            private Object readHashValueAndSpecialize(HostObject arg0Value, Object arg1Value) throws UnsupportedMessageException, UnknownKeyException {
                int state_4 = this.state_4_;
                if (arg0Value.isNull()) {
                    this.state_4_ = state_4 |= 0x20000000;
                    return HostObject.ReadHashValue.doNull(arg0Value, arg1Value);
                }
                Cached node__ = null;
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (arg0Value.isMap(hostClassCache_)) {
                        node__ = this;
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        this.state_4_ = state_4 |= 0x40000000;
                        return HostObject.ReadHashValue.doMap(arg0Value, arg1Value, node__, hostClassCache_, INLINED_TO_HOST, INLINED_TO_GUEST, INLINED_ERROR);
                    }
                }
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = arg0Value.getHostClassCache();
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (!arg0Value.isMap(hostClassCache_1)) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_1;
                        }
                        this.state_4_ = state_4 |= Integer.MIN_VALUE;
                        return HostObject.ReadHashValue.doNotMap(arg0Value, arg1Value, hostClassCache_1);
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
            }

            @Override
            public boolean isHashEntryInsertable(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_5 = this.state_5_;
                if ((state_5 & 3) != 0) {
                    HostClassCache hostClassCache_;
                    if ((state_5 & 1) != 0 && arg0Value.isNull()) {
                        return HostObject.IsHashEntryInsertable.doNull(arg0Value, arg1Value);
                    }
                    if ((state_5 & 2) != 0 && (hostClassCache_ = this.hostClassCache) != null && !arg0Value.isNull()) {
                        Cached node__ = this;
                        return HostObject.IsHashEntryInsertable.doNonNull(arg0Value, arg1Value, node__, INLINED_CONTAINS_KEY, hostClassCache_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isHashEntryInsertableAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isHashEntryInsertableAndSpecialize(HostObject arg0Value, Object arg1Value) {
                int state_5 = this.state_5_;
                if (arg0Value.isNull()) {
                    this.state_5_ = state_5 |= 1;
                    return HostObject.IsHashEntryInsertable.doNull(arg0Value, arg1Value);
                }
                Cached node__ = null;
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_;
                    node__ = this;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    this.state_5_ = state_5 |= 2;
                    return HostObject.IsHashEntryInsertable.doNonNull(arg0Value, arg1Value, node__, INLINED_CONTAINS_KEY, hostClassCache_);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
            }

            @Override
            public void writeHashEntry(Object arg0Value_, Object arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownKeyException, UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_5 = this.state_5_;
                if ((state_5 & 0x1C) != 0) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_;
                    if ((state_5 & 4) != 0 && arg0Value.isNull()) {
                        HostObject.WriteHashEntry.doNull(arg0Value, arg1Value, arg2Value);
                        return;
                    }
                    if ((state_5 & 8) != 0 && (hostClassCache_ = this.hostClassCache) != null && !arg0Value.isNull() && arg0Value.isMap(hostClassCache_)) {
                        Cached node__ = this;
                        HostObject.WriteHashEntry.doMap(arg0Value, arg1Value, arg2Value, node__, hostClassCache_, INLINED_TO_HOST, INLINED_ERROR);
                        return;
                    }
                    if ((state_5 & 0x10) != 0 && (hostClassCache_1 = this.hostClassCache) != null && !arg0Value.isNull() && !arg0Value.isMap(hostClassCache_1)) {
                        HostObject.WriteHashEntry.doNotMap(arg0Value, arg1Value, arg2Value, hostClassCache_1);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeHashEntryAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeHashEntryAndSpecialize(HostObject arg0Value, Object arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException {
                int state_5 = this.state_5_;
                if (arg0Value.isNull()) {
                    this.state_5_ = state_5 |= 4;
                    HostObject.WriteHashEntry.doNull(arg0Value, arg1Value, arg2Value);
                    return;
                }
                Cached node__ = null;
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (arg0Value.isMap(hostClassCache_)) {
                        node__ = this;
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        this.state_5_ = state_5 |= 8;
                        HostObject.WriteHashEntry.doMap(arg0Value, arg1Value, arg2Value, node__, hostClassCache_, INLINED_TO_HOST, INLINED_ERROR);
                        return;
                    }
                }
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = arg0Value.getHostClassCache();
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (!arg0Value.isMap(hostClassCache_1)) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_1;
                        }
                        this.state_5_ = state_5 |= 0x10;
                        HostObject.WriteHashEntry.doNotMap(arg0Value, arg1Value, arg2Value, hostClassCache_1);
                        return;
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value);
            }

            @Override
            public void removeHashEntry(Object arg0Value_, Object arg1Value) throws UnsupportedMessageException, UnknownKeyException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_5 = this.state_5_;
                if ((state_5 & 0xE0) != 0) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_;
                    if ((state_5 & 0x20) != 0 && arg0Value.isNull()) {
                        HostObject.RemoveHashEntry.doNull(arg0Value, arg1Value);
                        return;
                    }
                    if ((state_5 & 0x40) != 0 && (hostClassCache_ = this.hostClassCache) != null && !arg0Value.isNull() && arg0Value.isMap(hostClassCache_)) {
                        Cached node__ = this;
                        HostObject.RemoveHashEntry.doMap(arg0Value, arg1Value, node__, hostClassCache_, INLINED_TO_HOST, INLINED_ERROR);
                        return;
                    }
                    if ((state_5 & 0x80) != 0 && (hostClassCache_1 = this.hostClassCache) != null && !arg0Value.isNull() && !arg0Value.isMap(hostClassCache_1)) {
                        HostObject.RemoveHashEntry.doNotMap(arg0Value, arg1Value, hostClassCache_1);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.removeHashEntryAndSpecialize(arg0Value, arg1Value);
            }

            private void removeHashEntryAndSpecialize(HostObject arg0Value, Object arg1Value) throws UnsupportedMessageException, UnknownKeyException {
                int state_5 = this.state_5_;
                if (arg0Value.isNull()) {
                    this.state_5_ = state_5 |= 0x20;
                    HostObject.RemoveHashEntry.doNull(arg0Value, arg1Value);
                    return;
                }
                Cached node__ = null;
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (arg0Value.isMap(hostClassCache_)) {
                        node__ = this;
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        this.state_5_ = state_5 |= 0x40;
                        HostObject.RemoveHashEntry.doMap(arg0Value, arg1Value, node__, hostClassCache_, INLINED_TO_HOST, INLINED_ERROR);
                        return;
                    }
                }
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = arg0Value.getHostClassCache();
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (!arg0Value.isMap(hostClassCache_1)) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_1;
                        }
                        this.state_5_ = state_5 |= 0x80;
                        HostObject.RemoveHashEntry.doNotMap(arg0Value, arg1Value, hostClassCache_1);
                        return;
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
            }

            @Override
            public Object getHashEntriesIterator(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_5 = this.state_5_;
                if ((state_5 & 0x700) != 0) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_;
                    if ((state_5 & 0x100) != 0 && arg0Value.isNull()) {
                        return HostObject.GetHashEntriesIterator.doNull(arg0Value);
                    }
                    if ((state_5 & 0x200) != 0 && (hostClassCache_ = this.hostClassCache) != null && !arg0Value.isNull() && arg0Value.isMap(hostClassCache_)) {
                        Cached node__ = this;
                        return HostObject.GetHashEntriesIterator.doMap(arg0Value, node__, hostClassCache_, INLINED_TO_GUEST, INLINED_ERROR);
                    }
                    if ((state_5 & 0x400) != 0 && (hostClassCache_1 = this.hostClassCache) != null && !arg0Value.isNull() && !arg0Value.isMap(hostClassCache_1)) {
                        return HostObject.GetHashEntriesIterator.doNotMap(arg0Value, hostClassCache_1);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getHashEntriesIteratorAndSpecialize(arg0Value);
            }

            private Object getHashEntriesIteratorAndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                int state_5 = this.state_5_;
                if (arg0Value.isNull()) {
                    this.state_5_ = state_5 |= 0x100;
                    return HostObject.GetHashEntriesIterator.doNull(arg0Value);
                }
                Cached node__ = null;
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = arg0Value.getHostClassCache();
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (arg0Value.isMap(hostClassCache_)) {
                        node__ = this;
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        this.state_5_ = state_5 |= 0x200;
                        return HostObject.GetHashEntriesIterator.doMap(arg0Value, node__, hostClassCache_, INLINED_TO_GUEST, INLINED_ERROR);
                    }
                }
                if (!arg0Value.isNull()) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = arg0Value.getHostClassCache();
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (!arg0Value.isMap(hostClassCache_1)) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_1;
                        }
                        this.state_5_ = state_5 |= 0x400;
                        return HostObject.GetHashEntriesIterator.doNotMap(arg0Value, hostClassCache_1);
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            private boolean isIdenticalOrUndefinedFallbackGuard_(int state_5, HostObject arg0Value, Object arg1Value) {
                return (state_5 & 0x800) != 0 || !(arg1Value instanceof HostObject);
            }

            @Override
            protected TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_5 = this.state_5_;
                if ((state_5 & 0x1800) != 0) {
                    if ((state_5 & 0x800) != 0 && arg1Value instanceof HostObject) {
                        HostObject arg1Value_ = (HostObject)arg1Value;
                        return HostObject.IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                    }
                    if ((state_5 & 0x1000) != 0 && this.isIdenticalOrUndefinedFallbackGuard_(state_5, arg0Value, arg1Value)) {
                        return HostObject.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isIdenticalOrUndefinedAndSpecialize(arg0Value, arg1Value);
            }

            private TriState isIdenticalOrUndefinedAndSpecialize(HostObject arg0Value, Object arg1Value) {
                int state_5 = this.state_5_;
                if (arg1Value instanceof HostObject) {
                    HostObject arg1Value_ = (HostObject)arg1Value;
                    this.state_5_ = state_5 |= 0x800;
                    return HostObject.IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                }
                this.state_5_ = state_5 |= 0x1000;
                return HostObject.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
            }

            @Override
            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostObject)receiver).hasMembers();
            }

            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostObject)receiver).getMembers(includeInternal);
            }

            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                ReadMemberNode_ReadMemberData s0_ = this.readMemberNode__readMember_cache;
                if (s0_ != null) {
                    ReadMemberNode_ReadMemberData node__ = s0_;
                    return arg0Value.readMember(arg1Value, node__, INLINED_READ_MEMBER_LOOKUP_FIELD, INLINED_READ_MEMBER_READ_FIELD, INLINED_READ_MEMBER_LOOKUP_METHOD, INLINED_READ_MEMBER_NODE__READ_MEMBER_LOOKUP_INNER_CLASS_, INLINED_READ_MEMBER_ERROR);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object readMemberNode_AndSpecialize(HostObject arg0Value, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                ReadMemberNode_ReadMemberData s0_;
                ReadMemberNode_ReadMemberData node__ = null;
                node__ = s0_ = this.insert(new ReadMemberNode_ReadMemberData());
                VarHandle.storeStoreFence();
                this.readMemberNode__readMember_cache = s0_;
                return arg0Value.readMember(arg1Value, node__, INLINED_READ_MEMBER_LOOKUP_FIELD, INLINED_READ_MEMBER_READ_FIELD, INLINED_READ_MEMBER_LOOKUP_METHOD, INLINED_READ_MEMBER_NODE__READ_MEMBER_LOOKUP_INNER_CLASS_, INLINED_READ_MEMBER_ERROR);
            }

            @Override
            public boolean isMemberInsertable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostObject)receiver).isMemberInsertable(member);
            }

            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                WriteMemberNode_WriteMemberData s0_ = this.writeMemberNode__writeMember_cache;
                if (s0_ != null) {
                    WriteMemberNode_WriteMemberData node__ = s0_;
                    arg0Value.writeMember(arg1Value, arg2Value, node__, INLINED_WRITE_MEMBER_LOOKUP_FIELD, INLINED_WRITE_MEMBER_NODE__WRITE_MEMBER_WRITE_FIELD_, INLINED_WRITE_MEMBER_ERROR);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeMemberNode_AndSpecialize(HostObject arg0Value, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                WriteMemberNode_WriteMemberData s0_;
                WriteMemberNode_WriteMemberData node__ = null;
                node__ = s0_ = this.insert(new WriteMemberNode_WriteMemberData());
                VarHandle.storeStoreFence();
                this.writeMemberNode__writeMember_cache = s0_;
                arg0Value.writeMember(arg1Value, arg2Value, node__, INLINED_WRITE_MEMBER_LOOKUP_FIELD, INLINED_WRITE_MEMBER_NODE__WRITE_MEMBER_WRITE_FIELD_, INLINED_WRITE_MEMBER_ERROR);
            }

            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                InteropLibrary fieldValues__;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_5 = this.state_5_;
                if ((state_5 & 0x2000) != 0 && (fieldValues__ = this.invokeMemberNode__invokeMember_fieldValues_) != null) {
                    Cached node__ = this;
                    return arg0Value.invokeMember(arg1Value, arg2Value, node__, INLINED_LOOKUP_METHOD, INLINED_HOST_EXECUTE, INLINED_LOOKUP_FIELD, INLINED_READ_FIELD, fieldValues__, INLINED_ERROR);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.invokeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object invokeMemberNode_AndSpecialize(HostObject arg0Value, String arg1Value, Object[] arg2Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException, UnknownIdentifierException {
                int state_5 = this.state_5_;
                Cached node__ = null;
                node__ = this;
                InteropLibrary fieldValues__ = this.insert(INTEROP_LIBRARY_.createDispatched(5));
                Objects.requireNonNull(fieldValues__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.invokeMemberNode__invokeMember_fieldValues_ = fieldValues__;
                this.state_5_ = state_5 |= 0x2000;
                return arg0Value.invokeMember(arg1Value, arg2Value, node__, INLINED_LOOKUP_METHOD, INLINED_HOST_EXECUTE, INLINED_LOOKUP_FIELD, INLINED_READ_FIELD, fieldValues__, INLINED_ERROR);
            }

            @Override
            public boolean isNull(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostObject)receiver).isNull();
            }

            @Override
            public boolean isExecutable(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                Cached node__ = this;
                return arg0Value.isExecutable(node__, INLINED_LOOKUP_FUNCTIONAL_METHOD);
            }

            @Override
            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                Cached node__ = this;
                return arg0Value.execute(arg1Value, node__, INLINED_HOST_EXECUTE, INLINED_LOOKUP_FUNCTIONAL_METHOD, INLINED_ERROR);
            }

            @Override
            public boolean isString(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                Cached node__ = this;
                return arg0Value.isString(node__, INLINED_CLASS_PROFILE);
            }

            @Override
            public String asString(Object arg0Value_) throws UnsupportedMessageException {
                InteropLibrary numbers_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                int state_5 = this.state_5_;
                if ((state_5 & 0x4000) != 0 && (numbers_ = this.numbers) != null) {
                    Cached node__ = this;
                    Cached thisLibrary__ = this;
                    return arg0Value.asString(node__, thisLibrary__, numbers_, INLINED_ERROR);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asStringNode_AndSpecialize(arg0Value);
            }

            private String asStringNode_AndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                InteropLibrary numbers_;
                int state_5 = this.state_5_;
                Cached thisLibrary__ = null;
                Cached node__ = null;
                node__ = this;
                thisLibrary__ = this;
                InteropLibrary numbers__shared = this.numbers;
                if (numbers__shared != null) {
                    numbers_ = numbers__shared;
                } else {
                    numbers_ = this.insert(INTEROP_LIBRARY_.createDispatched(5));
                    if (numbers_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.numbers == null) {
                    VarHandle.storeStoreFence();
                    this.numbers = numbers_;
                }
                this.state_5_ = state_5 |= 0x4000;
                return arg0Value.asString(node__, thisLibrary__, numbers_, INLINED_ERROR);
            }

            @Override
            public boolean isBoolean(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostObject)receiver).isBoolean();
            }

            @Override
            public boolean asBoolean(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                Cached node__ = this;
                return arg0Value.asBoolean(node__, INLINED_ERROR);
            }

            @Override
            public boolean isDate(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostObject)receiver).isDate();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public LocalDate asDate(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostObject)receiver).asDate();
            }

            @Override
            public boolean isTime(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostObject)receiver).isTime();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public LocalTime asTime(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostObject)receiver).asTime();
            }

            @Override
            public boolean isTimeZone(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostObject)receiver).isTimeZone();
            }

            @Override
            public ZoneId asTimeZone(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostObject)receiver).asTimeZone();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Instant asInstant(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostObject)receiver).asInstant();
            }

            @Override
            public boolean isDuration(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostObject)receiver).isDuration();
            }

            @Override
            public Duration asDuration(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostObject)receiver).asDuration();
            }

            @Override
            public boolean isException(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostObject)receiver).isException();
            }

            @Override
            public ExceptionType getExceptionType(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                Cached node__ = this;
                return arg0Value.getExceptionType(node__, INLINED_ERROR);
            }

            @Override
            public boolean isExceptionIncompleteSource(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                Cached node__ = this;
                return arg0Value.isExceptionIncompleteSource(node__, INLINED_ERROR);
            }

            @Override
            public int getExceptionExitStatus(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                Cached node__ = this;
                return arg0Value.getExceptionExitStatus(node__, INLINED_ERROR);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasExceptionMessage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostObject)receiver).hasExceptionMessage();
            }

            @Override
            public Object getExceptionMessage(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                Cached node__ = this;
                return arg0Value.getExceptionMessage(node__, INLINED_ERROR);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasExceptionCause(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostObject)receiver).hasExceptionCause();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getExceptionCause(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostObject)receiver).getExceptionCause();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasExceptionStackTrace(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostObject)receiver).hasExceptionStackTrace();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getExceptionStackTrace(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostObject)receiver).getExceptionStackTrace();
            }

            @Override
            public RuntimeException throwException(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                Cached node__ = this;
                return arg0Value.throwException(node__, INLINED_ERROR);
            }

            @Override
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostObject)receiver).hasLanguage();
            }

            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostObject)receiver).getLanguage();
            }

            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostObject)receiver).toDisplayString(allowSideEffects);
            }

            @Override
            public boolean hasMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostObject)receiver).hasMetaObject();
            }

            @Override
            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostObject)receiver).getMetaObject();
            }

            @Override
            public boolean isMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostObject)receiver).isMetaObject();
            }

            @Override
            public Object getMetaQualifiedName(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostObject)receiver).getMetaQualifiedName();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getMetaSimpleName(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostObject)receiver).getMetaSimpleName();
            }

            @Override
            public boolean isMetaInstance(Object arg0Value_, Object arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostObject arg0Value = (HostObject)arg0Value_;
                Cached node__ = this;
                Cached library__ = this;
                return arg0Value.isMetaInstance(arg1Value, node__, library__, INLINED_ERROR);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasMetaParents(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostObject)receiver).hasMetaParents();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getMetaParents(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostObject)receiver).getMetaParents();
            }

            @Override
            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return HostObject.identityHashCode((HostObject)receiver);
            }

            @GeneratedBy(value=HostObject.class)
            @DenyReplace
            private static final class IsMemberReadableCachedData
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                final IsMemberReadableCachedData next_;
                @CompilerDirectives.CompilationFinal
                boolean cachedStatic_;
                @CompilerDirectives.CompilationFinal
                Class<?> cachedClazz_;
                @CompilerDirectives.CompilationFinal
                String cachedName_;
                @CompilerDirectives.CompilationFinal
                boolean cachedReadable_;

                IsMemberReadableCachedData(IsMemberReadableCachedData next_) {
                    this.next_ = next_;
                }
            }

            @GeneratedBy(value=HostObject.class)
            @DenyReplace
            private static final class IsMemberModifiableCachedData
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                final IsMemberModifiableCachedData next_;
                @CompilerDirectives.CompilationFinal
                boolean cachedStatic_;
                @CompilerDirectives.CompilationFinal
                Class<?> cachedClazz_;
                @CompilerDirectives.CompilationFinal
                String cachedName_;
                @CompilerDirectives.CompilationFinal
                boolean cachedModifiable_;

                IsMemberModifiableCachedData(IsMemberModifiableCachedData next_) {
                    this.next_ = next_;
                }
            }

            @GeneratedBy(value=HostObject.class)
            @DenyReplace
            private static final class IsMemberInternalCachedData
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                final IsMemberInternalCachedData next_;
                @CompilerDirectives.CompilationFinal
                boolean cachedStatic_;
                @CompilerDirectives.CompilationFinal
                Class<?> cachedClazz_;
                @CompilerDirectives.CompilationFinal
                String cachedName_;
                @CompilerDirectives.CompilationFinal
                boolean cachedInternal_;

                IsMemberInternalCachedData(IsMemberInternalCachedData next_) {
                    this.next_ = next_;
                }
            }

            @GeneratedBy(value=HostObject.class)
            @DenyReplace
            private static final class IsMemberInvocableCachedData
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                final IsMemberInvocableCachedData next_;
                @CompilerDirectives.CompilationFinal
                boolean cachedStatic_;
                @CompilerDirectives.CompilationFinal
                Class<?> cachedClazz_;
                @CompilerDirectives.CompilationFinal
                String cachedName_;
                @CompilerDirectives.CompilationFinal
                boolean cachedInvokable_;

                IsMemberInvocableCachedData(IsMemberInvocableCachedData next_) {
                    this.next_ = next_;
                }
            }

            @GeneratedBy(value=HostObject.class)
            @DenyReplace
            private static final class ReadMemberNode_ReadMemberData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int readMember_state_0_;
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private Object readMemberNode__readMember_lookupInnerClass__field1_;

                ReadMemberNode_ReadMemberData() {
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }

            @GeneratedBy(value=HostObject.class)
            @DenyReplace
            private static final class WriteMemberNode_WriteMemberData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int writeMember_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node writeMemberNode__writeMember_writeField__field1_;

                WriteMemberNode_WriteMemberData() {
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }
}

