/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj;

import com.mysql.cj.BindValue;
import com.mysql.cj.CancelQueryTask;
import com.mysql.cj.ClientPreparedQuery;
import com.mysql.cj.Messages;
import com.mysql.cj.NativeQueryBindValue;
import com.mysql.cj.NativeQueryBindings;
import com.mysql.cj.NativeSession;
import com.mysql.cj.QueryBindings;
import com.mysql.cj.ServerPreparedQueryTestcaseGenerator;
import com.mysql.cj.ServerVersion;
import com.mysql.cj.conf.PropertyKey;
import com.mysql.cj.conf.RuntimeProperty;
import com.mysql.cj.exceptions.CJException;
import com.mysql.cj.exceptions.ExceptionFactory;
import com.mysql.cj.exceptions.WrongArgumentException;
import com.mysql.cj.protocol.ColumnDefinition;
import com.mysql.cj.protocol.Message;
import com.mysql.cj.protocol.ProtocolEntityFactory;
import com.mysql.cj.protocol.Resultset;
import com.mysql.cj.protocol.a.ColumnDefinitionFactory;
import com.mysql.cj.protocol.a.NativeConstants;
import com.mysql.cj.protocol.a.NativeMessageBuilder;
import com.mysql.cj.protocol.a.NativePacketPayload;
import com.mysql.cj.result.Field;
import com.mysql.cj.telemetry.TelemetryAttribute;
import com.mysql.cj.telemetry.TelemetryScope;
import com.mysql.cj.telemetry.TelemetrySpan;
import com.mysql.cj.telemetry.TelemetrySpanName;
import com.mysql.cj.util.StringUtils;
import com.mysql.cj.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;

public class ServerPreparedQuery
extends ClientPreparedQuery {
    private static final int READ_BUFFER_SIZE = 8192;
    private static final byte OPEN_CURSOR_FLAG = 1;
    private static final byte PARAMETER_COUNT_AVAILABLE = 8;
    private long serverStatementId;
    private Field[] parameterFields;
    private ColumnDefinition resultFields;
    protected boolean profileSQL = false;
    protected boolean gatherPerfMetrics;
    protected boolean logSlowQueries = false;
    private boolean useAutoSlowLog;
    protected RuntimeProperty<Integer> slowQueryThresholdMillis;
    protected RuntimeProperty<Boolean> explainSlowQueries;
    protected boolean useCursorFetch = false;
    protected boolean queryWasSlow = false;
    protected NativeMessageBuilder commandBuilder = null;

    public static ServerPreparedQuery getInstance(NativeSession sess) {
        if (sess.getPropertySet().getBooleanProperty(PropertyKey.autoGenerateTestcaseScript).getValue().booleanValue()) {
            return new ServerPreparedQueryTestcaseGenerator(sess);
        }
        return new ServerPreparedQuery(sess);
    }

    protected ServerPreparedQuery(NativeSession sess) {
        super(sess);
        this.profileSQL = sess.getPropertySet().getBooleanProperty(PropertyKey.profileSQL).getValue();
        this.gatherPerfMetrics = sess.getPropertySet().getBooleanProperty(PropertyKey.gatherPerfMetrics).getValue();
        this.logSlowQueries = sess.getPropertySet().getBooleanProperty(PropertyKey.logSlowQueries).getValue();
        this.useAutoSlowLog = sess.getPropertySet().getBooleanProperty(PropertyKey.autoSlowLog).getValue();
        this.slowQueryThresholdMillis = sess.getPropertySet().getIntegerProperty(PropertyKey.slowQueryThresholdMillis);
        this.explainSlowQueries = sess.getPropertySet().getBooleanProperty(PropertyKey.explainSlowQueries);
        this.useCursorFetch = sess.getPropertySet().getBooleanProperty(PropertyKey.useCursorFetch).getValue();
        this.commandBuilder = (NativeMessageBuilder)sess.getProtocol().getMessageBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverPrepare(String sql) throws IOException {
        this.session.checkClosed();
        this.session.getSessionLock().lock();
        try {
            boolean checkEOF;
            long begin = this.profileSQL ? System.currentTimeMillis() : 0L;
            NativePacketPayload prepareResultPacket = this.session.getProtocol().sendCommand(this.commandBuilder.buildComStmtPrepare(this.session.getSharedSendPacket(), sql, this.session.getPropertySet().getStringProperty(PropertyKey.characterEncoding).getValue()), false, 0);
            prepareResultPacket.setPosition(1);
            this.serverStatementId = prepareResultPacket.readInteger(NativeConstants.IntegerDataType.INT4);
            int fieldCount = (int)prepareResultPacket.readInteger(NativeConstants.IntegerDataType.INT2);
            this.setParameterCount((int)prepareResultPacket.readInteger(NativeConstants.IntegerDataType.INT2));
            this.queryBindings = new NativeQueryBindings(this.parameterCount, this.session, NativeQueryBindValue::new);
            if (this.gatherPerfMetrics) {
                this.session.getProtocol().getMetricsHolder().incrementNumberOfPrepares();
            }
            if (this.profileSQL) {
                this.session.getProfilerEventHandler().processEvent((byte)2, this.session, this, null, this.session.getCurrentTimeNanosOrMillis() - begin, new Throwable(), this.truncateQueryToLog(sql));
            }
            boolean bl = checkEOF = !this.session.getServerSession().isEOFDeprecated();
            if (this.parameterCount > 0) {
                ColumnDefinition columnDefinitions = this.session.getProtocol().read(ColumnDefinition.class, new ColumnDefinitionFactory(this.parameterCount, null));
                this.queryBindings.setColumnDefinition(columnDefinitions);
                this.parameterFields = columnDefinitions.getFields();
                if (checkEOF && this.session.getProtocol().probeMessage(null).isEOFPacket()) {
                    this.session.getProtocol().skipPacket();
                }
            }
            if (fieldCount > 0) {
                this.resultFields = this.session.getProtocol().read(ColumnDefinition.class, new ColumnDefinitionFactory(fieldCount, null));
                if (checkEOF && this.session.getProtocol().probeMessage(null).isEOFPacket()) {
                    this.session.getProtocol().skipPacket();
                }
            }
        }
        finally {
            this.session.getSessionLock().unlock();
        }
    }

    @Override
    public void statementBegins() {
        super.statementBegins();
        this.queryWasSlow = false;
    }

    public <T extends Resultset> T serverExecute(int maxRowsToRetrieve, boolean createStreamingResultSet, ColumnDefinition metadata, ProtocolEntityFactory<T, NativePacketPayload> resultSetFactory) {
        Object interceptedResults;
        if (this.session.shouldIntercept() && (interceptedResults = this.session.invokeQueryInterceptorsPre(this::getOriginalSql, this, true)) != null) {
            return interceptedResults;
        }
        String queryAsString = this.profileSQL || this.logSlowQueries || this.gatherPerfMetrics ? this.asSql() : "";
        return this.readExecuteResult(this.sendExecutePacket(this.prepareExecutePacket(), queryAsString), maxRowsToRetrieve, createStreamingResultSet, metadata, resultSetFactory, queryAsString);
    }

    public NativePacketPayload prepareExecutePacket() {
        BindValue[] bindValues = this.queryBindings.getBindValues();
        if (this.queryBindings.isLongParameterSwitchDetected()) {
            boolean firstFound = false;
            long boundTimeToCheck = 0L;
            for (int i = 0; i < this.parameterCount - 1; ++i) {
                if (!bindValues[i].isStream()) continue;
                if (firstFound && boundTimeToCheck != bindValues[i].getBoundBeforeExecutionNum()) {
                    throw ExceptionFactory.createException(Messages.getString("ServerPreparedStatement.11") + Messages.getString("ServerPreparedStatement.12"), "S1C00", 0, true, null, this.session.getExceptionInterceptor());
                }
                firstFound = true;
                boundTimeToCheck = bindValues[i].getBoundBeforeExecutionNum();
            }
            this.serverResetStatement();
        }
        this.queryBindings.checkAllParametersSet();
        for (int i = 0; i < this.parameterCount; ++i) {
            if (!bindValues[i].isStream()) continue;
            this.serverLongData(i, bindValues[i]);
        }
        boolean sendQueryAttributes = false;
        if (this.session.getServerSession().supportsQueryAttributes()) {
            sendQueryAttributes = this.session.getServerSession().getServerVersion().meetsMinimum(new ServerVersion(8, 0, 26));
        } else if (this.queryAttributesBindings.getCount() > 0) {
            this.session.getLog().logWarn(Messages.getString("QueryAttributes.SetButNotSupported"));
        }
        byte flags = 0;
        if (this.resultFields != null && this.resultFields.getFields() != null && this.useCursorFetch && this.resultSetType == Resultset.Type.FORWARD_ONLY && this.fetchSize > 0) {
            flags = (byte)(flags | 1);
        }
        if (sendQueryAttributes) {
            flags = (byte)(flags | 8);
        }
        return this.commandBuilder.buildComStmtExecute(this.session.getSharedSendPacket(), this.serverStatementId, flags, sendQueryAttributes, this);
    }

    public NativePacketPayload sendExecutePacket(NativePacketPayload packet, String queryAsString) {
        long begin = this.session.getCurrentTimeNanosOrMillis();
        this.resetCancelledState();
        CancelQueryTask timeoutTask = null;
        try {
            timeoutTask = this.startQueryTimer(this, this.timeoutInMillis);
            this.statementBegins();
            NativePacketPayload resultPacket = this.session.getProtocol().sendCommand(packet, false, 0);
            long queryEndTime = this.session.getCurrentTimeNanosOrMillis();
            if (timeoutTask != null) {
                this.stopQueryTimer(timeoutTask, true, true);
                timeoutTask = null;
            }
            long executeTime = queryEndTime - begin;
            this.setExecuteTime(executeTime);
            if (this.logSlowQueries) {
                boolean bl = this.useAutoSlowLog ? this.session.getProtocol().getMetricsHolder().checkAbonormallyLongQuery(executeTime) : (this.queryWasSlow = executeTime > (long)this.slowQueryThresholdMillis.getValue().intValue());
                if (this.queryWasSlow) {
                    this.session.getProfilerEventHandler().processEvent((byte)6, this.session, this, null, executeTime, new Throwable(), Messages.getString("ServerPreparedStatement.15", new String[]{String.valueOf(this.session.getSlowQueryThreshold()), String.valueOf(executeTime), this.originalSql, queryAsString}));
                }
            }
            if (this.gatherPerfMetrics) {
                this.session.getProtocol().getMetricsHolder().registerQueryExecutionTime(executeTime);
                this.session.getProtocol().getMetricsHolder().incrementNumberOfPreparedExecutes();
            }
            if (this.profileSQL) {
                this.session.getProfilerEventHandler().processEvent((byte)4, this.session, this, null, executeTime, new Throwable(), this.truncateQueryToLog(queryAsString));
            }
            NativePacketPayload nativePacketPayload = resultPacket;
            return nativePacketPayload;
        }
        catch (CJException sqlEx) {
            if (this.session.shouldIntercept()) {
                this.session.invokeQueryInterceptorsPost(this::getOriginalSql, this, null, true);
            }
            throw sqlEx;
        }
        finally {
            this.statementExecuting.set(false);
            this.stopQueryTimer(timeoutTask, false, false);
        }
    }

    public <T extends Resultset> T readExecuteResult(NativePacketPayload resultPacket, int maxRowsToRetrieve, boolean createStreamingResultSet, ColumnDefinition metadata, ProtocolEntityFactory<T, NativePacketPayload> resultSetFactory, String queryAsString) {
        try {
            T interceptedResults;
            long fetchStartTime = this.profileSQL ? this.session.getCurrentTimeNanosOrMillis() : 0L;
            T rs = this.session.getProtocol().readAllResults(maxRowsToRetrieve, createStreamingResultSet, resultPacket, true, metadata != null ? metadata : this.resultFields, resultSetFactory);
            if (this.session.shouldIntercept() && (interceptedResults = this.session.invokeQueryInterceptorsPost(this::getOriginalSql, this, rs, true)) != null) {
                rs = interceptedResults;
            }
            if (this.profileSQL) {
                this.session.getProfilerEventHandler().processEvent((byte)5, this.session, this, (Resultset)rs, this.session.getCurrentTimeNanosOrMillis() - fetchStartTime, new Throwable(), null);
            }
            if (this.queryWasSlow && this.explainSlowQueries.getValue().booleanValue()) {
                this.session.getProtocol().explainSlowQuery(queryAsString, queryAsString);
            }
            this.queryBindings.getSendTypesToServer().set(false);
            if (this.session.hadWarnings()) {
                this.session.getProtocol().scanForAndThrowDataTruncation();
            }
            return rs;
        }
        catch (IOException ioEx) {
            throw ExceptionFactory.createCommunicationsException(this.session.getPropertySet(), this.session.getServerSession(), this.session.getProtocol().getPacketSentTimeHolder(), this.session.getProtocol().getPacketReceivedTimeHolder(), ioEx, this.session.getExceptionInterceptor());
        }
        catch (CJException sqlEx) {
            if (this.session.shouldIntercept()) {
                this.session.invokeQueryInterceptorsPost(this::getOriginalSql, this, null, true);
            }
            throw sqlEx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverLongData(int parameterIndex, BindValue binding) {
        block31: {
            this.lock.lock();
            try {
                TelemetrySpan span = this.session.getTelemetryHandler().startSpan(TelemetrySpanName.STMT_SEND_LONG_DATA, new Object[0]);
                try (TelemetryScope scope = span.makeCurrent();){
                    String dbOperation = this.getQueryInfo().getStatementKeyword();
                    span.setAttribute(TelemetryAttribute.DB_NAME, this::getCurrentDatabase);
                    span.setAttribute(TelemetryAttribute.DB_OPERATION, dbOperation);
                    span.setAttribute(TelemetryAttribute.DB_STATEMENT, dbOperation + " (...)");
                    span.setAttribute(TelemetryAttribute.DB_SYSTEM, "mysql");
                    span.setAttribute(TelemetryAttribute.DB_USER, () -> this.session.getHostInfo().getUser());
                    span.setAttribute(TelemetryAttribute.THREAD_ID, () -> Thread.currentThread().getId());
                    span.setAttribute(TelemetryAttribute.THREAD_NAME, () -> Thread.currentThread().getName());
                    NativePacketPayload packet = this.session.getSharedSendPacket();
                    Object value = binding.getValue();
                    if (value instanceof byte[]) {
                        this.session.getProtocol().sendCommand(this.commandBuilder.buildComStmtSendLongData(packet, this.serverStatementId, parameterIndex, (byte[])value), true, 0);
                        break block31;
                    }
                    if (value instanceof InputStream) {
                        this.storeStream(parameterIndex, packet, (InputStream)value, binding.getScaleOrLength());
                        break block31;
                    }
                    if (value instanceof Blob) {
                        try {
                            this.storeStream(parameterIndex, packet, ((Blob)value).getBinaryStream(), binding.getScaleOrLength());
                            break block31;
                        }
                        catch (Throwable t) {
                            throw ExceptionFactory.createException(t.getMessage(), this.session.getExceptionInterceptor());
                        }
                    }
                    if (value instanceof Reader) {
                        if (binding.isNational() && !this.charEncoding.equalsIgnoreCase("UTF-8") && !this.charEncoding.equalsIgnoreCase("utf8")) {
                            throw ExceptionFactory.createException(Messages.getString("ServerPreparedStatement.31"), this.session.getExceptionInterceptor());
                        }
                        this.storeReader(parameterIndex, packet, (Reader)value, binding.getScaleOrLength());
                        break block31;
                    }
                    if (value instanceof Clob) {
                        if (binding.isNational() && !this.charEncoding.equalsIgnoreCase("UTF-8") && !this.charEncoding.equalsIgnoreCase("utf8")) {
                            throw ExceptionFactory.createException(Messages.getString("ServerPreparedStatement.31"), this.session.getExceptionInterceptor());
                        }
                        try {
                            this.storeReader(parameterIndex, packet, ((Clob)value).getCharacterStream(), binding.getScaleOrLength());
                            break block31;
                        }
                        catch (Throwable t) {
                            throw ExceptionFactory.createException(t.getMessage(), t);
                        }
                    }
                    throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ServerPreparedStatement.18") + value.getClass().getName() + "'", this.session.getExceptionInterceptor());
                }
                catch (Throwable t) {
                    span.setError(t);
                    throw t;
                }
                finally {
                    span.end();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void closeQuery() {
        this.queryBindings = null;
        this.parameterFields = null;
        this.resultFields = null;
        super.closeQuery();
    }

    public long getServerStatementId() {
        return this.serverStatementId;
    }

    public void setServerStatementId(long serverStatementId) {
        this.serverStatementId = serverStatementId;
    }

    public Field[] getParameterFields() {
        return this.parameterFields;
    }

    public void setParameterFields(Field[] parameterFields) {
        this.parameterFields = parameterFields;
    }

    public ColumnDefinition getResultFields() {
        return this.resultFields;
    }

    public void setResultFields(ColumnDefinition resultFields) {
        this.resultFields = resultFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeStream(int parameterIndex, NativePacketPayload packet, InputStream inStream, long length) {
        this.session.checkClosed();
        this.session.getSessionLock().lock();
        try {
            inStream.mark(Integer.MAX_VALUE);
            boolean limitLength = length == -1L ? false : this.session.getPropertySet().getBooleanProperty(PropertyKey.useStreamLengthsInPrepStmts).getValue();
            int sendThreshold = this.session.getPropertySet().getMemorySizeProperty(PropertyKey.blobSendChunkSize).getValue();
            byte[] buffer = new byte[8192];
            boolean dataSent = false;
            int bytesRead = 0;
            int bytesInPacket = 0;
            long lengthLeft = length;
            do {
                if (bytesInPacket == 0) {
                    packet.setPosition(0);
                    this.commandBuilder.buildComStmtSendLongDataHeader(packet, this.serverStatementId, parameterIndex);
                }
                if (limitLength) {
                    bytesRead = Util.readBlock(inStream, buffer, lengthLeft, this.session.getExceptionInterceptor());
                    lengthLeft -= (long)bytesRead;
                } else {
                    bytesRead = Util.readBlock(inStream, buffer, this.session.getExceptionInterceptor());
                }
                if (bytesRead > 0) {
                    packet.writeBytes(NativeConstants.StringLengthDataType.STRING_FIXED, buffer, 0, bytesRead);
                    bytesInPacket += bytesRead;
                }
                if (bytesInPacket < sendThreshold && (bytesRead > 0 || dataSent && bytesInPacket <= 0)) continue;
                this.session.getProtocol().sendCommand(packet, true, 0);
                dataSent = true;
                bytesInPacket = 0;
            } while (bytesRead > 0);
        }
        finally {
            try {
                inStream.reset();
            }
            catch (IOException iOException) {}
            if (((Boolean)this.autoClosePStmtStreams.getValue()).booleanValue() && inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
            this.session.getSessionLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeReader(int parameterIndex, NativePacketPayload packet, Reader reader, long length) {
        this.session.checkClosed();
        this.session.getSessionLock().lock();
        try {
            try {
                reader.mark(Integer.MAX_VALUE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String clobEncoding = this.session.getPropertySet().getStringProperty(PropertyKey.clobCharacterEncoding).getStringValue();
            if (clobEncoding == null) {
                clobEncoding = this.session.getPropertySet().getStringProperty(PropertyKey.characterEncoding).getValue();
            }
            boolean limitLength = length == -1L ? false : this.session.getPropertySet().getBooleanProperty(PropertyKey.useStreamLengthsInPrepStmts).getValue();
            int sendThreshold = this.session.getPropertySet().getMemorySizeProperty(PropertyKey.blobSendChunkSize).getValue();
            char[] buffer = new char[8192];
            boolean dataSent = false;
            int charsRead = 0;
            int bytesInPacket = 0;
            long lengthLeft = length;
            do {
                if (bytesInPacket == 0) {
                    packet.setPosition(0);
                    this.commandBuilder.buildComStmtSendLongDataHeader(packet, this.serverStatementId, parameterIndex);
                }
                if (limitLength) {
                    charsRead = Util.readBlock(reader, buffer, lengthLeft, this.session.getExceptionInterceptor());
                    lengthLeft -= (long)charsRead;
                } else {
                    charsRead = Util.readBlock(reader, buffer, this.session.getExceptionInterceptor());
                }
                if (charsRead > 0) {
                    byte[] charsAsBytes = StringUtils.getBytes(buffer, 0, charsRead, clobEncoding);
                    packet.writeBytes(NativeConstants.StringSelfDataType.STRING_EOF, charsAsBytes);
                    bytesInPacket += charsAsBytes.length;
                }
                if (bytesInPacket < sendThreshold && (charsRead > 0 || dataSent && bytesInPacket <= 0)) continue;
                this.session.getProtocol().sendCommand(packet, true, 0);
                dataSent = true;
                bytesInPacket = 0;
            } while (charsRead > 0);
        }
        finally {
            try {
                reader.reset();
            }
            catch (IOException iOException) {}
            if (((Boolean)this.autoClosePStmtStreams.getValue()).booleanValue() && reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            this.session.getSessionLock().unlock();
        }
    }

    public void clearParameters(boolean clearServerParameters) {
        boolean hadLongData = false;
        if (this.queryBindings != null) {
            hadLongData = this.queryBindings.clearBindValues();
            this.queryBindings.setLongParameterSwitchDetected(clearServerParameters && hadLongData);
        }
        if (clearServerParameters && hadLongData) {
            this.serverResetStatement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverResetStatement() {
        this.session.checkClosed();
        this.session.getSessionLock().lock();
        try {
            TelemetrySpan span = this.session.getTelemetryHandler().startSpan(TelemetrySpanName.STMT_RESET_PREPARED, new Object[0]);
            try (TelemetryScope scope = span.makeCurrent();){
                String dbOperation = this.getQueryInfo().getStatementKeyword();
                span.setAttribute(TelemetryAttribute.DB_NAME, this::getCurrentDatabase);
                span.setAttribute(TelemetryAttribute.DB_OPERATION, dbOperation);
                span.setAttribute(TelemetryAttribute.DB_STATEMENT, dbOperation + " (...)");
                span.setAttribute(TelemetryAttribute.DB_SYSTEM, "mysql");
                span.setAttribute(TelemetryAttribute.DB_USER, () -> this.session.getHostInfo().getUser());
                span.setAttribute(TelemetryAttribute.THREAD_ID, () -> Thread.currentThread().getId());
                span.setAttribute(TelemetryAttribute.THREAD_NAME, () -> Thread.currentThread().getName());
                try {
                    this.session.getProtocol().sendCommand(this.commandBuilder.buildComStmtReset(this.session.getSharedSendPacket(), this.serverStatementId), false, 0);
                }
                finally {
                    this.session.getProtocol().getServerSession().preserveOldTransactionState();
                    this.session.clearInputStream();
                }
                this.queryBindings.setLongParameterSwitchDetected(false);
            }
            catch (Throwable t) {
                span.setError(t);
                throw t;
            }
            finally {
                span.end();
            }
        }
        finally {
            this.session.getSessionLock().unlock();
        }
    }

    @Override
    protected long[] computeMaxParameterSetSizeAndBatchSize(int numBatchedArgs) {
        int i;
        long maxSizeOfParameterSet = 0L;
        long sizeOfEntireBatch = 11L;
        boolean supportsQueryAttributes = this.session.getServerSession().supportsQueryAttributes();
        if (supportsQueryAttributes) {
            sizeOfEntireBatch += 9L;
            sizeOfEntireBatch += (long)((this.queryAttributesBindings.getCount() + 7) / 8);
            for (i = 0; i < this.queryAttributesBindings.getCount(); ++i) {
                BindValue queryAttribute = this.queryAttributesBindings.getAttributeValue(i);
                sizeOfEntireBatch += (long)(2 + queryAttribute.getName().length()) + queryAttribute.getBinaryLength();
            }
        }
        for (i = 0; i < numBatchedArgs; ++i) {
            long sizeOfParameterSet = (this.parameterCount + 7) / 8 + this.parameterCount * 2;
            if (supportsQueryAttributes) {
                sizeOfParameterSet += (long)this.parameterCount;
            }
            BindValue[] bindValues = ((QueryBindings)this.batchedArgs.get(i)).getBindValues();
            for (int j = 0; j < bindValues.length; ++j) {
                sizeOfParameterSet += bindValues[j].getBinaryLength();
            }
            sizeOfEntireBatch += sizeOfParameterSet;
            if (sizeOfParameterSet <= maxSizeOfParameterSet) continue;
            maxSizeOfParameterSet = sizeOfParameterSet;
        }
        return new long[]{maxSizeOfParameterSet, sizeOfEntireBatch};
    }

    private String truncateQueryToLog(String sql) {
        String queryStr = null;
        int maxQuerySizeToLog = this.session.getPropertySet().getIntegerProperty(PropertyKey.maxQuerySizeToLog).getValue();
        if (sql.length() > maxQuerySizeToLog) {
            StringBuilder queryBuf = new StringBuilder(maxQuerySizeToLog + 12);
            queryBuf.append(sql.substring(0, maxQuerySizeToLog));
            queryBuf.append(Messages.getString("MysqlIO.25"));
            queryStr = queryBuf.toString();
        } else {
            queryStr = sql;
        }
        return queryStr;
    }

    @Override
    public <M extends Message> M fillSendPacket(QueryBindings bindings) {
        return null;
    }
}

