/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.spi.util;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.NeverDefault;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public final class ProfiledArrayBuilder<T> {
    private T[] storage;
    private int size;
    private final ArraySizeMemento memento;

    private ProfiledArrayBuilder(T[] storage, ArraySizeMemento memento) {
        this.storage = storage;
        this.size = 0;
        this.memento = memento;
    }

    public int getSize() {
        return this.size;
    }

    public void add(T obj) {
        if (this.size >= this.storage.length) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.storage = Arrays.copyOf(this.storage, (this.storage.length + 5) * 2);
        }
        this.storage[this.size++] = obj;
    }

    public T[] getFinalArray() {
        T[] ret = this.storage;
        this.storage = null;
        if (this.memento != null) {
            this.memento.feedbackProfile(this.size);
        }
        return ret;
    }

    private static final class ArraySizeMemento {
        @CompilerDirectives.CompilationFinal
        volatile int profiledInitialSize = 0;
        @CompilerDirectives.CompilationFinal
        volatile Assumption assumption = Truffle.getRuntime().createAssumption("ProfiledArrayBuilder");
        private static final AtomicIntegerFieldUpdater<ArraySizeMemento> SIZE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ArraySizeMemento.class, "profiledInitialSize");
        private static final AtomicReferenceFieldUpdater<ArraySizeMemento, Assumption> ASSUMPTION_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ArraySizeMemento.class, Assumption.class, "assumption");

        private ArraySizeMemento() {
        }

        void feedbackProfile(int newSize) {
            if (newSize > this.profiledInitialSize) {
                int oldProfiledInitialSize;
                CompilerDirectives.transferToInterpreterAndInvalidate();
                do {
                    if (newSize > (oldProfiledInitialSize = this.profiledInitialSize)) continue;
                    return;
                } while (!SIZE_UPDATER.compareAndSet(this, oldProfiledInitialSize, newSize));
                Assumption newAssumption = Truffle.getRuntime().createAssumption("ProfiledArrayBuilder");
                Assumption oldAssumption = ASSUMPTION_UPDATER.getAndSet(this, newAssumption);
                oldAssumption.invalidate();
            }
        }
    }

    private static final class UncachedArrayBuilderFactory
    extends ArrayBuilderFactory {
        private static final UncachedArrayBuilderFactory INSTANCE = new UncachedArrayBuilderFactory();
        private static final int UNCACHED_INITIAL_SIZE = 10;

        private UncachedArrayBuilderFactory() {
        }

        @Override
        public <T> ProfiledArrayBuilder<T> allocate(ArrayFactory<T> factory) {
            return new ProfiledArrayBuilder<T>(factory.create(10), null);
        }
    }

    private static final class ProfiledArrayBuilderFactory
    extends ArrayBuilderFactory {
        final ArraySizeMemento memento = new ArraySizeMemento();

        private ProfiledArrayBuilderFactory() {
        }

        @Override
        public <T> ProfiledArrayBuilder<T> allocate(ArrayFactory<T> factory) {
            if (!this.memento.assumption.isValid()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return new ProfiledArrayBuilder<T>(factory.create(this.memento.profiledInitialSize), this.memento);
        }
    }

    public static abstract class ArrayBuilderFactory {
        @NeverDefault
        public static ArrayBuilderFactory create() {
            return new ProfiledArrayBuilderFactory();
        }

        public static ArrayBuilderFactory getUncached() {
            return UncachedArrayBuilderFactory.INSTANCE;
        }

        public abstract <T> ProfiledArrayBuilder<T> allocate(ArrayFactory<T> var1);

        private ArrayBuilderFactory() {
        }
    }

    @FunctionalInterface
    public static interface ArrayFactory<T> {
        public T[] create(int var1);
    }
}

