/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.function.builtins.clinic;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ClinicConverterFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.floats.PFloat;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentCastNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.JavaDoubleConversionNodeGen;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

public abstract class JavaDoubleConversionNode
extends ArgumentCastNode {
    private final double defaultValue;
    final boolean useDefaultForNone;

    protected JavaDoubleConversionNode(double defaultValue, boolean useDefaultForNone) {
        this.defaultValue = defaultValue;
        this.useDefaultForNone = useDefaultForNone;
    }

    @Specialization(guards={"!useDefaultForNone", "isNoValue(none)"})
    double doNoValue(PNone none) {
        return this.defaultValue;
    }

    @Specialization(guards={"useDefaultForNone"})
    double doNoValueAndNone(PNone none) {
        return this.defaultValue;
    }

    @Specialization
    static double doDouble(double d) {
        return d;
    }

    @Specialization
    static double doPFloat(PFloat l) {
        return l.getValue();
    }

    @Specialization(guards={"!isHandledPNone(value)"})
    static double doOthers(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Cached PyFloatAsDoubleNode asDoubleNode) {
        return asDoubleNode.execute(frame, inliningTarget, value);
    }

    @ClinicConverterFactory(shortCircuitPrimitive={ArgumentClinic.PrimitiveType.Double})
    @NeverDefault
    public static JavaDoubleConversionNode create(@ClinicConverterFactory.DefaultValue double defaultValue, @ClinicConverterFactory.UseDefaultForNone boolean useDefaultForNone) {
        return JavaDoubleConversionNodeGen.create(defaultValue, useDefaultForNone);
    }

    @ClinicConverterFactory(shortCircuitPrimitive={ArgumentClinic.PrimitiveType.Double})
    @NeverDefault
    public static JavaDoubleConversionNode create(@ClinicConverterFactory.UseDefaultForNone boolean useDefaultForNone) {
        assert (!useDefaultForNone) : "defaultValue must be provided if useDefaultForNone is true";
        return JavaDoubleConversionNodeGen.create(0.0, false);
    }

    protected boolean isHandledPNone(Object value) {
        return JavaDoubleConversionNode.isHandledPNone(this.useDefaultForNone, value);
    }
}

