/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.fields;

import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptor;

public final class RowDescriptorBuilder {
    private final DatatypeCoder datatypeCoder;
    private int type;
    private int subType;
    private int scale;
    private int length;
    private String fieldName;
    private String tableAlias;
    private String originalName;
    private String originalTableName;
    private String ownerName;
    private final FieldDescriptor[] fieldDescriptors;
    private int currentFieldIndex;

    public RowDescriptorBuilder(int size, DatatypeCoder datatypeCoder) {
        this.datatypeCoder = datatypeCoder;
        this.fieldDescriptors = new FieldDescriptor[size];
    }

    public int getSize() {
        return this.fieldDescriptors.length;
    }

    public RowDescriptorBuilder setType(int type) {
        this.type = type;
        return this;
    }

    public RowDescriptorBuilder setSubType(int subType) {
        this.subType = subType;
        return this;
    }

    public RowDescriptorBuilder setScale(int scale) {
        this.scale = scale;
        return this;
    }

    public RowDescriptorBuilder setLength(int length) {
        this.length = length;
        return this;
    }

    public RowDescriptorBuilder setFieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public RowDescriptorBuilder setTableAlias(String tableAlias) {
        this.tableAlias = tableAlias;
        return this;
    }

    public RowDescriptorBuilder setOriginalName(String originalName) {
        this.originalName = originalName;
        return this;
    }

    public RowDescriptorBuilder setOriginalTableName(String originalTableName) {
        this.originalTableName = originalTableName;
        return this;
    }

    public RowDescriptorBuilder setFieldIndex(int index) {
        if (index < 0 || index >= this.fieldDescriptors.length) {
            throw new IndexOutOfBoundsException(String.format("The index '%d' exceeds the expected size (%d) of this RowDescriptorBuilder", index, this.fieldDescriptors.length));
        }
        if (this.fieldDescriptors[index] != null) {
            throw new IllegalStateException(String.format("There is already a field at index '%d'", index));
        }
        this.currentFieldIndex = index;
        return this;
    }

    public RowDescriptorBuilder at(int index) {
        return this.setFieldIndex(index);
    }

    public int getCurrentFieldIndex() {
        return this.currentFieldIndex;
    }

    public RowDescriptorBuilder setOwnerName(String ownerName) {
        this.ownerName = ownerName;
        return this;
    }

    public RowDescriptorBuilder simple(int type, int length, String originalName, String originalTableName) {
        this.type = type;
        this.length = length;
        this.originalName = originalName;
        this.originalTableName = originalTableName;
        return this;
    }

    public FieldDescriptor toFieldDescriptor() {
        return new FieldDescriptor(this.currentFieldIndex, this.datatypeCoder, this.type, this.subType, this.scale, this.length, this.fieldName, this.tableAlias, this.originalName, this.originalTableName, this.ownerName);
    }

    public RowDescriptorBuilder resetField() {
        this.type = 0;
        this.subType = 0;
        this.scale = 0;
        this.length = 0;
        this.fieldName = null;
        this.tableAlias = null;
        this.originalName = null;
        this.originalTableName = null;
        this.ownerName = null;
        return this;
    }

    public RowDescriptorBuilder copyFieldFrom(FieldDescriptor sourceFieldDescriptor) {
        this.type = sourceFieldDescriptor.getType();
        this.subType = sourceFieldDescriptor.getSubType();
        this.scale = sourceFieldDescriptor.getScale();
        this.length = sourceFieldDescriptor.getLength();
        this.fieldName = sourceFieldDescriptor.getFieldName();
        this.tableAlias = sourceFieldDescriptor.getTableAlias();
        this.originalName = sourceFieldDescriptor.getOriginalName();
        this.originalTableName = sourceFieldDescriptor.getOriginalTableName();
        this.ownerName = sourceFieldDescriptor.getOwnerName();
        return this;
    }

    public RowDescriptorBuilder addField() {
        return this.addField(this.toFieldDescriptor()).resetField();
    }

    public RowDescriptorBuilder addField(FieldDescriptor fieldDescriptor) {
        if (this.currentFieldIndex >= this.fieldDescriptors.length) {
            throw new IndexOutOfBoundsException(String.format("The index '%d' exceeds the expected size (%d) of this RowDescriptorBuilder", this.currentFieldIndex, this.fieldDescriptors.length));
        }
        this.fieldDescriptors[this.currentFieldIndex] = fieldDescriptor;
        ++this.currentFieldIndex;
        return this;
    }

    public RowDescriptor toRowDescriptor() {
        return RowDescriptor.createRowDescriptor(this.fieldDescriptors, this.datatypeCoder);
    }

    public boolean isComplete() {
        for (FieldDescriptor fieldDescriptor : this.fieldDescriptors) {
            if (fieldDescriptor != null) continue;
            return false;
        }
        return true;
    }

    public int getFirstUnprocessedIndex() {
        for (int idx = 0; idx < this.fieldDescriptors.length; ++idx) {
            if (this.fieldDescriptors[idx] != null) continue;
            return idx;
        }
        return this.getSize();
    }
}

