/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jaybird.util.FbDatetimeConversion;
import org.firebirdsql.jdbc.field.AbstractWithoutTimeZoneField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.jspecify.annotations.NullMarked;

final class FBTimeField
extends AbstractWithoutTimeZoneField {
    @NullMarked
    FBTimeField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
    }

    @Override
    public Object getObject() throws SQLException {
        return this.getTime();
    }

    @Override
    public String getString() throws SQLException {
        return this.convertForGet(this.getLocalTime(), FbDatetimeConversion::formatSqlTime, String.class);
    }

    @Override
    LocalTime getLocalTime() throws SQLException {
        return this.getDatatypeCoder().decodeLocalTime(this.getFieldData());
    }

    @Override
    LocalDateTime getLocalDateTime() throws SQLException {
        LocalTime localTime = this.getLocalTime();
        return localTime != null ? localTime.atDate(LocalDate.EPOCH) : null;
    }

    @Override
    public void setString(String value) throws SQLException {
        this.setLocalTime(this.fromString(value, FbDatetimeConversion::parseSqlTime));
    }

    @Override
    void setLocalDateTime(LocalDateTime value) throws SQLException {
        this.setLocalTime(value != null ? value.toLocalTime() : null);
    }

    @Override
    void setLocalTime(LocalTime value) throws SQLException {
        this.setFieldData(this.getDatatypeCoder().encodeLocalTime(value));
    }
}

