/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.control;

import java.awt.EventQueue;
import java.awt.Frame;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.Strings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordSession;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SessionListener;
import org.parosproxy.paros.view.View;
import org.parosproxy.paros.view.WaitMessageDialog;
import org.zaproxy.zap.model.IllegalContextNameException;
import org.zaproxy.zap.utils.ZapHtmlLabel;
import org.zaproxy.zap.utils.ZapXmlConfiguration;
import org.zaproxy.zap.view.ContextExportDialog;
import org.zaproxy.zap.view.PersistSessionDialog;
import org.zaproxy.zap.view.SessionTableSelectDialog;
import org.zaproxy.zap.view.widgets.WritableFileChooser;

public class MenuFileControl
implements SessionListener {
    private static final Logger LOGGER = LogManager.getLogger(MenuFileControl.class);
    private View view = null;
    private Model model = null;
    private Control control = null;
    private WaitMessageDialog waitMessageDialog = null;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");

    public MenuFileControl(Model model, View view, Control control) {
        this.view = view;
        this.model = model;
        this.control = control;
    }

    public void exit() {
        this.control.exit(false, null);
    }

    public void newSession(boolean isPromptNewSession) throws ClassNotFoundException, Exception {
        if (isPromptNewSession) {
            if (!this.informStopActiveActions()) {
                return;
            }
            if (this.model.getSession().isNewState()) {
                if (this.view.showConfirmDialog(Constant.messages.getString("menu.file.discardSession")) != 0) {
                    return;
                }
                this.control.discardSession();
            } else if (this.view.showConfirmDialog(Constant.messages.getString("menu.file.closeSession")) != 0) {
                return;
            }
        }
        int newSessionOption = this.model.getOptionsParam().getDatabaseParam().getNewSessionOption();
        if (this.model.getOptionsParam().getDatabaseParam().isNewSessionPrompt()) {
            PersistSessionDialog psd = new PersistSessionDialog(View.getSingleton().getMainFrame());
            switch (newSessionOption) {
                case 1: {
                    psd.setTimestampChosen();
                    break;
                }
                case 2: {
                    psd.setPersistChosen();
                    break;
                }
                case 3: {
                    psd.setTemporaryChosen();
                    break;
                }
            }
            psd.setVisible(true);
            newSessionOption = psd.isTimestampChosen() ? 1 : (psd.isPersistChosen() ? 2 : 3);
            this.model.getOptionsParam().getDatabaseParam().setNewSessionOption(newSessionOption);
            this.model.getOptionsParam().getDatabaseParam().setNewSessionPrompt(!psd.isDontAskAgain());
        }
        switch (newSessionOption) {
            case 1: {
                String filename = this.getTimestampFilename();
                if (filename != null) {
                    this.newSession(filename);
                    break;
                }
                this.control.newSession();
                break;
            }
            case 2: {
                this.control.newSession();
                this.saveAsSession();
                break;
            }
            default: {
                this.control.newSession();
            }
        }
    }

    private boolean informStopActiveActions() {
        String message;
        String activeActions = MenuFileControl.wrapEntriesInLiTags(this.control.getExtensionLoader().getActiveActions());
        return activeActions.isEmpty() || this.view.showConfirmDialog(new ZapHtmlLabel(message = Constant.messages.getString("menu.file.session.activeactions", activeActions))) == 0;
    }

    private static String wrapEntriesInLiTags(List<String> entries) {
        if (entries.isEmpty()) {
            return "";
        }
        StringBuilder strBuilder = new StringBuilder(entries.size() * 15);
        for (String entry : entries) {
            strBuilder.append("<li>");
            strBuilder.append(entry);
            strBuilder.append("</li>");
        }
        return strBuilder.toString();
    }

    private String getTimestampFilename() {
        File dir = new File(Constant.getZapHome(), "sessions");
        if (!dir.exists() && !dir.mkdirs()) {
            return null;
        }
        String timestamp = this.dateFormat.format(new Date());
        File tmpFile = new File(dir, timestamp + ".session");
        return tmpFile.getAbsolutePath();
    }

    public boolean newSession(String fileName) {
        final Object[] created = new Object[]{Boolean.TRUE};
        this.waitMessageDialog = this.view.getWaitMessageDialog(Constant.messages.getString("menu.file.newSession.wait.dialogue"));
        this.control.newSession(fileName, new SessionListener(){

            @Override
            public void sessionSnapshot(Exception e) {
            }

            @Override
            public void sessionSaved(final Exception e) {
                if (EventQueue.isDispatchThread()) {
                    if (e == null) {
                        MenuFileControl.this.view.getSiteTreePanel().getTreeSite().setModel(MenuFileControl.this.model.getSession().getSiteTree());
                    } else {
                        MenuFileControl.this.view.showWarningDialog(Constant.messages.getString("menu.file.newSession.error"));
                        LOGGER.error("Error creating session file {}", (Object)MenuFileControl.this.model.getSession().getFileName(), (Object)e);
                        created[0] = Boolean.FALSE;
                    }
                    if (MenuFileControl.this.waitMessageDialog != null) {
                        MenuFileControl.this.waitMessageDialog.setVisible(false);
                        MenuFileControl.this.waitMessageDialog = null;
                    }
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.sessionSaved(e);
                        }
                    });
                }
            }

            @Override
            public void sessionOpened(File file, Exception e) {
            }
        });
        this.waitMessageDialog.setVisible(true);
        return created[0] == Boolean.TRUE;
    }

    public boolean openSession(String session) {
        final Object[] opened = new Object[]{Boolean.TRUE};
        File sessionFile = new File(session);
        this.waitMessageDialog = this.view.getWaitMessageDialog(Constant.messages.getString("menu.file.loadSession"));
        LOGGER.info("opening session file {}", (Object)sessionFile.getAbsolutePath());
        this.control.openSession(sessionFile, new SessionListener(){

            @Override
            public void sessionSnapshot(Exception e) {
            }

            @Override
            public void sessionSaved(Exception e) {
            }

            @Override
            public void sessionOpened(final File file, final Exception e) {
                if (EventQueue.isDispatchThread()) {
                    if (e != null) {
                        MenuFileControl.this.view.showWarningDialog(Constant.messages.getString("menu.file.openSession.error"));
                        LOGGER.error("error opening session file {}", (Object)MenuFileControl.this.model.getSession().getFileName(), (Object)e);
                        opened[0] = Boolean.FALSE;
                    }
                    MenuFileControl.this.view.getSiteTreePanel().getTreeSite().setModel(MenuFileControl.this.model.getSession().getSiteTree());
                    if (MenuFileControl.this.waitMessageDialog != null) {
                        MenuFileControl.this.waitMessageDialog.setVisible(false);
                        MenuFileControl.this.waitMessageDialog = null;
                    }
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.sessionOpened(file, e);
                        }
                    });
                }
            }
        });
        this.waitMessageDialog.setVisible(true);
        return opened[0] == Boolean.TRUE;
    }

    public void openSession() {
        if (!this.informStopActiveActions()) {
            return;
        }
        if ("hsqldb".equals(this.model.getDb().getType())) {
            this.openFileBasedSession();
        } else {
            this.openDbBasedSession();
        }
    }

    private void openFileBasedSession() {
        JFileChooser chooser = new JFileChooser(this.model.getOptionsParam().getUserDirectory());
        chooser.setFileHidingEnabled(false);
        File file = null;
        chooser.setFileFilter(SessionFileChooser.SESSION_FILE_FILTER);
        int rc = chooser.showOpenDialog(this.view.getMainFrame());
        if (rc == 0) {
            try {
                file = chooser.getSelectedFile();
                if (file == null) {
                    return;
                }
                this.model.getOptionsParam().setUserDirectory(chooser.getCurrentDirectory());
                LOGGER.info("opening session file {}", (Object)file.getAbsolutePath());
                this.waitMessageDialog = this.view.getWaitMessageDialog(Constant.messages.getString("menu.file.loadSession"));
                this.control.openSession(file, (SessionListener)this);
                this.waitMessageDialog.setVisible(true);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void openDbBasedSession() {
        try {
            ArrayList<String> sessionList = new ArrayList<String>();
            for (RecordSession rs : this.model.getDb().getTableSession().listSessions()) {
                sessionList.add("" + rs.getSessionId());
            }
            SessionTableSelectDialog ssd = new SessionTableSelectDialog((Frame)View.getSingleton().getMainFrame(), sessionList);
            ssd.setVisible(true);
            if (ssd.getSelectedSession() != null) {
                this.waitMessageDialog = this.view.getWaitMessageDialog(Constant.messages.getString("menu.file.loadSession"));
                this.control.openSession(ssd.getSelectedSession(), (SessionListener)this);
                this.waitMessageDialog.setVisible(true);
            }
        }
        catch (DatabaseException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void saveSession() {
        Session session = this.model.getSession();
        if (session.isNewState()) {
            this.view.showWarningDialog("Please use Save As...");
            return;
        }
        try {
            this.waitMessageDialog = this.view.getWaitMessageDialog(Constant.messages.getString("menu.file.savingSession"));
            this.control.saveSession(session.getFileName(), this);
            LOGGER.info("saving session file {}", (Object)session.getFileName());
            if (this.waitMessageDialog != null) {
                this.waitMessageDialog.setVisible(true);
            }
        }
        catch (Exception e) {
            this.view.showWarningDialog(Constant.messages.getString("menu.file.savingSession.error"));
            LOGGER.error("error saving session file {}", (Object)session.getFileName());
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void saveAsSession() {
        if (!this.informStopActiveActions()) {
            return;
        }
        Session session = this.model.getSession();
        SessionFileChooser chooser = new SessionFileChooser(this.model.getOptionsParam().getUserDirectory(), session);
        File fileproposal = new File(session.getSessionName());
        if (session.getFileName() != null && session.getFileName().trim().length() > 0) {
            fileproposal = new File(session.getFileName());
        }
        chooser.setSelectedFile(fileproposal);
        File file = null;
        int rc = chooser.showSaveDialog(this.view.getMainFrame());
        if (rc == 0) {
            file = chooser.getSelectedFile();
            if (file == null) {
                return;
            }
            String fileName = MenuFileControl.createSessionFileName(file);
            try {
                this.waitMessageDialog = this.view.getWaitMessageDialog(Constant.messages.getString("menu.file.savingSession"));
                this.control.saveSession(fileName, this);
                LOGGER.info("save as session file {}", (Object)session.getFileName());
                this.waitMessageDialog.setVisible(true);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static String createSessionFileName(File file) {
        Object fileName = file.getAbsolutePath();
        if (!((String)fileName).endsWith(".session")) {
            fileName = (String)fileName + ".session";
        }
        return fileName;
    }

    public void saveSnapshot() {
        String activeActions = MenuFileControl.wrapEntriesInLiTags(this.control.getExtensionLoader().getActiveActions());
        if (!activeActions.isEmpty()) {
            this.view.showMessageDialog(new ZapHtmlLabel(Constant.messages.getString("menu.file.snapshot.activeactions", activeActions)));
            return;
        }
        Session session = this.model.getSession();
        SessionFileChooser chooser = new SessionFileChooser(this.model.getOptionsParam().getUserDirectory(), session);
        File fileproposal = new File(session.getSessionName());
        if (session.getFileName() != null && session.getFileName().trim().length() > 0) {
            Object proposedFileName = Strings.CI.removeEnd(session.getFileName(), (CharSequence)".session");
            proposedFileName = (String)proposedFileName + "-" + this.dateFormat.format(new Date()) + ".session";
            fileproposal = new File((String)proposedFileName);
        }
        chooser.setSelectedFile(fileproposal);
        File file = null;
        int rc = chooser.showSaveDialog(this.view.getMainFrame());
        if (rc == 0) {
            file = chooser.getSelectedFile();
            if (file == null) {
                return;
            }
            String fileName = MenuFileControl.createSessionFileName(file);
            try {
                this.waitMessageDialog = this.view.getWaitMessageDialog(Constant.messages.getString("menu.file.savingSnapshot"));
                this.control.snapshotSession(fileName, this);
                LOGGER.info("Snapshotting: {} as {}", (Object)session.getFileName(), (Object)fileName);
                this.waitMessageDialog.setVisible(true);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void properties() {
        View.getSingleton().showSessionDialog(this.model.getSession(), null);
    }

    @Override
    public void sessionOpened(File file, Exception e) {
        if (e != null) {
            this.view.showWarningDialog(Constant.messages.getString("menu.file.openSession.errorFile"));
            if (file != null) {
                LOGGER.error("Error opening session file {}", (Object)file.getAbsolutePath(), (Object)e);
            } else {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        if (this.waitMessageDialog != null) {
            this.waitMessageDialog.setVisible(false);
            this.waitMessageDialog = null;
        }
    }

    @Override
    public void sessionSaved(Exception e) {
        if (e != null) {
            this.view.showWarningDialog(Constant.messages.getString("menu.file.savingSession.error"));
            LOGGER.error("error saving session file {}", (Object)this.model.getSession().getFileName(), (Object)e);
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        if (this.waitMessageDialog != null) {
            this.waitMessageDialog.setVisible(false);
            this.waitMessageDialog = null;
        }
    }

    @Override
    public void sessionSnapshot(Exception e) {
        if (e != null) {
            this.view.showWarningDialog(Constant.messages.getString("menu.file.snapshotSession.error"));
            LOGGER.error("error saving snapshot file {}", (Object)this.model.getSession().getFileName(), (Object)e);
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        if (this.waitMessageDialog != null) {
            this.waitMessageDialog.setVisible(false);
            this.waitMessageDialog = null;
        }
    }

    public void importContext() {
        JFileChooser chooser = new JFileChooser(Constant.getContextsDir());
        File file = null;
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.isFile() && file.getName().endsWith(".context");
            }

            @Override
            public String getDescription() {
                return Constant.messages.getString("file.format.zap.context");
            }
        });
        int rc = chooser.showOpenDialog(View.getSingleton().getMainFrame());
        if (rc == 0) {
            try {
                file = chooser.getSelectedFile();
                if (file == null || !file.exists()) {
                    return;
                }
                ZapXmlConfiguration config = new ZapXmlConfiguration(file);
                String ctxName = config.getString("context.name");
                Session session = Model.getSingleton().getSession();
                boolean forcedImport = true;
                while (session.getContext(ctxName) != null) {
                    forcedImport = false;
                    ctxName = (String)JOptionPane.showInputDialog(View.getSingleton().getMainFrame(), Constant.messages.getString("context.import.duplicate.dialog.message", ctxName), Constant.messages.getString("context.import.duplicate.dialog.title"), 3, null, null, ctxName);
                }
                if (forcedImport || ctxName != null && !ctxName.isBlank()) {
                    config.setProperty("context.name", ctxName);
                    session.importContext(config);
                    View.getSingleton().showSessionDialog(Model.getSingleton().getSession(), Constant.messages.getString("context.list"), true);
                }
            }
            catch (IllegalContextNameException e) {
                String detailError = e.getReason() == IllegalContextNameException.Reason.EMPTY_NAME ? Constant.messages.getString("context.error.name.empty") : (e.getReason() == IllegalContextNameException.Reason.DUPLICATED_NAME ? Constant.messages.getString("context.error.name.duplicated") : Constant.messages.getString("context.error.name.unknown"));
                View.getSingleton().showWarningDialog(Constant.messages.getString("context.import.error", detailError));
            }
            catch (Exception e1) {
                LOGGER.error(e1.getMessage(), (Throwable)e1);
                View.getSingleton().showWarningDialog(Constant.messages.getString("context.import.error", e1.getMessage()));
            }
        }
    }

    public void exportContext() {
        ContextExportDialog exportDialog = new ContextExportDialog(View.getSingleton().getMainFrame());
        exportDialog.setVisible(true);
    }

    private static class SessionFileChooser
    extends WritableFileChooser {
        public static final FileFilter SESSION_FILE_FILTER = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.isFile() && file.getName().endsWith(".session");
            }

            @Override
            public String getDescription() {
                return Constant.messages.getString("file.format.zap.session");
            }
        };
        private static final long serialVersionUID = 1L;
        private final Session currentSession;

        public SessionFileChooser(File currentDirectory, Session currentSession) {
            super(currentDirectory);
            this.setFileFilter(SESSION_FILE_FILTER);
            this.currentSession = currentSession;
        }

        @Override
        public void approveSelection() {
            File file = this.getSelectedFile();
            if (file != null) {
                File currentFile;
                File sessionFile = new File(MenuFileControl.createSessionFileName(file));
                this.setSelectedFile(sessionFile);
                if (!this.currentSession.isNewState() && (currentFile = new File(this.currentSession.getFileName())).getAbsolutePath().equals(sessionFile.getAbsolutePath())) {
                    this.showErrorDialog(Constant.messages.getString("menu.file.error.selectedCurrentSession.msg"), Constant.messages.getString("menu.file.error.selectedCurrentSession.title"));
                    return;
                }
            }
            super.approveSelection();
        }
    }
}

