/* -*- mode: C; c-file-style: "gnu"; indent-tabs-mode: nil; -*-
 *
 * Copyright 2025 GNOME Foundation, Inc.
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * Authors:
 *  - Philip Withnall <pwithnall@gnome.org>
 */

#pragma once

#include <glib.h>
#include <glib-object.h>

G_BEGIN_DECLS

/**
 * MctFilterListParseCallback:
 * @hostname: valid hostname extracted from the filter list (may not be
 *   nul-terminated)
 * @hostname_len: length of @hostname, in bytes
 * @user_data: data passed to [func@Malcontent.filter_list_parse_from_data]
 * @error: return location for a [type@GLib.Error]
 *
 * Callback for a single hostname parsed using
 * [func@Malcontent.filter_list_parse_from_data].
 *
 * [func@Malcontent.filter_list_parse_from_data] will call this zero or more
 * times before it returns, providing callers a way to run custom code on each
 * hostname in the filter list. Typically this would be to add the hostname to
 * a table or other data store.
 *
 * Note that @hostname may not be nul-terminated, so always has to be handled in
 * terms of @hostname_len.
 *
 * If you set an error and return false from this callback,
 * [func@Malcontent.filter_list_parse_from_data] will immediately return with
 * that error.
 *
 * Returns: true on success; false otherwise
 * Since: 0.14.0
 */
typedef gboolean (*MctFilterListParseCallback) (const char  *hostname,
                                                size_t       hostname_len,
                                                void        *user_data,
                                                GError     **error);

gboolean mct_filter_list_parse_from_data (const char                  *filter_contents,
                                          size_t                       filter_contents_len,
                                          MctFilterListParseCallback   callback,
                                          void                        *user_data,
                                          GError                     **error);

G_END_DECLS
