/**
 * Qt6 Common library
 *
 * The Qt6 Common library is auto-generated and available to users under the same license as the Qt which it is used with or built with. See available licenses below. 
 * SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


#include "qoaiserverconfiguration.h"

#include <QtCore/qmap.h>
#include <QtCore/qset.h>
#include <QtCore/qstring.h>
#include <QtCore/qurl.h>

QT_BEGIN_NAMESPACE

namespace QtOpenApiCommon {

class QOAIServerConfigurationPrivate : public QSharedData
{
public:
    QString m_urlTemplate;
    QString m_description;
    QMap<QString, QOAIServerVariable> m_variables;
};

QOAIServerConfiguration::QOAIServerConfiguration()
    : d_ptr(new QOAIServerConfigurationPrivate)
{}

QOAIServerConfiguration::QOAIServerConfiguration(const QString &urlTemplate, const QString &description,
                                                             const QMap<QString, QOAIServerVariable> &variables)
    : QOAIServerConfiguration()
{
    d_ptr->m_urlTemplate = urlTemplate;
    d_ptr->m_description = description;
    d_ptr->m_variables = variables;
}

QOAIServerConfiguration::~QOAIServerConfiguration()
    = default;

QOAIServerConfiguration::QOAIServerConfiguration(const QOAIServerConfiguration &other)
    = default;

QOAIServerConfiguration &QOAIServerConfiguration::operator=(const QOAIServerConfiguration &other)
{
    if (this != &other)
        d_ptr = other.d_ptr;
    return *this;
}

QOAIServerConfiguration::QOAIServerConfiguration(QOAIServerConfiguration &&other) noexcept
    = default;

QOAIServerConfiguration &QOAIServerConfiguration::operator=(QOAIServerConfiguration &&other) noexcept
{
    swap(other);
    return *this;
}

void QOAIServerConfiguration::swap(QOAIServerConfiguration &other) noexcept
{
    d_ptr.swap(other.d_ptr);
}

QString QOAIServerConfiguration::urlTemplate() const
{
    return d_ptr->m_urlTemplate;
}

QUrl QOAIServerConfiguration::url() const
{
    if (d_ptr->m_variables.empty())
        return QUrl(d_ptr->m_urlTemplate); // nothing to substitute

    QString url = d_ptr->m_urlTemplate;
    // go through variables and replace placeholders
    for (const auto &[name, serverVariable] : d_ptr->m_variables.asKeyValueRange()) {
        const QString value = serverVariable.value();
        const auto enumValues = serverVariable.enumValues();
        if (!enumValues.empty() && !enumValues.contains(value)) {
            qWarning("The variable %s in the server URL has an invalid value %s.",
                     qPrintable(name), qPrintable(value));
        }
        const QString varTemplate = u'{' + name + u'}';
        url = url.replace(varTemplate, value);
    }
    return QUrl(url);
}

QOAIServerVariable::ServerError
QOAIServerConfiguration::setVariableValue(const QString &variable, const QString &value)
{
    d_ptr.detach();
    auto it = d_ptr->m_variables.find(variable);
    if (it == d_ptr->m_variables.end())
        return QOAIServerVariable::ServerError::ServerVariableNotFound;
    return it->setValue(value);
}

bool
comparesEqual(const QOAIServerConfiguration &lhs, const QOAIServerConfiguration &rhs) noexcept
{
    return lhs.d_ptr->m_urlTemplate == rhs.d_ptr->m_urlTemplate
        && lhs.d_ptr->m_description == rhs.d_ptr->m_description
        && lhs.d_ptr->m_variables == rhs.d_ptr->m_variables;
}

} // namespace QtOpenApiCommon

QT_END_NAMESPACE
