// components/services/storage/public/mojom/storage_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/storage/public/mojom/storage_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/storage/public/mojom/storage_service.mojom-params-data.h"
#include "components/services/storage/public/mojom/storage_service.mojom-shared-message-ids.h"

#include "components/services/storage/public/mojom/storage_service.mojom-import-headers.h"
#include "components/services/storage/public/mojom/storage_service.mojom-test-utils.h"


namespace storage::mojom {
const char StorageService::Name_[] = "storage.mojom.StorageService";

StorageService::IPCStableHashFunction StorageService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::StorageService>(message.name())) {
    case messages::StorageService::kEnableAggressiveDomStorageFlushing: {
      return &StorageService::EnableAggressiveDomStorageFlushing_Sym::IPCStableHash;
    }
    case messages::StorageService::kSetDataDirectory: {
      return &StorageService::SetDataDirectory_Sym::IPCStableHash;
    }
    case messages::StorageService::kBindPartition: {
      return &StorageService::BindPartition_Sym::IPCStableHash;
    }
    case messages::StorageService::kBindTestApi: {
      return &StorageService::BindTestApi_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* StorageService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::StorageService>(message.name())) {
      case messages::StorageService::kEnableAggressiveDomStorageFlushing:
            return "Receive storage::mojom::StorageService::EnableAggressiveDomStorageFlushing";
      case messages::StorageService::kSetDataDirectory:
            return "Receive storage::mojom::StorageService::SetDataDirectory";
      case messages::StorageService::kBindPartition:
            return "Receive storage::mojom::StorageService::BindPartition";
      case messages::StorageService::kBindTestApi:
            return "Receive storage::mojom::StorageService::BindTestApi";
    }
  } else {
    switch (static_cast<messages::StorageService>(message.name())) {
      case messages::StorageService::kEnableAggressiveDomStorageFlushing:
            return "Receive reply storage::mojom::StorageService::EnableAggressiveDomStorageFlushing";
      case messages::StorageService::kSetDataDirectory:
            return "Receive reply storage::mojom::StorageService::SetDataDirectory";
      case messages::StorageService::kBindPartition:
            return "Receive reply storage::mojom::StorageService::BindPartition";
      case messages::StorageService::kBindTestApi:
            return "Receive reply storage::mojom::StorageService::BindTestApi";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t StorageService::EnableAggressiveDomStorageFlushing_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::StorageService::EnableAggressiveDomStorageFlushing");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StorageService::SetDataDirectory_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::StorageService::SetDataDirectory");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StorageService::BindPartition_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::StorageService::BindPartition");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StorageService::BindTestApi_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::StorageService::BindTestApi");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

StorageServiceProxy::StorageServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void StorageServiceProxy::EnableAggressiveDomStorageFlushing(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::StorageService::EnableAggressiveDomStorageFlushing");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StorageService::kEnableAggressiveDomStorageFlushing), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::StorageService_EnableAggressiveDomStorageFlushing_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageService::Name_);
  message.set_method_name("EnableAggressiveDomStorageFlushing");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void StorageServiceProxy::SetDataDirectory(
    const ::base::FilePath& in_path, ::mojo::PendingRemote<::storage::mojom::Directory> in_directory) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::StorageService::SetDataDirectory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("directory"), in_directory,
                        "<value of type ::mojo::PendingRemote<::storage::mojom::Directory>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StorageService::kSetDataDirectory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::StorageService_SetDataDirectory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in StorageService.SetDataDirectory request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::storage::mojom::DirectoryInterfaceBase>>(
      in_directory, &params->directory, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->directory),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid directory in StorageService.SetDataDirectory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageService::Name_);
  message.set_method_name("SetDataDirectory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void StorageServiceProxy::BindPartition(
    const std::optional<::base::FilePath>& in_path, ::mojo::PendingReceiver<::storage::mojom::Partition> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::StorageService::BindPartition", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const std::optional<::base::FilePath>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::storage::mojom::Partition>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StorageService::kBindPartition), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::StorageService_BindPartition_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::storage::mojom::PartitionInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in StorageService.BindPartition request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageService::Name_);
  message.set_method_name("BindPartition");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void StorageServiceProxy::BindTestApi(
    ::mojo::ScopedMessagePipeHandle in_test_api_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::StorageService::BindTestApi", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("test_api_receiver"), in_test_api_receiver,
                        "<value of type ::mojo::ScopedMessagePipeHandle>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StorageService::kBindTestApi), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::StorageService_BindTestApi_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::ScopedMessagePipeHandle>(
      in_test_api_receiver, &params->test_api_receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->test_api_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid test_api_receiver in StorageService.BindTestApi request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageService::Name_);
  message.set_method_name("BindTestApi");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool StorageServiceStubDispatch::Accept(
    StorageService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::StorageService>(message->header()->name)) {
    case messages::StorageService::kEnableAggressiveDomStorageFlushing: {
      DCHECK(message->is_serialized());
      internal::StorageService_EnableAggressiveDomStorageFlushing_Params_Data* params =
          reinterpret_cast<internal::StorageService_EnableAggressiveDomStorageFlushing_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for StorageService.0
      bool success = true;
      StorageService_EnableAggressiveDomStorageFlushing_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableAggressiveDomStorageFlushing(        );
      return true;
    }
    case messages::StorageService::kSetDataDirectory: {
      DCHECK(message->is_serialized());
      internal::StorageService_SetDataDirectory_Params_Data* params =
          reinterpret_cast<internal::StorageService_SetDataDirectory_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for StorageService.1
      bool success = true;
      ::base::FilePath p_path{};
      ::mojo::PendingRemote<::storage::mojom::Directory> p_directory{};
      StorageService_SetDataDirectory_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success) {
        p_directory =
            input_data_view.TakeDirectory<decltype(p_directory)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDataDirectory(        
        std::move(p_path), 
        std::move(p_directory));
      return true;
    }
    case messages::StorageService::kBindPartition: {
      DCHECK(message->is_serialized());
      internal::StorageService_BindPartition_Params_Data* params =
          reinterpret_cast<internal::StorageService_BindPartition_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for StorageService.2
      bool success = true;
      std::optional<::base::FilePath> p_path{};
      ::mojo::PendingReceiver<::storage::mojom::Partition> p_receiver{};
      StorageService_BindPartition_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindPartition(        
        std::move(p_path), 
        std::move(p_receiver));
      return true;
    }
    case messages::StorageService::kBindTestApi: {
      DCHECK(message->is_serialized());
      internal::StorageService_BindTestApi_Params_Data* params =
          reinterpret_cast<internal::StorageService_BindTestApi_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for StorageService.3
      bool success = true;
      ::mojo::ScopedMessagePipeHandle p_test_api_receiver{};
      StorageService_BindTestApi_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_test_api_receiver = input_data_view.TakeTestApiReceiver();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageService::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindTestApi(        
        std::move(p_test_api_receiver));
      return true;
    }
  }
  return false;
}

// static
bool StorageServiceStubDispatch::AcceptWithResponder(
    StorageService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::StorageService>(message->header()->name)) {
    case messages::StorageService::kEnableAggressiveDomStorageFlushing: {
      break;
    }
    case messages::StorageService::kSetDataDirectory: {
      break;
    }
    case messages::StorageService::kBindPartition: {
      break;
    }
    case messages::StorageService::kBindTestApi: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kStorageServiceValidationInfo[] = {
    {base::to_underlying(messages::StorageService::kEnableAggressiveDomStorageFlushing),
     { &internal::StorageService_EnableAggressiveDomStorageFlushing_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::StorageService::kSetDataDirectory),
     { &internal::StorageService_SetDataDirectory_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::StorageService::kBindPartition),
     { &internal::StorageService_BindPartition_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::StorageService::kBindTestApi),
     { &internal::StorageService_BindTestApi_Params_Data::Validate,
      nullptr /* no response */}},
};

bool StorageServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::StorageService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kStorageServiceValidationInfo);
}



}  // storage::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace storage::mojom {


void StorageServiceInterceptorForTesting::EnableAggressiveDomStorageFlushing() {
  GetForwardingInterface()->EnableAggressiveDomStorageFlushing();
}
void StorageServiceInterceptorForTesting::SetDataDirectory(const ::base::FilePath& path, ::mojo::PendingRemote<::storage::mojom::Directory> directory) {
  GetForwardingInterface()->SetDataDirectory(
    std::move(path)
    , 
    std::move(directory)
    );
}
void StorageServiceInterceptorForTesting::BindPartition(const std::optional<::base::FilePath>& path, ::mojo::PendingReceiver<::storage::mojom::Partition> receiver) {
  GetForwardingInterface()->BindPartition(
    std::move(path)
    , 
    std::move(receiver)
    );
}
void StorageServiceInterceptorForTesting::BindTestApi(::mojo::ScopedMessagePipeHandle test_api_receiver) {
  GetForwardingInterface()->BindTestApi(
    std::move(test_api_receiver)
    );
}
StorageServiceAsyncWaiter::StorageServiceAsyncWaiter(
    StorageService* proxy) : proxy_(proxy) {}

StorageServiceAsyncWaiter::~StorageServiceAsyncWaiter() = default;






}  // storage::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif