// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_ServiceWorker_h
#define content_protocol_ServiceWorker_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "content/browser/devtools/protocol/target.h"

namespace content {
namespace protocol {
namespace ServiceWorker {
using RegistrationID = String;
class ServiceWorkerRegistration;
using ServiceWorkerVersionRunningStatus = String;
using ServiceWorkerVersionStatus = String;
class ServiceWorkerVersion;
class ServiceWorkerErrorMessage;

// ------------- Forward and enum declarations.

namespace ServiceWorkerVersionRunningStatusEnum {
CONTENT_EXPORT extern const char Stopped[];
CONTENT_EXPORT extern const char Starting[];
CONTENT_EXPORT extern const char Running[];
CONTENT_EXPORT extern const char Stopping[];
} // namespace ServiceWorkerVersionRunningStatusEnum

namespace ServiceWorkerVersionStatusEnum {
CONTENT_EXPORT extern const char New[];
CONTENT_EXPORT extern const char Installing[];
CONTENT_EXPORT extern const char Installed[];
CONTENT_EXPORT extern const char Activating[];
CONTENT_EXPORT extern const char Activated[];
CONTENT_EXPORT extern const char Redundant[];
} // namespace ServiceWorkerVersionStatusEnum

// ------------- Type and builder declarations.

class CONTENT_EXPORT ServiceWorkerRegistration : public ::crdtp::ProtocolObject<ServiceWorkerRegistration> {
public:
    ~ServiceWorkerRegistration() override { }

    String GetRegistrationId() { return m_registrationId; }
    void SetRegistrationId(const String& value) { m_registrationId = value; }

    String GetScopeURL() { return m_scopeURL; }
    void SetScopeURL(const String& value) { m_scopeURL = value; }

    bool GetIsDeleted() { return m_isDeleted; }
    void SetIsDeleted(bool value) { m_isDeleted = value; }

    template<int STATE>
    class ServiceWorkerRegistrationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            RegistrationIdSet = 1 << 1,
            ScopeURLSet = 1 << 2,
            IsDeletedSet = 1 << 3,
            AllFieldsSet = (RegistrationIdSet | ScopeURLSet | IsDeletedSet | 0)};


        ServiceWorkerRegistrationBuilder<STATE | RegistrationIdSet>& SetRegistrationId(const String& value)
        {
            static_assert(!(STATE & RegistrationIdSet), "property registrationId should not be set yet");
            m_result->SetRegistrationId(value);
            return castState<RegistrationIdSet>();
        }

        ServiceWorkerRegistrationBuilder<STATE | ScopeURLSet>& SetScopeURL(const String& value)
        {
            static_assert(!(STATE & ScopeURLSet), "property scopeURL should not be set yet");
            m_result->SetScopeURL(value);
            return castState<ScopeURLSet>();
        }

        ServiceWorkerRegistrationBuilder<STATE | IsDeletedSet>& SetIsDeleted(bool value)
        {
            static_assert(!(STATE & IsDeletedSet), "property isDeleted should not be set yet");
            m_result->SetIsDeleted(value);
            return castState<IsDeletedSet>();
        }

        std::unique_ptr<ServiceWorkerRegistration> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ServiceWorkerRegistration;
        ServiceWorkerRegistrationBuilder() : m_result(new ServiceWorkerRegistration()) { }

        template<int STEP> ServiceWorkerRegistrationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ServiceWorkerRegistrationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::ServiceWorker::ServiceWorkerRegistration> m_result;
    };

    static ServiceWorkerRegistrationBuilder<0> Create()
    {
        return ServiceWorkerRegistrationBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ServiceWorkerRegistration()
    {
          m_isDeleted = false;
    }

    String m_registrationId;
    String m_scopeURL;
    bool m_isDeleted;
};


class CONTENT_EXPORT ServiceWorkerVersion : public ::crdtp::ProtocolObject<ServiceWorkerVersion> {
public:
    ~ServiceWorkerVersion() override { }

    String GetVersionId() { return m_versionId; }
    void SetVersionId(const String& value) { m_versionId = value; }

    String GetRegistrationId() { return m_registrationId; }
    void SetRegistrationId(const String& value) { m_registrationId = value; }

    String GetScriptURL() { return m_scriptURL; }
    void SetScriptURL(const String& value) { m_scriptURL = value; }

    String GetRunningStatus() { return m_runningStatus; }
    void SetRunningStatus(const String& value) { m_runningStatus = value; }

    String GetStatus() { return m_status; }
    void SetStatus(const String& value) { m_status = value; }

    bool HasScriptLastModified() { return !!m_scriptLastModified; }
    double GetScriptLastModified(double defaultValue) const {
       return m_scriptLastModified.value_or(defaultValue);
    }
    const std::optional<double>& GetScriptLastModified() const {
       return m_scriptLastModified;
    }
    void SetScriptLastModified(double value) { m_scriptLastModified = value; }

    bool HasScriptResponseTime() { return !!m_scriptResponseTime; }
    double GetScriptResponseTime(double defaultValue) const {
       return m_scriptResponseTime.value_or(defaultValue);
    }
    const std::optional<double>& GetScriptResponseTime() const {
       return m_scriptResponseTime;
    }
    void SetScriptResponseTime(double value) { m_scriptResponseTime = value; }

    bool HasControlledClients() { return !!m_controlledClients; }
    protocol::Array<String>* GetControlledClients(protocol::Array<String>* defaultValue) {
       return m_controlledClients ? m_controlledClients.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<String>>& GetControlledClients() const {
       return m_controlledClients;
    }
    void SetControlledClients(std::unique_ptr<protocol::Array<String>> value) { m_controlledClients = std::move(value); }

    bool HasTargetId() { return !!m_targetId; }
    String GetTargetId(const String& defaultValue) const {
       return m_targetId.value_or(defaultValue);
    }
    const std::optional<String>& GetTargetId() const {
       return m_targetId;
    }
    void SetTargetId(const String& value) { m_targetId = value; }

    bool HasRouterRules() { return !!m_routerRules; }
    String GetRouterRules(const String& defaultValue) const {
       return m_routerRules.value_or(defaultValue);
    }
    const std::optional<String>& GetRouterRules() const {
       return m_routerRules;
    }
    void SetRouterRules(const String& value) { m_routerRules = value; }

    template<int STATE>
    class ServiceWorkerVersionBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            VersionIdSet = 1 << 1,
            RegistrationIdSet = 1 << 2,
            ScriptURLSet = 1 << 3,
            RunningStatusSet = 1 << 4,
            StatusSet = 1 << 5,
            AllFieldsSet = (VersionIdSet | RegistrationIdSet | ScriptURLSet | RunningStatusSet | StatusSet | 0)};


        ServiceWorkerVersionBuilder<STATE | VersionIdSet>& SetVersionId(const String& value)
        {
            static_assert(!(STATE & VersionIdSet), "property versionId should not be set yet");
            m_result->SetVersionId(value);
            return castState<VersionIdSet>();
        }

        ServiceWorkerVersionBuilder<STATE | RegistrationIdSet>& SetRegistrationId(const String& value)
        {
            static_assert(!(STATE & RegistrationIdSet), "property registrationId should not be set yet");
            m_result->SetRegistrationId(value);
            return castState<RegistrationIdSet>();
        }

        ServiceWorkerVersionBuilder<STATE | ScriptURLSet>& SetScriptURL(const String& value)
        {
            static_assert(!(STATE & ScriptURLSet), "property scriptURL should not be set yet");
            m_result->SetScriptURL(value);
            return castState<ScriptURLSet>();
        }

        ServiceWorkerVersionBuilder<STATE | RunningStatusSet>& SetRunningStatus(const String& value)
        {
            static_assert(!(STATE & RunningStatusSet), "property runningStatus should not be set yet");
            m_result->SetRunningStatus(value);
            return castState<RunningStatusSet>();
        }

        ServiceWorkerVersionBuilder<STATE | StatusSet>& SetStatus(const String& value)
        {
            static_assert(!(STATE & StatusSet), "property status should not be set yet");
            m_result->SetStatus(value);
            return castState<StatusSet>();
        }

        ServiceWorkerVersionBuilder<STATE>& SetScriptLastModified(double value)
        {
            m_result->SetScriptLastModified(value);
            return *this;
        }

        ServiceWorkerVersionBuilder<STATE>& SetScriptResponseTime(double value)
        {
            m_result->SetScriptResponseTime(value);
            return *this;
        }

        ServiceWorkerVersionBuilder<STATE>& SetControlledClients(std::unique_ptr<protocol::Array<String>> value)
        {
            m_result->SetControlledClients(std::move(value));
            return *this;
        }

        ServiceWorkerVersionBuilder<STATE>& SetTargetId(const String& value)
        {
            m_result->SetTargetId(value);
            return *this;
        }

        ServiceWorkerVersionBuilder<STATE>& SetRouterRules(const String& value)
        {
            m_result->SetRouterRules(value);
            return *this;
        }

        std::unique_ptr<ServiceWorkerVersion> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ServiceWorkerVersion;
        ServiceWorkerVersionBuilder() : m_result(new ServiceWorkerVersion()) { }

        template<int STEP> ServiceWorkerVersionBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ServiceWorkerVersionBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::ServiceWorker::ServiceWorkerVersion> m_result;
    };

    static ServiceWorkerVersionBuilder<0> Create()
    {
        return ServiceWorkerVersionBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ServiceWorkerVersion()
    {
    }

    String m_versionId;
    String m_registrationId;
    String m_scriptURL;
    String m_runningStatus;
    String m_status;
    std::optional<double> m_scriptLastModified;
    std::optional<double> m_scriptResponseTime;
    std::unique_ptr<protocol::Array<String>> m_controlledClients;
    std::optional<String> m_targetId;
    std::optional<String> m_routerRules;
};


class CONTENT_EXPORT ServiceWorkerErrorMessage : public ::crdtp::ProtocolObject<ServiceWorkerErrorMessage> {
public:
    ~ServiceWorkerErrorMessage() override { }

    String GetErrorMessage() { return m_errorMessage; }
    void SetErrorMessage(const String& value) { m_errorMessage = value; }

    String GetRegistrationId() { return m_registrationId; }
    void SetRegistrationId(const String& value) { m_registrationId = value; }

    String GetVersionId() { return m_versionId; }
    void SetVersionId(const String& value) { m_versionId = value; }

    String GetSourceURL() { return m_sourceURL; }
    void SetSourceURL(const String& value) { m_sourceURL = value; }

    int GetLineNumber() { return m_lineNumber; }
    void SetLineNumber(int value) { m_lineNumber = value; }

    int GetColumnNumber() { return m_columnNumber; }
    void SetColumnNumber(int value) { m_columnNumber = value; }

    template<int STATE>
    class ServiceWorkerErrorMessageBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ErrorMessageSet = 1 << 1,
            RegistrationIdSet = 1 << 2,
            VersionIdSet = 1 << 3,
            SourceURLSet = 1 << 4,
            LineNumberSet = 1 << 5,
            ColumnNumberSet = 1 << 6,
            AllFieldsSet = (ErrorMessageSet | RegistrationIdSet | VersionIdSet | SourceURLSet | LineNumberSet | ColumnNumberSet | 0)};


        ServiceWorkerErrorMessageBuilder<STATE | ErrorMessageSet>& SetErrorMessage(const String& value)
        {
            static_assert(!(STATE & ErrorMessageSet), "property errorMessage should not be set yet");
            m_result->SetErrorMessage(value);
            return castState<ErrorMessageSet>();
        }

        ServiceWorkerErrorMessageBuilder<STATE | RegistrationIdSet>& SetRegistrationId(const String& value)
        {
            static_assert(!(STATE & RegistrationIdSet), "property registrationId should not be set yet");
            m_result->SetRegistrationId(value);
            return castState<RegistrationIdSet>();
        }

        ServiceWorkerErrorMessageBuilder<STATE | VersionIdSet>& SetVersionId(const String& value)
        {
            static_assert(!(STATE & VersionIdSet), "property versionId should not be set yet");
            m_result->SetVersionId(value);
            return castState<VersionIdSet>();
        }

        ServiceWorkerErrorMessageBuilder<STATE | SourceURLSet>& SetSourceURL(const String& value)
        {
            static_assert(!(STATE & SourceURLSet), "property sourceURL should not be set yet");
            m_result->SetSourceURL(value);
            return castState<SourceURLSet>();
        }

        ServiceWorkerErrorMessageBuilder<STATE | LineNumberSet>& SetLineNumber(int value)
        {
            static_assert(!(STATE & LineNumberSet), "property lineNumber should not be set yet");
            m_result->SetLineNumber(value);
            return castState<LineNumberSet>();
        }

        ServiceWorkerErrorMessageBuilder<STATE | ColumnNumberSet>& SetColumnNumber(int value)
        {
            static_assert(!(STATE & ColumnNumberSet), "property columnNumber should not be set yet");
            m_result->SetColumnNumber(value);
            return castState<ColumnNumberSet>();
        }

        std::unique_ptr<ServiceWorkerErrorMessage> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ServiceWorkerErrorMessage;
        ServiceWorkerErrorMessageBuilder() : m_result(new ServiceWorkerErrorMessage()) { }

        template<int STEP> ServiceWorkerErrorMessageBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ServiceWorkerErrorMessageBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::ServiceWorker::ServiceWorkerErrorMessage> m_result;
    };

    static ServiceWorkerErrorMessageBuilder<0> Create()
    {
        return ServiceWorkerErrorMessageBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ServiceWorkerErrorMessage()
    {
          m_lineNumber = 0;
          m_columnNumber = 0;
    }

    String m_errorMessage;
    String m_registrationId;
    String m_versionId;
    String m_sourceURL;
    int m_lineNumber;
    int m_columnNumber;
};


// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse DeliverPushMessage(const String& in_origin, const String& in_registrationId, const String& in_data) = 0;
    virtual DispatchResponse Disable() = 0;
    virtual DispatchResponse DispatchSyncEvent(const String& in_origin, const String& in_registrationId, const String& in_tag, bool in_lastChance) = 0;
    virtual DispatchResponse DispatchPeriodicSyncEvent(const String& in_origin, const String& in_registrationId, const String& in_tag) = 0;
    virtual DispatchResponse Enable() = 0;
    virtual DispatchResponse InspectWorker(const String& in_versionId) = 0;
    virtual DispatchResponse SetForceUpdateOnPageLoad(bool in_forceUpdateOnPageLoad) = 0;
    virtual DispatchResponse SkipWaiting(const String& in_scopeURL) = 0;
    virtual DispatchResponse StartWorker(const String& in_scopeURL) = 0;
    class CONTENT_EXPORT StopAllWorkersCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~StopAllWorkersCallback() { }
    };
    virtual void StopAllWorkers(std::unique_ptr<StopAllWorkersCallback> callback) = 0;
    virtual DispatchResponse StopWorker(const String& in_versionId) = 0;
    virtual DispatchResponse Unregister(const String& in_scopeURL) = 0;
    virtual DispatchResponse UpdateRegistration(const String& in_scopeURL) = 0;

};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void WorkerErrorReported(std::unique_ptr<protocol::ServiceWorker::ServiceWorkerErrorMessage> errorMessage);
    void WorkerRegistrationUpdated(std::unique_ptr<protocol::Array<protocol::ServiceWorker::ServiceWorkerRegistration>> registrations);
    void WorkerVersionUpdated(std::unique_ptr<protocol::Array<protocol::ServiceWorker::ServiceWorkerVersion>> versions);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace ServiceWorker
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_ServiceWorker_h)
