// content/browser/tracing/trace_report/trace_report.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/browser/tracing/trace_report/trace_report.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/browser/tracing/trace_report/trace_report.mojom-params-data.h"
#include "content/browser/tracing/trace_report/trace_report.mojom-shared-message-ids.h"

#include "content/browser/tracing/trace_report/trace_report.mojom-import-headers.h"
#include "content/browser/tracing/trace_report/trace_report.mojom-test-utils.h"


namespace trace_report::mojom {
ClientTraceReport::ClientTraceReport()
    : uuid(),
      creation_time(),
      scenario_name(),
      upload_rule_name(),
      upload_rule_value(),
      total_size(),
      upload_state(),
      upload_time(),
      skip_reason(),
      has_trace_content() {}

ClientTraceReport::ClientTraceReport(
    const ::base::Token& uuid_in,
    ::base::Time creation_time_in,
    const std::string& scenario_name_in,
    const std::string& upload_rule_name_in,
    std::optional<int32_t> upload_rule_value_in,
    int64_t total_size_in,
    ::content::ReportUploadState upload_state_in,
    ::base::Time upload_time_in,
    ::content::SkipUploadReason skip_reason_in,
    bool has_trace_content_in)
    : uuid(std::move(uuid_in)),
      creation_time(std::move(creation_time_in)),
      scenario_name(std::move(scenario_name_in)),
      upload_rule_name(std::move(upload_rule_name_in)),
      upload_rule_value(std::move(upload_rule_value_in)),
      total_size(std::move(total_size_in)),
      upload_state(std::move(upload_state_in)),
      upload_time(std::move(upload_time_in)),
      skip_reason(std::move(skip_reason_in)),
      has_trace_content(std::move(has_trace_content_in)) {}

ClientTraceReport::~ClientTraceReport() = default;

void ClientTraceReport::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uuid"), this->uuid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::Token&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "creation_time"), this->creation_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scenario_name"), this->scenario_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "upload_rule_name"), this->upload_rule_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "upload_rule_value"), this->upload_rule_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total_size"), this->total_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "upload_state"), this->upload_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::content::ReportUploadState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "upload_time"), this->upload_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "skip_reason"), this->skip_reason,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::content::SkipUploadReason>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_trace_content"), this->has_trace_content,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ClientTraceReport::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Scenario::Scenario()
    : scenario_name() {}

Scenario::Scenario(
    const std::string& scenario_name_in)
    : scenario_name(std::move(scenario_name_in)) {}

Scenario::~Scenario() = default;
size_t Scenario::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->scenario_name);
  return seed;
}

void Scenario::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scenario_name"), this->scenario_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Scenario::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char TraceReportHandlerFactory::Name_[] = "trace_report.mojom.TraceReportHandlerFactory";

TraceReportHandlerFactory::IPCStableHashFunction TraceReportHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TraceReportHandlerFactory>(message.name())) {
    case messages::TraceReportHandlerFactory::kCreatePageHandler: {
      return &TraceReportHandlerFactory::CreatePageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TraceReportHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TraceReportHandlerFactory>(message.name())) {
      case messages::TraceReportHandlerFactory::kCreatePageHandler:
            return "Receive trace_report::mojom::TraceReportHandlerFactory::CreatePageHandler";
    }
  } else {
    switch (static_cast<messages::TraceReportHandlerFactory>(message.name())) {
      case messages::TraceReportHandlerFactory::kCreatePageHandler:
            return "Receive reply trace_report::mojom::TraceReportHandlerFactory::CreatePageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TraceReportHandlerFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)trace_report::mojom::TraceReportHandlerFactory::CreatePageHandler");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

TraceReportHandlerFactoryProxy::TraceReportHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TraceReportHandlerFactoryProxy::CreatePageHandler(
    ::mojo::PendingRemote<Page> in_page, ::mojo::PendingReceiver<PageHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send trace_report::mojom::TraceReportHandlerFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<PageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TraceReportHandlerFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::trace_report::mojom::internal::TraceReportHandlerFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::trace_report::mojom::PageInterfaceBase>>(
      in_page, &params->page, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->page),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid page in TraceReportHandlerFactory.CreatePageHandler request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::trace_report::mojom::PageHandlerInterfaceBase>>(
      in_handler, &params->handler, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->handler),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid handler in TraceReportHandlerFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TraceReportHandlerFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool TraceReportHandlerFactoryStubDispatch::Accept(
    TraceReportHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TraceReportHandlerFactory>(message->header()->name)) {
    case messages::TraceReportHandlerFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::TraceReportHandlerFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::TraceReportHandlerFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for TraceReportHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<Page> p_page{};
      ::mojo::PendingReceiver<PageHandler> p_handler{};
      TraceReportHandlerFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TraceReportHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool TraceReportHandlerFactoryStubDispatch::AcceptWithResponder(
    TraceReportHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TraceReportHandlerFactory>(message->header()->name)) {
    case messages::TraceReportHandlerFactory::kCreatePageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kTraceReportHandlerFactoryValidationInfo[] = {
    {base::to_underlying(messages::TraceReportHandlerFactory::kCreatePageHandler),
     { &internal::TraceReportHandlerFactory_CreatePageHandler_Params_Data::Validate,
      nullptr /* no response */}},
};

bool TraceReportHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::trace_report::mojom::TraceReportHandlerFactory::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kTraceReportHandlerFactoryValidationInfo);
}

const char PageHandler::Name_[] = "trace_report.mojom.PageHandler";

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kGetAllTraceReports: {
      return &PageHandler::GetAllTraceReports_Sym::IPCStableHash;
    }
    case messages::PageHandler::kDeleteSingleTrace: {
      return &PageHandler::DeleteSingleTrace_Sym::IPCStableHash;
    }
    case messages::PageHandler::kDeleteAllTraces: {
      return &PageHandler::DeleteAllTraces_Sym::IPCStableHash;
    }
    case messages::PageHandler::kUserUploadSingleTrace: {
      return &PageHandler::UserUploadSingleTrace_Sym::IPCStableHash;
    }
    case messages::PageHandler::kDownloadTrace: {
      return &PageHandler::DownloadTrace_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetAllPresetScenarios: {
      return &PageHandler::GetAllPresetScenarios_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetAllFieldScenarios: {
      return &PageHandler::GetAllFieldScenarios_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetEnabledScenarios: {
      return &PageHandler::GetEnabledScenarios_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetEnabledScenarios: {
      return &PageHandler::SetEnabledScenarios_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetPrivacyFilterEnabled: {
      return &PageHandler::GetPrivacyFilterEnabled_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetPrivacyFilterEnabled: {
      return &PageHandler::SetPrivacyFilterEnabled_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kGetAllTraceReports:
            return "Receive trace_report::mojom::PageHandler::GetAllTraceReports";
      case messages::PageHandler::kDeleteSingleTrace:
            return "Receive trace_report::mojom::PageHandler::DeleteSingleTrace";
      case messages::PageHandler::kDeleteAllTraces:
            return "Receive trace_report::mojom::PageHandler::DeleteAllTraces";
      case messages::PageHandler::kUserUploadSingleTrace:
            return "Receive trace_report::mojom::PageHandler::UserUploadSingleTrace";
      case messages::PageHandler::kDownloadTrace:
            return "Receive trace_report::mojom::PageHandler::DownloadTrace";
      case messages::PageHandler::kGetAllPresetScenarios:
            return "Receive trace_report::mojom::PageHandler::GetAllPresetScenarios";
      case messages::PageHandler::kGetAllFieldScenarios:
            return "Receive trace_report::mojom::PageHandler::GetAllFieldScenarios";
      case messages::PageHandler::kGetEnabledScenarios:
            return "Receive trace_report::mojom::PageHandler::GetEnabledScenarios";
      case messages::PageHandler::kSetEnabledScenarios:
            return "Receive trace_report::mojom::PageHandler::SetEnabledScenarios";
      case messages::PageHandler::kGetPrivacyFilterEnabled:
            return "Receive trace_report::mojom::PageHandler::GetPrivacyFilterEnabled";
      case messages::PageHandler::kSetPrivacyFilterEnabled:
            return "Receive trace_report::mojom::PageHandler::SetPrivacyFilterEnabled";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kGetAllTraceReports:
            return "Receive reply trace_report::mojom::PageHandler::GetAllTraceReports";
      case messages::PageHandler::kDeleteSingleTrace:
            return "Receive reply trace_report::mojom::PageHandler::DeleteSingleTrace";
      case messages::PageHandler::kDeleteAllTraces:
            return "Receive reply trace_report::mojom::PageHandler::DeleteAllTraces";
      case messages::PageHandler::kUserUploadSingleTrace:
            return "Receive reply trace_report::mojom::PageHandler::UserUploadSingleTrace";
      case messages::PageHandler::kDownloadTrace:
            return "Receive reply trace_report::mojom::PageHandler::DownloadTrace";
      case messages::PageHandler::kGetAllPresetScenarios:
            return "Receive reply trace_report::mojom::PageHandler::GetAllPresetScenarios";
      case messages::PageHandler::kGetAllFieldScenarios:
            return "Receive reply trace_report::mojom::PageHandler::GetAllFieldScenarios";
      case messages::PageHandler::kGetEnabledScenarios:
            return "Receive reply trace_report::mojom::PageHandler::GetEnabledScenarios";
      case messages::PageHandler::kSetEnabledScenarios:
            return "Receive reply trace_report::mojom::PageHandler::SetEnabledScenarios";
      case messages::PageHandler::kGetPrivacyFilterEnabled:
            return "Receive reply trace_report::mojom::PageHandler::GetPrivacyFilterEnabled";
      case messages::PageHandler::kSetPrivacyFilterEnabled:
            return "Receive reply trace_report::mojom::PageHandler::SetPrivacyFilterEnabled";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::GetAllTraceReports_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)trace_report::mojom::PageHandler::GetAllTraceReports");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::DeleteSingleTrace_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)trace_report::mojom::PageHandler::DeleteSingleTrace");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::DeleteAllTraces_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)trace_report::mojom::PageHandler::DeleteAllTraces");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::UserUploadSingleTrace_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)trace_report::mojom::PageHandler::UserUploadSingleTrace");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::DownloadTrace_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)trace_report::mojom::PageHandler::DownloadTrace");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetAllPresetScenarios_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)trace_report::mojom::PageHandler::GetAllPresetScenarios");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetAllFieldScenarios_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)trace_report::mojom::PageHandler::GetAllFieldScenarios");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetEnabledScenarios_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)trace_report::mojom::PageHandler::GetEnabledScenarios");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetEnabledScenarios_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)trace_report::mojom::PageHandler::SetEnabledScenarios");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetPrivacyFilterEnabled_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)trace_report::mojom::PageHandler::GetPrivacyFilterEnabled");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetPrivacyFilterEnabled_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)trace_report::mojom::PageHandler::SetPrivacyFilterEnabled");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageHandler_GetAllTraceReports_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetAllTraceReports_ForwardToCallback(
      PageHandler::GetAllTraceReportsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetAllTraceReports_ForwardToCallback(const PageHandler_GetAllTraceReports_ForwardToCallback&) = delete;
  PageHandler_GetAllTraceReports_ForwardToCallback& operator=(const PageHandler_GetAllTraceReports_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetAllTraceReportsCallback callback_;
};

class PageHandler_DeleteSingleTrace_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_DeleteSingleTrace_ForwardToCallback(
      PageHandler::DeleteSingleTraceCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_DeleteSingleTrace_ForwardToCallback(const PageHandler_DeleteSingleTrace_ForwardToCallback&) = delete;
  PageHandler_DeleteSingleTrace_ForwardToCallback& operator=(const PageHandler_DeleteSingleTrace_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::DeleteSingleTraceCallback callback_;
};

class PageHandler_DeleteAllTraces_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_DeleteAllTraces_ForwardToCallback(
      PageHandler::DeleteAllTracesCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_DeleteAllTraces_ForwardToCallback(const PageHandler_DeleteAllTraces_ForwardToCallback&) = delete;
  PageHandler_DeleteAllTraces_ForwardToCallback& operator=(const PageHandler_DeleteAllTraces_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::DeleteAllTracesCallback callback_;
};

class PageHandler_UserUploadSingleTrace_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_UserUploadSingleTrace_ForwardToCallback(
      PageHandler::UserUploadSingleTraceCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_UserUploadSingleTrace_ForwardToCallback(const PageHandler_UserUploadSingleTrace_ForwardToCallback&) = delete;
  PageHandler_UserUploadSingleTrace_ForwardToCallback& operator=(const PageHandler_UserUploadSingleTrace_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::UserUploadSingleTraceCallback callback_;
};

class PageHandler_DownloadTrace_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_DownloadTrace_ForwardToCallback(
      PageHandler::DownloadTraceCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_DownloadTrace_ForwardToCallback(const PageHandler_DownloadTrace_ForwardToCallback&) = delete;
  PageHandler_DownloadTrace_ForwardToCallback& operator=(const PageHandler_DownloadTrace_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::DownloadTraceCallback callback_;
};

class PageHandler_GetAllPresetScenarios_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetAllPresetScenarios_ForwardToCallback(
      PageHandler::GetAllPresetScenariosCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetAllPresetScenarios_ForwardToCallback(const PageHandler_GetAllPresetScenarios_ForwardToCallback&) = delete;
  PageHandler_GetAllPresetScenarios_ForwardToCallback& operator=(const PageHandler_GetAllPresetScenarios_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetAllPresetScenariosCallback callback_;
};

class PageHandler_GetAllFieldScenarios_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetAllFieldScenarios_ForwardToCallback(
      PageHandler::GetAllFieldScenariosCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetAllFieldScenarios_ForwardToCallback(const PageHandler_GetAllFieldScenarios_ForwardToCallback&) = delete;
  PageHandler_GetAllFieldScenarios_ForwardToCallback& operator=(const PageHandler_GetAllFieldScenarios_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetAllFieldScenariosCallback callback_;
};

class PageHandler_GetEnabledScenarios_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetEnabledScenarios_ForwardToCallback(
      PageHandler::GetEnabledScenariosCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetEnabledScenarios_ForwardToCallback(const PageHandler_GetEnabledScenarios_ForwardToCallback&) = delete;
  PageHandler_GetEnabledScenarios_ForwardToCallback& operator=(const PageHandler_GetEnabledScenarios_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetEnabledScenariosCallback callback_;
};

class PageHandler_SetEnabledScenarios_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_SetEnabledScenarios_ForwardToCallback(
      PageHandler::SetEnabledScenariosCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_SetEnabledScenarios_ForwardToCallback(const PageHandler_SetEnabledScenarios_ForwardToCallback&) = delete;
  PageHandler_SetEnabledScenarios_ForwardToCallback& operator=(const PageHandler_SetEnabledScenarios_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::SetEnabledScenariosCallback callback_;
};

class PageHandler_GetPrivacyFilterEnabled_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetPrivacyFilterEnabled_ForwardToCallback(
      PageHandler::GetPrivacyFilterEnabledCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetPrivacyFilterEnabled_ForwardToCallback(const PageHandler_GetPrivacyFilterEnabled_ForwardToCallback&) = delete;
  PageHandler_GetPrivacyFilterEnabled_ForwardToCallback& operator=(const PageHandler_GetPrivacyFilterEnabled_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetPrivacyFilterEnabledCallback callback_;
};

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::GetAllTraceReports(
    GetAllTraceReportsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send trace_report::mojom::PageHandler::GetAllTraceReports");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetAllTraceReports), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::trace_report::mojom::internal::PageHandler_GetAllTraceReports_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetAllTraceReports");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetAllTraceReports_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::DeleteSingleTrace(
    const ::base::Token& in_uuid, DeleteSingleTraceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send trace_report::mojom::PageHandler::DeleteSingleTrace", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const ::base::Token&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kDeleteSingleTrace), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::trace_report::mojom::internal::PageHandler_DeleteSingleTrace_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
      in_uuid, uuid_fragment);
  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->uuid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null uuid in PageHandler.DeleteSingleTrace request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("DeleteSingleTrace");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_DeleteSingleTrace_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::DeleteAllTraces(
    DeleteAllTracesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send trace_report::mojom::PageHandler::DeleteAllTraces");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kDeleteAllTraces), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::trace_report::mojom::internal::PageHandler_DeleteAllTraces_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("DeleteAllTraces");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_DeleteAllTraces_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::UserUploadSingleTrace(
    const ::base::Token& in_uuid, UserUploadSingleTraceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send trace_report::mojom::PageHandler::UserUploadSingleTrace", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const ::base::Token&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kUserUploadSingleTrace), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::trace_report::mojom::internal::PageHandler_UserUploadSingleTrace_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
      in_uuid, uuid_fragment);
  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->uuid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null uuid in PageHandler.UserUploadSingleTrace request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("UserUploadSingleTrace");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_UserUploadSingleTrace_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::DownloadTrace(
    const ::base::Token& in_uuid, DownloadTraceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send trace_report::mojom::PageHandler::DownloadTrace", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const ::base::Token&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kDownloadTrace), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::trace_report::mojom::internal::PageHandler_DownloadTrace_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
      in_uuid, uuid_fragment);
  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->uuid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null uuid in PageHandler.DownloadTrace request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("DownloadTrace");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_DownloadTrace_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetAllPresetScenarios(
    GetAllPresetScenariosCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send trace_report::mojom::PageHandler::GetAllPresetScenarios");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetAllPresetScenarios), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::trace_report::mojom::internal::PageHandler_GetAllPresetScenarios_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetAllPresetScenarios");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetAllPresetScenarios_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetAllFieldScenarios(
    GetAllFieldScenariosCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send trace_report::mojom::PageHandler::GetAllFieldScenarios");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetAllFieldScenarios), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::trace_report::mojom::internal::PageHandler_GetAllFieldScenarios_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetAllFieldScenarios");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetAllFieldScenarios_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetEnabledScenarios(
    GetEnabledScenariosCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send trace_report::mojom::PageHandler::GetEnabledScenarios");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetEnabledScenarios), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::trace_report::mojom::internal::PageHandler_GetEnabledScenarios_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetEnabledScenarios");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetEnabledScenarios_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::SetEnabledScenarios(
    const std::vector<std::string>& in_new_config, SetEnabledScenariosCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send trace_report::mojom::PageHandler::SetEnabledScenarios", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_config"), in_new_config,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetEnabledScenarios), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::trace_report::mojom::internal::PageHandler_SetEnabledScenarios_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->new_config)::BaseType>
      new_config_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& new_config_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_new_config, new_config_fragment, &new_config_validate_params);
  params->new_config.Set(
      new_config_fragment.is_null() ? nullptr : new_config_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->new_config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null new_config in PageHandler.SetEnabledScenarios request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetEnabledScenarios");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_SetEnabledScenarios_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetPrivacyFilterEnabled(
    GetPrivacyFilterEnabledCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send trace_report::mojom::PageHandler::GetPrivacyFilterEnabled");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetPrivacyFilterEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::trace_report::mojom::internal::PageHandler_GetPrivacyFilterEnabled_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetPrivacyFilterEnabled");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetPrivacyFilterEnabled_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::SetPrivacyFilterEnabled(
    bool in_enable) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send trace_report::mojom::PageHandler::SetPrivacyFilterEnabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enable"), in_enable,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetPrivacyFilterEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::trace_report::mojom::internal::PageHandler_SetPrivacyFilterEnabled_Params_Data> params(
          message);
  params.Allocate();
  params->enable = in_enable;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetPrivacyFilterEnabled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PageHandler_GetAllTraceReports_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetAllTraceReportsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetAllTraceReports_ProxyToResponder> proxy(
        new PageHandler_GetAllTraceReports_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetAllTraceReports_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetAllTraceReports_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetAllTraceReports_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PageHandler::GetAllTraceReportsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<ClientTraceReportPtr> in_reports);
};

bool PageHandler_GetAllTraceReports_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetAllTraceReports_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetAllTraceReports_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PageHandler.0
  bool success = true;
  std::vector<ClientTraceReportPtr> p_reports{};
  PageHandler_GetAllTraceReports_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadReports(&p_reports))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_reports));
  return true;
}

void PageHandler_GetAllTraceReports_ProxyToResponder::Run(
    std::vector<ClientTraceReportPtr> in_reports) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply trace_report::mojom::PageHandler::GetAllTraceReports", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reports"), in_reports,
                        "<value of type std::vector<ClientTraceReportPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetAllTraceReports), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::trace_report::mojom::internal::PageHandler_GetAllTraceReports_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->reports)::BaseType>
      reports_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& reports_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::trace_report::mojom::ClientTraceReportDataView>>(
      in_reports, reports_fragment, &reports_validate_params);
  params->reports.Set(
      reports_fragment.is_null() ? nullptr : reports_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->reports.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null reports in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetAllTraceReports");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_DeleteSingleTrace_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::DeleteSingleTraceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_DeleteSingleTrace_ProxyToResponder> proxy(
        new PageHandler_DeleteSingleTrace_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_DeleteSingleTrace_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_DeleteSingleTrace_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_DeleteSingleTrace_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PageHandler::DeleteSingleTraceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool PageHandler_DeleteSingleTrace_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_DeleteSingleTrace_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_DeleteSingleTrace_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PageHandler.1
  bool success = true;
  bool p_success{};
  PageHandler_DeleteSingleTrace_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void PageHandler_DeleteSingleTrace_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply trace_report::mojom::PageHandler::DeleteSingleTrace", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kDeleteSingleTrace), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::trace_report::mojom::internal::PageHandler_DeleteSingleTrace_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("DeleteSingleTrace");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_DeleteAllTraces_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::DeleteAllTracesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_DeleteAllTraces_ProxyToResponder> proxy(
        new PageHandler_DeleteAllTraces_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_DeleteAllTraces_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_DeleteAllTraces_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_DeleteAllTraces_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PageHandler::DeleteAllTracesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool PageHandler_DeleteAllTraces_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_DeleteAllTraces_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_DeleteAllTraces_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PageHandler.2
  bool success = true;
  bool p_success{};
  PageHandler_DeleteAllTraces_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void PageHandler_DeleteAllTraces_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply trace_report::mojom::PageHandler::DeleteAllTraces", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kDeleteAllTraces), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::trace_report::mojom::internal::PageHandler_DeleteAllTraces_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("DeleteAllTraces");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_UserUploadSingleTrace_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::UserUploadSingleTraceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_UserUploadSingleTrace_ProxyToResponder> proxy(
        new PageHandler_UserUploadSingleTrace_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_UserUploadSingleTrace_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_UserUploadSingleTrace_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_UserUploadSingleTrace_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PageHandler::UserUploadSingleTraceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool PageHandler_UserUploadSingleTrace_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_UserUploadSingleTrace_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_UserUploadSingleTrace_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PageHandler.3
  bool success = true;
  bool p_success{};
  PageHandler_UserUploadSingleTrace_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void PageHandler_UserUploadSingleTrace_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply trace_report::mojom::PageHandler::UserUploadSingleTrace", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kUserUploadSingleTrace), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::trace_report::mojom::internal::PageHandler_UserUploadSingleTrace_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("UserUploadSingleTrace");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_DownloadTrace_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::DownloadTraceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_DownloadTrace_ProxyToResponder> proxy(
        new PageHandler_DownloadTrace_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_DownloadTrace_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_DownloadTrace_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_DownloadTrace_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PageHandler::DownloadTraceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<::mojo_base::BigBuffer> in_trace);
};

bool PageHandler_DownloadTrace_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_DownloadTrace_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_DownloadTrace_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PageHandler.4
  bool success = true;
  std::optional<::mojo_base::BigBuffer> p_trace{};
  PageHandler_DownloadTrace_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadTrace(&p_trace))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_trace));
  return true;
}

void PageHandler_DownloadTrace_ProxyToResponder::Run(
    std::optional<::mojo_base::BigBuffer> in_trace) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply trace_report::mojom::PageHandler::DownloadTrace", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trace"), in_trace,
                        "<value of type std::optional<::mojo_base::BigBuffer>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kDownloadTrace), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::trace_report::mojom::internal::PageHandler_DownloadTrace_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->trace)>
      trace_fragment(params.message());
  trace_fragment.Claim(&params->trace);
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_trace, trace_fragment, true);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("DownloadTrace");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetAllPresetScenarios_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetAllPresetScenariosCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetAllPresetScenarios_ProxyToResponder> proxy(
        new PageHandler_GetAllPresetScenarios_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetAllPresetScenarios_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetAllPresetScenarios_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetAllPresetScenarios_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PageHandler::GetAllPresetScenariosCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<ScenarioPtr> in_config);
};

bool PageHandler_GetAllPresetScenarios_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetAllPresetScenarios_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetAllPresetScenarios_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PageHandler.5
  bool success = true;
  std::vector<ScenarioPtr> p_config{};
  PageHandler_GetAllPresetScenarios_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadConfig(&p_config))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_config));
  return true;
}

void PageHandler_GetAllPresetScenarios_ProxyToResponder::Run(
    std::vector<ScenarioPtr> in_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply trace_report::mojom::PageHandler::GetAllPresetScenarios", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type std::vector<ScenarioPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetAllPresetScenarios), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::trace_report::mojom::internal::PageHandler_GetAllPresetScenarios_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType>
      config_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& config_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::trace_report::mojom::ScenarioDataView>>(
      in_config, config_fragment, &config_validate_params);
  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null config in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetAllPresetScenarios");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetAllFieldScenarios_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetAllFieldScenariosCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetAllFieldScenarios_ProxyToResponder> proxy(
        new PageHandler_GetAllFieldScenarios_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetAllFieldScenarios_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetAllFieldScenarios_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetAllFieldScenarios_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PageHandler::GetAllFieldScenariosCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<ScenarioPtr> in_config);
};

bool PageHandler_GetAllFieldScenarios_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetAllFieldScenarios_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetAllFieldScenarios_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PageHandler.6
  bool success = true;
  std::vector<ScenarioPtr> p_config{};
  PageHandler_GetAllFieldScenarios_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadConfig(&p_config))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_config));
  return true;
}

void PageHandler_GetAllFieldScenarios_ProxyToResponder::Run(
    std::vector<ScenarioPtr> in_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply trace_report::mojom::PageHandler::GetAllFieldScenarios", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type std::vector<ScenarioPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetAllFieldScenarios), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::trace_report::mojom::internal::PageHandler_GetAllFieldScenarios_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType>
      config_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& config_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::trace_report::mojom::ScenarioDataView>>(
      in_config, config_fragment, &config_validate_params);
  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null config in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetAllFieldScenarios");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetEnabledScenarios_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetEnabledScenariosCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetEnabledScenarios_ProxyToResponder> proxy(
        new PageHandler_GetEnabledScenarios_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetEnabledScenarios_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetEnabledScenarios_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetEnabledScenarios_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PageHandler::GetEnabledScenariosCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<std::string>& in_config);
};

bool PageHandler_GetEnabledScenarios_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetEnabledScenarios_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetEnabledScenarios_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PageHandler.7
  bool success = true;
  std::vector<std::string> p_config{};
  PageHandler_GetEnabledScenarios_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadConfig(&p_config))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_config));
  return true;
}

void PageHandler_GetEnabledScenarios_ProxyToResponder::Run(
    const std::vector<std::string>& in_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply trace_report::mojom::PageHandler::GetEnabledScenarios", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetEnabledScenarios), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::trace_report::mojom::internal::PageHandler_GetEnabledScenarios_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType>
      config_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& config_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_config, config_fragment, &config_validate_params);
  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null config in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetEnabledScenarios");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_SetEnabledScenarios_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::SetEnabledScenariosCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_SetEnabledScenarios_ProxyToResponder> proxy(
        new PageHandler_SetEnabledScenarios_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_SetEnabledScenarios_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_SetEnabledScenarios_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_SetEnabledScenarios_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PageHandler::SetEnabledScenariosCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool PageHandler_SetEnabledScenarios_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_SetEnabledScenarios_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_SetEnabledScenarios_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PageHandler.8
  bool success = true;
  bool p_success{};
  PageHandler_SetEnabledScenarios_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void PageHandler_SetEnabledScenarios_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply trace_report::mojom::PageHandler::SetEnabledScenarios", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetEnabledScenarios), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::trace_report::mojom::internal::PageHandler_SetEnabledScenarios_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetEnabledScenarios");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetPrivacyFilterEnabled_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetPrivacyFilterEnabledCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetPrivacyFilterEnabled_ProxyToResponder> proxy(
        new PageHandler_GetPrivacyFilterEnabled_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetPrivacyFilterEnabled_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetPrivacyFilterEnabled_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetPrivacyFilterEnabled_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PageHandler::GetPrivacyFilterEnabledCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_enabled);
};

bool PageHandler_GetPrivacyFilterEnabled_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetPrivacyFilterEnabled_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetPrivacyFilterEnabled_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PageHandler.9
  bool success = true;
  bool p_enabled{};
  PageHandler_GetPrivacyFilterEnabled_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_enabled = input_data_view.enabled();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_enabled));
  return true;
}

void PageHandler_GetPrivacyFilterEnabled_ProxyToResponder::Run(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply trace_report::mojom::PageHandler::GetPrivacyFilterEnabled", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetPrivacyFilterEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::trace_report::mojom::internal::PageHandler_GetPrivacyFilterEnabled_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetPrivacyFilterEnabled");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kGetAllTraceReports: {
      break;
    }
    case messages::PageHandler::kDeleteSingleTrace: {
      break;
    }
    case messages::PageHandler::kDeleteAllTraces: {
      break;
    }
    case messages::PageHandler::kUserUploadSingleTrace: {
      break;
    }
    case messages::PageHandler::kDownloadTrace: {
      break;
    }
    case messages::PageHandler::kGetAllPresetScenarios: {
      break;
    }
    case messages::PageHandler::kGetAllFieldScenarios: {
      break;
    }
    case messages::PageHandler::kGetEnabledScenarios: {
      break;
    }
    case messages::PageHandler::kSetEnabledScenarios: {
      break;
    }
    case messages::PageHandler::kGetPrivacyFilterEnabled: {
      break;
    }
    case messages::PageHandler::kSetPrivacyFilterEnabled: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetPrivacyFilterEnabled_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetPrivacyFilterEnabled_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PageHandler.10
      bool success = true;
      bool p_enable{};
      PageHandler_SetPrivacyFilterEnabled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enable = input_data_view.enable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPrivacyFilterEnabled(        
        std::move(p_enable));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kGetAllTraceReports: {
      internal::PageHandler_GetAllTraceReports_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetAllTraceReports_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PageHandler.0
      bool success = true;
      PageHandler_GetAllTraceReports_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      PageHandler::GetAllTraceReportsCallback callback =
          PageHandler_GetAllTraceReports_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllTraceReports(std::move(callback));
      return true;
    }
    case messages::PageHandler::kDeleteSingleTrace: {
      internal::PageHandler_DeleteSingleTrace_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_DeleteSingleTrace_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PageHandler.1
      bool success = true;
      ::base::Token p_uuid{};
      PageHandler_DeleteSingleTrace_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      PageHandler::DeleteSingleTraceCallback callback =
          PageHandler_DeleteSingleTrace_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteSingleTrace(        
        std::move(p_uuid), std::move(callback));
      return true;
    }
    case messages::PageHandler::kDeleteAllTraces: {
      internal::PageHandler_DeleteAllTraces_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_DeleteAllTraces_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PageHandler.2
      bool success = true;
      PageHandler_DeleteAllTraces_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 2, false);
        return false;
      }
      PageHandler::DeleteAllTracesCallback callback =
          PageHandler_DeleteAllTraces_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteAllTraces(std::move(callback));
      return true;
    }
    case messages::PageHandler::kUserUploadSingleTrace: {
      internal::PageHandler_UserUploadSingleTrace_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_UserUploadSingleTrace_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PageHandler.3
      bool success = true;
      ::base::Token p_uuid{};
      PageHandler_UserUploadSingleTrace_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 3, false);
        return false;
      }
      PageHandler::UserUploadSingleTraceCallback callback =
          PageHandler_UserUploadSingleTrace_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UserUploadSingleTrace(        
        std::move(p_uuid), std::move(callback));
      return true;
    }
    case messages::PageHandler::kDownloadTrace: {
      internal::PageHandler_DownloadTrace_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_DownloadTrace_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PageHandler.4
      bool success = true;
      ::base::Token p_uuid{};
      PageHandler_DownloadTrace_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 4, false);
        return false;
      }
      PageHandler::DownloadTraceCallback callback =
          PageHandler_DownloadTrace_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DownloadTrace(        
        std::move(p_uuid), std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetAllPresetScenarios: {
      internal::PageHandler_GetAllPresetScenarios_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetAllPresetScenarios_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PageHandler.5
      bool success = true;
      PageHandler_GetAllPresetScenarios_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 5, false);
        return false;
      }
      PageHandler::GetAllPresetScenariosCallback callback =
          PageHandler_GetAllPresetScenarios_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllPresetScenarios(std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetAllFieldScenarios: {
      internal::PageHandler_GetAllFieldScenarios_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetAllFieldScenarios_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PageHandler.6
      bool success = true;
      PageHandler_GetAllFieldScenarios_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 6, false);
        return false;
      }
      PageHandler::GetAllFieldScenariosCallback callback =
          PageHandler_GetAllFieldScenarios_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllFieldScenarios(std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetEnabledScenarios: {
      internal::PageHandler_GetEnabledScenarios_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetEnabledScenarios_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PageHandler.7
      bool success = true;
      PageHandler_GetEnabledScenarios_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 7, false);
        return false;
      }
      PageHandler::GetEnabledScenariosCallback callback =
          PageHandler_GetEnabledScenarios_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetEnabledScenarios(std::move(callback));
      return true;
    }
    case messages::PageHandler::kSetEnabledScenarios: {
      internal::PageHandler_SetEnabledScenarios_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_SetEnabledScenarios_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PageHandler.8
      bool success = true;
      std::vector<std::string> p_new_config{};
      PageHandler_SetEnabledScenarios_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNewConfig(&p_new_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 8, false);
        return false;
      }
      PageHandler::SetEnabledScenariosCallback callback =
          PageHandler_SetEnabledScenarios_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetEnabledScenarios(        
        std::move(p_new_config), std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetPrivacyFilterEnabled: {
      internal::PageHandler_GetPrivacyFilterEnabled_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetPrivacyFilterEnabled_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PageHandler.9
      bool success = true;
      PageHandler_GetPrivacyFilterEnabled_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 9, false);
        return false;
      }
      PageHandler::GetPrivacyFilterEnabledCallback callback =
          PageHandler_GetPrivacyFilterEnabled_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPrivacyFilterEnabled(std::move(callback));
      return true;
    }
    case messages::PageHandler::kSetPrivacyFilterEnabled: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPageHandlerValidationInfo[] = {
    {base::to_underlying(messages::PageHandler::kGetAllTraceReports),
     { &internal::PageHandler_GetAllTraceReports_Params_Data::Validate,
      &internal::PageHandler_GetAllTraceReports_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PageHandler::kDeleteSingleTrace),
     { &internal::PageHandler_DeleteSingleTrace_Params_Data::Validate,
      &internal::PageHandler_DeleteSingleTrace_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PageHandler::kDeleteAllTraces),
     { &internal::PageHandler_DeleteAllTraces_Params_Data::Validate,
      &internal::PageHandler_DeleteAllTraces_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PageHandler::kUserUploadSingleTrace),
     { &internal::PageHandler_UserUploadSingleTrace_Params_Data::Validate,
      &internal::PageHandler_UserUploadSingleTrace_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PageHandler::kDownloadTrace),
     { &internal::PageHandler_DownloadTrace_Params_Data::Validate,
      &internal::PageHandler_DownloadTrace_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PageHandler::kGetAllPresetScenarios),
     { &internal::PageHandler_GetAllPresetScenarios_Params_Data::Validate,
      &internal::PageHandler_GetAllPresetScenarios_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PageHandler::kGetAllFieldScenarios),
     { &internal::PageHandler_GetAllFieldScenarios_Params_Data::Validate,
      &internal::PageHandler_GetAllFieldScenarios_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PageHandler::kGetEnabledScenarios),
     { &internal::PageHandler_GetEnabledScenarios_Params_Data::Validate,
      &internal::PageHandler_GetEnabledScenarios_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PageHandler::kSetEnabledScenarios),
     { &internal::PageHandler_SetEnabledScenarios_Params_Data::Validate,
      &internal::PageHandler_SetEnabledScenarios_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PageHandler::kGetPrivacyFilterEnabled),
     { &internal::PageHandler_GetPrivacyFilterEnabled_Params_Data::Validate,
      &internal::PageHandler_GetPrivacyFilterEnabled_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PageHandler::kSetPrivacyFilterEnabled),
     { &internal::PageHandler_SetPrivacyFilterEnabled_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::trace_report::mojom::PageHandler::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPageHandlerValidationInfo);
}

bool PageHandlerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::trace_report::mojom::PageHandler::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kPageHandlerValidationInfo);

}
const char Page::Name_[] = "trace_report.mojom.Page";

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}
namespace {
}  // namespace

bool PageRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::trace_report::mojom::Page::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, {});
}



}  // trace_report::mojom


namespace mojo {


// static
bool StructTraits<::trace_report::mojom::ClientTraceReport::DataView, ::trace_report::mojom::ClientTraceReportPtr>::Read(
    ::trace_report::mojom::ClientTraceReport::DataView input,
    ::trace_report::mojom::ClientTraceReportPtr* output) {
  bool success = true;
  ::trace_report::mojom::ClientTraceReportPtr result(::trace_report::mojom::ClientTraceReport::New());
  
      if (success && !input.ReadUuid(&result->uuid))
        success = false;
      if (success && !input.ReadCreationTime(&result->creation_time))
        success = false;
      if (success && !input.ReadScenarioName(&result->scenario_name))
        success = false;
      if (success && !input.ReadUploadRuleName(&result->upload_rule_name))
        success = false;
      if (success) {
        result->upload_rule_value = input.upload_rule_value();
      }
      if (success)
        result->total_size = input.total_size();
      if (success && !input.ReadUploadState(&result->upload_state))
        success = false;
      if (success && !input.ReadUploadTime(&result->upload_time))
        success = false;
      if (success && !input.ReadSkipReason(&result->skip_reason))
        success = false;
      if (success)
        result->has_trace_content = input.has_trace_content();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::trace_report::mojom::Scenario::DataView, ::trace_report::mojom::ScenarioPtr>::Read(
    ::trace_report::mojom::Scenario::DataView input,
    ::trace_report::mojom::ScenarioPtr* output) {
  bool success = true;
  ::trace_report::mojom::ScenarioPtr result(::trace_report::mojom::Scenario::New());
  
      if (success && !input.ReadScenarioName(&result->scenario_name))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace trace_report::mojom {


void TraceReportHandlerFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
TraceReportHandlerFactoryAsyncWaiter::TraceReportHandlerFactoryAsyncWaiter(
    TraceReportHandlerFactory* proxy) : proxy_(proxy) {}

TraceReportHandlerFactoryAsyncWaiter::~TraceReportHandlerFactoryAsyncWaiter() = default;




void PageHandlerInterceptorForTesting::GetAllTraceReports(GetAllTraceReportsCallback callback) {
  GetForwardingInterface()->GetAllTraceReports(std::move(callback));
}
void PageHandlerInterceptorForTesting::DeleteSingleTrace(const ::base::Token& uuid, DeleteSingleTraceCallback callback) {
  GetForwardingInterface()->DeleteSingleTrace(
    std::move(uuid)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::DeleteAllTraces(DeleteAllTracesCallback callback) {
  GetForwardingInterface()->DeleteAllTraces(std::move(callback));
}
void PageHandlerInterceptorForTesting::UserUploadSingleTrace(const ::base::Token& uuid, UserUploadSingleTraceCallback callback) {
  GetForwardingInterface()->UserUploadSingleTrace(
    std::move(uuid)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::DownloadTrace(const ::base::Token& uuid, DownloadTraceCallback callback) {
  GetForwardingInterface()->DownloadTrace(
    std::move(uuid)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::GetAllPresetScenarios(GetAllPresetScenariosCallback callback) {
  GetForwardingInterface()->GetAllPresetScenarios(std::move(callback));
}
void PageHandlerInterceptorForTesting::GetAllFieldScenarios(GetAllFieldScenariosCallback callback) {
  GetForwardingInterface()->GetAllFieldScenarios(std::move(callback));
}
void PageHandlerInterceptorForTesting::GetEnabledScenarios(GetEnabledScenariosCallback callback) {
  GetForwardingInterface()->GetEnabledScenarios(std::move(callback));
}
void PageHandlerInterceptorForTesting::SetEnabledScenarios(const std::vector<std::string>& new_config, SetEnabledScenariosCallback callback) {
  GetForwardingInterface()->SetEnabledScenarios(
    std::move(new_config)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::GetPrivacyFilterEnabled(GetPrivacyFilterEnabledCallback callback) {
  GetForwardingInterface()->GetPrivacyFilterEnabled(std::move(callback));
}
void PageHandlerInterceptorForTesting::SetPrivacyFilterEnabled(bool enable) {
  GetForwardingInterface()->SetPrivacyFilterEnabled(
    std::move(enable)
    );
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;

void PageHandlerAsyncWaiter::GetAllTraceReports(
    std::vector<ClientTraceReportPtr>* out_reports) {
  base::RunLoop loop;
  proxy_->GetAllTraceReports(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<ClientTraceReportPtr>* out_reports
,
             std::vector<ClientTraceReportPtr> reports) {*out_reports = std::move(reports);
            loop->Quit();
          },
          &loop,
          out_reports));
  loop.Run();
}

std::vector<ClientTraceReportPtr> PageHandlerAsyncWaiter::GetAllTraceReports(
    ) {
  std::vector<ClientTraceReportPtr> async_wait_result;
  GetAllTraceReports(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::DeleteSingleTrace(
    const ::base::Token& uuid, bool* out_success) {
  base::RunLoop loop;
  proxy_->DeleteSingleTrace(
      std::move(uuid),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool PageHandlerAsyncWaiter::DeleteSingleTrace(
    const ::base::Token& uuid) {
  bool async_wait_result;
  DeleteSingleTrace(std::move(uuid),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::DeleteAllTraces(
    bool* out_success) {
  base::RunLoop loop;
  proxy_->DeleteAllTraces(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool PageHandlerAsyncWaiter::DeleteAllTraces(
    ) {
  bool async_wait_result;
  DeleteAllTraces(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::UserUploadSingleTrace(
    const ::base::Token& uuid, bool* out_success) {
  base::RunLoop loop;
  proxy_->UserUploadSingleTrace(
      std::move(uuid),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool PageHandlerAsyncWaiter::UserUploadSingleTrace(
    const ::base::Token& uuid) {
  bool async_wait_result;
  UserUploadSingleTrace(std::move(uuid),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::DownloadTrace(
    const ::base::Token& uuid, std::optional<::mojo_base::BigBuffer>* out_trace) {
  base::RunLoop loop;
  proxy_->DownloadTrace(
      std::move(uuid),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::mojo_base::BigBuffer>* out_trace
,
             std::optional<::mojo_base::BigBuffer> trace) {*out_trace = std::move(trace);
            loop->Quit();
          },
          &loop,
          out_trace));
  loop.Run();
}

std::optional<::mojo_base::BigBuffer> PageHandlerAsyncWaiter::DownloadTrace(
    const ::base::Token& uuid) {
  std::optional<::mojo_base::BigBuffer> async_wait_result;
  DownloadTrace(std::move(uuid),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetAllPresetScenarios(
    std::vector<ScenarioPtr>* out_config) {
  base::RunLoop loop;
  proxy_->GetAllPresetScenarios(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<ScenarioPtr>* out_config
,
             std::vector<ScenarioPtr> config) {*out_config = std::move(config);
            loop->Quit();
          },
          &loop,
          out_config));
  loop.Run();
}

std::vector<ScenarioPtr> PageHandlerAsyncWaiter::GetAllPresetScenarios(
    ) {
  std::vector<ScenarioPtr> async_wait_result;
  GetAllPresetScenarios(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetAllFieldScenarios(
    std::vector<ScenarioPtr>* out_config) {
  base::RunLoop loop;
  proxy_->GetAllFieldScenarios(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<ScenarioPtr>* out_config
,
             std::vector<ScenarioPtr> config) {*out_config = std::move(config);
            loop->Quit();
          },
          &loop,
          out_config));
  loop.Run();
}

std::vector<ScenarioPtr> PageHandlerAsyncWaiter::GetAllFieldScenarios(
    ) {
  std::vector<ScenarioPtr> async_wait_result;
  GetAllFieldScenarios(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetEnabledScenarios(
    std::vector<std::string>* out_config) {
  base::RunLoop loop;
  proxy_->GetEnabledScenarios(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<std::string>* out_config
,
             const std::vector<std::string>& config) {*out_config = std::move(config);
            loop->Quit();
          },
          &loop,
          out_config));
  loop.Run();
}

std::vector<std::string> PageHandlerAsyncWaiter::GetEnabledScenarios(
    ) {
  std::vector<std::string> async_wait_result;
  GetEnabledScenarios(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::SetEnabledScenarios(
    const std::vector<std::string>& new_config, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetEnabledScenarios(
      std::move(new_config),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool PageHandlerAsyncWaiter::SetEnabledScenarios(
    const std::vector<std::string>& new_config) {
  bool async_wait_result;
  SetEnabledScenarios(std::move(new_config),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetPrivacyFilterEnabled(
    bool* out_enabled) {
  base::RunLoop loop;
  proxy_->GetPrivacyFilterEnabled(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_enabled
,
             bool enabled) {*out_enabled = std::move(enabled);
            loop->Quit();
          },
          &loop,
          out_enabled));
  loop.Run();
}

bool PageHandlerAsyncWaiter::GetPrivacyFilterEnabled(
    ) {
  bool async_wait_result;
  GetPrivacyFilterEnabled(&async_wait_result);
  return async_wait_result;
}




PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;






}  // trace_report::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif