// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/storage.json
// by tools/json_schema_compiler.
// DO NOT EDIT.

#ifndef EXTENSIONS_COMMON_API_STORAGE_H__
#define EXTENSIONS_COMMON_API_STORAGE_H__

#include <stdint.h>

#include <map>
#include <memory>
#include <optional>
#include <string>
#include <vector>

#include "base/values.h"
#include <string_view>


namespace extensions {
namespace api {
namespace storage {

//
// Properties
//

// Items in the <code>sync</code> storage area are synced using Chrome Sync.
namespace sync {
  // The maximum total amount (in bytes) of data that can be stored in sync
  // storage, as measured by the JSON stringification of every value plus every
  // key's length. Updates that would cause this limit to be exceeded fail
  // immediately and set $(ref:runtime.lastError) when using a callback, or when a
  // Promise is rejected.
  extern const int QUOTA_BYTES;
  // The maximum size (in bytes) of each individual item in sync storage, as
  // measured by the JSON stringification of its value plus its key length.
  // Updates containing items larger than this limit will fail immediately and set
  // $(ref:runtime.lastError) when using a callback, or when a Promise is
  // rejected.
  extern const int QUOTA_BYTES_PER_ITEM;
  // The maximum number of items that can be stored in sync storage. Updates that
  // would cause this limit to be exceeded will fail immediately and set
  // $(ref:runtime.lastError) when using a callback, or when a Promise is
  // rejected.
  extern const int MAX_ITEMS;
  // <p>The maximum number of <code>set</code>, <code>remove</code>, or
  // <code>clear</code> operations that can be performed each hour. This is 1
  // every 2 seconds, a lower ceiling than the short term higher writes-per-minute
  // limit.</p><p>Updates that would cause this limit to be exceeded fail
  // immediately and set $(ref:runtime.lastError) when using a callback, or when a
  // Promise is rejected.</p>
  extern const int MAX_WRITE_OPERATIONS_PER_HOUR;
  // <p>The maximum number of <code>set</code>, <code>remove</code>, or
  // <code>clear</code> operations that can be performed each minute. This is 2
  // per second, providing higher throughput than writes-per-hour over a shorter
  // period of time.</p><p>Updates that would cause this limit to be exceeded fail
  // immediately and set $(ref:runtime.lastError) when using a callback, or when a
  // Promise is rejected.</p>
  extern const int MAX_WRITE_OPERATIONS_PER_MINUTE;
  //
  extern const int MAX_SUSTAINED_WRITE_OPERATIONS_PER_MINUTE;
}  // namespace sync

// Items in the <code>local</code> storage area are local to each machine.
namespace local {
  // The maximum amount (in bytes) of data that can be stored in local storage, as
  // measured by the JSON stringification of every value plus every key's length.
  // This value will be ignored if the extension has the
  // <code>unlimitedStorage</code> permission. Updates that would cause this limit
  // to be exceeded fail immediately and set $(ref:runtime.lastError) when using a
  // callback, or a rejected Promise if using async/await.
  extern const int QUOTA_BYTES;
}  // namespace local

// Items in the <code>session</code> storage area are stored in-memory and will
// not be persisted to disk.
namespace session {
  // The maximum amount (in bytes) of data that can be stored in memory, as
  // measured by estimating the dynamically allocated memory usage of every value
  // and key. Updates that would cause this limit to be exceeded fail immediately
  // and set $(ref:runtime.lastError) when using a callback, or when a Promise is
  // rejected.
  extern const int QUOTA_BYTES;
}  // namespace session

//
// Types
//

// The storage area's access level.
enum class AccessLevel {
  kNone = 0,
  kTrustedContexts,
  kTrustedAndUntrustedContexts,
  kMaxValue = kTrustedAndUntrustedContexts,
};


const char* ToString(AccessLevel as_enum);
AccessLevel ParseAccessLevel(std::string_view as_string);
std::u16string GetAccessLevelParseError(std::string_view as_string);

struct StorageChange {
  StorageChange();
  ~StorageChange();
  StorageChange(const StorageChange&) = delete;
  StorageChange& operator=(const StorageChange&) = delete;
  StorageChange(StorageChange&& rhs) noexcept;
  StorageChange& operator=(StorageChange&& rhs) noexcept;

  // Populates a StorageChange object from a base::Value& instance. Returns
  // whether |out| was successfully populated.
  static bool Populate(const base::Value& value, StorageChange& out);

  // Populates a StorageChange object from a Dict& instance. Returns whether
  // |out| was successfully populated.
  static bool Populate(const base::Value::Dict& value, StorageChange& out);

  // Creates a deep copy of StorageChange.
  StorageChange Clone() const;

  // Creates a StorageChange object from a base::Value::Dict, or nullopt on
  // failure.
  static std::optional<StorageChange> FromValue(const base::Value::Dict& value);

  // Creates a StorageChange object from a base::Value, or nullopt on failure.
  static std::optional<StorageChange> FromValue(const base::Value& value);

  // Returns a new base::Value::Dict representing the serialized form of
  // thisStorageChange object.
  base::Value::Dict ToValue() const;

  // The old value of the item, if there was an old value.
  std::optional<base::Value> old_value;

  // The new value of the item, if there is a new value.
  std::optional<base::Value> new_value;

};

namespace StorageArea {

namespace Get {

struct Params {
  static std::optional<Params> Create(const base::Value::List& args);
  Params(const Params&) = delete;
  Params& operator=(const Params&) = delete;
  Params(Params&& rhs) noexcept;
  Params& operator=(Params&& rhs) noexcept;
  ~Params();

  // A single key to get, list of keys to get, or a dictionary specifying default
  // values (see description of the object).  An empty list or object will return
  // an empty result object.  Pass in <code>null</code> to get the entire contents
  // of storage.
  struct Keys {
    Keys();
    ~Keys();
    Keys(const Keys&) = delete;
    Keys& operator=(const Keys&) = delete;
    Keys(Keys&& rhs) noexcept;
    Keys& operator=(Keys&& rhs) noexcept;

    // Populates a Keys object from a base::Value& instance. Returns whether |out|
    // was successfully populated.
    static bool Populate(const base::Value& value, Keys& out);

    // Creates a deep copy of Keys.
    Keys Clone() const;

    // Creates a Keys object from a base::Value, or nullopt on failure.
    static std::optional<Keys> FromValue(const base::Value& value);
    // Storage items to return in the callback, where the values are replaced with
    // those from storage if they exist.
    struct Object {
      Object();
      ~Object();
      Object(const Object&) = delete;
      Object& operator=(const Object&) = delete;
      Object(Object&& rhs) noexcept;
      Object& operator=(Object&& rhs) noexcept;

      // Populates a Object object from a base::Value& instance. Returns whether
      // |out| was successfully populated.
      static bool Populate(const base::Value& value, Object& out);

      // Populates a Object object from a Dict& instance. Returns whether |out| was
      // successfully populated.
      static bool Populate(const base::Value::Dict& value, Object& out);

      // Creates a deep copy of Object.
      Object Clone() const;

      // Creates a Object object from a base::Value::Dict, or nullopt on failure.
      static std::optional<Object> FromValue(const base::Value::Dict& value);

      // Creates a Object object from a base::Value, or nullopt on failure.
      static std::optional<Object> FromValue(const base::Value& value);

      base::Value::Dict additional_properties;
    };


    // Choices:
    std::optional<std::string> as_string;
    std::optional<std::vector<std::string>> as_strings;
    std::optional<Object> as_object;
  };


  // A single key to get, list of keys to get, or a dictionary specifying default
  // values (see description of the object).  An empty list or object will return
  // an empty result object.  Pass in <code>null</code> to get the entire contents
  // of storage.
  std::optional<Keys> keys;


 private:
  Params();
};

namespace Results {

// Object with items in their key-value mappings.
struct Items {
  Items();
  ~Items();
  Items(const Items&) = delete;
  Items& operator=(const Items&) = delete;
  Items(Items&& rhs) noexcept;
  Items& operator=(Items&& rhs) noexcept;

  // Returns a new base::Value::Dict representing the serialized form of
  // thisItems object.
  base::Value::Dict ToValue() const;

  base::Value::Dict additional_properties;
};


// Object with items in their key-value mappings.
base::Value::List Create(const Items& items);
}  // namespace Results

}  // namespace Get

namespace GetKeys {

namespace Results {

// Array with keys read from storage.
base::Value::List Create(const std::vector<std::string>& keys);
}  // namespace Results

}  // namespace GetKeys

namespace GetBytesInUse {

struct Params {
  static std::optional<Params> Create(const base::Value::List& args);
  Params(const Params&) = delete;
  Params& operator=(const Params&) = delete;
  Params(Params&& rhs) noexcept;
  Params& operator=(Params&& rhs) noexcept;
  ~Params();

  // A single key or list of keys to get the total usage for. An empty list will
  // return 0. Pass in <code>null</code> to get the total usage of all of storage.
  struct Keys {
    Keys();
    ~Keys();
    Keys(const Keys&) = delete;
    Keys& operator=(const Keys&) = delete;
    Keys(Keys&& rhs) noexcept;
    Keys& operator=(Keys&& rhs) noexcept;

    // Populates a Keys object from a base::Value& instance. Returns whether |out|
    // was successfully populated.
    static bool Populate(const base::Value& value, Keys& out);

    // Creates a deep copy of Keys.
    Keys Clone() const;

    // Creates a Keys object from a base::Value, or nullopt on failure.
    static std::optional<Keys> FromValue(const base::Value& value);
    // Choices:
    std::optional<std::string> as_string;
    std::optional<std::vector<std::string>> as_strings;
  };


  // A single key or list of keys to get the total usage for. An empty list will
  // return 0. Pass in <code>null</code> to get the total usage of all of storage.
  std::optional<Keys> keys;


 private:
  Params();
};

namespace Results {

// Amount of space being used in storage, in bytes.
base::Value::List Create(double bytes_in_use);
}  // namespace Results

}  // namespace GetBytesInUse

namespace Set {

struct Params {
  static std::optional<Params> Create(const base::Value::List& args);
  Params(const Params&) = delete;
  Params& operator=(const Params&) = delete;
  Params(Params&& rhs) noexcept;
  Params& operator=(Params&& rhs) noexcept;
  ~Params();

  // <p>An object which gives each key/value pair to update storage with. Any
  // other key/value pairs in storage will not be affected.</p><p>Primitive values
  // such as numbers will serialize as expected. Values with a <code>typeof</code>
  // <code>"object"</code> and <code>"function"</code> will typically serialize to
  // <code>{}</code>, with the exception of <code>Array</code> (serializes as
  // expected), <code>Date</code>, and <code>Regex</code> (serialize using their
  // <code>String</code> representation).</p>
  struct Items {
    Items();
    ~Items();
    Items(const Items&) = delete;
    Items& operator=(const Items&) = delete;
    Items(Items&& rhs) noexcept;
    Items& operator=(Items&& rhs) noexcept;

    // Populates a Items object from a base::Value& instance. Returns whether
    // |out| was successfully populated.
    static bool Populate(const base::Value& value, Items& out);

    // Populates a Items object from a Dict& instance. Returns whether |out| was
    // successfully populated.
    static bool Populate(const base::Value::Dict& value, Items& out);

    // Creates a deep copy of Items.
    Items Clone() const;

    // Creates a Items object from a base::Value::Dict, or nullopt on failure.
    static std::optional<Items> FromValue(const base::Value::Dict& value);

    // Creates a Items object from a base::Value, or nullopt on failure.
    static std::optional<Items> FromValue(const base::Value& value);

    base::Value::Dict additional_properties;
  };


  // <p>An object which gives each key/value pair to update storage with. Any
  // other key/value pairs in storage will not be affected.</p><p>Primitive values
  // such as numbers will serialize as expected. Values with a <code>typeof</code>
  // <code>"object"</code> and <code>"function"</code> will typically serialize to
  // <code>{}</code>, with the exception of <code>Array</code> (serializes as
  // expected), <code>Date</code>, and <code>Regex</code> (serialize using their
  // <code>String</code> representation).</p>
  Items items;


 private:
  Params();
};

namespace Results {

base::Value::List Create();
}  // namespace Results

}  // namespace Set

namespace Remove {

struct Params {
  static std::optional<Params> Create(const base::Value::List& args);
  Params(const Params&) = delete;
  Params& operator=(const Params&) = delete;
  Params(Params&& rhs) noexcept;
  Params& operator=(Params&& rhs) noexcept;
  ~Params();

  // A single key or a list of keys for items to remove.
  struct Keys {
    Keys();
    ~Keys();
    Keys(const Keys&) = delete;
    Keys& operator=(const Keys&) = delete;
    Keys(Keys&& rhs) noexcept;
    Keys& operator=(Keys&& rhs) noexcept;

    // Populates a Keys object from a base::Value& instance. Returns whether |out|
    // was successfully populated.
    static bool Populate(const base::Value& value, Keys& out);

    // Creates a deep copy of Keys.
    Keys Clone() const;

    // Creates a Keys object from a base::Value, or nullopt on failure.
    static std::optional<Keys> FromValue(const base::Value& value);
    // Choices:
    std::optional<std::string> as_string;
    std::optional<std::vector<std::string>> as_strings;
  };


  // A single key or a list of keys for items to remove.
  Keys keys;


 private:
  Params();
};

namespace Results {

base::Value::List Create();
}  // namespace Results

}  // namespace Remove

namespace Clear {

namespace Results {

base::Value::List Create();
}  // namespace Results

}  // namespace Clear

namespace SetAccessLevel {

struct Params {
  static std::optional<Params> Create(const base::Value::List& args);
  Params(const Params&) = delete;
  Params& operator=(const Params&) = delete;
  Params(Params&& rhs) noexcept;
  Params& operator=(Params&& rhs) noexcept;
  ~Params();

  struct AccessOptions {
    AccessOptions();
    ~AccessOptions();
    AccessOptions(const AccessOptions&) = delete;
    AccessOptions& operator=(const AccessOptions&) = delete;
    AccessOptions(AccessOptions&& rhs) noexcept;
    AccessOptions& operator=(AccessOptions&& rhs) noexcept;

    // Populates a AccessOptions object from a base::Value& instance. Returns
    // whether |out| was successfully populated.
    static bool Populate(const base::Value& value, AccessOptions& out);

    // Populates a AccessOptions object from a Dict& instance. Returns whether
    // |out| was successfully populated.
    static bool Populate(const base::Value::Dict& value, AccessOptions& out);

    // Creates a deep copy of AccessOptions.
    AccessOptions Clone() const;

    // Creates a AccessOptions object from a base::Value::Dict, or nullopt on
    // failure.
    static std::optional<AccessOptions> FromValue(const base::Value::Dict& value);

    // Creates a AccessOptions object from a base::Value, or nullopt on failure.
    static std::optional<AccessOptions> FromValue(const base::Value& value);

    // The access level of the storage area.
    AccessLevel access_level;

  };


  AccessOptions access_options;


 private:
  Params();
};

namespace Results {

base::Value::List Create();
}  // namespace Results

}  // namespace SetAccessLevel

}  // namespace StorageArea


//
// Events
//

namespace OnChanged {

extern const char kEventName[];  // "storage.onChanged"

// Object mapping each key that changed to its corresponding
// $(ref:storage.StorageChange) for that item.
struct Changes {
  Changes();
  ~Changes();
  Changes(const Changes&) = delete;
  Changes& operator=(const Changes&) = delete;
  Changes(Changes&& rhs) noexcept;
  Changes& operator=(Changes&& rhs) noexcept;

  // Returns a new base::Value::Dict representing the serialized form of
  // thisChanges object.
  base::Value::Dict ToValue() const;

  std::map<std::string, StorageChange> additional_properties;
};


// Object mapping each key that changed to its corresponding
// $(ref:storage.StorageChange) for that item.
// The name of the storage area (<code>"local"</code>, <code>"managed"</code>,
// <code>"session"</code>, or <code>"sync"</code>) the changes are for.
base::Value::List Create(const Changes& changes, const std::string& area_name);
}  // namespace OnChanged

}  // namespace storage
}  // namespace api
}  // namespace extensions

#endif  // EXTENSIONS_COMMON_API_STORAGE_H__
