// gpu/ipc/common/gpu_channel.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "gpu/ipc/common/gpu_channel.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "gpu/ipc/common/gpu_channel.mojom-params-data.h"
namespace gpu {
namespace mojom {

NOINLINE static const char* ContextTypeToStringHelper(ContextType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ContextType::kWebGL1:
      return "kWebGL1";
    case ContextType::kWebGL2:
      return "kWebGL2";
    case ContextType::kOpenGLES2:
      return "kOpenGLES2";
    case ContextType::kOpenGLES3:
      return "kOpenGLES3";
    case ContextType::kOpenGLES31ForTesting:
      return "kOpenGLES31ForTesting";
    case ContextType::kWebGPU:
      return "kWebGPU";
    default:
      return nullptr;
  }
}

std::string ContextTypeToString(ContextType value) {
  const char *str = ContextTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ContextType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ContextType value) {
  return os << ContextTypeToString(value);
}

NOINLINE static const char* ContextColorSpaceToStringHelper(ContextColorSpace value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ContextColorSpace::kUnspecified:
      return "kUnspecified";
    case ContextColorSpace::kSRGB:
      return "kSRGB";
    case ContextColorSpace::kDisplayP3:
      return "kDisplayP3";
    default:
      return nullptr;
  }
}

std::string ContextColorSpaceToString(ContextColorSpace value) {
  const char *str = ContextColorSpaceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ContextColorSpace value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ContextColorSpace value) {
  return os << ContextColorSpaceToString(value);
}

NOINLINE static const char* SchedulingPriorityToStringHelper(SchedulingPriority value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SchedulingPriority::kHigh:
      return "kHigh";
    case SchedulingPriority::kNormal:
      return "kNormal";
    case SchedulingPriority::kLow:
      return "kLow";
    default:
      return nullptr;
  }
}

std::string SchedulingPriorityToString(SchedulingPriority value) {
  const char *str = SchedulingPriorityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SchedulingPriority value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SchedulingPriority value) {
  return os << SchedulingPriorityToString(value);
}

namespace internal {
// static
bool DeferredRequestParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const DeferredRequestParams_Data* object = static_cast<const DeferredRequestParams_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case DeferredRequestParams_Tag::kCommandBufferRequest: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_command_buffer_request, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_command_buffer_request, validation_context))
        return false;
      return true;
    }
    case DeferredRequestParams_Tag::kSharedImageRequest: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_shared_image_request, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateNonInlinedUnion(object->data.f_shared_image_request,
                                                   validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in DeferredRequestParams");
      return false;
    }
  }
}
// static
bool DeferredCommandBufferRequestParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const DeferredCommandBufferRequestParams_Data* object = static_cast<const DeferredCommandBufferRequestParams_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case DeferredCommandBufferRequestParams_Tag::kAsyncFlush: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_async_flush, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_async_flush, validation_context))
        return false;
      return true;
    }
    case DeferredCommandBufferRequestParams_Tag::kDestroyTransferBuffer: {

      return true;
    }
    case DeferredCommandBufferRequestParams_Tag::kSetDefaultFramebufferSharedImage: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_set_default_framebuffer_shared_image, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_set_default_framebuffer_shared_image, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in DeferredCommandBufferRequestParams");
      return false;
    }
  }
}
// static
bool DeferredSharedImageRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const DeferredSharedImageRequest_Data* object = static_cast<const DeferredSharedImageRequest_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case DeferredSharedImageRequest_Tag::kNop: {

      return true;
    }
    case DeferredSharedImageRequest_Tag::kCreateSharedImage: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_create_shared_image, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_create_shared_image, validation_context))
        return false;
      return true;
    }
    case DeferredSharedImageRequest_Tag::kCreateSharedImageWithData: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_create_shared_image_with_data, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_create_shared_image_with_data, validation_context))
        return false;
      return true;
    }
    case DeferredSharedImageRequest_Tag::kCreateSharedImageWithBuffer: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_create_shared_image_with_buffer, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_create_shared_image_with_buffer, validation_context))
        return false;
      return true;
    }
    case DeferredSharedImageRequest_Tag::kRegisterUploadBuffer: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_register_upload_buffer, 5, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_register_upload_buffer, validation_context))
        return false;
      return true;
    }
    case DeferredSharedImageRequest_Tag::kUpdateSharedImage: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_update_shared_image, 6, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_update_shared_image, validation_context))
        return false;
      return true;
    }
    case DeferredSharedImageRequest_Tag::kCopyToGpuMemoryBuffer: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_copy_to_gpu_memory_buffer, 7, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_copy_to_gpu_memory_buffer, validation_context))
        return false;
      return true;
    }
    case DeferredSharedImageRequest_Tag::kDestroySharedImage: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_destroy_shared_image, 8, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_destroy_shared_image, validation_context))
        return false;
      return true;
    }
    case DeferredSharedImageRequest_Tag::kAddReferenceToSharedImage: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_add_reference_to_shared_image, 9, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_add_reference_to_shared_image, validation_context))
        return false;
      return true;
    }
    case DeferredSharedImageRequest_Tag::kCreateSharedImagePool: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_create_shared_image_pool, 10, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_create_shared_image_pool, validation_context))
        return false;
      return true;
    }
    case DeferredSharedImageRequest_Tag::kDestroySharedImagePool: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_destroy_shared_image_pool, 11, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_destroy_shared_image_pool, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in DeferredSharedImageRequest");
      return false;
    }
  }
}


// static
bool ContextCreationAttribs_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContextCreationAttribs_Data* object =
      static_cast<const ContextCreationAttribs_Data*>(data);


  if (!::gl::mojom::internal::GpuPreference_Data
        ::Validate(object->gpu_preference, validation_context))
    return false;


  if (!::gpu::mojom::internal::ContextType_Data
        ::Validate(object->context_type, validation_context))
    return false;

  return true;
}

ContextCreationAttribs_Data::ContextCreationAttribs_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CreateCommandBufferParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CreateCommandBufferParams_Data* object =
      static_cast<const CreateCommandBufferParams_Data*>(data);


  if (!::gpu::mojom::internal::SchedulingPriority_Data
        ::Validate(object->stream_priority, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->attribs, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->attribs, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->active_url, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->active_url, validation_context))
    return false;

  return true;
}

CreateCommandBufferParams_Data::CreateCommandBufferParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CommandBufferState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CommandBufferState_Data* object =
      static_cast<const CommandBufferState_Data*>(data);


  if (!::gpu::mojom::internal::Error_Data
        ::Validate(object->error, validation_context))
    return false;


  if (!::gpu::mojom::internal::ContextLostReason_Data
        ::Validate(object->context_lost_reason, validation_context))
    return false;

  return true;
}

CommandBufferState_Data::CommandBufferState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScheduleImageDecodeParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ScheduleImageDecodeParams_Data* object =
      static_cast<const ScheduleImageDecodeParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->encoded_data, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& encoded_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->encoded_data, validation_context,
                                         &encoded_data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_size, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->target_color_space, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->target_color_space, validation_context))
    return false;

  return true;
}

ScheduleImageDecodeParams_Data::ScheduleImageDecodeParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeferredRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeferredRequest_Data* object =
      static_cast<const DeferredRequest_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->params, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sync_token_fences, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& sync_token_fences_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->sync_token_fences, validation_context,
                                         &sync_token_fences_validate_params)) {
    return false;
  }

  return true;
}

DeferredRequest_Data::DeferredRequest_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeferredCommandBufferRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeferredCommandBufferRequest_Data* object =
      static_cast<const DeferredCommandBufferRequest_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->params, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->params, validation_context))
    return false;

  return true;
}

DeferredCommandBufferRequest_Data::DeferredCommandBufferRequest_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AsyncFlushParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AsyncFlushParams_Data* object =
      static_cast<const AsyncFlushParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sync_token_fences, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& sync_token_fences_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->sync_token_fences, validation_context,
                                         &sync_token_fences_validate_params)) {
    return false;
  }

  return true;
}

AsyncFlushParams_Data::AsyncFlushParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SetDefaultFramebufferSharedImageParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SetDefaultFramebufferSharedImageParams_Data* object =
      static_cast<const SetDefaultFramebufferSharedImageParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mailbox, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mailbox, validation_context))
    return false;

  return true;
}

SetDefaultFramebufferSharedImageParams_Data::SetDefaultFramebufferSharedImageParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedImageInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedImageInfo_Data* object =
      static_cast<const SharedImageInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->meta, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->meta, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->debug_label, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& debug_label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->debug_label, validation_context,
                                         &debug_label_validate_params)) {
    return false;
  }

  return true;
}

SharedImageInfo_Data::SharedImageInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CreateSharedImageParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CreateSharedImageParams_Data* object =
      static_cast<const CreateSharedImageParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mailbox, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mailbox, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->si_info, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->si_info, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->pool_id, validation_context))
    return false;

  return true;
}

CreateSharedImageParams_Data::CreateSharedImageParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CreateSharedImageWithDataParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CreateSharedImageWithDataParams_Data* object =
      static_cast<const CreateSharedImageWithDataParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mailbox, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mailbox, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->si_info, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->si_info, validation_context))
    return false;

  return true;
}

CreateSharedImageWithDataParams_Data::CreateSharedImageWithDataParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CreateSharedImageWithBufferParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CreateSharedImageWithBufferParams_Data* object =
      static_cast<const CreateSharedImageWithBufferParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mailbox, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mailbox, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->si_info, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->si_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->buffer_handle, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->buffer_handle, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->pool_id, validation_context))
    return false;

  return true;
}

CreateSharedImageWithBufferParams_Data::CreateSharedImageWithBufferParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UpdateSharedImageParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UpdateSharedImageParams_Data* object =
      static_cast<const UpdateSharedImageParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mailbox, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mailbox, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->in_fence_handle, validation_context))
    return false;

  return true;
}

UpdateSharedImageParams_Data::UpdateSharedImageParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AddReferenceToSharedImageParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AddReferenceToSharedImageParams_Data* object =
      static_cast<const AddReferenceToSharedImageParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mailbox, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mailbox, validation_context))
    return false;

  return true;
}

AddReferenceToSharedImageParams_Data::AddReferenceToSharedImageParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CopyToGpuMemoryBufferParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CopyToGpuMemoryBufferParams_Data* object =
      static_cast<const CopyToGpuMemoryBufferParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mailbox, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mailbox, validation_context))
    return false;

  return true;
}

CopyToGpuMemoryBufferParams_Data::CopyToGpuMemoryBufferParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CreateSharedImagePoolParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CreateSharedImagePoolParams_Data* object =
      static_cast<const CreateSharedImagePoolParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pool_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->pool_id, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client_remote, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client_remote,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CreateSharedImagePoolParams_Data::CreateSharedImagePoolParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DestroySharedImagePoolParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DestroySharedImagePoolParams_Data* object =
      static_cast<const DestroySharedImagePoolParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pool_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->pool_id, validation_context))
    return false;

  return true;
}

DestroySharedImagePoolParams_Data::DestroySharedImagePoolParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuChannel_CrashForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuChannel_CrashForTesting_Params_Data* object =
      static_cast<const GpuChannel_CrashForTesting_Params_Data*>(data);

  return true;
}

GpuChannel_CrashForTesting_Params_Data::GpuChannel_CrashForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuChannel_TerminateForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuChannel_TerminateForTesting_Params_Data* object =
      static_cast<const GpuChannel_TerminateForTesting_Params_Data*>(data);

  return true;
}

GpuChannel_TerminateForTesting_Params_Data::GpuChannel_TerminateForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuChannel_GetChannelToken_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuChannel_GetChannelToken_Params_Data* object =
      static_cast<const GpuChannel_GetChannelToken_Params_Data*>(data);

  return true;
}

GpuChannel_GetChannelToken_Params_Data::GpuChannel_GetChannelToken_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuChannel_GetChannelToken_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuChannel_GetChannelToken_ResponseParams_Data* object =
      static_cast<const GpuChannel_GetChannelToken_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->token, validation_context))
    return false;

  return true;
}

GpuChannel_GetChannelToken_ResponseParams_Data::GpuChannel_GetChannelToken_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuChannel_Flush_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuChannel_Flush_Params_Data* object =
      static_cast<const GpuChannel_Flush_Params_Data*>(data);

  return true;
}

GpuChannel_Flush_Params_Data::GpuChannel_Flush_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuChannel_Flush_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuChannel_Flush_ResponseParams_Data* object =
      static_cast<const GpuChannel_Flush_ResponseParams_Data*>(data);

  return true;
}

GpuChannel_Flush_ResponseParams_Data::GpuChannel_Flush_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuChannel_GetSharedMemoryForFlushId_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuChannel_GetSharedMemoryForFlushId_Params_Data* object =
      static_cast<const GpuChannel_GetSharedMemoryForFlushId_Params_Data*>(data);

  return true;
}

GpuChannel_GetSharedMemoryForFlushId_Params_Data::GpuChannel_GetSharedMemoryForFlushId_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuChannel_GetSharedMemoryForFlushId_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuChannel_GetSharedMemoryForFlushId_ResponseParams_Data* object =
      static_cast<const GpuChannel_GetSharedMemoryForFlushId_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->version_buffer, validation_context))
    return false;

  return true;
}

GpuChannel_GetSharedMemoryForFlushId_ResponseParams_Data::GpuChannel_GetSharedMemoryForFlushId_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuChannel_CreateCommandBuffer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuChannel_CreateCommandBuffer_Params_Data* object =
      static_cast<const GpuChannel_CreateCommandBuffer_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->shared_state, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->shared_state, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

GpuChannel_CreateCommandBuffer_Params_Data::GpuChannel_CreateCommandBuffer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuChannel_CreateCommandBuffer_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuChannel_CreateCommandBuffer_ResponseParams_Data* object =
      static_cast<const GpuChannel_CreateCommandBuffer_ResponseParams_Data*>(data);


  if (!::gpu::mojom::internal::ContextResult_Data
        ::Validate(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->capabilties, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->capabilties, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gl_capabilities, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->gl_capabilities, validation_context))
    return false;

  return true;
}

GpuChannel_CreateCommandBuffer_ResponseParams_Data::GpuChannel_CreateCommandBuffer_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuChannel_DestroyCommandBuffer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuChannel_DestroyCommandBuffer_Params_Data* object =
      static_cast<const GpuChannel_DestroyCommandBuffer_Params_Data*>(data);

  return true;
}

GpuChannel_DestroyCommandBuffer_Params_Data::GpuChannel_DestroyCommandBuffer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuChannel_DestroyCommandBuffer_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuChannel_DestroyCommandBuffer_ResponseParams_Data* object =
      static_cast<const GpuChannel_DestroyCommandBuffer_ResponseParams_Data*>(data);

  return true;
}

GpuChannel_DestroyCommandBuffer_ResponseParams_Data::GpuChannel_DestroyCommandBuffer_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuChannel_ScheduleImageDecode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuChannel_ScheduleImageDecode_Params_Data* object =
      static_cast<const GpuChannel_ScheduleImageDecode_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

GpuChannel_ScheduleImageDecode_Params_Data::GpuChannel_ScheduleImageDecode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuChannel_FlushDeferredRequests_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuChannel_FlushDeferredRequests_Params_Data* object =
      static_cast<const GpuChannel_FlushDeferredRequests_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->requests, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& requests_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->requests, validation_context,
                                         &requests_validate_params)) {
    return false;
  }

  return true;
}

GpuChannel_FlushDeferredRequests_Params_Data::GpuChannel_FlushDeferredRequests_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuChannel_CreateGpuMemoryBuffer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuChannel_CreateGpuMemoryBuffer_Params_Data* object =
      static_cast<const GpuChannel_CreateGpuMemoryBuffer_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->size, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->size, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->format, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->format, validation_context))
    return false;


  if (!::gfx::mojom::internal::BufferUsage_Data
        ::Validate(object->buffer_usage, validation_context))
    return false;

  return true;
}

GpuChannel_CreateGpuMemoryBuffer_Params_Data::GpuChannel_CreateGpuMemoryBuffer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuChannel_CreateGpuMemoryBuffer_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuChannel_CreateGpuMemoryBuffer_ResponseParams_Data* object =
      static_cast<const GpuChannel_CreateGpuMemoryBuffer_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->buffer_handle, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->buffer_handle, validation_context))
    return false;

  return true;
}

GpuChannel_CreateGpuMemoryBuffer_ResponseParams_Data::GpuChannel_CreateGpuMemoryBuffer_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuChannel_GetGpuMemoryBufferHandleInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuChannel_GetGpuMemoryBufferHandleInfo_Params_Data* object =
      static_cast<const GpuChannel_GetGpuMemoryBufferHandleInfo_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mailbox, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mailbox, validation_context))
    return false;

  return true;
}

GpuChannel_GetGpuMemoryBufferHandleInfo_Params_Data::GpuChannel_GetGpuMemoryBufferHandleInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuChannel_GetGpuMemoryBufferHandleInfo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuChannel_GetGpuMemoryBufferHandleInfo_ResponseParams_Data* object =
      static_cast<const GpuChannel_GetGpuMemoryBufferHandleInfo_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->buffer_handle, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->buffer_handle, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->format, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->format, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->size, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->size, validation_context))
    return false;


  if (!::gfx::mojom::internal::BufferUsage_Data
        ::Validate(object->buffer_usage, validation_context))
    return false;

  return true;
}

GpuChannel_GetGpuMemoryBufferHandleInfo_ResponseParams_Data::GpuChannel_GetGpuMemoryBufferHandleInfo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuChannel_WaitForTokenInRange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuChannel_WaitForTokenInRange_Params_Data* object =
      static_cast<const GpuChannel_WaitForTokenInRange_Params_Data*>(data);

  return true;
}

GpuChannel_WaitForTokenInRange_Params_Data::GpuChannel_WaitForTokenInRange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuChannel_WaitForTokenInRange_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuChannel_WaitForTokenInRange_ResponseParams_Data* object =
      static_cast<const GpuChannel_WaitForTokenInRange_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->state, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->state, validation_context))
    return false;

  return true;
}

GpuChannel_WaitForTokenInRange_ResponseParams_Data::GpuChannel_WaitForTokenInRange_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuChannel_WaitForGetOffsetInRange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuChannel_WaitForGetOffsetInRange_Params_Data* object =
      static_cast<const GpuChannel_WaitForGetOffsetInRange_Params_Data*>(data);

  return true;
}

GpuChannel_WaitForGetOffsetInRange_Params_Data::GpuChannel_WaitForGetOffsetInRange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuChannel_WaitForGetOffsetInRange_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuChannel_WaitForGetOffsetInRange_ResponseParams_Data* object =
      static_cast<const GpuChannel_WaitForGetOffsetInRange_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->state, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->state, validation_context))
    return false;

  return true;
}

GpuChannel_WaitForGetOffsetInRange_ResponseParams_Data::GpuChannel_WaitForGetOffsetInRange_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CommandBuffer_SetGetBuffer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CommandBuffer_SetGetBuffer_Params_Data* object =
      static_cast<const CommandBuffer_SetGetBuffer_Params_Data*>(data);

  return true;
}

CommandBuffer_SetGetBuffer_Params_Data::CommandBuffer_SetGetBuffer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CommandBuffer_RegisterTransferBuffer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CommandBuffer_RegisterTransferBuffer_Params_Data* object =
      static_cast<const CommandBuffer_RegisterTransferBuffer_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->buffer, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->buffer, validation_context))
    return false;

  return true;
}

CommandBuffer_RegisterTransferBuffer_Params_Data::CommandBuffer_RegisterTransferBuffer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CommandBuffer_CreateGpuFenceFromHandle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CommandBuffer_CreateGpuFenceFromHandle_Params_Data* object =
      static_cast<const CommandBuffer_CreateGpuFenceFromHandle_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fence_handle, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->fence_handle, validation_context))
    return false;

  return true;
}

CommandBuffer_CreateGpuFenceFromHandle_Params_Data::CommandBuffer_CreateGpuFenceFromHandle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CommandBuffer_GetGpuFenceHandle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CommandBuffer_GetGpuFenceHandle_Params_Data* object =
      static_cast<const CommandBuffer_GetGpuFenceHandle_Params_Data*>(data);

  return true;
}

CommandBuffer_GetGpuFenceHandle_Params_Data::CommandBuffer_GetGpuFenceHandle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CommandBuffer_GetGpuFenceHandle_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CommandBuffer_GetGpuFenceHandle_ResponseParams_Data* object =
      static_cast<const CommandBuffer_GetGpuFenceHandle_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->fence_handle, validation_context))
    return false;

  return true;
}

CommandBuffer_GetGpuFenceHandle_ResponseParams_Data::CommandBuffer_GetGpuFenceHandle_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CommandBuffer_SignalSyncToken_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CommandBuffer_SignalSyncToken_Params_Data* object =
      static_cast<const CommandBuffer_SignalSyncToken_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sync_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sync_token, validation_context))
    return false;

  return true;
}

CommandBuffer_SignalSyncToken_Params_Data::CommandBuffer_SignalSyncToken_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CommandBuffer_SignalQuery_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CommandBuffer_SignalQuery_Params_Data* object =
      static_cast<const CommandBuffer_SignalQuery_Params_Data*>(data);

  return true;
}

CommandBuffer_SignalQuery_Params_Data::CommandBuffer_SignalQuery_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CommandBufferClient_OnConsoleMessage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CommandBufferClient_OnConsoleMessage_Params_Data* object =
      static_cast<const CommandBufferClient_OnConsoleMessage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

CommandBufferClient_OnConsoleMessage_Params_Data::CommandBufferClient_OnConsoleMessage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CommandBufferClient_OnGpuSwitched_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CommandBufferClient_OnGpuSwitched_Params_Data* object =
      static_cast<const CommandBufferClient_OnGpuSwitched_Params_Data*>(data);


  if (!::gl::mojom::internal::GpuPreference_Data
        ::Validate(object->active_gpu_heuristic, validation_context))
    return false;

  return true;
}

CommandBufferClient_OnGpuSwitched_Params_Data::CommandBufferClient_OnGpuSwitched_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CommandBufferClient_OnDestroyed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CommandBufferClient_OnDestroyed_Params_Data* object =
      static_cast<const CommandBufferClient_OnDestroyed_Params_Data*>(data);


  if (!::gpu::mojom::internal::ContextLostReason_Data
        ::Validate(object->reason, validation_context))
    return false;


  if (!::gpu::mojom::internal::Error_Data
        ::Validate(object->error, validation_context))
    return false;

  return true;
}

CommandBufferClient_OnDestroyed_Params_Data::CommandBufferClient_OnDestroyed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CommandBufferClient_OnReturnData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CommandBufferClient_OnReturnData_Params_Data* object =
      static_cast<const CommandBufferClient_OnReturnData_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  return true;
}

CommandBufferClient_OnReturnData_Params_Data::CommandBufferClient_OnReturnData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CommandBufferClient_OnSignalAck_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CommandBufferClient_OnSignalAck_Params_Data* object =
      static_cast<const CommandBufferClient_OnSignalAck_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->state, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->state, validation_context))
    return false;

  return true;
}

CommandBufferClient_OnSignalAck_Params_Data::CommandBufferClient_OnSignalAck_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace gpu

namespace perfetto {

// static
void TraceFormatTraits<::gpu::mojom::ContextType>::WriteIntoTrace(
   perfetto::TracedValue context, ::gpu::mojom::ContextType value) {
  return std::move(context).WriteString(::gpu::mojom::ContextTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::gpu::mojom::ContextColorSpace>::WriteIntoTrace(
   perfetto::TracedValue context, ::gpu::mojom::ContextColorSpace value) {
  return std::move(context).WriteString(::gpu::mojom::ContextColorSpaceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::gpu::mojom::SchedulingPriority>::WriteIntoTrace(
   perfetto::TracedValue context, ::gpu::mojom::SchedulingPriority value) {
  return std::move(context).WriteString(::gpu::mojom::SchedulingPriorityToString(value));
}

} // namespace perfetto